/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.jwt.algorithms;

import com.bastiaanjansen.jwt.algorithms.Algorithm;
import com.bastiaanjansen.jwt.exceptions.JWTSignException;
import com.bastiaanjansen.jwt.exceptions.JWTValidationException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class RSAAlgorithm
extends Algorithm {
    private final KeyPair keyPair;

    RSAAlgorithm(String name, String description, KeyPair keyPair) {
        super(name, description);
        this.keyPair = keyPair;
    }

    @Override
    public byte[] sign(String data) throws JWTSignException {
        return this.sign(data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] sign(byte[] data) throws JWTSignException {
        try {
            Signature signature = Signature.getInstance(this.description);
            signature.initSign(this.keyPair.getPrivate());
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTSignException(e.getMessage());
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] expected) throws JWTValidationException {
        try {
            Signature signature = Signature.getInstance(this.description);
            signature.initVerify(this.keyPair.getPublic());
            signature.update(data);
            return signature.verify(expected);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTValidationException(e.getMessage());
        }
    }
}

