/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.clusteredobjectpool.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.bbottema.clusteredobjectpool.core.ClusterConfig;
import org.bbottema.clusteredobjectpool.core.ResourcePool;
import org.bbottema.clusteredobjectpool.core.ResourcePools;
import org.bbottema.clusteredobjectpool.core.api.LoadBalancingStrategy;
import org.bbottema.clusteredobjectpool.core.api.ResourceKey;
import org.bbottema.clusteredobjectpool.util.CompositeFuturesAsFutureTask;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.GenericObjectPool;
import org.bbottema.genericobjectpool.PoolConfig;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceClusters<ClusterKey, PoolKey, T> {
    @NotNull
    private final Map<ClusterKey, ResourcePools<PoolKey, T>> resourceClusters = new HashMap<ClusterKey, ResourcePools<PoolKey, T>>();
    @NotNull
    private final ClusterConfig<PoolKey, T> clusterConfig;
    @NotNull
    private final LoadBalancingStrategy<ResourcePool<PoolKey, T>, Collection<ResourcePool<PoolKey, T>>> loadBalancingStrategy;

    public ResourceClusters(ClusterConfig<PoolKey, T> clusterConfig) {
        this.clusterConfig = clusterConfig;
        this.loadBalancingStrategy = clusterConfig.getLoadBalancingStrategy();
    }

    public void registerResourcePool(ResourceKey<ClusterKey, PoolKey> key) {
        this.registerResourcePool(key, this.clusterConfig.getDefaultExpirationPolicy(), this.clusterConfig.getDefaultCorePoolSize(), this.clusterConfig.getDefaultMaxPoolSize());
    }

    public void registerResourcePool(@NotNull ResourceKey<ClusterKey, PoolKey> key, @NotNull ExpirationPolicy<T> expirationPolicy, int corePoolSize, int maxPoolSize) throws IllegalArgumentException {
        ResourcePools cluster = this.findOrCreateCluster(key.getClusterKey());
        if (cluster.containsPool(key.getPoolKey())) {
            throw new IllegalArgumentException("Pool already exists for " + key);
        }
        GenericObjectPool pool = new GenericObjectPool(PoolConfig.builder().corePoolsize(corePoolSize).maxPoolsize(maxPoolSize).expirationPolicy(expirationPolicy).build(), this.clusterConfig.getAllocatorFactory().create(key.getPoolKey()));
        cluster.add(new ResourcePool(key.getPoolKey(), pool));
    }

    public boolean isPoolRegistered(@NotNull ResourceKey<ClusterKey, PoolKey> key) {
        return this.resourceClusters.containsKey(key.getClusterKey()) && this.resourceClusters.get(key.getClusterKey()).containsPool(key.getPoolKey());
    }

    @Nullable
    public PoolableObject<T> claimResourceFromCluster(ClusterKey clusterKey) throws InterruptedException {
        return this.cycleToNextPool(clusterKey).claim(this.clusterConfig.getClaimTimeout());
    }

    @Nullable
    public PoolableObject<T> claimResourceFromPool(ResourceKey<ClusterKey, PoolKey> key) throws InterruptedException {
        ResourcePools<PoolKey, T> cluster = this.findOrCreateCluster(key.getClusterKey());
        if (!cluster.containsPool(key.getPoolKey())) {
            this.registerResourcePool(key);
        }
        return cluster.claimResource(key.getPoolKey(), this.clusterConfig.getClaimTimeout());
    }

    public int countLiveResources() {
        int total = 0;
        for (ResourcePools<PoolKey, T> resourcePools : this.resourceClusters.values()) {
            total += resourcePools.currentlyAllocated();
        }
        return total;
    }

    public synchronized Future<?> shutDown() {
        return this.shutdownPool(null);
    }

    public synchronized Future<Void> shutdownPool(@Nullable PoolKey key) {
        ArrayList<Future<Void>> poolsShuttingDown = new ArrayList<Future<Void>>();
        for (ResourcePools<PoolKey, T> resourcePools : this.resourceClusters.values()) {
            poolsShuttingDown.add(resourcePools.shutdownPool(key));
        }
        return CompositeFuturesAsFutureTask.ofFutures(poolsShuttingDown);
    }

    private synchronized ResourcePools<PoolKey, T> findOrCreateCluster(ClusterKey clusterKey) {
        if (!this.resourceClusters.containsKey(clusterKey)) {
            Collection<ResourcePool<PoolKey, T>> collectionForCycling = this.loadBalancingStrategy.createCollectionForCycling();
            this.resourceClusters.put(clusterKey, new ResourcePools<PoolKey, T>(collectionForCycling));
        }
        return this.resourceClusters.get(clusterKey);
    }

    private synchronized ResourcePool<PoolKey, T> cycleToNextPool(ClusterKey clusterKey) {
        ResourcePools<PoolKey, T> cluster = this.findOrCreateCluster(clusterKey);
        if (cluster.getClusterCollection().isEmpty()) {
            throw new IllegalStateException(String.format("Cluster contains no pools to draw from for key '%s'", cluster));
        }
        return this.loadBalancingStrategy.cycle(cluster.getClusterCollection());
    }

    public ClusterConfig<PoolKey, T> getClusterConfig() {
        return this.clusterConfig;
    }
}

