/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.GenericObjectPool;
import org.jetbrains.annotations.NotNull;

public class PoolableObject<T> {
    private final GenericObjectPool<T> pool;
    @NotNull
    private T allocatedObject;
    private final Date createdOn = new Date();
    private final long creationStampMs;
    private long allocationStampMs;
    @NotNull
    private Map<ExpirationPolicy, Long> expiriesMs = new HashMap<ExpirationPolicy, Long>();
    @NotNull
    private PoolStatus currentPoolStatus;

    PoolableObject(GenericObjectPool<T> pool, @NotNull T allocatedObject) {
        this.pool = pool;
        this.allocatedObject = allocatedObject;
        this.allocationStampMs = this.creationStampMs = System.currentTimeMillis();
        this.currentPoolStatus = PoolStatus.AVAILABLE;
    }

    public void release() {
        this.pool.releasePoolableObject(this);
    }

    public void invalidate() {
        this.pool.invalidatePoolableObject(this);
    }

    void resetAllocationTimestamp() {
        this.allocationStampMs = System.currentTimeMillis();
    }

    public long ageMs() {
        return System.currentTimeMillis() - this.creationStampMs;
    }

    public long allocationAgeMs() {
        return System.currentTimeMillis() - this.allocationStampMs;
    }

    void dereferenceObject() {
        this.allocatedObject = ObjectDeallocated.INSTANCE;
    }

    @NotNull
    public T getAllocatedObject() {
        if (this.currentPoolStatus == PoolStatus.DEALLOCATED) {
            throw new IllegalStateException("This object has already been deallocated, you can't use it anymore!");
        }
        return this.allocatedObject;
    }

    public Date getCreatedOn() {
        return new Date(this.createdOn.getTime());
    }

    public String toString() {
        return "PoolableObject(allocatedObject=" + this.getAllocatedObject() + ", createdOn=" + this.getCreatedOn() + ", creationStampMs=" + this.creationStampMs + ", allocationStampMs=" + this.allocationStampMs + ", expiriesMs=" + this.getExpiriesMs() + ", currentPoolStatus=" + (Object)((Object)this.getCurrentPoolStatus()) + ")";
    }

    public Map<ExpirationPolicy, Long> getExpiriesMs() {
        return this.expiriesMs;
    }

    PoolStatus getCurrentPoolStatus() {
        return this.currentPoolStatus;
    }

    void setCurrentPoolStatus(PoolStatus currentPoolStatus) {
        this.currentPoolStatus = currentPoolStatus;
    }

    static class ObjectDeallocated {
        static final ObjectDeallocated INSTANCE = new ObjectDeallocated();

        ObjectDeallocated() {
        }
    }

    static enum PoolStatus {
        AVAILABLE,
        CLAIMED,
        WAITING_FOR_DEALLOCATION,
        DEALLOCATED;

    }
}

