/*
 * Copyright © 2019 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.bbottema.genericobjectpool.expirypolicies;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Value;
import lombok.experimental.NonFinal;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

@NonFinal@Value
@SuppressFBWarnings(value = "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", justification = "Generated code")
public class CombinedExpirationPolicies<T> implements ExpirationPolicy<T> {
	
	@NotNull
	private final Set<ExpirationPolicy<T>> expirationPolicies;
	
	@Override
	public boolean hasExpired(@NotNull PoolableObject<T> poolableObject) {
		boolean expired = false;
		for (ExpirationPolicy<T> expirationPolicy : expirationPolicies) {
			if (expirationPolicy.hasExpired(poolableObject)) {
				expired = true; // don't return, expiry policies mutate poolable objects, which might be useful for inspection
			}
		}
		return expired;
	}
}
