/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool;

import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;

public interface ExpirationPolicy<T> {
    public boolean hasExpired(@NotNull PoolableObject<T> var1);

    public static class NeverExpirePolicy<T>
    implements ExpirationPolicy<T> {
        private static final NeverExpirePolicy<?> NEVER_EXPIRE_POLICY = new NeverExpirePolicy();

        static <T> NeverExpirePolicy<T> getInstance() {
            return NEVER_EXPIRE_POLICY;
        }

        @Override
        public boolean hasExpired(@NotNull PoolableObject<T> poolableObject) {
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NeverExpirePolicy)) {
                return false;
            }
            NeverExpirePolicy other = (NeverExpirePolicy)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof NeverExpirePolicy;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public String toString() {
            return "ExpirationPolicy.NeverExpirePolicy()";
        }

        private NeverExpirePolicy() {
        }
    }
}

