/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Generated code")
public class PoolConfig<T> {
    private final int maxPoolsize;
    private final int corePoolsize;
    @NotNull
    private final ThreadFactory threadFactory;
    @NotNull
    private final ExpirationPolicy<T> expirationPolicy;

    private PoolConfig(int maxPoolsize, int corePoolsize, @Nullable ThreadFactory threadFactory, @Nullable ExpirationPolicy<T> expirationPolicy) {
        this.maxPoolsize = maxPoolsize;
        this.corePoolsize = corePoolsize;
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
        ExpirationPolicy<T> expirationPolicy2 = this.expirationPolicy = expirationPolicy != null ? expirationPolicy : ExpirationPolicy.NeverExpirePolicy.getInstance();
        if (maxPoolsize <= 0) {
            throw new IllegalArgumentException("Pool size should have a max size of at least one");
        }
        if (corePoolsize > maxPoolsize) {
            throw new IllegalArgumentException("Core pool size cannot be bigger than the pool's max size");
        }
    }

    public static <T> PoolConfigBuilder<T> builder() {
        return new PoolConfigBuilder();
    }

    public int getMaxPoolsize() {
        return this.maxPoolsize;
    }

    public int getCorePoolsize() {
        return this.corePoolsize;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public ExpirationPolicy<T> getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolConfig)) {
            return false;
        }
        PoolConfig other = (PoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxPoolsize() != other.getMaxPoolsize()) {
            return false;
        }
        if (this.getCorePoolsize() != other.getCorePoolsize()) {
            return false;
        }
        ThreadFactory this$threadFactory = this.getThreadFactory();
        ThreadFactory other$threadFactory = other.getThreadFactory();
        if (this$threadFactory == null ? other$threadFactory != null : !this$threadFactory.equals(other$threadFactory)) {
            return false;
        }
        ExpirationPolicy<T> this$expirationPolicy = this.getExpirationPolicy();
        ExpirationPolicy<T> other$expirationPolicy = other.getExpirationPolicy();
        return !(this$expirationPolicy == null ? other$expirationPolicy != null : !this$expirationPolicy.equals(other$expirationPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxPoolsize();
        result = result * 59 + this.getCorePoolsize();
        ThreadFactory $threadFactory = this.getThreadFactory();
        result = result * 59 + ($threadFactory == null ? 43 : $threadFactory.hashCode());
        ExpirationPolicy<T> $expirationPolicy = this.getExpirationPolicy();
        result = result * 59 + ($expirationPolicy == null ? 43 : $expirationPolicy.hashCode());
        return result;
    }

    public String toString() {
        return "PoolConfig(maxPoolsize=" + this.getMaxPoolsize() + ", corePoolsize=" + this.getCorePoolsize() + ", threadFactory=" + this.getThreadFactory() + ", expirationPolicy=" + this.getExpirationPolicy() + ")";
    }

    public static class PoolConfigBuilder<T> {
        private int maxPoolsize;
        private int corePoolsize;
        private ThreadFactory threadFactory;
        private ExpirationPolicy<T> expirationPolicy;

        PoolConfigBuilder() {
        }

        public PoolConfigBuilder<T> maxPoolsize(int maxPoolsize) {
            this.maxPoolsize = maxPoolsize;
            return this;
        }

        public PoolConfigBuilder<T> corePoolsize(int corePoolsize) {
            this.corePoolsize = corePoolsize;
            return this;
        }

        public PoolConfigBuilder<T> threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public PoolConfigBuilder<T> expirationPolicy(ExpirationPolicy<T> expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
            return this;
        }

        public PoolConfig<T> build() {
            return new PoolConfig(this.maxPoolsize, this.corePoolsize, this.threadFactory, this.expirationPolicy);
        }

        public String toString() {
            return "PoolConfig.PoolConfigBuilder(maxPoolsize=" + this.maxPoolsize + ", corePoolsize=" + this.corePoolsize + ", threadFactory=" + this.threadFactory + ", expirationPolicy=" + this.expirationPolicy + ")";
        }
    }
}

