/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.genericobjectpool.expirypolicies;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;

public abstract class TimeoutExpirationPolicy<T>
implements ExpirationPolicy<T> {
    private final long expiryAgeMs;

    TimeoutExpirationPolicy(long expiryAge, TimeUnit unit) {
        if (expiryAge < 1L) {
            throw new IllegalArgumentException("Max permitted age cannot be less than 1");
        }
        this.expiryAgeMs = unit.toMillis(expiryAge);
    }

    @Override
    public final boolean hasExpired(@NotNull PoolableObject<T> poolableObject) {
        Map<ExpirationPolicy, Long> expiriesMs = poolableObject.getExpiriesMs();
        if (!expiriesMs.containsKey(this)) {
            expiriesMs.put(this, this.expiryAgeMs);
        }
        return this._hasExpired(poolableObject);
    }

    abstract boolean _hasExpired(@NotNull PoolableObject<T> var1);

    public long getExpiryAgeMs() {
        return this.expiryAgeMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeoutExpirationPolicy)) {
            return false;
        }
        TimeoutExpirationPolicy other = (TimeoutExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getExpiryAgeMs() == other.getExpiryAgeMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeoutExpirationPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expiryAgeMs = this.getExpiryAgeMs();
        result = result * 59 + (int)($expiryAgeMs >>> 32 ^ $expiryAgeMs);
        return result;
    }

    public String toString() {
        return "TimeoutExpirationPolicy(expiryAgeMs=" + this.getExpiryAgeMs() + ")";
    }
}

