/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.rtftohtml.impl.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class CharsetHelper {
    private static String[] CHARSET_PREFIXES = new String[]{"", "cp", "iso-", "ibm", "x-windows-", "ms"};
    public static final Charset WINDOWS_CHARSET = Charset.forName("CP1252");

    public static Charset findCharset(String rtfCodePage) {
        if (rtfCodePage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/util/CharsetHelper.findCharset must not be null");
        }
        Charset charset = rtfCodePage.equals("65001") || rtfCodePage.equalsIgnoreCase("cp65001") ? StandardCharsets.UTF_8 : CharsetHelper.detectCharset(rtfCodePage);
        if (charset == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/util/CharsetHelper.findCharset must not return null");
        }
        return charset;
    }

    private static Charset detectCharset(String rtfCodePage) {
        if (rtfCodePage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/util/CharsetHelper.detectCharset must not be null");
        }
        for (String prefix : CHARSET_PREFIXES) {
            Charset charset;
            try {
                charset = Charset.forName(prefix + rtfCodePage);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                continue;
            }
            if (charset == null) {
                throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/util/CharsetHelper.detectCharset must not return null");
            }
            return charset;
        }
        throw new UnsupportedCharsetException(rtfCodePage);
    }
}

