/*
 * Decompiled with CFR 0.152.
 */
package com.bekawestberg.loopinglayout.library;

import com.bekawestberg.loopinglayout.library.LoopingLayoutManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a,\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\r"}, d2={"addViewsAtAnchorEdge", "", "adapterIndex", "layoutManager", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "itemCount", "addViewsAtOptAnchorEdge", "calculateDistances", "Lkotlin/Pair;", "anchorIndex", "count", "defaultDecider", "estimateShortestRoute", "library_release"})
public final class DirectionDecidersKt {
    public static final int defaultDecider(int adapterIndex, @NotNull LoopingLayoutManager layoutManager, int itemCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        return DirectionDecidersKt.estimateShortestRoute(adapterIndex, layoutManager, itemCount);
    }

    public static final int addViewsAtAnchorEdge(int adapterIndex, @NotNull LoopingLayoutManager layoutManager, int itemCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        return layoutManager.convertAdapterDirToMovementDir(-1);
    }

    public static final int addViewsAtOptAnchorEdge(int adapterIndex, @NotNull LoopingLayoutManager layoutManager, int itemCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        return layoutManager.convertAdapterDirToMovementDir(1);
    }

    public static final int estimateShortestRoute(int adapterIndex, @NotNull LoopingLayoutManager layoutManager, int itemCount) {
        int n;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        if (layoutManager.getTopLeftIndex() == adapterIndex) {
            return -1;
        }
        if (layoutManager.getBottomRightIndex() == adapterIndex) {
            return 1;
        }
        Pair<Integer, Integer> pair = DirectionDecidersKt.calculateDistances(adapterIndex, layoutManager.getTopLeftIndex(), itemCount);
        int topLeftInLoopDist = ((Number)pair.component1()).intValue();
        int topLeftOverSeamDist = ((Number)pair.component2()).intValue();
        boolean topLeftTargetSmaller = adapterIndex < layoutManager.getTopLeftIndex();
        Pair<Integer, Integer> pair2 = DirectionDecidersKt.calculateDistances(adapterIndex, layoutManager.getBottomRightIndex(), itemCount);
        int bottomRightInLoopDist = ((Number)pair2.component1()).intValue();
        int bottomRightOverSeamDist = ((Number)pair2.component2()).intValue();
        boolean bottomRightTargetSmaller = adapterIndex < layoutManager.getBottomRightIndex();
        Integer[] integerArray = new Integer[]{topLeftInLoopDist, topLeftOverSeamDist, bottomRightInLoopDist, bottomRightOverSeamDist};
        int minDist = ((Number)((Object)ArraysKt.minOrThrow((Comparable[])integerArray))).intValue();
        int n2 = minDist;
        if (n2 == topLeftInLoopDist ? true : n2 == bottomRightInLoopDist) {
            bl2 = true;
        } else if (n2 == topLeftOverSeamDist ? true : n2 == bottomRightOverSeamDist) {
            bl2 = false;
        } else {
            throw new IllegalStateException();
        }
        boolean minDistIsInLoop = bl2;
        boolean minDistIsOverSeam = !minDistIsInLoop;
        int n3 = minDist;
        if (n3 == topLeftInLoopDist ? true : n3 == topLeftOverSeamDist) {
            bl = topLeftTargetSmaller;
        } else if (n3 == bottomRightInLoopDist ? true : n3 == bottomRightOverSeamDist) {
            bl = bottomRightTargetSmaller;
        } else {
            throw new IllegalStateException();
        }
        boolean targetIsSmaller = bl;
        boolean targetIsLarger = !targetIsSmaller;
        if (targetIsSmaller && minDistIsInLoop) {
            n = -1;
        } else if (targetIsSmaller && minDistIsOverSeam) {
            n = 1;
        } else if (targetIsLarger && minDistIsInLoop) {
            n = 1;
        } else if (targetIsLarger && minDistIsOverSeam) {
            n = -1;
        } else {
            throw new IllegalStateException();
        }
        int adapterDir = n;
        return layoutManager.convertAdapterDirToMovementDir(adapterDir);
    }

    @NotNull
    public static final Pair<Integer, Integer> calculateDistances(int adapterIndex, int anchorIndex, int count) {
        int inLoopDist = Math.abs(adapterIndex - anchorIndex);
        int smallerIndex = Math.min(adapterIndex, anchorIndex);
        int largerIndex = Math.max(adapterIndex, anchorIndex);
        int overSeamDist = count - largerIndex + smallerIndex;
        return new Pair((Object)inLoopDist, (Object)overSeamDist);
    }
}

