/*
 * Decompiled with CFR 0.152.
 */
package com.bekawestberg.loopinglayout.library;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.bekawestberg.loopinglayout.library.LoopableIntExtensionsKt;
import com.bekawestberg.loopinglayout.library.LoopingLayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u0016\u0018\u0000 \u0082\u00012\u00020\u00012\u00020\u0002:\u0010\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001B#\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\b\u00100\u001a\u00020\bH\u0016J\b\u00101\u001a\u00020\bH\u0016J\u0010\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0016J\u0010\u00106\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0016J\b\u00107\u001a\u00020\u0006H\u0002J\b\u00108\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u00020\u0006H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0006H\u0016J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006H\u0002J\u0010\u0010>\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010?\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010@\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0016J\u000e\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u0006J\u000e\u0010C\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006J$\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u00062\n\u0010H\u001a\u00060IR\u00020JH\u0002J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020F0L2\u0006\u0010G\u001a\u00020\u0006H\u0002J\u0006\u0010M\u001a\u00020\u0006J\u0006\u0010N\u001a\u00020\u0006J\u0006\u0010O\u001a\u00020\u0006J\u0006\u0010P\u001a\u00020\u0006J\u0012\u0010Q\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\u0006H\u0016JJ\u0010Q\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\u000628\u0010R\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\bT\u0012\b\bU\u0012\u0004\b\b(V\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\bT\u0012\b\bU\u0012\u0004\b\b(W\u0012\u0006\u0012\u0004\u0018\u00010F0SJ\b\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0010\u0010[\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0014\u0010\\\u001a\u00060]R\u00020\u00002\u0006\u0010D\u001a\u00020\u0006H\u0002J\u001c\u0010^\u001a\u00060]R\u00020\u00002\u0006\u0010D\u001a\u00020\u00062\u0006\u0010_\u001a\u00020FH\u0002J\u0010\u0010`\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0010\u0010a\u001a\u00020b2\u0006\u0010_\u001a\u00020FH\u0002J\b\u0010c\u001a\u00020\bH\u0016J\u0010\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u0006H\u0002J$\u0010g\u001a\u00020e2\n\u0010H\u001a\u00060IR\u00020J2\u0006\u00103\u001a\u0002042\u0006\u0010h\u001a\u00020iH\u0016J\u001c\u0010j\u001a\u00020e2\n\u0010H\u001a\u00060IR\u00020J2\u0006\u00103\u001a\u000204H\u0016J\u0012\u0010k\u001a\u00020e2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0012\u0010l\u001a\u00020e2\b\u00103\u001a\u0004\u0018\u00010mH\u0016J\n\u0010n\u001a\u0004\u0018\u00010mH\u0016J$\u0010o\u001a\u00020e2\u0006\u0010D\u001a\u00020\u00062\n\u0010H\u001a\u00060IR\u00020J2\u0006\u00103\u001a\u000204H\u0002J\u0014\u0010p\u001a\u00020e2\n\u0010H\u001a\u00060IR\u00020JH\u0002J$\u0010q\u001a\u00020\u00062\u0006\u0010r\u001a\u00020\u00062\n\u0010H\u001a\u00060IR\u00020J2\u0006\u00103\u001a\u000204H\u0002J$\u0010s\u001a\u00020\u00062\u0006\u0010t\u001a\u00020\u00062\n\u0010H\u001a\u00060IR\u00020J2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010u\u001a\u00020e2\u0006\u0010G\u001a\u00020\u0006H\u0016J[\u0010u\u001a\u00020e2\u0006\u0010G\u001a\u00020\u00062K\u0010R\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\bT\u0012\b\bU\u0012\u0004\b\b(V\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\bT\u0012\b\bU\u0012\u0004\b\b(W\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\bT\u0012\b\bU\u0012\u0004\b\b(v\u0012\u0004\u0012\u00020\u00060)J$\u0010w\u001a\u00020\u00062\u0006\u0010x\u001a\u00020\u00062\n\u0010H\u001a\u00060IR\u00020J2\u0006\u00103\u001a\u000204H\u0016J \u0010y\u001a\u00020e2\u0006\u0010z\u001a\u00020J2\u0006\u00103\u001a\u0002042\u0006\u0010{\u001a\u00020\u0006H\u0016J*\u0010|\u001a\u00020\u00062\u0006\u0010}\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u00062\u0006\u00103\u001a\u0002042\b\b\u0002\u0010~\u001a\u00020\bH\u0002J\u0010\u0010\u007f\u001a\u00020\b2\u0006\u0010_\u001a\u00020FH\u0002J\u0011\u0010\u0080\u0001\u001a\u00020\b2\u0006\u0010_\u001a\u00020FH\u0002J\u0011\u0010\u0081\u0001\u001a\u00020\b2\u0006\u0010G\u001a\u00020\u0006H\u0002R\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0011\"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010'R2\u0010(\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001e\u0010.\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0011\u00a8\u0006\u008a\u0001"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "Landroidx/recyclerview/widget/RecyclerView$SmoothScroller$ScrollVectorProvider;", "context", "Landroid/content/Context;", "orientation", "", "reverseLayout", "", "(Landroid/content/Context;IZ)V", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "anchorIndex", "getAnchorIndex", "()I", "<set-?>", "bottomRightIndex", "getBottomRightIndex", "extraLayoutSpace", "isLayoutRTL", "()Z", "layoutHeight", "getLayoutHeight", "layoutRequest", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LayoutRequest;", "layoutWidth", "getLayoutWidth", "optAnchorIndex", "getOptAnchorIndex", "getOrientation", "setOrientation", "(I)V", "orientationHelper", "Landroidx/recyclerview/widget/OrientationHelper;", "getReverseLayout", "setReverseLayout", "(Z)V", "smoothScrollDirectionDecider", "Lkotlin/Function3;", "getSmoothScrollDirectionDecider", "()Lkotlin/jvm/functions/Function3;", "setSmoothScrollDirectionDecider", "(Lkotlin/jvm/functions/Function3;)V", "topLeftIndex", "getTopLeftIndex", "canScrollHorizontally", "canScrollVertically", "computeHorizontalScrollExtent", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "computeHorizontalScrollOffset", "computeHorizontalScrollRange", "computeScrollExtent", "computeScrollOffset", "computeScrollRange", "computeScrollVectorForPosition", "Landroid/graphics/PointF;", "targetPosition", "count", "computeVerticalScrollExtent", "computeVerticalScrollOffset", "computeVerticalScrollRange", "convertAdapterDirToMovementDir", "adapterDir", "convertMovementDirToAdapterDir", "movementDir", "createViewForIndex", "Landroid/view/View;", "adapterIndex", "recycler", "Landroidx/recyclerview/widget/RecyclerView$Recycler;", "Landroidx/recyclerview/widget/RecyclerView;", "findAllViewsWithPosition", "", "findFirstCompletelyVisibleItemPosition", "findFirstVisibleItemPosition", "findLastCompletelyVisibleItemPosition", "findLastVisibleItemPosition", "findViewByPosition", "strategy", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "targetIndex", "layoutManager", "generateDefaultLayoutParams", "Landroidx/recyclerview/widget/RecyclerView$LayoutParams;", "getAdapterDirectionFromMovementDirection", "getInitialIndex", "getInitialItem", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$ListItem;", "getItemForView", "view", "getMovementDirectionFromAdapterDirection", "getNonScrollingEdges", "Landroid/graphics/Rect;", "isAutoMeasureEnabled", "offsetChildren", "", "amount", "onInitializeAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onLayoutChildren", "onLayoutCompleted", "onRestoreInstanceState", "Landroid/os/Parcelable;", "onSaveInstanceState", "recycleViews", "scrapNonVisibleViews", "scrollBy", "delta", "scrollHorizontallyBy", "dx", "scrollToPosition", "itemCount", "scrollVerticallyBy", "dy", "smoothScrollToPosition", "recyclerView", "position", "stepIndex", "index", "updateIndex", "viewIsFullyVisible", "viewIsVisible", "viewWithIndexIsFullyVisible", "Companion", "LayoutRequest", "LeadingBottomListItem", "LeadingLeftListItem", "LeadingRightListItem", "LeadingTopListItem", "ListItem", "LoopingSmoothScroller", "library_release"})
@SourceDebugExtension(value={"SMAP\nLoopingLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoopingLayoutManager.kt\ncom/bekawestberg/loopinglayout/library/LoopingLayoutManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1313:1\n1855#2,2:1314\n*S KotlinDebug\n*F\n+ 1 LoopingLayoutManager.kt\ncom/bekawestberg/loopinglayout/library/LoopingLayoutManager\n*L\n527#1:1314,2\n*E\n"})
public class LoopingLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LayoutRequest layoutRequest;
    private int extraLayoutSpace;
    private OrientationHelper orientationHelper;
    private int topLeftIndex;
    private int bottomRightIndex;
    @NotNull
    private Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer> smoothScrollDirectionDecider;
    private int orientation;
    private boolean reverseLayout;
    @NotNull
    private static final String TAG = "LoopingLayoutManager";
    private static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TOWARDS_TOP_LEFT = -1;
    public static final int TOWARDS_BOTTOM_RIGHT = 1;
    public static final int TOWARDS_LOWER_INDICES = -1;
    public static final int TOWARDS_HIGHER_INDICES = 1;
    private static final int SCROLL_OFFSET = 100;
    private static final int SCROLL_RANGE = 200;

    public final int getLayoutWidth() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public final int getLayoutHeight() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    public final int getTopLeftIndex() {
        return this.topLeftIndex;
    }

    public final int getBottomRightIndex() {
        return this.bottomRightIndex;
    }

    public final int getAnchorIndex() {
        return this.getInitialIndex(this.getMovementDirectionFromAdapterDirection(-1));
    }

    public final int getOptAnchorIndex() {
        return this.getInitialIndex(this.getMovementDirectionFromAdapterDirection(1));
    }

    @NotNull
    public final Function3<Integer, LoopingLayoutManager, Integer, Integer> getSmoothScrollDirectionDecider() {
        return this.smoothScrollDirectionDecider;
    }

    public final void setSmoothScrollDirectionDecider(@NotNull Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer> function3) {
        Intrinsics.checkNotNullParameter(function3, (String)"<set-?>");
        this.smoothScrollDirectionDecider = function3;
    }

    @JvmOverloads
    public LoopingLayoutManager(@NotNull Context context, int orientation, boolean reverseLayout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.layoutRequest = new LayoutRequest(0, 0, 0, null, null, null, 62, null);
        this.smoothScrollDirectionDecider = smoothScrollDirectionDecider.1.INSTANCE;
        this.setOrientation(orientation);
        this.setReverseLayout(reverseLayout);
    }

    public /* synthetic */ LoopingLayoutManager(Context context, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(context, n, bl);
    }

    public LoopingLayoutManager(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        this.layoutRequest = new LayoutRequest(0, 0, 0, null, null, null, 62, null);
        this.smoothScrollDirectionDecider = smoothScrollDirectionDecider.1.INSTANCE;
        RecyclerView.LayoutManager.Properties properties = RecyclerView.LayoutManager.getProperties((Context)context, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
        this.setOrientation(properties.orientation);
        this.setReverseLayout(properties.reverseLayout);
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int orientation) {
        if (!(orientation == 0 || orientation == 1)) {
            boolean bl = false;
            String string = "invalid orientation:" + orientation;
            throw new IllegalArgumentException(string.toString());
        }
        if (orientation != this.orientation) {
            OrientationHelper orientationHelper = OrientationHelper.createOrientationHelper((RecyclerView.LayoutManager)this, (int)orientation);
            Intrinsics.checkNotNullExpressionValue((Object)orientationHelper, (String)"createOrientationHelper(this, orientation)");
            this.orientationHelper = orientationHelper;
            this.assertNotInLayoutOrScroll(null);
            this.orientation = orientation;
            this.requestLayout();
            return;
        }
        if (this.orientationHelper == null) {
            OrientationHelper orientationHelper = OrientationHelper.createOrientationHelper((RecyclerView.LayoutManager)this, (int)orientation);
            Intrinsics.checkNotNullExpressionValue((Object)orientationHelper, (String)"createOrientationHelper(this, orientation)");
            this.orientationHelper = orientationHelper;
        }
    }

    public final boolean getReverseLayout() {
        return this.reverseLayout;
    }

    public final void setReverseLayout(boolean reverseLayout) {
        if (reverseLayout == this.reverseLayout) {
            return;
        }
        this.assertNotInLayoutOrScroll(null);
        this.reverseLayout = reverseLayout;
        this.requestLayout();
    }

    public final boolean isLayoutRTL() {
        return this.getLayoutDirection() == 1;
    }

    public boolean isAutoMeasureEnabled() {
        return true;
    }

    @NotNull
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        int direction = this.getMovementDirectionFromAdapterDirection(-1);
        return this.getChildCount() == 0 ? null : (Parcelable)new LayoutRequest(this.getInitialIndex(direction), this.getInitialItem(direction).getHiddenSize(), 0, null, null, null, 60, null);
    }

    public void onRestoreInstanceState(@Nullable Parcelable state) {
        if (state instanceof LayoutRequest) {
            this.layoutRequest = (LayoutRequest)state;
        }
    }

    public void onLayoutChildren(@NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        ListItem item;
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.layoutRequest.initialize(this, state);
        this.detachAndScrapAttachedViews(recycler);
        int movementDir = this.getMovementDirectionFromAdapterDirection(-this.layoutRequest.getAdapterDirection());
        ListItem prevItem = null;
        int size = this.orientation == 0 ? this.getLayoutWidth() : this.getLayoutHeight();
        int index = Math.min(this.layoutRequest.getAnchorIndex(), state.getItemCount() - 1);
        for (int sizeFilled = 0; sizeFilled < size; sizeFilled += item.getSize()) {
            View view = this.createViewForIndex(index, movementDir, recycler);
            item = this.getItemForView(movementDir, view);
            Object layoutRect = this.getNonScrollingEdges(view);
            ListItem listItem = prevItem;
            if (listItem == null || (listItem = listItem.getPositionOfItemFollowingSelf(item, (Rect)layoutRect)) == null) {
                listItem = item.getPositionOfSelfAsFirst((Rect)layoutRect, this.layoutRequest.getScrollOffset());
            }
            layoutRect = listItem;
            this.layoutDecorated(view, layoutRect.left, layoutRect.top, layoutRect.right, layoutRect.bottom);
            index = this.stepIndex(index, movementDir, state, false);
            prevItem = item;
        }
        if (movementDir == -1) {
            this.bottomRightIndex = this.layoutRequest.getAnchorIndex();
            this.topLeftIndex = this.stepIndex(index, -movementDir, state, false);
        } else {
            this.topLeftIndex = this.layoutRequest.getAnchorIndex();
            this.bottomRightIndex = this.stepIndex(index, -movementDir, state, false);
        }
    }

    public void onLayoutCompleted(@Nullable RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.layoutRequest.finishProcessing();
    }

    public boolean canScrollVertically() {
        return this.orientation == 1;
    }

    public int scrollVerticallyBy(int dy, @NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.scrollBy(dy, recycler, state);
    }

    public boolean canScrollHorizontally() {
        return this.orientation == 0;
    }

    public int scrollHorizontallyBy(int dx, @NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.scrollBy(dx, recycler, state);
    }

    private final int scrollBy(int delta, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || delta == 0) {
            return 0;
        }
        int movementDir = Integer.signum(delta);
        this.scrapNonVisibleViews(recycler);
        int absDelta = Math.abs(delta);
        int amountScrolled = 0;
        int index = this.getInitialIndex(movementDir);
        ListItem selectedItem = this.getInitialItem(movementDir);
        while (amountScrolled < absDelta) {
            int hiddenSize = selectedItem.getHiddenSize();
            int amountToScroll = RangesKt.coerceAtMost((int)hiddenSize, (int)(absDelta - amountScrolled));
            this.offsetChildren(amountToScroll * -movementDir);
            if ((amountScrolled += amountToScroll) >= absDelta) continue;
            index = LoopingLayoutManager.stepIndex$default(this, index, movementDir, state, false, 8, null);
            View newView = this.createViewForIndex(index, movementDir, recycler);
            ListItem newItem = this.getItemForView(movementDir, newView);
            Rect layoutRect = this.getNonScrollingEdges(newView);
            layoutRect = selectedItem.getPositionOfItemFollowingSelf(newItem, layoutRect);
            this.layoutDecorated(newView, layoutRect.left, layoutRect.top, layoutRect.right, layoutRect.bottom);
            selectedItem = newItem;
        }
        for (int viewSpace = selectedItem.getHiddenSize(); viewSpace < this.extraLayoutSpace; viewSpace += selectedItem.getSize()) {
            index = this.stepIndex(index, movementDir, state, false);
            View newView = this.createViewForIndex(index, movementDir, recycler);
            ListItem newItem = this.getItemForView(movementDir, newView);
            Rect layoutRect = this.getNonScrollingEdges(newView);
            layoutRect = selectedItem.getPositionOfItemFollowingSelf(newItem, layoutRect);
            this.layoutDecorated(newView, layoutRect.left, layoutRect.top, layoutRect.right, layoutRect.bottom);
            selectedItem = newItem;
        }
        this.recycleViews(movementDir, recycler, state);
        return amountScrolled * movementDir;
    }

    private final Rect getNonScrollingEdges(View view) {
        Rect layoutRect = new Rect();
        boolean isVertical = this.orientation == 1;
        if (isVertical && this.isLayoutRTL()) {
            int n = layoutRect.right = this.getWidth() - this.getPaddingRight();
            OrientationHelper orientationHelper = this.orientationHelper;
            if (orientationHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"orientationHelper");
                orientationHelper = null;
            }
            layoutRect.left = n - orientationHelper.getDecoratedMeasurementInOther(view);
        } else if (isVertical && !this.isLayoutRTL()) {
            int n = layoutRect.left = this.getPaddingLeft();
            OrientationHelper orientationHelper = this.orientationHelper;
            if (orientationHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"orientationHelper");
                orientationHelper = null;
            }
            layoutRect.right = n + orientationHelper.getDecoratedMeasurementInOther(view);
        } else {
            int n = layoutRect.top = this.getPaddingTop();
            OrientationHelper orientationHelper = this.orientationHelper;
            if (orientationHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"orientationHelper");
                orientationHelper = null;
            }
            layoutRect.bottom = n + orientationHelper.getDecoratedMeasurementInOther(view);
        }
        return layoutRect;
    }

    private final View createViewForIndex(int adapterIndex, int movementDir, RecyclerView.Recycler recycler) {
        View view = recycler.getViewForPosition(adapterIndex);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"recycler.getViewForPosition(adapterIndex)");
        View newView = view;
        if (movementDir == -1) {
            this.addView(newView, 0);
        } else {
            this.addView(newView);
        }
        this.measureChildWithMargins(newView, 0, 0);
        return newView;
    }

    private final void offsetChildren(int amount) {
        if (this.orientation == 0) {
            this.offsetChildrenHorizontal(amount);
        } else {
            this.offsetChildrenVertical(amount);
        }
    }

    private final int getInitialIndex(int movementDir) {
        return movementDir == -1 ? this.topLeftIndex : this.bottomRightIndex;
    }

    private final ListItem getInitialItem(int movementDir) {
        View initialView;
        View view = initialView = movementDir == -1 ? this.getChildAt(0) : this.getChildAt(this.getChildCount() - 1);
        Intrinsics.checkNotNull((Object)view);
        return this.getItemForView(movementDir, view);
    }

    private final int stepIndex(int index, int movementDir, RecyclerView.State state, boolean updateIndex) {
        int adapterDirection = this.getAdapterDirectionFromMovementDirection(movementDir);
        int count = state.getItemCount();
        boolean isTowardsTopLeft = movementDir == -1;
        boolean isTowardsBottomRight = movementDir == 1;
        boolean isTowardsHigherIndices = adapterDirection == 1;
        boolean isTowardsLowerIndices = adapterDirection == -1;
        int newIndex = 0;
        if (isTowardsTopLeft && isTowardsHigherIndices) {
            newIndex = LoopableIntExtensionsKt.loopedIncrement(index, count);
            if (updateIndex) {
                this.topLeftIndex = newIndex;
            }
        } else if (isTowardsTopLeft && isTowardsLowerIndices) {
            newIndex = LoopableIntExtensionsKt.loopedDecrement(index, count);
            if (updateIndex) {
                this.topLeftIndex = newIndex;
            }
        } else if (isTowardsBottomRight && isTowardsHigherIndices) {
            newIndex = LoopableIntExtensionsKt.loopedIncrement(index, count);
            if (updateIndex) {
                this.bottomRightIndex = newIndex;
            }
        } else if (isTowardsBottomRight && isTowardsLowerIndices) {
            newIndex = LoopableIntExtensionsKt.loopedDecrement(index, count);
            if (updateIndex) {
                this.bottomRightIndex = newIndex;
            }
        } else {
            throw new IllegalStateException("Invalid move & adapter direction combination.");
        }
        return newIndex;
    }

    static /* synthetic */ int stepIndex$default(LoopingLayoutManager loopingLayoutManager, int n, int n2, RecyclerView.State state, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stepIndex");
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return loopingLayoutManager.stepIndex(n, n2, state, bl);
    }

    private final ListItem getItemForView(int movementDir, View view) {
        ListItem listItem;
        boolean isVertical = this.orientation == 1;
        boolean isHorizontal = !isVertical;
        boolean isTowardsTopLeft = movementDir == -1;
        boolean isTowardsBottomRight = !isTowardsTopLeft;
        if (isVertical && isTowardsTopLeft) {
            listItem = new LeadingBottomListItem(view);
        } else if (isVertical && isTowardsBottomRight) {
            listItem = new LeadingTopListItem(view);
        } else if (isHorizontal && isTowardsTopLeft) {
            listItem = new LeadingRightListItem(view);
        } else if (isHorizontal && isTowardsBottomRight) {
            listItem = new LeadingLeftListItem(view);
        } else {
            throw new IllegalStateException("Invalid movement state.");
        }
        return listItem;
    }

    private final void scrapNonVisibleViews(RecyclerView.Recycler recycler) {
        for (int i = this.getChildCount() - 1; -1 < i; --i) {
            View view;
            if (this.getChildAt(i) == null || this.viewIsVisible(view)) continue;
            this.detachAndScrapView(view, recycler);
        }
    }

    private final void recycleViews(int movementDir, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int initialIndex = this.getInitialIndex(movementDir);
        int distanceFromStart = -1;
        boolean foundVisibleView = false;
        List viewsToRemove = new ArrayList();
        IntProgression range = movementDir == -1 ? (IntProgression)RangesKt.until((int)0, (int)this.getChildCount()) : RangesKt.downTo((int)(this.getChildCount() - 1), (int)0);
        int i = range.getFirst();
        int n = range.getLast();
        int n2 = range.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                View view;
                Intrinsics.checkNotNull((Object)this.getChildAt(i));
                if (this.viewIsVisible(view)) {
                    if (!foundVisibleView) {
                        foundVisibleView = true;
                    }
                    ++distanceFromStart;
                } else if (foundVisibleView) {
                    viewsToRemove.add(i);
                }
                if (i == n) break;
                i += n2;
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.sortedDescending((Iterable)viewsToRemove);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int i2 = ((Number)element$iv).intValue();
            boolean bl = false;
            this.removeAndRecycleViewAt(i2, recycler);
        }
        if (((Collection)viewsToRemove).size() == 0) {
            return;
        }
        int adapterDirection = this.getAdapterDirectionFromMovementDirection(movementDir * -1);
        int changeInPosition = adapterDirection * distanceFromStart;
        int count = state.getItemCount();
        if (movementDir == -1) {
            this.bottomRightIndex = LoopableIntExtensionsKt.loop(initialIndex, changeInPosition, count);
        } else {
            this.topLeftIndex = LoopableIntExtensionsKt.loop(initialIndex, changeInPosition, count);
        }
    }

    private final boolean viewIsVisible(View view) {
        return this.orientation == 0 ? this.getDecoratedRight(view) > this.getPaddingLeft() && this.getDecoratedLeft(view) < this.getWidth() - this.getPaddingRight() : this.getDecoratedBottom(view) > this.getPaddingTop() && this.getDecoratedTop(view) < this.getHeight() - this.getPaddingBottom();
    }

    private final boolean viewIsFullyVisible(View view) {
        return this.orientation == 0 ? this.getDecoratedLeft(view) >= this.getPaddingLeft() && this.getDecoratedRight(view) <= this.getWidth() - this.getPaddingRight() : this.getDecoratedTop(view) >= this.getPaddingTop() && this.getDecoratedBottom(view) <= this.getHeight() - this.getPaddingBottom();
    }

    public final int convertMovementDirToAdapterDir(int movementDir) {
        return this.getMovementDirectionFromAdapterDirection(movementDir);
    }

    private final int getAdapterDirectionFromMovementDirection(int movementDir) {
        int n;
        boolean isVertical = this.orientation == 1;
        boolean isHorizontal = !isVertical;
        boolean isTowardsTopLeft = movementDir == -1;
        boolean isTowardsBottomRight = !isTowardsTopLeft;
        boolean isRTL = this.isLayoutRTL();
        boolean isLTR = !isRTL;
        boolean isReversed = this.reverseLayout;
        boolean isNotReversed = !isReversed;
        if (isVertical && isTowardsTopLeft && isNotReversed) {
            n = -1;
        } else if (isVertical && isTowardsTopLeft && isReversed) {
            n = 1;
        } else if (isVertical && isTowardsBottomRight && isNotReversed) {
            n = 1;
        } else if (isVertical && isTowardsBottomRight && isReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsTopLeft && isLTR && isNotReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsTopLeft && isLTR && isReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsTopLeft && isRTL && isNotReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsTopLeft && isRTL && isReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsBottomRight && isLTR && isNotReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsBottomRight && isLTR && isReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsBottomRight && isRTL && isNotReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsBottomRight && isRTL && isReversed) {
            n = 1;
        } else {
            throw new IllegalStateException("Invalid movement state.");
        }
        return n;
    }

    public final int convertAdapterDirToMovementDir(int adapterDir) {
        return this.getMovementDirectionFromAdapterDirection(adapterDir);
    }

    private final int getMovementDirectionFromAdapterDirection(int movementDir) {
        int n;
        boolean isVertical = this.orientation == 1;
        boolean isHorizontal = !isVertical;
        boolean isTowardsHigher = movementDir == 1;
        boolean isTowardsLower = !isTowardsHigher;
        boolean isRTL = this.isLayoutRTL();
        boolean isLTR = !isRTL;
        boolean isReversed = this.reverseLayout;
        boolean isNotReversed = !isReversed;
        if (isVertical && isTowardsHigher && isNotReversed) {
            n = 1;
        } else if (isVertical && isTowardsHigher && isReversed) {
            n = -1;
        } else if (isVertical && isTowardsLower && isNotReversed) {
            n = -1;
        } else if (isVertical && isTowardsLower && isReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsHigher && isLTR && isNotReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsHigher && isLTR && isReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsHigher && isRTL && isNotReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsHigher && isRTL && isReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsLower && isLTR && isNotReversed) {
            n = -1;
        } else if (isHorizontal && isTowardsLower && isLTR && isReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsLower && isRTL && isNotReversed) {
            n = 1;
        } else if (isHorizontal && isTowardsLower && isRTL && isReversed) {
            n = -1;
        } else {
            throw new IllegalStateException("Invalid adapter state.");
        }
        return n;
    }

    public int computeVerticalScrollOffset(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.computeScrollOffset();
    }

    public int computeVerticalScrollRange(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.computeScrollRange();
    }

    public int computeVerticalScrollExtent(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.computeScrollExtent();
    }

    public int computeHorizontalScrollOffset(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.computeScrollOffset();
    }

    public int computeHorizontalScrollRange(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.computeScrollRange();
    }

    public int computeHorizontalScrollExtent(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.computeScrollExtent();
    }

    private final int computeScrollOffset() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        return 100;
    }

    private final int computeScrollRange() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        return 200;
    }

    private final int computeScrollExtent() {
        return 0;
    }

    public void onInitializeAccessibilityEvent(@NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state, @NotNull AccessibilityEvent event) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onInitializeAccessibilityEvent(recycler, state, event);
        if (this.getChildCount() > 0) {
            event.setFromIndex(this.topLeftIndex);
            event.setToIndex(this.bottomRightIndex);
        }
    }

    @NotNull
    public PointF computeScrollVectorForPosition(int targetPosition) {
        return this.computeScrollVectorForPosition(targetPosition, this.getItemCount());
    }

    private final PointF computeScrollVectorForPosition(int targetPosition, int count) {
        int movementDir = ((Number)this.smoothScrollDirectionDecider.invoke((Object)targetPosition, (Object)this, (Object)count)).intValue();
        return this.orientation == 0 ? new PointF((float)movementDir, 0.0f) : new PointF(0.0f, (float)movementDir);
    }

    @Nullable
    public View findViewByPosition(int adapterIndex) {
        return this.findViewByPosition(adapterIndex, (Function2<? super Integer, ? super LoopingLayoutManager, ? extends View>)((Function2)findViewByPosition.1.INSTANCE));
    }

    @Nullable
    public final View findViewByPosition(int adapterIndex, @NotNull Function2<? super Integer, ? super LoopingLayoutManager, ? extends View> strategy) {
        Intrinsics.checkNotNullParameter(strategy, (String)"strategy");
        return (View)strategy.invoke((Object)adapterIndex, (Object)this);
    }

    private final Iterable<View> findAllViewsWithPosition(int adapterIndex) {
        List views = new ArrayList();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view == null || this.getPosition(view) != adapterIndex) continue;
            ((Collection)views).add(view);
        }
        return views;
    }

    public final int findFirstVisibleItemPosition() {
        int lowestIndex = Integer.MAX_VALUE;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view == null || this.getPosition(view) >= lowestIndex || !this.viewIsVisible(view)) continue;
            lowestIndex = this.getPosition(view);
        }
        return lowestIndex;
    }

    public final int findFirstCompletelyVisibleItemPosition() {
        int lowestIndex = Integer.MAX_VALUE;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view == null || this.getPosition(view) >= lowestIndex || !this.viewIsFullyVisible(view)) continue;
            lowestIndex = this.getPosition(view);
        }
        return lowestIndex;
    }

    public final int findLastVisibleItemPosition() {
        int highestIndex = 0;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view == null || this.getPosition(view) <= highestIndex || !this.viewIsVisible(view)) continue;
            highestIndex = this.getPosition(view);
        }
        return highestIndex;
    }

    public final int findLastCompletelyVisibleItemPosition() {
        int highestIndex = 0;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view == null || this.getPosition(view) <= highestIndex || !this.viewIsFullyVisible(view)) continue;
            highestIndex = this.getPosition(view);
        }
        return highestIndex;
    }

    public void scrollToPosition(int adapterIndex) {
        this.scrollToPosition(adapterIndex, (Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer>)((Function3)scrollToPosition.1.INSTANCE));
    }

    public final void scrollToPosition(int adapterIndex, @NotNull Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer> strategy) {
        Intrinsics.checkNotNullParameter(strategy, (String)"strategy");
        if (this.viewWithIndexIsFullyVisible(adapterIndex)) {
            return;
        }
        this.layoutRequest = new LayoutRequest(adapterIndex, 0, 0, strategy, null, null, 54, null);
        this.requestLayout();
    }

    private final boolean viewWithIndexIsFullyVisible(int adapterIndex) {
        Iterable<View> views = this.findAllViewsWithPosition(adapterIndex);
        for (View view : views) {
            if (!this.viewIsFullyVisible(view)) continue;
            return true;
        }
        return false;
    }

    public void smoothScrollToPosition(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.State state, int position) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Context context = recyclerView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"recyclerView.context");
        LoopingSmoothScroller loopingSmoothScroller = new LoopingSmoothScroller(context, state);
        loopingSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)loopingSmoothScroller);
    }

    @JvmOverloads
    public LoopingLayoutManager(@NotNull Context context, int orientation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, orientation, false, 4, null);
    }

    @JvmOverloads
    public LoopingLayoutManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, 0, false, 6, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Ba\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\"\b\u0002\u0010\t\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB\u0005\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0006H\u0016R \u0010\b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00068F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00068F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00068F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R(\u0010\t\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LayoutRequest;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "anchorIndex", "", "scrollOffset", "adapterDirection", "scrollStrategy", "Lkotlin/Function3;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "layoutManager", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "(IIILkotlin/jvm/functions/Function3;Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;Landroidx/recyclerview/widget/RecyclerView$State;)V", "()V", "<set-?>", "getAdapterDirection", "()I", "getAnchorIndex", "hasBeenInitialized", "", "getScrollOffset", "describeContents", "finishProcessing", "", "initialize", "writeToParcel", "flags", "CREATOR", "library_release"})
    private static final class LayoutRequest
    implements Parcelable {
        @NotNull
        public static final CREATOR CREATOR = new CREATOR(null);
        private int anchorIndex;
        private int scrollOffset;
        private int adapterDirection;
        @Nullable
        private Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer> scrollStrategy;
        private boolean hasBeenInitialized;

        public LayoutRequest() {
            this.anchorIndex = -1;
            this.adapterDirection = -1;
        }

        public final int getAnchorIndex() {
            if (!this.hasBeenInitialized) {
                throw new Exception("LayoutRequest has not been initialized.");
            }
            return this.anchorIndex;
        }

        public final int getScrollOffset() {
            if (!this.hasBeenInitialized) {
                throw new Exception("LayoutRequest has not been initialized.");
            }
            return this.scrollOffset;
        }

        public final int getAdapterDirection() {
            if (!this.hasBeenInitialized) {
                throw new Exception("LayoutRequest has not been initialized.");
            }
            return this.adapterDirection;
        }

        public LayoutRequest(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            this();
            this.anchorIndex = parcel.readInt();
            this.scrollOffset = parcel.readInt();
            this.adapterDirection = parcel.readInt();
        }

        public LayoutRequest(int anchorIndex, int scrollOffset, int adapterDirection, @Nullable Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer> scrollStrategy, @Nullable LoopingLayoutManager layoutManager, @Nullable RecyclerView.State state) {
            this();
            this.anchorIndex = anchorIndex;
            this.scrollOffset = scrollOffset;
            this.adapterDirection = adapterDirection;
            this.scrollStrategy = scrollStrategy;
            if (layoutManager != null && state != null) {
                this.initialize(layoutManager, state);
            }
            if (!this.hasBeenInitialized && anchorIndex != -1 && scrollStrategy == null) {
                this.hasBeenInitialized = true;
            }
        }

        public /* synthetic */ LayoutRequest(int n, int n2, int n3, Function3 function3, LoopingLayoutManager loopingLayoutManager, RecyclerView.State state, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = -1;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = -1;
            }
            if ((n4 & 8) != 0) {
                function3 = null;
            }
            if ((n4 & 0x10) != 0) {
                loopingLayoutManager = null;
            }
            if ((n4 & 0x20) != 0) {
                state = null;
            }
            this(n, n2, n3, (Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer>)function3, loopingLayoutManager, state);
        }

        /*
         * WARNING - void declaration
         */
        public final void initialize(@NotNull LoopingLayoutManager layoutManager, @NotNull RecyclerView.State state) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (this.hasBeenInitialized) {
                return;
            }
            this.hasBeenInitialized = true;
            LayoutRequest layoutRequest = this;
            Function3<? super Integer, ? super LoopingLayoutManager, ? super Integer, Integer> function3 = this.scrollStrategy;
            if (function3 != null) {
                void it;
                int n2 = ((Number)function3.invoke((Object)this.getAnchorIndex(), (Object)layoutManager, (Object)state.getItemCount())).intValue();
                LayoutRequest layoutRequest2 = layoutRequest;
                boolean bl = false;
                int n3 = layoutManager.getAdapterDirectionFromMovementDirection((int)it);
                layoutRequest = layoutRequest2;
                n = n3;
            } else {
                n = layoutRequest.adapterDirection = this.getAdapterDirection();
            }
            if (this.getAnchorIndex() == -1) {
                if (layoutManager.getChildCount() == 0) {
                    this.anchorIndex = 0;
                } else {
                    int direction = layoutManager.getMovementDirectionFromAdapterDirection(this.getAdapterDirection());
                    this.anchorIndex = layoutManager.getInitialIndex(direction);
                    this.scrollOffset = layoutManager.getInitialItem(direction).getHiddenSize();
                }
            }
        }

        public final void finishProcessing() {
            this.anchorIndex = -1;
            this.scrollOffset = 0;
            this.adapterDirection = -1;
            this.scrollStrategy = null;
            this.hasBeenInitialized = false;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeInt(this.getAnchorIndex());
            parcel.writeInt(this.getScrollOffset());
            parcel.writeInt(this.getAdapterDirection());
        }

        public int describeContents() {
            return 0;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LayoutRequest$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LayoutRequest;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LayoutRequest;", "library_release"})
        public static final class CREATOR
        implements Parcelable.Creator<LayoutRequest> {
            private CREATOR() {
            }

            @NotNull
            public LayoutRequest createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new LayoutRequest(parcel);
            }

            @NotNull
            public LayoutRequest[] newArray(int size) {
                int n = 0;
                LayoutRequest[] layoutRequestArray = new LayoutRequest[size];
                while (n < size) {
                    int n2 = n++;
                    layoutRequestArray[n2] = new LayoutRequest();
                }
                return layoutRequestArray;
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0000R\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H&J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0006H&R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0012\u0010\u000b\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0012\u0010\r\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$ListItem;", "", "view", "Landroid/view/View;", "(Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;Landroid/view/View;)V", "followingEdge", "", "getFollowingEdge", "()I", "hiddenSize", "getHiddenSize", "leadingEdge", "getLeadingEdge", "size", "getSize", "getView", "()Landroid/view/View;", "getPositionOfItemFollowingSelf", "Landroid/graphics/Rect;", "item", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "rect", "getPositionOfSelfAsFirst", "hiddenAmount", "library_release"})
    private abstract class ListItem {
        @NotNull
        private final View view;

        public ListItem(View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.view = view;
        }

        @NotNull
        protected final View getView() {
            return this.view;
        }

        public abstract int getHiddenSize();

        public abstract int getLeadingEdge();

        public abstract int getFollowingEdge();

        public abstract int getSize();

        @NotNull
        public abstract Rect getPositionOfItemFollowingSelf(@NotNull ListItem var1, @NotNull Rect var2);

        @NotNull
        public abstract Rect getPositionOfSelfAsFirst(@NotNull Rect var1, int var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0001R\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LeadingBottomListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$ListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "view", "Landroid/view/View;", "(Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;Landroid/view/View;)V", "followingEdge", "", "getFollowingEdge", "()I", "hiddenSize", "getHiddenSize", "leadingEdge", "getLeadingEdge", "size", "getSize", "getPositionOfItemFollowingSelf", "Landroid/graphics/Rect;", "item", "rect", "getPositionOfSelfAsFirst", "hiddenAmount", "library_release"})
    private final class LeadingBottomListItem
    extends ListItem {
        public LeadingBottomListItem(View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
        }

        @Override
        public int getHiddenSize() {
            return RangesKt.coerceAtLeast((int)(LoopingLayoutManager.this.getPaddingTop() - LoopingLayoutManager.this.getDecoratedTop(this.getView())), (int)0);
        }

        @Override
        public int getLeadingEdge() {
            return LoopingLayoutManager.this.getDecoratedBottom(this.getView());
        }

        @Override
        public int getFollowingEdge() {
            return LoopingLayoutManager.this.getDecoratedTop(this.getView());
        }

        @Override
        public int getSize() {
            return LoopingLayoutManager.this.getDecoratedMeasuredHeight(this.getView());
        }

        @Override
        @NotNull
        public Rect getPositionOfItemFollowingSelf(@NotNull ListItem item, @NotNull Rect rect) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.bottom = this.getFollowingEdge();
            rect.top = rect.bottom - item.getSize();
            return rect;
        }

        @Override
        @NotNull
        public Rect getPositionOfSelfAsFirst(@NotNull Rect rect, int hiddenAmount) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.bottom = LoopingLayoutManager.this.getHeight() - LoopingLayoutManager.this.getPaddingBottom() + hiddenAmount;
            rect.top = rect.bottom - this.getSize();
            return rect;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0001R\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LeadingTopListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$ListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "view", "Landroid/view/View;", "(Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;Landroid/view/View;)V", "followingEdge", "", "getFollowingEdge", "()I", "hiddenSize", "getHiddenSize", "leadingEdge", "getLeadingEdge", "size", "getSize", "getPositionOfItemFollowingSelf", "Landroid/graphics/Rect;", "item", "rect", "getPositionOfSelfAsFirst", "hiddenAmount", "library_release"})
    private final class LeadingTopListItem
    extends ListItem {
        public LeadingTopListItem(View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
        }

        @Override
        public int getHiddenSize() {
            return RangesKt.coerceAtLeast((int)(LoopingLayoutManager.this.getDecoratedBottom(this.getView()) - (LoopingLayoutManager.this.getHeight() - LoopingLayoutManager.this.getPaddingBottom())), (int)0);
        }

        @Override
        public int getLeadingEdge() {
            return LoopingLayoutManager.this.getDecoratedTop(this.getView());
        }

        @Override
        public int getFollowingEdge() {
            return LoopingLayoutManager.this.getDecoratedBottom(this.getView());
        }

        @Override
        public int getSize() {
            return LoopingLayoutManager.this.getDecoratedMeasuredHeight(this.getView());
        }

        @Override
        @NotNull
        public Rect getPositionOfItemFollowingSelf(@NotNull ListItem item, @NotNull Rect rect) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.top = this.getFollowingEdge();
            rect.bottom = rect.top + item.getSize();
            return rect;
        }

        @Override
        @NotNull
        public Rect getPositionOfSelfAsFirst(@NotNull Rect rect, int hiddenAmount) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.top = LoopingLayoutManager.this.getPaddingTop() - hiddenAmount;
            rect.bottom = rect.top + this.getSize();
            return rect;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0001R\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LeadingRightListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$ListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "view", "Landroid/view/View;", "(Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;Landroid/view/View;)V", "followingEdge", "", "getFollowingEdge", "()I", "hiddenSize", "getHiddenSize", "leadingEdge", "getLeadingEdge", "size", "getSize", "getPositionOfItemFollowingSelf", "Landroid/graphics/Rect;", "item", "rect", "getPositionOfSelfAsFirst", "hiddenAmount", "library_release"})
    private final class LeadingRightListItem
    extends ListItem {
        public LeadingRightListItem(View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
        }

        @Override
        public int getHiddenSize() {
            return RangesKt.coerceAtLeast((int)(LoopingLayoutManager.this.getPaddingLeft() - LoopingLayoutManager.this.getDecoratedLeft(this.getView())), (int)0);
        }

        @Override
        public int getLeadingEdge() {
            return LoopingLayoutManager.this.getDecoratedRight(this.getView());
        }

        @Override
        public int getFollowingEdge() {
            return LoopingLayoutManager.this.getDecoratedLeft(this.getView());
        }

        @Override
        public int getSize() {
            return LoopingLayoutManager.this.getDecoratedMeasuredWidth(this.getView());
        }

        @Override
        @NotNull
        public Rect getPositionOfItemFollowingSelf(@NotNull ListItem item, @NotNull Rect rect) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.right = this.getFollowingEdge();
            rect.left = rect.right - item.getSize();
            return rect;
        }

        @Override
        @NotNull
        public Rect getPositionOfSelfAsFirst(@NotNull Rect rect, int hiddenAmount) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.right = LoopingLayoutManager.this.getWidth() - LoopingLayoutManager.this.getPaddingRight() + hiddenAmount;
            rect.left = rect.right - this.getSize();
            return rect;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0001R\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LeadingLeftListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$ListItem;", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "view", "Landroid/view/View;", "(Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;Landroid/view/View;)V", "followingEdge", "", "getFollowingEdge", "()I", "hiddenSize", "getHiddenSize", "leadingEdge", "getLeadingEdge", "size", "getSize", "getPositionOfItemFollowingSelf", "Landroid/graphics/Rect;", "item", "rect", "getPositionOfSelfAsFirst", "hiddenAmount", "library_release"})
    private final class LeadingLeftListItem
    extends ListItem {
        public LeadingLeftListItem(View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
        }

        @Override
        public int getHiddenSize() {
            return RangesKt.coerceAtLeast((int)(LoopingLayoutManager.this.getDecoratedRight(this.getView()) - (LoopingLayoutManager.this.getWidth() - LoopingLayoutManager.this.getPaddingRight())), (int)0);
        }

        @Override
        public int getLeadingEdge() {
            return LoopingLayoutManager.this.getDecoratedLeft(this.getView());
        }

        @Override
        public int getFollowingEdge() {
            return LoopingLayoutManager.this.getDecoratedRight(this.getView());
        }

        @Override
        public int getSize() {
            return LoopingLayoutManager.this.getDecoratedMeasuredWidth(this.getView());
        }

        @Override
        @NotNull
        public Rect getPositionOfItemFollowingSelf(@NotNull ListItem item, @NotNull Rect rect) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.left = this.getFollowingEdge();
            rect.right = rect.left + item.getSize();
            return rect;
        }

        @Override
        @NotNull
        public Rect getPositionOfSelfAsFirst(@NotNull Rect rect, int hiddenAmount) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            rect.left = LoopingLayoutManager.this.getPaddingLeft() - hiddenAmount;
            rect.right = rect.left + this.getSize();
            return rect;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$LoopingSmoothScroller;", "Landroidx/recyclerview/widget/LinearSmoothScroller;", "context", "Landroid/content/Context;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "(Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;Landroid/content/Context;Landroidx/recyclerview/widget/RecyclerView$State;)V", "getContext", "()Landroid/content/Context;", "getState", "()Landroidx/recyclerview/widget/RecyclerView$State;", "computeScrollVectorForPosition", "Landroid/graphics/PointF;", "targetPosition", "", "onStart", "", "onStop", "library_release"})
    private final class LoopingSmoothScroller
    extends LinearSmoothScroller {
        @NotNull
        private final Context context;
        @NotNull
        private final RecyclerView.State state;

        public LoopingSmoothScroller(@NotNull Context context, RecyclerView.State state) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super(context);
            this.context = context;
            this.state = state;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final RecyclerView.State getState() {
            return this.state;
        }

        public void onStart() {
            float rate = this.calculateSpeedPerPixel(this.context.getResources().getDisplayMetrics());
            int time = 500;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.bekawestberg.loopinglayout.library.LoopingLayoutManager");
            ((LoopingLayoutManager)layoutManager).extraLayoutSpace = (int)(rate * (float)time);
        }

        public void onStop() {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.bekawestberg.loopinglayout.library.LoopingLayoutManager");
            ((LoopingLayoutManager)layoutManager).extraLayoutSpace = 0;
        }

        @Nullable
        public PointF computeScrollVectorForPosition(int targetPosition) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager instanceof LoopingLayoutManager) {
                return ((LoopingLayoutManager)layoutManager).computeScrollVectorForPosition(targetPosition, this.state.getItemCount());
            }
            Log.w((String)LoopingLayoutManager.TAG, (String)"A LoopingSmoothScroller should only be attached to a LoopingLayoutManager.");
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager$Companion;", "", "()V", "DEBUG", "", "HORIZONTAL", "", "SCROLL_OFFSET", "SCROLL_RANGE", "TAG", "", "TOWARDS_BOTTOM_RIGHT", "TOWARDS_HIGHER_INDICES", "TOWARDS_LOWER_INDICES", "TOWARDS_TOP_LEFT", "VERTICAL", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

