/*
 * Decompiled with CFR 0.152.
 */
package com.bekawestberg.loopinglayout.library;

import android.view.View;
import com.bekawestberg.loopinglayout.library.LoopingLayoutManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"childClosestToAnchorEdge", "Landroid/view/View;", "targetAdapterIndex", "", "layoutManager", "Lcom/bekawestberg/loopinglayout/library/LoopingLayoutManager;", "childClosestToMiddle", "defaultPicker", "library_release"})
public final class ViewPickersKt {
    @Nullable
    public static final View defaultPicker(int targetAdapterIndex, @NotNull LoopingLayoutManager layoutManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        return ViewPickersKt.childClosestToMiddle(targetAdapterIndex, layoutManager);
    }

    @Nullable
    public static final View childClosestToAnchorEdge(int targetAdapterIndex, @NotNull LoopingLayoutManager layoutManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        int movementDir = layoutManager.convertAdapterDirToMovementDir(1);
        IntProgression range = movementDir == 1 ? (IntProgression)RangesKt.until((int)0, (int)layoutManager.getChildCount()) : RangesKt.downTo((int)(layoutManager.getChildCount() - 1), (int)0);
        int i = range.getFirst();
        int n = range.getLast();
        int n2 = range.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (layoutManager.getChildAt(i) != null) {
                View view;
                if (layoutManager.getPosition(view) == targetAdapterIndex) {
                    return view;
                }
                if (i == n) break;
                i += n2;
            }
        }
        return null;
    }

    @Nullable
    public static final View childClosestToMiddle(int targetAdapterIndex, @NotNull LoopingLayoutManager layoutManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        int minDistance = Integer.MAX_VALUE;
        View closestView = null;
        int layoutMiddle = layoutManager.getOrientation() == 0 ? layoutManager.getPaddingLeft() + layoutManager.getLayoutWidth() / 2 : layoutManager.getPaddingTop() + layoutManager.getLayoutHeight() / 2;
        int n = layoutManager.getChildCount();
        for (int i = 0; i < n; ++i) {
            int childMiddle;
            int distance;
            View view;
            if (layoutManager.getChildAt(i) == null) {
                return null;
            }
            if (layoutManager.getPosition(view) != targetAdapterIndex || (distance = Math.abs((childMiddle = layoutManager.getOrientation() == 0 ? layoutManager.getDecoratedLeft(view) + layoutManager.getDecoratedMeasuredWidth(view) / 2 : layoutManager.getDecoratedTop(view) + layoutManager.getDecoratedMeasuredHeight(view) / 2) - layoutMiddle)) >= minDistance) continue;
            minDistance = distance;
            closestView = view;
        }
        return closestView;
    }
}

