/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine;

import com.github.benmanes.caffeine.SingleConsumerQueue;
import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import com.github.benmanes.caffeine.testing.IsEmptyIterable;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsValidSingleConsumerQueue<E>
extends TypeSafeDiagnosingMatcher<SingleConsumerQueue<E>> {
    public void describeTo(Description description) {
        description.appendText("singleConsumerQueue");
    }

    protected boolean matchesSafely(SingleConsumerQueue<E> queue, Description description) {
        DescriptionBuilder builder = new DescriptionBuilder(description);
        if (queue.isEmpty()) {
            builder.expectThat("empty queue", queue, Matchers.is(IsEmptyIterable.deeplyEmpty()));
            builder.expectThat("empty queue", queue.head, Matchers.is((Object)queue.tail));
            builder.expectThat("empty queue", queue.head.next, Matchers.is((Matcher)Matchers.nullValue()));
        }
        builder.expectThat("corrupted queue node", queue.tail.next, Matchers.is((Matcher)Matchers.nullValue()));
        this.checkForLoop(queue, builder);
        this.checkArena(queue, builder);
        return builder.matches();
    }

    void checkForLoop(SingleConsumerQueue<E> queue, DescriptionBuilder builder) {
        builder.expectThat("Expected sentinel node", queue.head.value, Matchers.is((Matcher)Matchers.nullValue()));
        Set seen = Sets.newIdentityHashSet();
        SingleConsumerQueue.Node node = queue.head.next;
        while (node != null) {
            SingleConsumerQueue.Node current = node;
            Supplier<String> errorMsg = () -> String.format("Loop detected: %s in %s", current, seen);
            builder.expectThat(errorMsg, Boolean.valueOf(seen.add(node)), Matchers.is((Object)true));
            builder.expectThat("not tail", node, Matchers.is((Matcher)Matchers.not((Object)queue.head)));
            builder.expectThat("not completed", Boolean.valueOf(node.isDone()), Matchers.is((Object)true));
            builder.expectThat("not null value", node.value, Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            node = node.next;
        }
        builder.expectThat("queue size", queue, Matchers.hasSize((int)seen.size()));
    }

    void checkArena(SingleConsumerQueue<E> queue, DescriptionBuilder builder) {
        for (AtomicReference slot : queue.arena) {
            builder.expectThat("not null arena slot", slot.get(), Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    public static <E> IsValidSingleConsumerQueue<E> validate() {
        return new IsValidSingleConsumerQueue<E>();
    }
}

