/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine;

import com.github.benmanes.caffeine.IsValidSingleConsumerQueue;
import com.github.benmanes.caffeine.SingleConsumerQueue;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.github.benmanes.caffeine.testing.IsEmptyIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={ValidatingQueueListener.class})
public class SingleConsumerQueueTest {
    private static final int PRODUCE = 10000;
    private static final int NUM_PRODUCERS = 10;
    private static final int POPULATED_SIZE = 10;

    @Test(dataProvider="empty")
    public void clear_whenEmpty(Queue<?> queue) {
        queue.clear();
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="populated")
    public void clear_whenPopulated(Queue<?> queue) {
        queue.clear();
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void isEmpty_whenEmpty(Queue<?> queue) {
        MatcherAssert.assertThat((Object)queue.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="populated")
    public void isEmpty_whenPopulated(Queue<?> queue) {
        MatcherAssert.assertThat((Object)queue.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="empty")
    public void size_whenEmpty(Queue<?> queue) {
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Iterables.size(queue))));
    }

    @Test(dataProvider="populated")
    public void size_whenPopulated(Queue<?> queue) {
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)Iterables.size(queue), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Iterables.size(queue))));
    }

    @Test(dataProvider="empty")
    public void contains_withNull(Queue<?> queue) {
        MatcherAssert.assertThat((Object)queue.contains(null), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="populated")
    public void contains_whenFound(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.contains(Iterables.get(queue, (int)5)), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="populated")
    public void contains_whenNotFound(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.contains(-1), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="empty", expectedExceptions={NullPointerException.class})
    public void containsAll_withNull(Queue<?> queue) {
        queue.containsAll(null);
    }

    @Test(dataProvider="populated")
    public void containsAll_whenFound(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.containsAll((Collection<?>)ImmutableList.of((Object)0, (Object)5, (Object)9)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)queue.containsAll(queue), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="populated")
    public void containsAll_whenNotFound(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.containsAll((Collection<?>)ImmutableList.of((Object)-1, (Object)-5, (Object)-10)), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="empty")
    public void peek_whenEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.peek(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="populated")
    public void peek_whenPopulated(SingleConsumerQueue<Integer> queue) {
        Integer first = (Integer)queue.head.next.value;
        MatcherAssert.assertThat((Object)((Integer)queue.peek()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat((Object)queue.contains((Object)first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void element_whenEmpty(Queue<Integer> queue) {
        queue.element();
    }

    @Test(dataProvider="populated")
    public void element_whenPopulated(SingleConsumerQueue<Integer> queue) {
        Integer first = (Integer)queue.head.next.value;
        MatcherAssert.assertThat((Object)((Integer)queue.element()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat((Object)queue.contains((Object)first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty")
    public void offer_whenEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.offer(1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="populated")
    public void offer_whenPopulated(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.offer(1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)11));
    }

    @Test(dataProvider="empty")
    public void add_whenEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.add(1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)queue.peek(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Integer)Iterables.getLast(queue)), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Iterables.size(queue))));
    }

    @Test(dataProvider="populated")
    public void add_whenPopulated(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.add(-1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)queue.peek(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)-1)));
        MatcherAssert.assertThat((Object)((Integer)Iterables.getLast(queue)), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)11));
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Iterables.size(queue))));
    }

    @Test(dataProvider="empty")
    public void addAll_whenEmpty(Queue<Integer> queue) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        SingleConsumerQueueTest.populate(list, 10);
        MatcherAssert.assertThat((Object)queue.addAll(list), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)queue.peek(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)((Integer)Iterables.getLast(queue)), (Matcher)Matchers.is((Object)9));
        MatcherAssert.assertThat((String)String.format("%nExpected: %s%n     but: %s", queue, list), (boolean)Iterators.elementsEqual(queue.iterator(), list.iterator()));
    }

    @Test(dataProvider="singleton,populated")
    public void addAll_whenPopulated(Queue<Integer> queue) {
        ImmutableList list = ImmutableList.of((Object)10, (Object)11, (Object)12);
        ImmutableList expect = ImmutableList.copyOf((Iterable)Iterables.concat(queue, (Iterable)list));
        MatcherAssert.assertThat((Object)queue.addAll((Collection<Integer>)list), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)queue.peek(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)((Integer)Iterables.getLast(queue)), (Matcher)Matchers.is((Object)12));
        MatcherAssert.assertThat((String)String.format("%nExpected: %s%n     but: %s", queue, expect), (boolean)Iterators.elementsEqual(queue.iterator(), expect.iterator()));
    }

    @Test(dataProvider="empty")
    public void poll_whenEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.poll(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="populated")
    public void poll_whenPopulated(Queue<Integer> queue) {
        Integer first = queue.peek();
        MatcherAssert.assertThat((Object)queue.poll(), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)9));
        MatcherAssert.assertThat((Object)queue.contains(first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="populated")
    public void poll_toEmpty(Queue<Integer> queue) {
        Integer value;
        while ((value = queue.poll()) != null) {
            MatcherAssert.assertThat((Object)queue.contains(value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void remove_whenEmpty(Queue<Integer> queue) {
        queue.remove();
    }

    @Test(dataProvider="populated")
    public void remove_whenPopulated(Queue<Integer> queue) {
        Integer first = queue.peek();
        MatcherAssert.assertThat((Object)queue.remove(), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)9));
        MatcherAssert.assertThat((Object)queue.contains(first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="populated")
    public void remove_toEmpty(Queue<Integer> queue) {
        while (!queue.isEmpty()) {
            Integer value = queue.remove();
            MatcherAssert.assertThat((Object)queue.contains(value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty,singleton,populated")
    public void removeElement_notFound(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.remove(-1), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="populated")
    public void removeElement_whenFound(Queue<Integer> queue) {
        Integer first = queue.peek();
        MatcherAssert.assertThat((Object)queue.remove(first), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)9));
        MatcherAssert.assertThat((Object)queue.contains(first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="populated")
    public void removeElement_toEmpty(Queue<Integer> queue) {
        while (!queue.isEmpty()) {
            Integer value = queue.peek();
            MatcherAssert.assertThat((Object)queue.remove(value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)queue.contains(value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void removeAll_withEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.removeAll((Collection<?>)ImmutableList.of()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="populated")
    public void removeAll_withPopulated(Queue<Integer> queue) {
        Integer first = queue.peek();
        MatcherAssert.assertThat((Object)queue.removeAll((Collection<?>)ImmutableList.of((Object)first)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)9));
        MatcherAssert.assertThat((Object)queue.contains(first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="populated")
    public void removeAll_toEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.removeAll((Collection<?>)ImmutableList.copyOf(queue)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void retainAll_withEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.retainAll((Collection<?>)ImmutableList.of()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="populated")
    public void retainAll_withPopulated(Queue<Integer> queue) {
        Integer first = queue.peek();
        MatcherAssert.assertThat((Object)queue.retainAll((Collection<?>)ImmutableList.of((Object)first)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queue.contains(first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="populated")
    public void retainAll_toEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.retainAll((Collection<?>)ImmutableList.of()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void iterator_noMoreElements(Queue<Integer> queue) {
        queue.iterator().next();
    }

    @Test(dataProvider="empty")
    public void iterator_whenEmpty(Queue<Integer> queue) {
        MatcherAssert.assertThat((Object)queue.iterator().hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="singleton,populated")
    public void iterator_whenPopulated(Queue<Integer> queue) {
        ArrayList<Integer> copy = new ArrayList<Integer>();
        SingleConsumerQueueTest.populate(copy, queue.size());
        MatcherAssert.assertThat((String)String.format("%nExpected: %s%n     but: %s", queue, copy), (boolean)Iterators.elementsEqual(queue.iterator(), copy.iterator()));
    }

    @Test(dataProvider="populated", expectedExceptions={IllegalStateException.class})
    public void iterator_removal_unread(Queue<Integer> queue) {
        queue.iterator().remove();
    }

    @Test(dataProvider="populated", expectedExceptions={IllegalStateException.class})
    public void iterator_removal_duplicate(Queue<Integer> queue) {
        Iterator it = queue.iterator();
        it.next();
        it.remove();
        it.remove();
    }

    @Test(dataProvider="populated")
    public void iterator_removal(Queue<Integer> queue) {
        Iterator it = queue.iterator();
        it.next();
        it.remove();
    }

    @Test(dataProvider="populated")
    public void iterator_removal_toEmpty(Queue<Integer> queue) {
        Iterator it = queue.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty,singleton,populated")
    public void toArray(Queue<Integer> queue) {
        Object[] expect = new ArrayList<Integer>(queue).toArray();
        Object[] actual = queue.toArray();
        MatcherAssert.assertThat((Object)actual, (Matcher)(queue.isEmpty() ? Matchers.emptyArray() : Matchers.arrayContaining((Object[])expect)));
    }

    @Test(dataProvider="empty,singleton,populated")
    public void toTypedArray(Queue<Integer> queue) {
        Object[] expect = new ArrayList<Integer>(queue).toArray(new Integer[0]);
        Integer[] actual = queue.toArray(new Integer[0]);
        MatcherAssert.assertThat((Object)actual, (Matcher)(queue.isEmpty() ? Matchers.emptyArray() : Matchers.arrayContaining((Object[])expect)));
    }

    @Test(dataProvider="empty,singleton,populated")
    public void toString(Queue<Integer> queue) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        SingleConsumerQueueTest.populate(list, queue.size());
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasToString((String)((Object)list).toString()));
    }

    @Test(dataProvider="empty,singleton,populated")
    public void serializable(Queue<Integer> queue) {
        Queue copy = (Queue)SerializableTester.reserialize(queue);
        MatcherAssert.assertThat((String)String.format("%nExpected: %s%n     but: %s", queue, copy), (boolean)Iterators.elementsEqual(queue.iterator(), copy.iterator()));
    }

    @Test(dataProvider="empty")
    public void oneProducer_oneConsumer(Queue<Integer> queue) {
        AtomicInteger started = new AtomicInteger();
        AtomicInteger finished = new AtomicInteger();
        ConcurrentTestHarness.execute(() -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)2));
            for (int i = 0; i < 10000; ++i) {
                queue.add(i);
            }
            finished.incrementAndGet();
        });
        ConcurrentTestHarness.execute(() -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)2));
            for (int i = 0; i < 10000; ++i) {
                while (queue.poll() == null) {
                }
            }
            finished.incrementAndGet();
        });
        Awaits.await().untilAtomic(finished, Matchers.is((Object)2));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void manyProducers_noConsumer(Queue<Integer> queue) {
        ConcurrentTestHarness.timeTasks(10, () -> {
            for (int i = 0; i < 10000; ++i) {
                queue.add(i);
            }
        });
        MatcherAssert.assertThat(queue, (Matcher)Matchers.hasSize((int)100000));
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Iterables.size(queue))));
    }

    @Test(dataProvider="empty")
    public void manyProducers_oneConsumer(Queue<Integer> queue) {
        AtomicInteger started = new AtomicInteger();
        AtomicInteger finished = new AtomicInteger();
        ConcurrentTestHarness.execute(() -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)11));
            for (int i = 0; i < 100000; ++i) {
                while (queue.poll() == null) {
                }
            }
            finished.incrementAndGet();
        });
        ConcurrentTestHarness.timeTasks(10, () -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)11));
            for (int i = 0; i < 10000; ++i) {
                queue.add(i);
            }
            finished.incrementAndGet();
        });
        Awaits.await().untilAtomic(finished, Matchers.is((Object)11));
        MatcherAssert.assertThat(queue, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @DataProvider(name="empty")
    public Object[][] providesEmpty() {
        return new Object[][]{{SingleConsumerQueueTest.makePopulated(0, true)}, {SingleConsumerQueueTest.makePopulated(0, false)}};
    }

    @DataProvider(name="singleton")
    public Object[][] providesSingleton() {
        return new Object[][]{{SingleConsumerQueueTest.makePopulated(1, true)}, {SingleConsumerQueueTest.makePopulated(1, false)}};
    }

    @DataProvider(name="populated")
    public Object[][] providesPopulated() {
        return new Object[][]{{SingleConsumerQueueTest.makePopulated(10, true)}, {SingleConsumerQueueTest.makePopulated(10, false)}};
    }

    @DataProvider(name="singleton,populated")
    public Object[][] providesSingletonAndPopulated() {
        return new Object[][]{{SingleConsumerQueueTest.makePopulated(1, true)}, {SingleConsumerQueueTest.makePopulated(1, false)}, {SingleConsumerQueueTest.makePopulated(10, true)}, {SingleConsumerQueueTest.makePopulated(10, false)}};
    }

    @DataProvider(name="empty,singleton,populated")
    public Object[][] providesEmptyAndSingletonAndPopulated() {
        return new Object[][]{{SingleConsumerQueueTest.makePopulated(0, true)}, {SingleConsumerQueueTest.makePopulated(0, false)}, {SingleConsumerQueueTest.makePopulated(1, true)}, {SingleConsumerQueueTest.makePopulated(1, false)}, {SingleConsumerQueueTest.makePopulated(10, true)}, {SingleConsumerQueueTest.makePopulated(10, false)}};
    }

    static SingleConsumerQueue<Integer> makePopulated(int size, boolean optimistic) {
        SingleConsumerQueue queue = optimistic ? SingleConsumerQueue.optimistic() : SingleConsumerQueue.linearizable();
        SingleConsumerQueueTest.populate((Collection<Integer>)queue, size);
        return queue;
    }

    static void populate(Collection<Integer> collection, int start) {
        for (int i = 0; i < start; ++i) {
            collection.add(i);
        }
    }

    static void cleanUp(ITestResult testResult) {
        Object[] params = testResult.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param instanceof SingleConsumerQueue) {
                boolean linearizable = ((SingleConsumerQueue)param).factory.apply(null) instanceof SingleConsumerQueue.LinearizableNode;
                params[i] = param.getClass().getSimpleName() + "_" + (linearizable ? "linearizable" : "optimistic");
                continue;
            }
            params[i] = Objects.toString(param);
        }
    }

    public static final class ValidatingQueueListener
    implements IInvokedMethodListener {
        public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
            try {
                if (testResult.isSuccess()) {
                    for (Object param : testResult.getParameters()) {
                        if (!(param instanceof SingleConsumerQueue)) continue;
                        MatcherAssert.assertThat((Object)((SingleConsumerQueue)param), (Matcher)Matchers.is(IsValidSingleConsumerQueue.validate()));
                    }
                }
            }
            catch (AssertionError caught) {
                testResult.setStatus(2);
                testResult.setThrowable((Throwable)((Object)caught));
            }
            finally {
                SingleConsumerQueueTest.cleanUp(testResult);
            }
        }
    }
}

