/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.base;

import com.github.benmanes.caffeine.base.UnsafeAccess;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class UnsafeAccessTest {
    @Test
    public void load_fallback() throws Exception {
        MatcherAssert.assertThat((Object)UnsafeAccess.load((String)"abc", (String)"theUnsafe"), (Matcher)Matchers.is((Object)UnsafeAccess.UNSAFE));
        MatcherAssert.assertThat((Object)UnsafeAccess.load((String)"abc", (String)"efg"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)UnsafeAccess.UNSAFE)));
    }

    @Test
    public void objectFieldOffset() {
        MatcherAssert.assertThat((Object)UnsafeAccess.objectFieldOffset(RelaxedFields.class, (String)"ivalue"), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
    }

    @Test(expectedExceptions={Error.class})
    public void objectFieldOffset_error() {
        UnsafeAccess.objectFieldOffset(this.getClass(), (String)"foobar");
    }

    @Test(dataProvider="relaxedFields")
    public void relaxed_ivalue(RelaxedFields relaxedFields) {
        relaxedFields.setRelaxedInt(100);
        int read = relaxedFields.getRelaxedInt();
        MatcherAssert.assertThat((Object)relaxedFields.ivalue, (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((Object)read, (Matcher)Matchers.is((Object)100));
    }

    @Test(dataProvider="relaxedFields")
    public void relaxed_lvalue(RelaxedFields relaxedFields) {
        relaxedFields.setRelaxedLong(100L);
        long read = relaxedFields.getRelaxedLong();
        MatcherAssert.assertThat((Object)relaxedFields.lvalue, (Matcher)Matchers.is((Object)100L));
        MatcherAssert.assertThat((Object)read, (Matcher)Matchers.is((Object)100L));
    }

    @Test(dataProvider="relaxedFields")
    public void relaxed_ovalue(MoreRelaxedFields relaxedFields) {
        Object o = new Object();
        relaxedFields.setRelaxedObject(o);
        Object read = relaxedFields.getRelaxedObject();
        MatcherAssert.assertThat((Object)relaxedFields.ovalue, (Matcher)Matchers.is((Object)o));
        MatcherAssert.assertThat((Object)read, (Matcher)Matchers.is((Object)o));
    }

    @DataProvider(name="relaxedFields")
    public Object[][] providesRelaxedFields() {
        return new Object[][]{{new MoreRelaxedFields()}};
    }

    static final class MoreRelaxedFields
    extends RelaxedFields {
        static final long OVALUE_OFFSET = UnsafeAccess.objectFieldOffset(MoreRelaxedFields.class, (String)"ovalue");
        private volatile Object ovalue;

        MoreRelaxedFields() {
        }

        void setRelaxedObject(Object value) {
            UnsafeAccess.UNSAFE.putOrderedObject(this, OVALUE_OFFSET, value);
        }

        Object getRelaxedObject() {
            return UnsafeAccess.UNSAFE.getObject(this, OVALUE_OFFSET);
        }
    }

    static class RelaxedFields {
        static final long IVALUE_OFFSET = UnsafeAccess.objectFieldOffset(RelaxedFields.class, (String)"ivalue");
        static final long LVALUE_OFFSET = UnsafeAccess.objectFieldOffset(RelaxedFields.class, (String)"lvalue");
        private volatile int ivalue;
        private volatile long lvalue;

        RelaxedFields() {
        }

        void setRelaxedInt(int value) {
            UnsafeAccess.UNSAFE.putOrderedInt(this, IVALUE_OFFSET, value);
        }

        int getRelaxedInt() {
            return UnsafeAccess.UNSAFE.getInt(this, IVALUE_OFFSET);
        }

        void setRelaxedLong(long value) {
            UnsafeAccess.UNSAFE.putOrderedLong(this, LVALUE_OFFSET, value);
        }

        long getRelaxedLong() {
            return UnsafeAccess.UNSAFE.getInt(this, LVALUE_OFFSET);
        }
    }
}

