/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.WriteThroughEntry;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.cache.testing.RejectingCacheWriter;
import com.github.benmanes.caffeine.testing.IsEmptyIterable;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class AsMapTest {
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void isEmpty(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)context.original().isEmpty()));
        if (map.isEmpty()) {
            MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void size(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void clear(Map<Integer, Integer> map, CacheContext context) {
        map.clear();
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, context.original().size(), RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void clear_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.clear();
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void containsKey_null(Map<Integer, Integer> map, CacheContext context) {
        map.containsKey(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsKey_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.containsKey(key), (Matcher)Matchers.is((Object)true));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsKey_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.containsKey(context.absentKey()), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void containsValue_null(Map<Integer, Integer> map, CacheContext context) {
        map.containsValue(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsValue_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.containsValue(context.original().get(key)), (Matcher)Matchers.is((Object)true));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsValue_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.containsValue(context.absentValue()), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void get_null(Map<Integer, Integer> map, CacheContext context) {
        map.get(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void get_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void get_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)context.original().get(key)));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getOrDefault_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.getOrDefault(null, 1);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getOrDefault_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.getOrDefault(context.absentKey(), null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.getOrDefault(context.absentKey(), context.absentKey()), (Matcher)Matchers.is((Object)context.absentKey()));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getOrDefault_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.getOrDefault(key, context.absentKey()), (Matcher)Matchers.is((Object)context.original().get(key)));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void forEach_null(Map<Integer, Integer> map, CacheContext context) {
        map.forEach(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void forEach_scan(Map<Integer, Integer> map, CacheContext context) {
        HashMap<Integer, Integer> remaining = new HashMap<Integer, Integer>(context.original());
        map.forEach(remaining::remove);
        MatcherAssert.assertThat(remaining, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void forEach_modify(Map<Integer, Integer> map, CacheContext context) {
        ArrayList modified = new ArrayList();
        map.forEach((key, value) -> {
            Integer newKey = context.lastKey() + key;
            modified.add(newKey);
            map.put(newKey, (Integer)key);
        });
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.put(null, 1);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_nullValue(Map<Integer, Integer> map, CacheContext context) {
        map.put(1, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_nullKeyAndValue(Map<Integer, Integer> map, CacheContext context) {
        map.put(null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void put_insert_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.put(context.absentKey(), context.absentValue());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void put_replace_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.put(context.middleKey(), context.absentValue());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_insert(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.put(context.absentKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.original().size() + 1)));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote(context.absentKey(), context.absentValue()));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void put_replace_sameValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.put(key, value), (Matcher)Matchers.is((Object)value));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        if (context.isGuava() || context.isAsync()) {
            int count = context.firstMiddleLastKeys().size();
            MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        } else {
            MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void put_replace_differentValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.put(key, context.absentValue()), (Matcher)Matchers.is((Object)value));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)context.absentValue()));
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote(key, context.absentValue()));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_null(Map<Integer, Integer> map, CacheContext context) {
        map.putAll(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void putAll_insert_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.putAll(context.absent());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void putAll_replace_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.putAll((Map<Integer, Integer>)ImmutableMap.of((Object)context.middleKey(), (Object)context.absentValue()));
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_empty(Map<Integer, Integer> map, CacheContext context) {
        map.putAll(Collections.emptyMap());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_insert(Map<Integer, Integer> map, CacheContext context) {
        int startKey = context.original().size() + 1;
        Map entries = IntStream.range(startKey, 100 + startKey).boxed().collect(Collectors.toMap(Function.identity(), key -> -key.intValue()));
        map.putAll(entries);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(100 + context.original().size())));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wroteAll(entries));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void putAll_replace(Map<Integer, Integer> map, CacheContext context) {
        LinkedHashMap<Integer, Integer> entries = new LinkedHashMap<Integer, Integer>(context.original());
        entries.replaceAll((key, value) -> key);
        map.putAll(entries);
        MatcherAssert.assertThat(map, (Matcher)Matchers.is((Matcher)Matchers.equalTo(entries)));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, entries.size(), RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wroteAll(entries));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void putAll_mixed(Map<Integer, Integer> map, CacheContext context) {
        HashMap entries = new HashMap();
        HashMap replaced = new HashMap();
        context.original().forEach((key, value) -> {
            if (key % 2 == 0) {
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                replaced.put(key, value);
            }
            entries.put(key, value);
        });
        map.putAll(entries);
        MatcherAssert.assertThat(map, (Matcher)Matchers.is((Matcher)Matchers.equalTo(entries)));
        HashMap expect = context.isGuava() || context.isAsync() ? entries : replaced;
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, expect.size(), RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wroteAll(replaced));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.putIfAbsent(null, 2);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_nullValue(Map<Integer, Integer> map, CacheContext context) {
        map.putIfAbsent(1, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_nullKeyAndValue(Map<Integer, Integer> map, CacheContext context) {
        map.putIfAbsent(null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void putIfAbsent_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.putIfAbsent(context.absentKey(), context.absentValue());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.putIfAbsent(key, key), (Matcher)Matchers.is((Object)value));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_insert(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.putIfAbsent(context.absentKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.original().size() + 1)));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote(context.absentKey(), context.absentValue()));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void remove_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.remove(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void remove_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.remove(context.middleKey());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void remove_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.remove(context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void remove_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            map.remove(key);
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deleted(key, context.original().get(key), RemovalCause.EXPLICIT));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.original().size() - context.firstMiddleLastKeys().size())));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.remove(null, 1);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_nullValue(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.remove(1, null), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_nullKeyAndValue(Map<Integer, Integer> map, CacheContext context) {
        map.remove(null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void removeConditionally_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.remove(context.middleKey(), context.original().get(context.middleKey()));
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.remove(context.absentKey(), context.absentValue()), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_presentKey(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.remove(key, key), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void removeConditionally_presentKeyAndValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.remove(key, value), (Matcher)Matchers.is((Object)true));
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deleted(key, value, RemovalCause.EXPLICIT));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_null(Map<Integer, Integer> map, CacheContext context) {
        map.replace(null, 1);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_nullValue(Map<Integer, Integer> map, CacheContext context) {
        map.replace(1, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_nullKeyAndValue(Map<Integer, Integer> map, CacheContext context) {
        map.replace(null, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.replace(context.absentKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void replace_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.replace(context.middleKey(), context.absentValue());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replace_sameValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.replace(key, value), (Matcher)Matchers.is((Object)value));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        if (context.isGuava() || context.isAsync()) {
            int count = context.firstMiddleLastKeys().size();
            MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        } else {
            MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replace_differentValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer oldValue = context.original().get(key);
            MatcherAssert.assertThat((Object)map.replace(key, context.absentValue()), (Matcher)Matchers.is((Object)oldValue));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)context.absentValue()));
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote(key, context.absentValue()));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.writes(count));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.replace(null, 1, 1);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullOldValue(Map<Integer, Integer> map, CacheContext context) {
        map.replace(1, null, 1);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullNewValue(Map<Integer, Integer> map, CacheContext context) {
        map.replace(1, 1, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKeyAndOldValue(Map<Integer, Integer> map, CacheContext context) {
        map.replace(null, null, 1);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKeyAndNewValue(Map<Integer, Integer> map, CacheContext context) {
        map.replace(null, 1, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullOldAndNewValue(Map<Integer, Integer> map, CacheContext context) {
        map.replace(1, null, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKeyAndValues(Map<Integer, Integer> map, CacheContext context) {
        map.replace(null, null, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_absent(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.absentKey();
        MatcherAssert.assertThat((Object)map.replace(key, key, key), (Matcher)Matchers.is((Object)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void replaceConditionally_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Integer key = context.middleKey();
            map.replace(key, context.original().get(key), context.absentValue());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_wrongOldValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.replace(key, key, context.absentKey()), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replaceConditionally_sameValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.replace(key, value, value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        if (context.isGuava() || context.isAsync()) {
            int count = context.firstMiddleLastKeys().size();
            MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        } else {
            MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replaceConditionally_differentValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.replace(key, context.original().get(key), context.absentValue()), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)context.absentValue()));
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote(key, context.absentValue()));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.writes(count));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void replaceAll_null(Map<Integer, Integer> map, CacheContext context) {
        map.replaceAll(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void replaceAll_nullValue(Map<Integer, Integer> map, CacheContext context) {
        map.replaceAll((key, value) -> null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void replaceAll_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.replaceAll((key, value) -> context.absentValue());
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void replaceAll_sameValue(Map<Integer, Integer> map, CacheContext context) {
        map.replaceAll((key, value) -> value);
        MatcherAssert.assertThat(map, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        if (context.isGuava() || context.isAsync()) {
            MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, map.size(), RemovalCause.REPLACED));
        } else {
            MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void replaceAll_differentValue(Map<Integer, Integer> map, CacheContext context) {
        map.replaceAll((key, value) -> key);
        map.forEach((key, value) -> {
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)key)));
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote((Integer)key, (Integer)key));
        });
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, map.size(), RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.writes(context.original().size()));
    }

    @CheckNoStats
    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfAbsent_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.computeIfAbsent(null, key -> -key.intValue());
    }

    @CheckNoStats
    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfAbsent_nullMappingFunction(Map<Integer, Integer> map, CacheContext context) {
        map.computeIfAbsent(context.absentKey(), null);
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_nullValue(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.computeIfAbsent(context.absentKey(), key -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void computeIfAbsent_recursive(final Map<Integer, Integer> map, CacheContext context) {
        Function<Integer, Integer> mappingFunction = new Function<Integer, Integer>(){

            @Override
            public Integer apply(Integer key) {
                return map.computeIfAbsent(key, this);
            }
        };
        map.computeIfAbsent(context.absentKey(), mappingFunction);
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void computeIfAbsent_pingpong(final Map<Integer, Integer> map, final CacheContext context) {
        Function<Integer, Integer> mappingFunction = new Function<Integer, Integer>(){

            @Override
            public Integer apply(Integer key) {
                Integer value = context.original().get(key);
                return map.computeIfAbsent(value, this);
            }
        };
        map.computeIfAbsent(context.absentKey(), mappingFunction);
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_error(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.computeIfAbsent(context.absentKey(), key -> {
                throw new Error();
            });
        }
        catch (Error error) {
            // empty catch block
        }
        MatcherAssert.assertThat(map, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)map.computeIfAbsent(context.absentKey(), key -> key), (Matcher)Matchers.is((Object)context.absentKey()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.computeIfAbsent(key, k -> {
                throw new AssertionError();
            }), (Matcher)Matchers.is((Object)value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(count)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.computeIfAbsent(context.absentKey(), key -> context.absentValue()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(1 + context.original().size())));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfPresent_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.computeIfPresent(null, (key, value) -> -key.intValue());
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfPresent_nullMappingFunction(Map<Integer, Integer> map, CacheContext context) {
        map.computeIfPresent(1, null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void computeIfPresent_nullValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            map.computeIfPresent(key, (k, v) -> null);
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(count)));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void computeIfPresent_recursive(final Map<Integer, Integer> map, CacheContext context) {
        BiFunction<Integer, Integer, Integer> mappingFunction = new BiFunction<Integer, Integer, Integer>(){
            boolean recursed;

            @Override
            public Integer apply(Integer key, Integer value) {
                if (this.recursed) {
                    throw new StackOverflowError();
                }
                this.recursed = true;
                return map.computeIfPresent(key, this);
            }
        };
        map.computeIfPresent(context.firstKey(), mappingFunction);
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void computeIfPresent_pingpong(final Map<Integer, Integer> map, final CacheContext context) {
        BiFunction<Integer, Integer, Integer> mappingFunction = new BiFunction<Integer, Integer, Integer>(){
            int recursed;

            @Override
            public Integer apply(Integer key, Integer value) {
                if (++this.recursed == 2) {
                    throw new StackOverflowError();
                }
                return map.computeIfPresent(context.lastKey(), this);
            }
        };
        map.computeIfPresent(context.firstKey(), mappingFunction);
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void computeIfPresent_error(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.computeIfPresent(context.firstKey(), (key, value) -> {
                throw new Error();
            });
        }
        catch (Error error) {
            // empty catch block
        }
        MatcherAssert.assertThat(map, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)map.computeIfPresent(context.firstKey(), (k, v) -> -k.intValue()), (Matcher)Matchers.is((Object)(-context.firstKey().intValue())));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfPresent_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.computeIfPresent(context.absentKey(), (key, value) -> value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void computeIfPresent_present(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.computeIfPresent(key, (k, v) -> k), (Matcher)Matchers.is((Object)key));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)key));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void compute_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.compute(null, (key, value) -> -key.intValue());
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void compute_nullMappingFunction(Map<Integer, Integer> map, CacheContext context) {
        map.compute(1, null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void compute_remove(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.compute(key, (k, v) -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(count)));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void compute_recursive(final Map<Integer, Integer> map, CacheContext context) {
        BiFunction<Integer, Integer, Integer> mappingFunction = new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer key, Integer value) {
                return map.compute(key, this);
            }
        };
        map.compute(context.absentKey(), mappingFunction);
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void compute_pingpong(final Map<Integer, Integer> map, final CacheContext context) {
        BiFunction<Integer, Integer, Integer> mappingFunction = new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer key, Integer value) {
                return map.computeIfPresent(context.lastKey(), this);
            }
        };
        map.computeIfPresent(context.firstKey(), mappingFunction);
    }

    @CacheSpec
    @Test(dataProvider="caches")
    public void compute_error(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.compute(context.absentKey(), (key, value) -> {
                throw new Error();
            });
        }
        catch (Error error) {
            // empty catch block
        }
        MatcherAssert.assertThat(map, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)map.computeIfPresent(context.absentKey(), (k, v) -> -k.intValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void compute_absent_nullValue(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.compute(context.absentKey(), (key, value) -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void compute_absent(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.compute(context.absentKey(), (key, value) -> context.absentValue()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(1 + context.original().size())));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void compute_sameValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.compute(key, (k, v) -> v), (Matcher)Matchers.is((Object)value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        if (context.isGuava() || context.isAsync()) {
            MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        } else {
            MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void compute_differentValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.compute(key, (k, v) -> k), (Matcher)Matchers.is((Object)key));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)key));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void merge_nullKey(Map<Integer, Integer> map, CacheContext context) {
        map.merge(null, 1, (oldValue, value) -> -oldValue.intValue());
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void merge_nullValue(Map<Integer, Integer> map, CacheContext context) {
        map.merge(1, null, (oldValue, value) -> -oldValue.intValue());
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void merge_nullMappingFunction(Map<Integer, Integer> map, CacheContext context) {
        map.merge(1, 1, null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void merge_remove(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.merge(key, value, (oldValue, v) -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(count)));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches")
    public void merge_recursive(final Map<Integer, Integer> map, CacheContext context) {
        BiFunction<Integer, Integer, Integer> mappingFunction = new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer oldValue, Integer value) {
                return map.merge(oldValue, -oldValue.intValue(), this);
            }
        };
        Integer firstValue = context.original().get(context.firstKey());
        Integer value = map.merge(context.absentKey(), firstValue, mappingFunction);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)firstValue));
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void merge_pingpong(final Map<Integer, Integer> map, final CacheContext context) {
        BiFunction<Integer, Integer, Integer> mappingFunction = new BiFunction<Integer, Integer, Integer>(){
            int recursed;

            @Override
            public Integer apply(Integer oldValue, Integer value) {
                if (++this.recursed == 2) {
                    throw new StackOverflowError();
                }
                return map.merge(context.lastKey(), context.original().get(context.lastKey()), this);
            }
        };
        map.merge(context.firstKey(), context.original().get(context.firstKey()), mappingFunction);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void merge_error(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.merge(context.firstKey(), context.original().get(context.firstKey()), (oldValue, value) -> {
                throw new Error();
            });
        }
        catch (Error error) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat(map, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void merge_absent(Map<Integer, Integer> map, CacheContext context) {
        Integer result = map.merge(context.absentKey(), context.absentValue(), (oldValue, value) -> value);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(1 + context.original().size())));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void merge_sameValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.merge(key, -key.intValue(), (oldValue, v) -> oldValue), (Matcher)Matchers.is((Object)value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        if (context.isGuava()) {
            MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        } else {
            MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
        }
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void merge_differentValue(Map<Integer, Integer> map, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.merge(key, key, (oldValue, v) -> oldValue + v), (Matcher)Matchers.is((Object)0));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Object)0));
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equals_null(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.equals(null), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equals_self(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.equals(map), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equals(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.equals(context.original()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)context.original().equals(map), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void hashCode(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)context.original().hashCode())));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void hashCode_self(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat((Object)map.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)map.hashCode())));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equalsAndHashCodeFail_empty(Map<Integer, Integer> map, CacheContext context) {
        ImmutableMap other = ImmutableMap.of((Object)1, (Object)-1, (Object)2, (Object)-2, (Object)3, (Object)-3);
        MatcherAssert.assertThat((Object)map.equals(other), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)other.equals(map), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)map.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)other.hashCode()))));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equalsAndHashCodeFail_present(Map<Integer, Integer> map, CacheContext context) {
        ImmutableMap other = ImmutableMap.of((Object)1, (Object)-1, (Object)2, (Object)-2, (Object)3, (Object)-3);
        MatcherAssert.assertThat((Object)map.equals(other), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)other.equals(map), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)map.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)other.hashCode()))));
        ImmutableMap empty = ImmutableMap.of();
        MatcherAssert.assertThat((Object)map.equals(empty), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)empty.equals(map), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)map.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)empty.hashCode()))));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void toString(Map<Integer, Integer> map, CacheContext context) {
        String toString = map.toString();
        if (!context.original().toString().equals(toString)) {
            map.forEach((key, value) -> MatcherAssert.assertThat((Object)toString, (Matcher)Matchers.containsString((String)(key + "=" + value))));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void keySetToArray_null(Map<Integer, Integer> map, CacheContext context) {
        map.keySet().toArray((Integer[])null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void keySetToArray(Map<Integer, Integer> map, CacheContext context) {
        int length = context.original().size();
        Integer[] ints = map.keySet().toArray(new Integer[length]);
        MatcherAssert.assertThat((Object)ints.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(ints).containsAll(context.original().keySet()), (Matcher)Matchers.is((Object)true));
        Object[] array = map.keySet().toArray();
        MatcherAssert.assertThat((Object)array.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(array).containsAll(context.original().keySet()), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void keySet_whenEmpty(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat(map.keySet(), (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void keySet_addNotSupported(Map<Integer, Integer> map, CacheContext context) {
        map.keySet().add(1);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void keySet_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.keySet().clear();
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySet_clear(Map<Integer, Integer> map, CacheContext context) {
        map.keySet().clear();
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySet(Map<Integer, Integer> map, CacheContext context) {
        Set<Integer> keys = map.keySet();
        MatcherAssert.assertThat((Object)keys.contains(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)keys.remove(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.hasSize((int)context.original().size()));
        for (Integer key : ImmutableSet.copyOf(keys)) {
            MatcherAssert.assertThat((Object)keys.contains(key), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)keys.remove(key), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)keys.remove(key), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)keys.contains(key), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySet_iterator(Map<Integer, Integer> map, CacheContext context) {
        int iterations = 0;
        Iterator<Integer> i = map.keySet().iterator();
        while (i.hasNext()) {
            MatcherAssert.assertThat((Object)map.containsKey(i.next()), (Matcher)Matchers.is((Object)true));
            ++iterations;
            i.remove();
        }
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, iterations, RemovalCause.EXPLICIT));
        MatcherAssert.assertThat((Object)iterations, (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void keyIterator_noElement(Map<Integer, Integer> map, CacheContext context) {
        map.keySet().iterator().remove();
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NoSuchElementException.class})
    public void keyIterator_noMoreElements(Map<Integer, Integer> map, CacheContext context) {
        map.keySet().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void keyIterator_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Iterator<Integer> i = map.keySet().iterator();
            i.next();
            i.remove();
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void keySpliterator_forEachRemaining_null(Map<Integer, Integer> map, CacheContext context) {
        map.keySet().spliterator().forEachRemaining(null);
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_forEachRemaining(Map<Integer, Integer> map, CacheContext context) {
        int[] count = new int[1];
        map.keySet().spliterator().forEachRemaining(key -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void keySpliterator_tryAdvance_null(Map<Integer, Integer> map, CacheContext context) {
        map.keySet().spliterator().tryAdvance(null);
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_tryAdvance(Map<Integer, Integer> map, CacheContext context) {
        boolean advanced;
        Spliterator<Integer> spliterator = map.keySet().spliterator();
        int[] count = new int[1];
        while (advanced = spliterator.tryAdvance(key -> {
            count[0] = count[0] + 1;
        })) {
        }
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_trySplit(Map<Integer, Integer> map, CacheContext context) {
        Spliterator<Integer> spliterator = map.keySet().spliterator();
        Spliterator other = (Spliterator)MoreObjects.firstNonNull(spliterator.trySplit(), Spliterators.emptySpliterator());
        int[] count = new int[1];
        spliterator.forEachRemaining(key -> {
            count[0] = count[0] + 1;
        });
        other.forEachRemaining(key -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_estimateSize(Map<Integer, Integer> map, CacheContext context) {
        Spliterator<Integer> spliterator = map.keySet().spliterator();
        MatcherAssert.assertThat((Object)((int)spliterator.estimateSize()), (Matcher)Matchers.is((Object)map.size()));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void valuesToArray_null(Map<Integer, Integer> map, CacheContext context) {
        map.values().toArray((Integer[])null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void valuesToArray(Map<Integer, Integer> map, CacheContext context) {
        int length = context.original().size();
        Integer[] ints = map.values().toArray(new Integer[length]);
        MatcherAssert.assertThat((Object)ints.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(ints).containsAll(context.original().values()), (Matcher)Matchers.is((Object)true));
        Object[] array = map.values().toArray();
        MatcherAssert.assertThat((Object)array.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(array).containsAll(context.original().values()), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void values_empty(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat(map.values(), (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void values_addNotSupported(Map<Integer, Integer> map, CacheContext context) {
        map.values().add(1);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void values_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.values().clear();
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void values_clear(Map<Integer, Integer> map, CacheContext context) {
        map.values().clear();
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void values_removeIf_null(Map<Integer, Integer> map, CacheContext context) {
        map.values().removeIf(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void values_removeIf(Map<Integer, Integer> map, CacheContext context) {
        Predicate<Integer> isEven = value -> value % 2 == 0;
        boolean hasEven = map.values().stream().anyMatch(isEven);
        boolean removedIfEven = map.values().removeIf(isEven);
        MatcherAssert.assertThat((Object)map.values().stream().anyMatch(isEven), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)removedIfEven, (Matcher)Matchers.is((Object)hasEven));
        if (removedIfEven) {
            MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(context.original().size()))));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void values(Map<Integer, Integer> map, CacheContext context) {
        Collection<Integer> values = map.values();
        MatcherAssert.assertThat((Object)values.contains(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)values.remove(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(values, (Matcher)Matchers.hasSize((int)context.original().size()));
        for (Integer value : ImmutableList.copyOf(values)) {
            MatcherAssert.assertThat((Object)values.contains(value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)values.remove(value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)values.remove(value), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)values.contains(value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueIterator(Map<Integer, Integer> map, CacheContext context) {
        int iterations = 0;
        Iterator<Integer> i = map.values().iterator();
        while (i.hasNext()) {
            MatcherAssert.assertThat((Object)map.containsValue(i.next()), (Matcher)Matchers.is((Object)true));
            ++iterations;
            i.remove();
        }
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, iterations, RemovalCause.EXPLICIT));
        MatcherAssert.assertThat((Object)iterations, (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void valueIterator_noElement(Map<Integer, Integer> map, CacheContext context) {
        map.values().iterator().remove();
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NoSuchElementException.class})
    public void valueIterator_noMoreElements(Map<Integer, Integer> map, CacheContext context) {
        map.values().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void valueIterator_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Iterator<Integer> i = map.values().iterator();
            i.next();
            i.remove();
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void valueSpliterator_forEachRemaining_null(Map<Integer, Integer> map, CacheContext context) {
        map.values().spliterator().forEachRemaining(null);
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_forEachRemaining(Map<Integer, Integer> map, CacheContext context) {
        int[] count = new int[1];
        map.values().spliterator().forEachRemaining(value -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void valueSpliterator_tryAdvance_null(Map<Integer, Integer> map, CacheContext context) {
        map.values().spliterator().tryAdvance(null);
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_tryAdvance(Map<Integer, Integer> map, CacheContext context) {
        boolean advanced;
        Spliterator<Integer> spliterator = map.values().spliterator();
        int[] count = new int[1];
        while (advanced = spliterator.tryAdvance(value -> {
            count[0] = count[0] + 1;
        })) {
        }
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_trySplit(Map<Integer, Integer> map, CacheContext context) {
        Spliterator<Integer> spliterator = map.values().spliterator();
        Spliterator other = (Spliterator)MoreObjects.firstNonNull(spliterator.trySplit(), Spliterators.emptySpliterator());
        int[] count = new int[1];
        spliterator.forEachRemaining(value -> {
            count[0] = count[0] + 1;
        });
        other.forEachRemaining(value -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_estimateSize(Map<Integer, Integer> map, CacheContext context) {
        Spliterator<Integer> spliterator = map.values().spliterator();
        MatcherAssert.assertThat((Object)((int)spliterator.estimateSize()), (Matcher)Matchers.is((Object)map.size()));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySetToArray_null(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().toArray((Map.Entry[])null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void entriesToArray(Map<Integer, Integer> map, CacheContext context) {
        int length = context.original().size();
        Object[] ints = map.entrySet().toArray(new Object[length]);
        MatcherAssert.assertThat((Object)ints.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(ints).containsAll(context.original().entrySet()), (Matcher)Matchers.is((Object)true));
        Object[] array = map.entrySet().toArray();
        MatcherAssert.assertThat((Object)array.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(array).containsAll(context.original().entrySet()), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void entrySet_empty(Map<Integer, Integer> map, CacheContext context) {
        MatcherAssert.assertThat(map.entrySet(), (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void entrySet_addIsNotSupported(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.entrySet().add(Maps.immutableEntry((Object)1, (Object)2));
        }
        finally {
            MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void entrySet_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            map.entrySet().clear();
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySet_clear(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().clear();
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySet_removeIf_null(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().removeIf(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySet_removeIf(Map<Integer, Integer> map, CacheContext context) {
        Predicate<Map.Entry> isEven = entry -> (Integer)entry.getValue() % 2 == 0;
        boolean hasEven = map.entrySet().stream().anyMatch(isEven);
        boolean removedIfEven = map.entrySet().removeIf(isEven);
        MatcherAssert.assertThat((Object)map.entrySet().stream().anyMatch(isEven), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)removedIfEven, (Matcher)Matchers.is((Object)hasEven));
        if (removedIfEven) {
            MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(context.original().size()))));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySet(Map<Integer, Integer> map, CacheContext context) {
        Set<Map.Entry<Integer, Integer>> entries = map.entrySet();
        MatcherAssert.assertThat((Object)entries.contains(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)entries.remove(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.hasSize((int)context.original().size()));
        entries.forEach(entry -> {
            MatcherAssert.assertThat((Object)entries.contains(entry), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)entries.remove(entry), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)entries.remove(entry), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)entries.contains(entry), (Matcher)Matchers.is((Object)false));
        });
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entryIterator(Map<Integer, Integer> map, CacheContext context) {
        int iterations = 0;
        Iterator<Map.Entry<Integer, Integer>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, Integer> entry = i.next();
            MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry((Object)entry.getKey(), (Object)entry.getValue()));
            ++iterations;
            i.remove();
        }
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, iterations, RemovalCause.EXPLICIT));
        MatcherAssert.assertThat((Object)iterations, (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void entryIterator_noElement(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().iterator().remove();
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NoSuchElementException.class})
    public void entryIterator_noMoreElements(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void entryIterator_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Iterator<Map.Entry<Integer, Integer>> i = map.entrySet().iterator();
            i.next();
            i.remove();
        }
        finally {
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySpliterator_forEachRemaining_null(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().spliterator().forEachRemaining(null);
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_forEachRemaining(Map<Integer, Integer> map, CacheContext context) {
        int[] count = new int[1];
        map.entrySet().spliterator().forEachRemaining(entry -> {
            if (context.isCaffeine()) {
                MatcherAssert.assertThat((Object)entry, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WriteThroughEntry.class)));
            }
            count[0] = count[0] + 1;
            MatcherAssert.assertThat(context.original(), (Matcher)Matchers.hasEntry((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue())));
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySpliterator_tryAdvance_null(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().spliterator().tryAdvance(null);
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_tryAdvance(Map<Integer, Integer> map, CacheContext context) {
        boolean advanced;
        Spliterator<Map.Entry<Integer, Integer>> spliterator = map.entrySet().spliterator();
        int[] count = new int[1];
        while (advanced = spliterator.tryAdvance(entry -> {
            if (context.isCaffeine()) {
                MatcherAssert.assertThat((Object)entry, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WriteThroughEntry.class)));
            }
            count[0] = count[0] + 1;
        })) {
        }
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_trySplit(Map<Integer, Integer> map, CacheContext context) {
        Spliterator<Map.Entry<Integer, Integer>> spliterator = map.entrySet().spliterator();
        Spliterator other = (Spliterator)MoreObjects.firstNonNull(spliterator.trySplit(), Spliterators.emptySpliterator());
        int[] count = new int[1];
        spliterator.forEachRemaining(entry -> {
            count[0] = count[0] + 1;
        });
        other.forEachRemaining(entry -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)map.size()));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_estimateSize(Map<Integer, Integer> map, CacheContext context) {
        Spliterator<Map.Entry<Integer, Integer>> spliterator = map.entrySet().spliterator();
        MatcherAssert.assertThat((Object)((int)spliterator.estimateSize()), (Matcher)Matchers.is((Object)map.size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void writeThroughEntry(Map<Integer, Integer> map, CacheContext context) {
        Map.Entry<Integer, Integer> entry = map.entrySet().iterator().next();
        entry.setValue(3);
        MatcherAssert.assertThat((Object)map.get(entry.getKey()), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote((Integer)entry.getKey(), 3));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void writeThroughEntry_null(Map<Integer, Integer> map, CacheContext context) {
        map.entrySet().iterator().next().setValue(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void writeThroughEntry_serialize(Map<Integer, Integer> map, CacheContext context) {
        Map.Entry<Integer, Integer> entry = map.entrySet().iterator().next();
        Object copy = SerializableTester.reserialize(entry);
        MatcherAssert.assertThat(entry, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)copy)));
    }
}

