/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.WriteThroughEntry;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.testing.IsEmptyIterable;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class AsyncAsMapTest {
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void isEmpty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)context.original().isEmpty()));
        if (cache.asMap().isEmpty()) {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void size(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void clear(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().clear();
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, context.original().size(), RemovalCause.EXPLICIT));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void containsKey_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().containsKey(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsKey_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)cache.asMap().containsKey(key), (Matcher)Matchers.is((Object)true));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsKey_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().containsKey(context.absentKey()), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void containsValue_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().containsValue(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsValue_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)cache.asMap().containsValue(cache.asMap().get(key)), (Matcher)Matchers.is((Object)true));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void containsValue_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().containsValue(CompletableFuture.completedFuture(context.absentValue())), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void get_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().get(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void get_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void get_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)((Integer)((CompletableFuture)cache.asMap().get(key)).join()), (Matcher)Matchers.is((Object)context.original().get(key)));
        }
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getOrDefault_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().getOrDefault(null, CompletableFuture.completedFuture(1));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getOrDefault_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        MatcherAssert.assertThat((Object)cache.asMap().getOrDefault(context.absentKey(), null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(cache.asMap().getOrDefault(context.absentKey(), value), (Matcher)Matchers.is(value));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getOrDefault_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)cache.asMap().getOrDefault(key, value).join(), (Matcher)Matchers.is((Object)context.original().get(key)));
        }
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void forEach_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().forEach(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void forEach_scan(AsyncCache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> remaining = new HashMap<Integer, Integer>(context.original());
        cache.asMap().forEach((k, v) -> remaining.remove(k, v.join()));
        MatcherAssert.assertThat(remaining, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void forEach_modify(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList modified = new ArrayList();
        cache.asMap().forEach((key, value) -> {
            Integer newKey = context.lastKey() + key;
            modified.add(newKey);
            cache.synchronous().put((Object)newKey, key);
        });
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().put(null, CompletableFuture.completedFuture(1));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().put(1, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_nullKeyAndValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().put(null, null);
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_insert(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        MatcherAssert.assertThat(cache.asMap().put(context.absentKey(), value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is(value));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(context.original().size() + 1)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void put_replace_sameValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat((Object)cache.asMap().put(key, value), (Matcher)Matchers.is((Object)value));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void put_replace_differentValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture<Integer> newValue = CompletableFuture.completedFuture(context.absentValue());
            MatcherAssert.assertThat((Object)cache.asMap().put(key, newValue).join(), (Matcher)Matchers.is((Object)context.original().get(key)));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is(newValue));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().putAll(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_empty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().putAll(Collections.emptyMap());
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_insert(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int startKey = context.original().size() + 1;
        Map entries = IntStream.range(startKey, 100 + startKey).boxed().collect(Collectors.toMap(Function.identity(), key -> CompletableFuture.completedFuture(-key.intValue())));
        cache.asMap().putAll(entries);
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(100 + context.original().size())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void putAll_replace(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map entries = context.original().keySet().stream().collect(Collectors.toMap(Function.identity(), CompletableFuture::completedFuture));
        cache.asMap().putAll(entries);
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(entries)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, entries.size(), RemovalCause.REPLACED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void putAll_mixed(AsyncCache<Integer, Integer> cache, CacheContext context) {
        HashMap entries = new HashMap();
        ArrayList replaced = new ArrayList();
        context.original().forEach((key, value) -> {
            if (key % 2 == 0) {
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                replaced.add(key);
                entries.put(key, CompletableFuture.completedFuture(value));
            } else {
                entries.put(key, (CompletableFuture)cache.asMap().get(key));
            }
        });
        cache.asMap().putAll(entries);
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(entries)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, replaced.size(), RemovalCause.REPLACED));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().putIfAbsent(null, CompletableFuture.completedFuture(2));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().putIfAbsent(1, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_nullKeyAndValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().putIfAbsent(null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat(cache.asMap().putIfAbsent(key, CompletableFuture.completedFuture(key)), (Matcher)Matchers.is((Object)value));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putIfAbsent_insert(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        MatcherAssert.assertThat(cache.asMap().putIfAbsent(context.absentKey(), value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is(value));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(context.original().size() + 1)));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void remove_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().remove(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void remove_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().remove(context.absentKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void remove_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.asMap().remove(key);
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(context.original().size() - context.firstMiddleLastKeys().size())));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().remove(null, 1);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().remove(1, null), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_nullKeyAndValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().remove(null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        MatcherAssert.assertThat((Object)cache.asMap().remove(context.absentKey(), value), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void removeConditionally_presentKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture<Integer> value = CompletableFuture.completedFuture(key);
            MatcherAssert.assertThat((Object)cache.asMap().remove(key, value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void removeConditionally_presentKeyAndValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat((Object)cache.asMap().remove(key, value), (Matcher)Matchers.is((Object)true));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replace(null, CompletableFuture.completedFuture(1));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replace(1, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_nullKeyAndValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replace(null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replace_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat(cache.asMap().replace(context.absentKey(), CompletableFuture.completedFuture(context.absentValue())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replace_sameValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat((Object)cache.asMap().replace(key, value), (Matcher)Matchers.is((Object)value));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replace_differentValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture oldValue = (CompletableFuture)cache.asMap().get(key);
            CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
            MatcherAssert.assertThat(cache.asMap().replace(key, value), (Matcher)Matchers.is((Object)oldValue));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is(value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(1);
        cache.asMap().replace(null, value, value);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullOldValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(1);
        cache.asMap().replace(1, null, value);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullNewValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(1);
        cache.asMap().replace(1, value, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKeyAndOldValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(1);
        cache.asMap().replace(null, null, value);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKeyAndNewValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(1);
        cache.asMap().replace(null, value, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullOldAndNewValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replace(1, null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_nullKeyAndValues(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replace(null, null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        MatcherAssert.assertThat((Object)cache.asMap().replace(context.absentKey(), value, value), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void replaceConditionally_wrongOldValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture oldValue = (CompletableFuture)cache.asMap().get(key);
            CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
            MatcherAssert.assertThat((Object)cache.asMap().replace(key, value, value), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is((Object)oldValue));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replaceConditionally_sameValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat((Object)cache.asMap().replace(key, value, value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void replaceConditionally_differentValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture oldValue = (CompletableFuture)cache.asMap().get(key);
            CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
            MatcherAssert.assertThat((Object)cache.asMap().replace(key, oldValue, value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(key)), (Matcher)Matchers.is(value));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void replaceAll_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replaceAll(null);
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void replaceAll_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replaceAll((key, value) -> null);
    }

    @CacheSpec
    @Test(dataProvider="caches")
    public void replaceAll_sameValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replaceAll((key, value) -> value);
        MatcherAssert.assertThat((Object)cache.synchronous().asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
    }

    @CacheSpec
    @Test(dataProvider="caches")
    public void replaceAll_differentValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().replaceAll((key, value) -> CompletableFuture.completedFuture(key));
        cache.asMap().forEach((key, value) -> MatcherAssert.assertThat((Object)((Integer)value.join()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)key))));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, cache.asMap().size(), RemovalCause.REPLACED));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfAbsent_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().computeIfAbsent(null, key -> CompletableFuture.completedFuture(-key.intValue()));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfAbsent_nullMappingFunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().computeIfAbsent(context.absentKey(), null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().computeIfAbsent(context.absentKey(), key -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void computeIfAbsent_recursive(final AsyncCache<Integer, Integer> cache, CacheContext context) {
        Function<Integer, CompletableFuture<Integer>> mappingFunction = new Function<Integer, CompletableFuture<Integer>>(){

            @Override
            public CompletableFuture<Integer> apply(Integer key) {
                return cache.asMap().computeIfAbsent(key, this);
            }
        };
        cache.asMap().computeIfAbsent(context.absentKey(), mappingFunction);
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void computeIfAbsent_pingpong(final AsyncCache<Integer, Integer> cache, final CacheContext context) {
        Function<Integer, CompletableFuture<Integer>> mappingFunction = new Function<Integer, CompletableFuture<Integer>>(){

            @Override
            public CompletableFuture<Integer> apply(Integer key) {
                Integer value = context.original().get(key);
                return cache.asMap().computeIfAbsent(value, this);
            }
        };
        cache.asMap().computeIfAbsent(context.absentKey(), mappingFunction);
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_error(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.asMap().computeIfAbsent(context.absentKey(), key -> {
                throw new IllegalStateException();
            });
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)cache.synchronous().asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)((Integer)cache.asMap().computeIfAbsent(context.absentKey(), key -> CompletableFuture.completedFuture(key)).join()), (Matcher)Matchers.is((Object)context.absentKey()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)cache.asMap().computeIfAbsent(key, k -> {
                throw new AssertionError();
            }), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(count)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        MatcherAssert.assertThat((Object)cache.asMap().computeIfAbsent(context.absentKey(), key -> value), (Matcher)Matchers.is(value));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is(value));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(1 + context.original().size())));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfPresent_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().computeIfPresent(null, (key, value) -> CompletableFuture.completedFuture(-key.intValue()));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void computeIfPresent_nullMappingFunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().computeIfPresent(1, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void computeIfPresent_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.asMap().computeIfPresent(key, (k, v) -> null);
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void computeIfPresent_recursive(final AsyncCache<Integer, Integer> cache, CacheContext context) {
        BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>> mappingFunction = new BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>>(){
            boolean recursed;

            @Override
            public CompletableFuture<Integer> apply(Integer key, CompletableFuture<Integer> value) {
                if (this.recursed) {
                    throw new StackOverflowError();
                }
                this.recursed = true;
                return cache.asMap().computeIfPresent(key, this);
            }
        };
        cache.asMap().computeIfPresent(context.firstKey(), mappingFunction);
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void computeIfPresent_pingpong(final AsyncCache<Integer, Integer> cache, final CacheContext context) {
        BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>> mappingFunction = new BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>>(){
            int recursed;

            @Override
            public CompletableFuture<Integer> apply(Integer key, CompletableFuture<Integer> value) {
                if (++this.recursed == 2) {
                    throw new StackOverflowError();
                }
                return cache.asMap().computeIfPresent(context.lastKey(), this);
            }
        };
        cache.asMap().computeIfPresent(context.firstKey(), mappingFunction);
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void computeIfPresent_error(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.asMap().computeIfPresent(context.firstKey(), (key, value) -> {
                throw new IllegalStateException();
            });
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)cache.synchronous().asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)((Integer)cache.asMap().computeIfPresent(context.firstKey(), (k, v) -> CompletableFuture.completedFuture(-k.intValue())).join()), (Matcher)Matchers.is((Object)(-context.firstKey().intValue())));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void computeIfPresent_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().computeIfPresent(context.absentKey(), (key, value) -> value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void computeIfPresent_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture<Integer> value = CompletableFuture.completedFuture(key);
            MatcherAssert.assertThat((Object)cache.asMap().computeIfPresent(key, (k, v) -> value), (Matcher)Matchers.is(value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)((Integer)cache.synchronous().asMap().get(key)), (Matcher)Matchers.is((Object)key));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void compute_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().compute(null, (key, value) -> CompletableFuture.completedFuture(-key.intValue()));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void compute_nullMappingFunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().compute(1, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void compute_remove(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)cache.asMap().compute(key, (k, v) -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void compute_recursive(final AsyncCache<Integer, Integer> cache, CacheContext context) {
        BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>> mappingFunction = new BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>>(){

            @Override
            public CompletableFuture<Integer> apply(Integer key, CompletableFuture<Integer> value) {
                return cache.asMap().compute(key, this);
            }
        };
        cache.asMap().compute(context.absentKey(), mappingFunction);
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(enabled=false, dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void compute_pingpong(final AsyncCache<Integer, Integer> cache, final CacheContext context) {
        BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>> mappingFunction = new BiFunction<Integer, CompletableFuture<Integer>, CompletableFuture<Integer>>(){

            @Override
            public CompletableFuture<Integer> apply(Integer key, CompletableFuture<Integer> value) {
                return cache.asMap().computeIfPresent(context.lastKey(), this);
            }
        };
        cache.asMap().computeIfPresent(context.firstKey(), mappingFunction);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void compute_error(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.asMap().compute(context.absentKey(), (key, value) -> {
                throw new IllegalStateException();
            });
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)cache.synchronous().asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)cache.asMap().computeIfPresent(context.absentKey(), (k, v) -> CompletableFuture.completedFuture(-k.intValue())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void compute_absent_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().compute(context.absentKey(), (key, value) -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void compute_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        MatcherAssert.assertThat((Object)cache.asMap().compute(context.absentKey(), (k, v) -> value), (Matcher)Matchers.is(value));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(1 + context.original().size())));
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is(value));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void compute_sameValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat((Object)cache.asMap().compute(key, (k, v) -> v), (Matcher)Matchers.is((Object)value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)((Integer)cache.synchronous().asMap().get(key)), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void compute_differentValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture<Integer> value = CompletableFuture.completedFuture(key);
            MatcherAssert.assertThat((Object)cache.asMap().compute(key, (k, v) -> value), (Matcher)Matchers.is(value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)((Integer)cache.synchronous().asMap().get(key)), (Matcher)Matchers.is((Object)key));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void merge_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().merge(null, CompletableFuture.completedFuture(-1), (oldValue, value) -> value);
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void merge_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().merge(1, null, (oldValue, value) -> value);
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void merge_nullMappingFunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().merge(1, CompletableFuture.completedFuture(1), null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void merge_remove(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat((Object)cache.asMap().merge(key, value, (oldValue, v) -> null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(context.original().size() - count)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches")
    public void merge_recursive(final AsyncCache<Integer, Integer> cache, final CacheContext context) {
        BiFunction<CompletableFuture<Integer>, CompletableFuture<Integer>, CompletableFuture<Integer>> mappingFunction = new BiFunction<CompletableFuture<Integer>, CompletableFuture<Integer>, CompletableFuture<Integer>>(){

            @Override
            public CompletableFuture<Integer> apply(CompletableFuture<Integer> oldValue, CompletableFuture<Integer> value) {
                return cache.asMap().merge(context.absentKey(), oldValue, this);
            }
        };
        CompletableFuture firstValue = (CompletableFuture)cache.asMap().get(context.firstKey());
        CompletableFuture<Integer> value = cache.asMap().merge(context.absentKey(), firstValue, mappingFunction);
        MatcherAssert.assertThat(value, (Matcher)Matchers.is((Object)firstValue));
    }

    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={StackOverflowError.class})
    public void merge_pingpong(final AsyncCache<Integer, Integer> cache, final CacheContext context) {
        BiFunction<CompletableFuture<Integer>, CompletableFuture<Integer>, CompletableFuture<Integer>> mappingFunction = new BiFunction<CompletableFuture<Integer>, CompletableFuture<Integer>, CompletableFuture<Integer>>(){
            int recursed;

            @Override
            public CompletableFuture<Integer> apply(CompletableFuture<Integer> oldValue, CompletableFuture<Integer> value) {
                if (++this.recursed == 2) {
                    throw new StackOverflowError();
                }
                CompletableFuture lastValue = (CompletableFuture)cache.asMap().get(context.lastKey());
                return cache.asMap().merge(context.lastKey(), lastValue, this);
            }
        };
        cache.asMap().merge(context.firstKey(), (CompletableFuture)cache.asMap().get(context.firstKey()), mappingFunction);
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void merge_error(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.asMap().merge(context.firstKey(), (CompletableFuture)cache.asMap().get(context.firstKey()), (oldValue, value) -> {
                throw new IllegalStateException();
            });
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)cache.synchronous().asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)((Integer)cache.asMap().merge(context.firstKey(), (CompletableFuture)cache.asMap().get(context.firstKey()), (oldValue, value) -> CompletableFuture.completedFuture(context.absentValue())).join()), (Matcher)Matchers.is((Object)context.absentValue()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void merge_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> absent = CompletableFuture.completedFuture(context.absentValue());
        CompletableFuture result = cache.asMap().merge(context.absentKey(), absent, (oldValue, value) -> value);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is(absent));
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(context.absentKey())), (Matcher)Matchers.is(absent));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)(1 + context.original().size())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void merge_sameValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            CompletableFuture value = (CompletableFuture)cache.asMap().get(key);
            MatcherAssert.assertThat((Object)cache.asMap().merge(key, CompletableFuture.completedFuture(-key.intValue()), (oldValue, v) -> oldValue), (Matcher)Matchers.is((Object)value));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            MatcherAssert.assertThat((Object)((Integer)cache.synchronous().asMap().get(key)), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void merge_differentValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)((Integer)cache.asMap().merge(key, CompletableFuture.completedFuture(key), (oldValue, v) -> CompletableFuture.completedFuture((Integer)oldValue.join() + (Integer)v.join())).join()), (Matcher)Matchers.is((Object)0));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)((Integer)cache.synchronous().asMap().get(key)), (Matcher)Matchers.is((Object)0));
        }
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equals_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().equals(null), (Matcher)Matchers.is((Object)false));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equals_self(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().equals(cache.asMap()), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equals(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ImmutableMap map = ImmutableMap.copyOf((Map)cache.asMap());
        MatcherAssert.assertThat((Object)cache.asMap().equals(map), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)map.equals(cache.asMap()), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void hashCode(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().hashCode(), (Matcher)Matchers.is((Object)ImmutableMap.copyOf((Map)cache.asMap()).hashCode()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void hashCode_self(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.asMap().hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)cache.asMap().hashCode())));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equalsAndHashCodeFail_empty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ImmutableMap other = ImmutableMap.of((Object)1, CompletableFuture.completedFuture(-1), (Object)2, CompletableFuture.completedFuture(-2), (Object)3, CompletableFuture.completedFuture(-3));
        MatcherAssert.assertThat((Object)cache.asMap().equals(other), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)other.equals(cache.asMap()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)cache.asMap().hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)other.hashCode()))));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void equalsAndHashCodeFail_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ImmutableMap other = ImmutableMap.of((Object)1, CompletableFuture.completedFuture(-1), (Object)2, CompletableFuture.completedFuture(-2), (Object)3, CompletableFuture.completedFuture(-3));
        MatcherAssert.assertThat((Object)cache.asMap().equals(other), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)other.equals(cache.asMap()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)cache.asMap().hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)other.hashCode()))));
        ImmutableMap empty = ImmutableMap.of();
        MatcherAssert.assertThat((Object)cache.asMap().equals(empty), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)empty.equals(cache.asMap()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)cache.asMap().hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)empty.hashCode()))));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void toString(AsyncCache<Integer, Integer> cache, CacheContext context) {
        String toString = cache.asMap().toString();
        if (!context.original().toString().equals(toString)) {
            cache.asMap().forEach((key, value) -> MatcherAssert.assertThat((Object)toString, (Matcher)Matchers.containsString((String)(key + "=" + value))));
        }
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void keySetToArray_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().keySet().toArray((Integer[])null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void keySetToArray(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int length = context.original().size();
        Integer[] ints = cache.asMap().keySet().toArray(new Integer[length]);
        MatcherAssert.assertThat((Object)ints.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(ints).containsAll(context.original().keySet()), (Matcher)Matchers.is((Object)true));
        Object[] array = cache.asMap().keySet().toArray();
        MatcherAssert.assertThat((Object)array.length, (Matcher)Matchers.is((Object)length));
        MatcherAssert.assertThat((Object)Arrays.asList(array).containsAll(context.original().keySet()), (Matcher)Matchers.is((Object)true));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void keySet_whenEmpty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat(cache.asMap().keySet(), (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void keySet_addNotSupported(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().keySet().add(1);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySet_clear(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().keySet().clear();
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySet(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Set keys = cache.asMap().keySet();
        MatcherAssert.assertThat((Object)keys.contains(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)keys.remove(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.hasSize((int)context.original().size()));
        for (Integer key : ImmutableSet.copyOf(keys)) {
            MatcherAssert.assertThat((Object)keys.contains(key), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)keys.remove(key), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)keys.remove(key), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)keys.contains(key), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySet_iterator(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int iterations = 0;
        Iterator i = cache.asMap().keySet().iterator();
        while (i.hasNext()) {
            MatcherAssert.assertThat((Object)cache.asMap().containsKey(i.next()), (Matcher)Matchers.is((Object)true));
            ++iterations;
            i.remove();
        }
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, iterations, RemovalCause.EXPLICIT));
        MatcherAssert.assertThat((Object)iterations, (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void keyIterator_noElement(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().keySet().iterator().remove();
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NoSuchElementException.class})
    public void keyIterator_noMoreElements(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().keySet().iterator().next();
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void keySpliterator_forEachRemaining_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().keySet().spliterator().forEachRemaining(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_forEachRemaining(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int[] count = new int[1];
        cache.asMap().keySet().spliterator().forEachRemaining(key -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void keySpliterator_tryAdvance_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().keySet().spliterator().tryAdvance(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_tryAdvance(AsyncCache<Integer, Integer> cache, CacheContext context) {
        boolean advanced;
        Spliterator spliterator = cache.asMap().keySet().spliterator();
        int[] count = new int[1];
        while (advanced = spliterator.tryAdvance(key -> {
            count[0] = count[0] + 1;
        })) {
        }
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_trySplit(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Spliterator spliterator = cache.asMap().keySet().spliterator();
        Spliterator other = (Spliterator)MoreObjects.firstNonNull(spliterator.trySplit(), Spliterators.emptySpliterator());
        int[] count = new int[1];
        spliterator.forEachRemaining(key -> {
            count[0] = count[0] + 1;
        });
        other.forEachRemaining(key -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void keySpliterator_estimateSize(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Spliterator spliterator = cache.asMap().keySet().spliterator();
        MatcherAssert.assertThat((Object)((int)spliterator.estimateSize()), (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void valuesToArray_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().toArray((CompletableFuture[])null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void valuesToArray(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int length = context.original().size();
        CompletableFuture[] futures = cache.asMap().values().toArray(new CompletableFuture[length]);
        List values = Arrays.stream(futures).map(CompletableFuture::join).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)values.containsAll(context.original().values()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)futures.length, (Matcher)Matchers.is((Object)length));
        Object[] array = cache.asMap().values().toArray();
        MatcherAssert.assertThat((Object)array.length, (Matcher)Matchers.is((Object)length));
        for (Object item : array) {
            CompletableFuture future = (CompletableFuture)item;
            MatcherAssert.assertThat(context.original().values(), (Matcher)Matchers.hasItem((Object)((Integer)future.join())));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void values_empty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat(cache.asMap().values(), (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void values_addNotSupported(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().add(CompletableFuture.completedFuture(1));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void values_clear(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().clear();
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void values_removeIf_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().removeIf(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void values_removeIf(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Predicate<CompletableFuture> isEven = value -> (Integer)value.join() % 2 == 0;
        boolean hasEven = cache.asMap().values().stream().anyMatch(isEven);
        boolean removedIfEven = cache.asMap().values().removeIf(isEven);
        MatcherAssert.assertThat((Object)cache.asMap().values().stream().anyMatch(isEven), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)removedIfEven, (Matcher)Matchers.is((Object)hasEven));
        if (removedIfEven) {
            MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(context.original().size()))));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void values(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Collection values = cache.asMap().values();
        MatcherAssert.assertThat((Object)values.contains(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)values.remove(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(values, (Matcher)Matchers.hasSize((int)context.original().size()));
        for (CompletableFuture value : ImmutableList.copyOf(values)) {
            MatcherAssert.assertThat((Object)values.contains(value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)values.remove(value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)values.remove(value), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)values.contains(value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueIterator(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int iterations = 0;
        Iterator i = cache.asMap().values().iterator();
        while (i.hasNext()) {
            MatcherAssert.assertThat((Object)cache.asMap().containsValue(i.next()), (Matcher)Matchers.is((Object)true));
            ++iterations;
            i.remove();
        }
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, iterations, RemovalCause.EXPLICIT));
        MatcherAssert.assertThat((Object)iterations, (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void valueIterator_noElement(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().iterator().remove();
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NoSuchElementException.class})
    public void valueIterator_noMoreElements(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().iterator().next();
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void valueSpliterator_forEachRemaining_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().spliterator().forEachRemaining(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_forEachRemaining(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int[] count = new int[1];
        cache.asMap().values().spliterator().forEachRemaining(value -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void valueSpliterator_tryAdvance_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().values().spliterator().tryAdvance(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_tryAdvance(AsyncCache<Integer, Integer> cache, CacheContext context) {
        boolean advanced;
        Spliterator spliterator = cache.asMap().values().spliterator();
        int[] count = new int[1];
        while (advanced = spliterator.tryAdvance(value -> {
            count[0] = count[0] + 1;
        })) {
        }
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_trySplit(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Spliterator spliterator = cache.asMap().values().spliterator();
        Spliterator other = (Spliterator)MoreObjects.firstNonNull(spliterator.trySplit(), Spliterators.emptySpliterator());
        int[] count = new int[1];
        spliterator.forEachRemaining(value -> {
            count[0] = count[0] + 1;
        });
        other.forEachRemaining(value -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void valueSpliterator_estimateSize(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Spliterator spliterator = cache.asMap().values().spliterator();
        MatcherAssert.assertThat((Object)((int)spliterator.estimateSize()), (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySetToArray_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().toArray((Map.Entry[])null);
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void entriesToArray(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int length = context.original().size();
        Map.Entry[] entries = cache.asMap().entrySet().toArray(new Map.Entry[length]);
        MatcherAssert.assertThat((Object)entries.length, (Matcher)Matchers.is((Object)length));
        for (Map.Entry entry : entries) {
            MatcherAssert.assertThat(context.original(), (Matcher)Matchers.hasEntry((Object)((Integer)entry.getKey()), (Object)((Integer)((CompletableFuture)entry.getValue()).join())));
        }
        Object[] array = cache.asMap().entrySet().toArray();
        MatcherAssert.assertThat((Object)array.length, (Matcher)Matchers.is((Object)length));
        for (Object item : array) {
            Map.Entry entry = (Map.Entry)item;
            MatcherAssert.assertThat(context.original(), (Matcher)Matchers.hasEntry((Object)((Integer)entry.getKey()), (Object)((Integer)((CompletableFuture)entry.getValue()).join())));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void entrySet_empty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat(cache.asMap().entrySet(), (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void entrySet_addIsNotSupported(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.asMap().entrySet().add(Maps.immutableEntry((Object)1, CompletableFuture.completedFuture(2)));
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)0));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySet_clear(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().clear();
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySet_removeIf_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().removeIf(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySet_removeIf(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Predicate<Map.Entry> isEven = entry -> (Integer)((CompletableFuture)entry.getValue()).join() % 2 == 0;
        boolean hasEven = cache.asMap().entrySet().stream().anyMatch(isEven);
        boolean removedIfEven = cache.asMap().entrySet().removeIf(isEven);
        MatcherAssert.assertThat((Object)cache.asMap().entrySet().stream().anyMatch(isEven), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)removedIfEven, (Matcher)Matchers.is((Object)hasEven));
        if (removedIfEven) {
            MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(context.original().size()))));
        }
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySet(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Set entries = cache.asMap().entrySet();
        MatcherAssert.assertThat((Object)entries.contains(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)entries.remove(new Object()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.hasSize((int)context.original().size()));
        entries.forEach(entry -> {
            MatcherAssert.assertThat((Object)entries.contains(entry), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)entries.remove(entry), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)entries.remove(entry), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)entries.contains(entry), (Matcher)Matchers.is((Object)false));
        });
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        int count = context.original().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entryIterator(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Iterator i = cache.asMap().entrySet().iterator();
        int iterations = 0;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.hasEntry((Object)((Integer)entry.getKey()), (Object)((CompletableFuture)entry.getValue())));
            ++iterations;
            i.remove();
        }
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, iterations, RemovalCause.EXPLICIT));
        MatcherAssert.assertThat((Object)iterations, (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void entryIterator_noElement(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().iterator().remove();
    }

    @CheckNoStats
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NoSuchElementException.class})
    public void entryIterator_noMoreElements(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().iterator().next();
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySpliterator_forEachRemaining_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().spliterator().forEachRemaining(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_forEachRemaining(AsyncCache<Integer, Integer> cache, CacheContext context) {
        int[] count = new int[1];
        cache.asMap().entrySet().spliterator().forEachRemaining(entry -> {
            if (context.isCaffeine()) {
                MatcherAssert.assertThat((Object)entry, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WriteThroughEntry.class)));
            }
            count[0] = count[0] + 1;
            MatcherAssert.assertThat(context.original(), (Matcher)Matchers.hasEntry((Object)((Integer)entry.getKey()), (Object)((Integer)((CompletableFuture)entry.getValue()).join())));
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)context.original().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void entrySpliterator_tryAdvance_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().spliterator().tryAdvance(null);
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_tryAdvance(AsyncCache<Integer, Integer> cache, CacheContext context) {
        boolean advanced;
        Spliterator spliterator = cache.asMap().entrySet().spliterator();
        int[] count = new int[1];
        while (advanced = spliterator.tryAdvance(entry -> {
            if (context.isCaffeine()) {
                MatcherAssert.assertThat((Object)entry, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WriteThroughEntry.class)));
            }
            count[0] = count[0] + 1;
        })) {
        }
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_trySplit(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Spliterator spliterator = cache.asMap().entrySet().spliterator();
        Spliterator other = (Spliterator)MoreObjects.firstNonNull(spliterator.trySplit(), Spliterators.emptySpliterator());
        int[] count = new int[1];
        spliterator.forEachRemaining(entry -> {
            count[0] = count[0] + 1;
        });
        other.forEachRemaining(entry -> {
            count[0] = count[0] + 1;
        });
        MatcherAssert.assertThat((Object)count[0], (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CacheSpec
    @CheckNoStats
    @Test(dataProvider="caches")
    public void entrySpliterator_estimateSize(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Spliterator spliterator = cache.asMap().entrySet().spliterator();
        MatcherAssert.assertThat((Object)((int)spliterator.estimateSize()), (Matcher)Matchers.is((Object)cache.asMap().size()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void writeThroughEntry(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map.Entry entry = cache.asMap().entrySet().iterator().next();
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(3);
        entry.setValue(value);
        MatcherAssert.assertThat((Object)((CompletableFuture)cache.asMap().get(entry.getKey())), (Matcher)Matchers.is(value));
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void writeThroughEntry_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.asMap().entrySet().iterator().next().setValue(null);
    }
}

