/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.IsCacheReserializable;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class AsyncCacheTest {
    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getIfPresent_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getIfPresent(null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getIfPresent_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getIfPresent_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.firstKey()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.middleKey()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.lastKey()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(3L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getFunc_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.get(null, key -> null);
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getFunc_nullLoader(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.get((Object)context.absentKey(), (Function)null);
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getFunc_nullKeyAndLoader(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.get(null, (Function)null);
    }

    @CheckNoWriter
    @CacheSpec
    @Test(dataProvider="caches")
    public void getFunc_absent_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        CompletableFuture valueFuture = cache.get((Object)key, k -> null);
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)key), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(executor={CacheSpec.CacheExecutor.THREADED}, executorFailure=CacheSpec.ExecutorFailure.IGNORED)
    public void getFunc_absent_null_async(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        AtomicBoolean ready = new AtomicBoolean();
        AtomicBoolean done = new AtomicBoolean();
        CompletableFuture valueFuture = cache.get((Object)key, k -> {
            Awaits.await().untilTrue(ready);
            return null;
        });
        valueFuture.whenComplete((r, e) -> done.set(true));
        ready.set(true);
        Awaits.await().untilTrue(done);
        Awaits.await().until(() -> !cache.synchronous().asMap().containsKey(context.absentKey()));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.synchronous().asMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)key)));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void getFunc_absent_failure(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture valueFuture = cache.get((Object)context.absentKey(), k -> {
            throw new IllegalStateException();
        });
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isCompletedExceptionally(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(executor={CacheSpec.CacheExecutor.THREADED}, executorFailure=CacheSpec.ExecutorFailure.IGNORED)
    public void getFunc_absent_failure_async(AsyncCache<Integer, Integer> cache, CacheContext context) {
        AtomicBoolean ready = new AtomicBoolean();
        AtomicBoolean done = new AtomicBoolean();
        CompletableFuture valueFuture = cache.get((Object)context.absentKey(), k -> {
            Awaits.await().untilTrue(ready);
            throw new IllegalStateException();
        });
        valueFuture.whenComplete((r, e) -> done.set(true));
        ready.set(true);
        Awaits.await().untilTrue(done);
        Awaits.await().until(() -> !cache.synchronous().asMap().containsKey(context.absentKey()));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isCompletedExceptionally(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(executor={CacheSpec.CacheExecutor.THREADED}, executorFailure=CacheSpec.ExecutorFailure.IGNORED)
    public void getFunc_absent_cancelled(AsyncCache<Integer, Integer> cache, CacheContext context) {
        AtomicBoolean done = new AtomicBoolean();
        CompletableFuture valueFuture = cache.get((Object)context.absentKey(), k -> {
            Awaits.await().until(done::get);
            return null;
        });
        valueFuture.whenComplete((r, e) -> done.set(true));
        valueFuture.cancel(true);
        Awaits.await().untilTrue(done);
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void getFunc_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        CompletableFuture value = cache.get((Object)key, k -> context.absentValue());
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentValue())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getFunc_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Function<Integer, Integer> loader = key -> {
            throw new RuntimeException();
        };
        MatcherAssert.assertThat((Object)cache.get((Object)context.firstKey(), loader), (Matcher)Matchers.is(IsFutureValue.futureOf(context.original().get(context.firstKey()))));
        MatcherAssert.assertThat((Object)cache.get((Object)context.middleKey(), loader), (Matcher)Matchers.is(IsFutureValue.futureOf(context.original().get(context.middleKey()))));
        MatcherAssert.assertThat((Object)cache.get((Object)context.lastKey(), loader), (Matcher)Matchers.is(IsFutureValue.futureOf(context.original().get(context.lastKey()))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(3L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getBiFunc_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.get(null, (key, executor) -> CompletableFuture.completedFuture(null));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getBiFunc_nullLoader(AsyncCache<Integer, Integer> cache, CacheContext context) {
        BiFunction mappingFunction = null;
        cache.get((Object)context.absentKey(), mappingFunction);
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getBiFunc_nullKeyAndLoader(AsyncCache<Integer, Integer> cache, CacheContext context) {
        BiFunction mappingFunction = null;
        cache.get(null, mappingFunction);
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void getBiFunc_throwsException(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.get((Object)context.absentKey(), (key, executor) -> {
                throw new IllegalStateException();
            });
        }
        finally {
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
            MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @CheckNoWriter
    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getBiFunc_absent_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.get((Object)context.absentKey(), (k, executor) -> null);
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void getBiFunc_absent_failure_before(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(new IllegalStateException());
        Integer key = context.absentKey();
        CompletableFuture valueFuture = cache.get((Object)key, (k, executor) -> failedFuture);
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isCompletedExceptionally(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)key), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void getBiFunc_absent_failure_after(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture failedFuture = new CompletableFuture();
        Integer key = context.absentKey();
        CompletableFuture valueFuture = cache.get((Object)key, (k, executor) -> failedFuture);
        failedFuture.completeExceptionally(new IllegalStateException());
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isCompletedExceptionally(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)key), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void getBiFunc_absent_cancelled(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture cancelledFuture = new CompletableFuture();
        cache.get((Object)context.absentKey(), (k, executor) -> cancelledFuture);
        cancelledFuture.cancel(true);
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void getBiFunc_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        CompletableFuture value = cache.get((Object)key, (k, executor) -> CompletableFuture.completedFuture(context.absentValue()));
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentValue())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getBiFunc_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        BiFunction<Integer, Executor, CompletableFuture> loader = (key, executor) -> {
            throw new RuntimeException();
        };
        MatcherAssert.assertThat((Object)cache.get((Object)context.firstKey(), loader), (Matcher)Matchers.is(IsFutureValue.futureOf(context.original().get(context.firstKey()))));
        MatcherAssert.assertThat((Object)cache.get((Object)context.middleKey(), loader), (Matcher)Matchers.is(IsFutureValue.futureOf(context.original().get(context.middleKey()))));
        MatcherAssert.assertThat((Object)cache.get((Object)context.lastKey(), loader), (Matcher)Matchers.is(IsFutureValue.futureOf(context.original().get(context.lastKey()))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(3L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_nullKeys(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(null, keys -> {
            throw new AssertionError();
        });
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_nullKeys_nullFunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(null, (Function)null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_nullFunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(context.original().keySet(), (Function)null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(Collections.singletonList(null), keys -> {
            throw new AssertionError();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoWriter
    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={CompletionException.class})
    public void getAllFunction_absent_failure(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.getAll(context.absentKeys(), keys -> {
                throw new IllegalStateException();
            }).join();
        }
        finally {
            int misses = context.absentKeys().size();
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        }
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys(), keys -> context.absent()).join();
        int count = context.absentKeys().size();
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)count));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(count)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_present_partial(AsyncCache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> expect = new HashMap<Integer, Integer>();
        expect.put(context.firstKey(), -context.firstKey().intValue());
        expect.put(context.middleKey(), -context.middleKey().intValue());
        expect.put(context.lastKey(), -context.lastKey().intValue());
        Map result = (Map)cache.getAll(expect.keySet(), keys -> {
            MatcherAssert.assertThat((Object)Iterables.size((Iterable)keys), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(expect.keySet().size()))));
            return Streams.stream((Iterable)keys).collect(Collectors.toMap(key -> key, key -> -key.intValue()));
        }).join();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expect)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(expect.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_exceeds(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys(), keys -> {
            ArrayList<Integer> moreKeys = new ArrayList<Integer>((Collection<Integer>)ImmutableList.copyOf((Iterable)keys));
            for (int i = 0; i < 10; ++i) {
                moreKeys.add(ThreadLocalRandom.current().nextInt());
            }
            return moreKeys.stream().collect(Collectors.toMap(key -> key, key -> -key.intValue()));
        }).join();
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.equalTo(context.absentKeys()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(context.initialSize() + (long)context.absentKeys().size()))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(result.size())).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_duplicates(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ImmutableSet absentKeys = ImmutableSet.copyOf((Iterable)Iterables.limit(context.absentKeys(), (int)Ints.saturatedCast((long)(context.maximum().max() - context.initialSize()))));
        Iterable keys = Iterables.concat((Iterable)absentKeys, (Iterable)absentKeys, context.original().keySet(), context.original().keySet());
        Map result = (Map)cache.getAll(keys, keysToLoad -> {
            MatcherAssert.assertThat((Object)ImmutableList.copyOf((Iterable)keysToLoad), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Iterable)keysToLoad).asList())));
            return Streams.stream((Iterable)keysToLoad).collect(Collectors.toMap(key -> key, key -> -key.intValue()));
        }).join();
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasMissCount(absentKeys.size()));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasHitCount(context.initialSize()));
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Iterable)keys))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_present_ordered_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.absentKeys());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, keysToLoad -> Streams.stream((Iterable)keysToLoad).collect(Collectors.toMap(key -> key, key -> -key.intValue()))).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_present_ordered_partial(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, keysToLoad -> Streams.stream((Iterable)keysToLoad).collect(Collectors.toMap(key -> key, key -> -key.intValue()))).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_present_ordered_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, keysToLoad -> {
            throw new AssertionError();
        }).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_present_ordered_exceeds(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, keysToLoad -> {
            ArrayList<Integer> moreKeys = new ArrayList<Integer>((Collection<Integer>)ImmutableList.copyOf((Iterable)keysToLoad));
            for (int i = 0; i < 10; ++i) {
                moreKeys.add(ThreadLocalRandom.current().nextInt());
            }
            return moreKeys.stream().collect(Collectors.toMap(key -> key, key -> -key.intValue()));
        }).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, compute={CacheSpec.Compute.ASYNC}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_badLoader(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.getAll(context.absentKeys(), keysToLoad -> {
                throw new LoadAllException();
            }).join();
        }
        catch (CompletionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(LoadAllException.class)));
            MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_nullKeys(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(null, (keys, executor) -> {
            throw new AssertionError();
        });
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_nullKeys_nullBifunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        BiFunction f = null;
        cache.getAll(null, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_nullBifunction(AsyncCache<Integer, Integer> cache, CacheContext context) {
        BiFunction f = null;
        cache.getAll(context.original().keySet(), null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(Collections.singletonList(null), (keys, executor) -> {
            throw new AssertionError();
        });
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllFunction_iterable_empty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll((Iterable)ImmutableList.of(), keys -> {
            throw new AssertionError();
        }).join();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_iterable_empty(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll((Iterable)ImmutableList.of(), (keys, executor) -> {
            throw new AssertionError();
        }).join();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void getAllFunction_immutable(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys(), keys -> Streams.stream((Iterable)keys).collect(Collectors.toMap(key -> key, key -> key))).join();
        result.clear();
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void getAllBifunction_immutable(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys(), (keys, executor) -> CompletableFuture.completedFuture(Streams.stream((Iterable)keys).collect(Collectors.toMap(key -> key, key -> key)))).join();
        result.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoWriter
    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={CompletionException.class})
    public void getAllFunction_absent_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.getAll(context.absentKeys(), keys -> null).join();
        }
        finally {
            int misses = context.absentKeys().size();
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        }
    }

    @CheckNoWriter
    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={CompletionException.class})
    public void getAllBifunction_absent_null(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(context.absentKeys(), (keys, executor) -> CompletableFuture.completedFuture(null)).join();
    }

    @CheckNoWriter
    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAllBifunction_absent_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(context.absentKeys(), (keys, executor) -> null).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoWriter
    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={CompletionException.class})
    public void getAllBifunction_absent_failure(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.getAll(context.absentKeys(), (keys, executor) -> {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(new IllegalStateException());
                return future;
            }).join();
        }
        finally {
            int misses = context.absentKeys().size();
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        }
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys(), (keys, executor) -> CompletableFuture.completedFuture(context.absent())).join();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is(context.absent()));
        int count = context.absentKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(count)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_present_partial(AsyncCache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> expect = new HashMap<Integer, Integer>();
        expect.put(context.firstKey(), -context.firstKey().intValue());
        expect.put(context.middleKey(), -context.middleKey().intValue());
        expect.put(context.lastKey(), -context.lastKey().intValue());
        Map result = (Map)cache.getAll(expect.keySet(), (keys, executor) -> {
            MatcherAssert.assertThat((Object)Iterables.size((Iterable)keys), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(expect.keySet().size()))));
            return CompletableFuture.completedFuture(Streams.stream((Iterable)keys).collect(Collectors.toMap(key -> key, key -> -key.intValue())));
        }).join();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expect)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(expect.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_exceeds(AsyncCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys(), (keys, executor) -> {
            ArrayList<Integer> moreKeys = new ArrayList<Integer>((Collection<Integer>)ImmutableList.copyOf((Iterable)keys));
            for (int i = 0; i < 10; ++i) {
                moreKeys.add(ThreadLocalRandom.current().nextInt());
            }
            return CompletableFuture.completedFuture(moreKeys.stream().collect(Collectors.toMap(key -> key, key -> -key.intValue())));
        }).join();
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.equalTo(context.absentKeys()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(context.initialSize() + (long)context.absentKeys().size()))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(result.size())).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_duplicates(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ImmutableSet absentKeys = ImmutableSet.copyOf((Iterable)Iterables.limit(context.absentKeys(), (int)Ints.saturatedCast((long)(context.maximum().max() - context.initialSize()))));
        Iterable keys = Iterables.concat((Iterable)absentKeys, (Iterable)absentKeys, context.original().keySet(), context.original().keySet());
        Map result = (Map)cache.getAll(keys, (keysToLoad, executor) -> {
            MatcherAssert.assertThat((Object)ImmutableList.copyOf((Iterable)keysToLoad), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Iterable)keysToLoad).asList())));
            return CompletableFuture.completedFuture(Streams.stream((Iterable)keysToLoad).collect(Collectors.toMap(key -> key, key -> -key.intValue())));
        }).join();
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasMissCount(absentKeys.size()));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasHitCount(context.initialSize()));
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Iterable)keys))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_present_ordered_absent(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.absentKeys());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, (keysToLoad, executor) -> {
            MatcherAssert.assertThat((Object)ImmutableSet.copyOf((Iterable)keysToLoad), (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.absentKeys())));
            return CompletableFuture.completedFuture(Streams.stream((Iterable)keysToLoad).collect(Collectors.toMap(key -> key, key -> -key.intValue())));
        }).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_present_ordered_partial(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, (keysToLoad, executor) -> {
            MatcherAssert.assertThat((Object)ImmutableSet.copyOf((Iterable)keysToLoad), (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.absentKeys())));
            return CompletableFuture.completedFuture(Streams.stream((Iterable)keysToLoad).collect(Collectors.toMap(key -> key, key -> -key.intValue())));
        }).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_present_ordered_present(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, (keysToLoad, executor) -> {
            throw new AssertionError();
        }).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_present_ordered_exceeds(AsyncCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ImmutableList result = ImmutableList.copyOf(((Map)cache.getAll(keys, (keysToLoad, executor) -> {
            ArrayList<Integer> moreKeys = new ArrayList<Integer>((Collection<Integer>)ImmutableList.copyOf((Iterable)keysToLoad));
            for (int i = 0; i < 10; ++i) {
                moreKeys.add(ThreadLocalRandom.current().nextInt());
            }
            return CompletableFuture.completedFuture(moreKeys.stream().collect(Collectors.toMap(key -> key, key -> -key.intValue())));
        }).join()).keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, compute={CacheSpec.Compute.ASYNC}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllBifunction_badLoader(AsyncCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.getAll(context.absentKeys(), (keysToLoad, executor) -> {
                throw new LoadAllException();
            }).join();
            Assert.fail();
        }
        catch (LoadAllException e) {
            MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Object)context.original().size()));
        }
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void put_nullKey(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        cache.put(null, value);
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void put_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.absentKey(), null);
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void put_nullKeyAndValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        cache.put(null, null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_insert_failure_before(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Object> failedFuture = CompletableFuture.completedFuture(null);
        failedFuture.completeExceptionally(new IllegalStateException());
        cache.put((Object)context.absentKey(), failedFuture);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_insert_failure_after(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture failedFuture = new CompletableFuture();
        cache.put((Object)context.absentKey(), failedFuture);
        failedFuture.completeExceptionally(new IllegalStateException());
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_insert(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        cache.put((Object)context.absentKey(), value);
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() + 1L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)((Integer)cache.synchronous().getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Object)context.absentValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_replace_failure_before(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Object> failedFuture = CompletableFuture.completedFuture(null);
        failedFuture.completeExceptionally(new IllegalStateException());
        cache.put((Object)context.middleKey(), failedFuture);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() - 1L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_replace_failure_after(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Object> failedFuture = CompletableFuture.completedFuture(null);
        cache.put((Object)context.middleKey(), failedFuture);
        failedFuture.completeExceptionally(new IllegalStateException());
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() - 1L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void put_replace_nullValue(AsyncCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Object> value = CompletableFuture.completedFuture(null);
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.put((Object)key, value);
            MatcherAssert.assertThat((Object)cache.getIfPresent((Object)key), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() - (long)count)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @Test(dataProvider="caches")
    @CacheSpec(writer={CacheSpec.Writer.EXCEPTIONAL})
    public void serialize(AsyncCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat(cache, (Matcher)Matchers.is(IsCacheReserializable.reserializable()));
    }

    private static final class LoadAllException
    extends RuntimeException {
        private LoadAllException() {
        }
    }
}

