/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class AsyncLoadingCacheTest {
    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void get_null(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.get(null);
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void get_absent(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.get((Object)context.absentKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentValue())));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.EXCEPTIONAL})
    public void get_absent_failure(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture future = cache.get((Object)context.absentKey());
        MatcherAssert.assertThat((Object)future.isCompletedExceptionally(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.EXCEPTIONAL}, executor={CacheSpec.CacheExecutor.THREADED}, executorFailure=CacheSpec.ExecutorFailure.IGNORED)
    public void get_absent_failure_async(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        AtomicBoolean done = new AtomicBoolean();
        Integer key = context.absentKey();
        CompletableFuture valueFuture = cache.get((Object)key);
        valueFuture.whenComplete((r, e) -> done.set(true));
        Awaits.await().untilTrue(done);
        Awaits.await().until(() -> !cache.synchronous().asMap().containsKey(context.absentKey()));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        MatcherAssert.assertThat((Object)valueFuture.isCompletedExceptionally(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)key), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void get_present(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.get((Object)context.firstKey()), IsFutureValue.futureOf(-context.firstKey().intValue()));
        MatcherAssert.assertThat((Object)cache.get((Object)context.middleKey()), IsFutureValue.futureOf(-context.middleKey().intValue()));
        MatcherAssert.assertThat((Object)cache.get((Object)context.lastKey()), IsFutureValue.futureOf(-context.lastKey().intValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(3L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_iterable_null(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_iterable_nullKey(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(Collections.singletonList(null));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_iterable_empty(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture result = cache.getAll((Iterable)ImmutableList.of());
        MatcherAssert.assertThat((Object)((Map)result.join()).size(), (Matcher)Matchers.is((Object)0));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void getAll_immutable(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ((Map)cache.getAll(context.absentKeys()).join()).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.BULK_NULL})
    @Test(dataProvider="caches", expectedExceptions={CompletionException.class})
    public void getAll_absent_bulkNull(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        int misses;
        try {
            cache.getAll(context.absentKeys()).join();
            misses = context.absentKeys().size();
        }
        catch (Throwable throwable) {
            int misses2 = context.absentKeys().size();
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses2)).and((Matcher)HasStats.hasHitCount(0L)));
            int loadFailures = context.loader().isBulk() ? 1 : (context.isAsync() ? misses2 : 1);
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures)));
            throw throwable;
        }
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
        int loadFailures = context.loader().isBulk() ? 1 : (context.isAsync() ? misses : 1);
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.EXCEPTIONAL, CacheSpec.Loader.BULK_EXCEPTIONAL})
    @Test(dataProvider="caches", expectedExceptions={CompletionException.class})
    public void getAll_absent_failure(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        int loadFailures;
        int misses;
        try {
            cache.getAll(context.absentKeys()).join();
            misses = context.absentKeys().size();
            loadFailures = context.loader().isBulk() ? 1 : (context.isAsync() ? misses : 1);
        }
        catch (Throwable throwable) {
            int misses2 = context.absentKeys().size();
            int loadFailures2 = context.loader().isBulk() ? 1 : (context.isAsync() ? misses2 : 1);
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses2)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures2)));
            throw throwable;
        }
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_absent(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys()).join();
        int count = context.absentKeys().size();
        int loads = context.loader().isBulk() ? 1 : count;
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)count));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(count)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(loads)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_partial(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> expect = new HashMap<Integer, Integer>();
        expect.put(context.firstKey(), -context.firstKey().intValue());
        expect.put(context.middleKey(), -context.middleKey().intValue());
        expect.put(context.lastKey(), -context.lastKey().intValue());
        Map result = (Map)cache.getAll(expect.keySet()).join();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expect)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(expect.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.BULK_NEGATIVE_EXCEEDS}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_exceeds(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Map result = (Map)cache.getAll(context.absentKeys()).join();
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.equalTo(context.absentKeys()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(context.initialSize() + (long)context.absentKeys().size()))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(result.size())).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_duplicates(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ImmutableSet absentKeys = ImmutableSet.copyOf((Iterable)Iterables.limit(context.absentKeys(), (int)Ints.saturatedCast((long)(context.maximum().max() - context.initialSize()))));
        Iterable keys = Iterables.concat((Iterable)absentKeys, (Iterable)absentKeys, context.original().keySet(), context.original().keySet());
        Map result = (Map)cache.getAll(keys).join();
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasMissCount(absentKeys.size()));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasHitCount(context.initialSize()));
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Iterable)keys))));
        int loads = context.loader().isBulk() ? 1 : absentKeys.size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(loads)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_ordered_absent(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(((Map)cache.getAll(keys).join()).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_ordered_partial(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(((Map)cache.getAll(keys).join()).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.EXCEPTIONAL, CacheSpec.Loader.BULK_NEGATIVE_EXCEEDS}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_ordered_present(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(((Map)cache.getAll(keys).join()).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.BULK_NEGATIVE_EXCEEDS}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_ordered_exceeds(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(((Map)cache.getAll(keys).join()).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, compute={CacheSpec.Compute.ASYNC}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_badLoader(CacheContext context) {
        AsyncCacheLoader<Integer, Integer> loader = new AsyncCacheLoader<Integer, Integer>(){

            public CompletableFuture<Integer> asyncLoad(Integer key, Executor executor) {
                throw new IllegalStateException();
            }

            public CompletableFuture<Map<Integer, Integer>> asyncLoadAll(Iterable<? extends Integer> keys, Executor executor) {
                throw new LoadAllException();
            }
        };
        AsyncLoadingCache<Integer, Integer> cache = context.buildAsync(loader);
        try {
            cache.getAll(context.absentKeys()).join();
            Assert.fail();
        }
        catch (LoadAllException e) {
            MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void put_replace(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> value = CompletableFuture.completedFuture(context.absentValue());
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.put((Object)key, value);
            MatcherAssert.assertThat((Object)cache.get((Object)key), (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentValue())));
        }
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, executor={CacheSpec.CacheExecutor.THREADED}, compute={CacheSpec.Compute.ASYNC}, values={CacheSpec.ReferenceType.STRONG})
    public void refresh(CacheContext context) {
        AtomicBoolean done = new AtomicBoolean();
        AsyncLoadingCache cache = context.buildAsync(key -> {
            Awaits.await().untilTrue(done);
            return -key.intValue();
        });
        Integer key2 = 1;
        cache.synchronous().put((Object)key2, (Object)key2);
        CompletableFuture original = cache.get((Object)key2);
        for (int i = 0; i < 10; ++i) {
            context.ticker().advance(1L, TimeUnit.SECONDS);
            cache.synchronous().refresh((Object)key2);
            CompletableFuture next = cache.get((Object)key2);
            MatcherAssert.assertThat((Object)next, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)original)));
        }
        done.set(true);
        Awaits.await().until(() -> (Integer)cache.synchronous().getIfPresent((Object)key2), Matchers.is((Object)(-key2.intValue())));
    }

    @Test(dataProvider="caches", timeOut=5000L)
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, executor={CacheSpec.CacheExecutor.THREADED}, compute={CacheSpec.Compute.ASYNC}, values={CacheSpec.ReferenceType.STRONG})
    public void refresh_deadlock(CacheContext context) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        AsyncLoadingCache cache = context.buildAsync((k, e) -> future);
        cache.synchronous().refresh((Object)context.absentKey());
        CompletableFuture get = cache.get((Object)context.absentKey());
        future.complete(context.absentValue());
        MatcherAssert.assertThat((Object)get, IsFutureValue.futureOf(context.absentValue()));
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void asyncLoadAll() {
        AsyncCacheLoader loader = (key, executor) -> CompletableFuture.completedFuture(-key.intValue());
        loader.asyncLoadAll(Collections.emptyList(), Runnable::run).join();
    }

    @Test
    public void asyncReload() {
        AsyncCacheLoader loader = (key, executor) -> CompletableFuture.completedFuture(-key.intValue());
        CompletableFuture future = loader.asyncReload((Object)1, (Object)2, Runnable::run);
        MatcherAssert.assertThat(future.join(), (Matcher)Matchers.is((Object)-1));
    }

    private static final class LoadAllException
    extends RuntimeException {
        private LoadAllException() {
        }
    }
}

