/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import java.lang.reflect.Constructor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class AsyncTest {
    private static final long ONE_MINUTE = TimeUnit.MINUTES.toNanos(1L);

    @Test
    public void reflectivelyConstruct() throws Exception {
        Constructor constructor = Async.class.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
    }

    @Test(dataProvider="successful")
    public void isReady_success(CompletableFuture<?> future) {
        MatcherAssert.assertThat((Object)Async.isReady(future), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="unsuccessful")
    public void isReady_fails(CompletableFuture<?> future) {
        MatcherAssert.assertThat((Object)Async.isReady(future), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="successful")
    public void getIfReady_success(CompletableFuture<?> future) {
        MatcherAssert.assertThat((Object)Async.getIfReady(future), (Matcher)Matchers.is((Object)1));
    }

    @Test(dataProvider="unsuccessful")
    public void getIfReady_fails(CompletableFuture<?> future) {
        MatcherAssert.assertThat((Object)Async.getIfReady(future), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="successful")
    public void getWhenSuccessful_success(CompletableFuture<?> future) {
        MatcherAssert.assertThat((Object)Async.getWhenSuccessful(future), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void getWhenSuccessful_success_async() {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        AtomicInteger result = new AtomicInteger();
        ConcurrentTestHarness.execute(() -> {
            result.set(1);
            result.set((Integer)Async.getWhenSuccessful((CompletableFuture)future));
        });
        Awaits.await().untilAtomic(result, Matchers.is((Object)1));
        future.obtrudeValue(2);
        Awaits.await().untilAtomic(result, Matchers.is((Object)2));
    }

    @Test(dataProvider="unsuccessful")
    public void getWhenSuccessful_fails(CompletableFuture<?> future) {
        if (future != null && !future.isDone()) {
            AtomicInteger result = new AtomicInteger();
            ConcurrentTestHarness.execute(() -> {
                result.set(1);
                Object value = Async.getWhenSuccessful((CompletableFuture)future);
                result.set(value == null ? 2 : 3);
            });
            Awaits.await().untilAtomic(result, Matchers.is((Object)1));
            future.obtrudeException(new IllegalStateException());
            Awaits.await().untilAtomic(result, Matchers.is((Matcher)Matchers.not((Object)1)));
            MatcherAssert.assertThat((Object)result.get(), (Matcher)Matchers.is((Object)2));
        }
        MatcherAssert.assertThat((Object)Async.getWhenSuccessful(future), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void asyncExpiry_pending() {
        Async.AsyncExpiry expiry = AsyncTest.makeAsyncExpiry(ONE_MINUTE, ONE_MINUTE, ONE_MINUTE);
        CompletableFuture future = new CompletableFuture();
        MatcherAssert.assertThat((Object)expiry.expireAfterCreate((Object)0, future, 1L), (Matcher)Matchers.is((Object)0x5FFFFFFFFFFFFFFEL));
        ((Expiry)Mockito.verify((Object)expiry.delegate, (VerificationMode)Mockito.never())).expireAfterCreate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong());
        MatcherAssert.assertThat((Object)expiry.expireAfterUpdate((Object)0, future, 1L, 2L), (Matcher)Matchers.is((Object)0x5FFFFFFFFFFFFFFEL));
        ((Expiry)Mockito.verify((Object)expiry.delegate, (VerificationMode)Mockito.never())).expireAfterUpdate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        MatcherAssert.assertThat((Object)expiry.expireAfterRead((Object)0, future, 1L, 2L), (Matcher)Matchers.is((Object)0x5FFFFFFFFFFFFFFEL));
        ((Expiry)Mockito.verify((Object)expiry.delegate, (VerificationMode)Mockito.never())).expireAfterRead((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    @Test
    public void asyncExpiry_completed() {
        Async.AsyncExpiry expiry = AsyncTest.makeAsyncExpiry(ONE_MINUTE, 2L * ONE_MINUTE, 3L * ONE_MINUTE);
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(100);
        MatcherAssert.assertThat((Object)expiry.expireAfterCreate((Object)0, future, 1L), (Matcher)Matchers.is((Object)ONE_MINUTE));
        ((Expiry)Mockito.verify((Object)expiry.delegate)).expireAfterCreate((Object)0, (Object)100, 1L);
        MatcherAssert.assertThat((Object)expiry.expireAfterUpdate((Object)0, future, 1L, 2L), (Matcher)Matchers.is((Object)(2L * ONE_MINUTE)));
        ((Expiry)Mockito.verify((Object)expiry.delegate)).expireAfterUpdate((Object)0, (Object)100, 1L, 2L);
        MatcherAssert.assertThat((Object)expiry.expireAfterRead((Object)0, future, 1L, 2L), (Matcher)Matchers.is((Object)(3L * ONE_MINUTE)));
        ((Expiry)Mockito.verify((Object)expiry.delegate)).expireAfterRead((Object)0, (Object)100, 1L, 2L);
    }

    @Test
    public void asyncExpiry_bounded() {
        Async.AsyncExpiry expiry = AsyncTest.makeAsyncExpiry(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(100);
        MatcherAssert.assertThat((Object)expiry.expireAfterCreate((Object)0, future, 1L), (Matcher)Matchers.is((Object)0x3FFFFFFFFFFFFFFFL));
        MatcherAssert.assertThat((Object)expiry.expireAfterUpdate((Object)0, future, 1L, 2L), (Matcher)Matchers.is((Object)0x3FFFFFFFFFFFFFFFL));
        MatcherAssert.assertThat((Object)expiry.expireAfterRead((Object)0, future, 1L, 2L), (Matcher)Matchers.is((Object)0x3FFFFFFFFFFFFFFFL));
    }

    @DataProvider(name="successful")
    public Object[][] providesSuccessful() {
        return new Object[][]{{CompletableFuture.completedFuture(1)}};
    }

    @DataProvider(name="unsuccessful")
    public Object[][] providesUnsuccessful() {
        return new Object[][]{{null}, {new CompletableFuture()}, {CompletableFuture.completedFuture(null)}, {AsyncTest.newFailedFuture(new InterruptedException())}, {AsyncTest.newFailedFuture(new IllegalStateException())}};
    }

    private static <K, V> Async.AsyncExpiry<K, V> makeAsyncExpiry(long create, long update, long read) {
        Expiry mock = (Expiry)Mockito.mock(Expiry.class);
        Mockito.when((Object)mock.expireAfterCreate(ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)create);
        Mockito.when((Object)mock.expireAfterUpdate(ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)update);
        Mockito.when((Object)mock.expireAfterRead(ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)read);
        return new Async.AsyncExpiry(mock);
    }

    private static CompletableFuture<Integer> newFailedFuture(Exception e) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        future.completeExceptionally(e);
        return future;
    }
}

