/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedBuffer;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class BoundedBufferTest {
    static final String DUMMY = "test";

    @DataProvider
    public Object[][] buffer() {
        return new Object[][]{{new BoundedBuffer()}};
    }

    @Test(dataProvider="buffer")
    public void offer(BoundedBuffer<String> buffer) {
        ConcurrentTestHarness.timeTasks(10, () -> {
            for (int i = 0; i < 100; ++i) {
                buffer.offer((Object)DUMMY);
            }
        });
        MatcherAssert.assertThat((Object)buffer.writes(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)buffer.writes(), (Matcher)Matchers.is((Object)buffer.size()));
    }

    @Test(dataProvider="buffer")
    public void drain(BoundedBuffer<String> buffer) {
        for (int i = 0; i < 16; ++i) {
            buffer.offer((Object)DUMMY);
        }
        int[] read = new int[1];
        buffer.drainTo(e -> {
            read[0] = read[0] + 1;
        });
        MatcherAssert.assertThat((Object)read[0], (Matcher)Matchers.is((Object)buffer.reads()));
        MatcherAssert.assertThat((Object)read[0], (Matcher)Matchers.is((Object)buffer.writes()));
    }

    @Test(dataProvider="buffer")
    public void offerAndDrain(BoundedBuffer<String> buffer) {
        ReentrantLock lock = new ReentrantLock();
        AtomicInteger reads = new AtomicInteger();
        ConcurrentTestHarness.timeTasks(10, () -> {
            for (int i = 0; i < 1000; ++i) {
                boolean shouldDrain;
                boolean bl = shouldDrain = buffer.offer((Object)DUMMY) == 1;
                if (shouldDrain && lock.tryLock()) {
                    buffer.drainTo(e -> reads.incrementAndGet());
                    lock.unlock();
                }
                Thread.yield();
            }
        });
        buffer.drainTo(e -> reads.incrementAndGet());
        MatcherAssert.assertThat((Object)reads.intValue(), (Matcher)Matchers.is((Object)buffer.reads()));
        MatcherAssert.assertThat((Object)reads.intValue(), (Matcher)Matchers.is((Object)buffer.writes()));
    }
}

