/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.References;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.testing.GcFinalization;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class BoundedLocalCacheTest {
    static BoundedLocalCache<Integer, Integer> asBoundedLocalCache(Cache<Integer, Integer> cache) {
        return (BoundedLocalCache)cache.asMap();
    }

    @Test
    public void cleanupTask_allowGc() {
        BoundedLocalCache<Object, Object> cache = new BoundedLocalCache<Object, Object>(Caffeine.newBuilder(), null, false){};
        BoundedLocalCache.PerformCleanupTask task = cache.drainBuffersTask;
        cache = null;
        GcFinalization.awaitClear((WeakReference)task.reference);
        task.run();
    }

    @Test
    public void scheduleAfterWrite() {
        BoundedLocalCache<Object, Object> cache = new BoundedLocalCache<Object, Object>(Caffeine.newBuilder(), null, false){

            void scheduleDrainBuffers() {
            }
        };
        ImmutableMap transitions = ImmutableMap.of((Object)0, (Object)1, (Object)1, (Object)1, (Object)2, (Object)3, (Object)3, (Object)3);
        transitions.forEach((arg_0, arg_1) -> BoundedLocalCacheTest.lambda$scheduleAfterWrite$0((BoundedLocalCache)cache, arg_0, arg_1));
    }

    @Test
    public void scheduleDrainBuffers() {
        Executor executor = (Executor)Mockito.mock(Executor.class);
        BoundedLocalCache<Object, Object> cache = new BoundedLocalCache<Object, Object>(Caffeine.newBuilder().executor(executor), null, false){};
        ImmutableMap transitions = ImmutableMap.of((Object)0, (Object)2, (Object)1, (Object)2, (Object)2, (Object)2, (Object)3, (Object)3);
        transitions.forEach((arg_0, arg_1) -> BoundedLocalCacheTest.lambda$scheduleDrainBuffers$1((BoundedLocalCache)cache, executor, arg_0, arg_1));
    }

    @Test
    public void rescheduleDrainBuffers() {
        final AtomicBoolean evicting = new AtomicBoolean();
        final AtomicBoolean done = new AtomicBoolean();
        CacheWriter<Integer, Integer> writer = new CacheWriter<Integer, Integer>(){

            public void write(Integer key, Integer value) {
            }

            public void delete(Integer key, Integer value, RemovalCause cause) {
                evicting.set(true);
                Awaits.await().untilTrue(done);
            }
        };
        BoundedLocalCache<Integer, Integer> map = BoundedLocalCacheTest.asBoundedLocalCache((Cache<Integer, Integer>)Caffeine.newBuilder().writer((CacheWriter)writer).maximumSize(0L).build());
        map.put((Object)1, (Object)1);
        Awaits.await().untilTrue(evicting);
        map.put((Object)2, (Object)2);
        MatcherAssert.assertThat((Object)map.drainStatus, (Matcher)Matchers.is((Object)3));
        done.set(true);
        Awaits.await().until(() -> map.drainStatus, Matchers.is((Object)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL}, executorFailure=CacheSpec.ExecutorFailure.EXPECTED, executor={CacheSpec.CacheExecutor.REJECTING}, removalListener={CacheSpec.Listener.CONSUMING})
    public void scheduleDrainBuffers_rejected(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
    }

    @Test
    public void putWeighted_noOverflow() {
        Cache cache = Caffeine.newBuilder().executor(CacheSpec.CacheExecutor.DIRECT.create()).weigher((Weigher)CacheSpec.CacheWeigher.MAX_VALUE).maximumWeight(Long.MAX_VALUE).build();
        BoundedLocalCache<Integer, Integer> map = BoundedLocalCacheTest.asBoundedLocalCache((Cache<Integer, Integer>)cache);
        cache.put((Object)1, (Object)1);
        map.setWindowMaximum(0L);
        map.setWeightedSize(9223372034707292160L);
        cache.put((Object)2, (Object)2);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)Math.max(0L, map.weightedSize()), (Matcher)Matchers.is((Object)9223372034707292160L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.ONE})
    public void evict_alreadyRemoved(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Map.Entry oldEntry = (Map.Entry)Iterables.get(context.absent().entrySet(), (int)0);
        Map.Entry newEntry = (Map.Entry)Iterables.get(context.absent().entrySet(), (int)1);
        localCache.put((Object)((Integer)oldEntry.getKey()), (Object)((Integer)oldEntry.getValue()));
        localCache.evictionLock.lock();
        try {
            Object lookupKey = localCache.nodeFactory.newLookupKey(oldEntry.getKey());
            Node node = (Node)localCache.data.get(lookupKey);
            BoundedLocalCacheTest.checkStatus((Node<Integer, Integer>)node, Status.ALIVE);
            ConcurrentTestHarness.execute(() -> {
                localCache.put((Object)((Integer)newEntry.getKey()), (Object)((Integer)newEntry.getValue()));
                MatcherAssert.assertThat((Object)((Integer)localCache.remove(oldEntry.getKey())), (Matcher)Matchers.is((Object)((Integer)oldEntry.getValue())));
            });
            Awaits.await().until(() -> localCache.containsKey(oldEntry.getKey()), Matchers.is((Object)false));
            Awaits.await().until(() -> {
                Node node2 = node;
                synchronized (node2) {
                    return !node.isAlive();
                }
            });
            BoundedLocalCacheTest.checkStatus((Node<Integer, Integer>)node, Status.RETIRED);
            localCache.cleanUp();
            BoundedLocalCacheTest.checkStatus((Node<Integer, Integer>)node, Status.DEAD);
            MatcherAssert.assertThat((Object)localCache.containsKey(newEntry.getKey()), (Matcher)Matchers.is((Object)true));
            Awaits.await().until(() -> cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.EXPLICIT));
        }
        finally {
            localCache.evictionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkStatus(Node<Integer, Integer> node, Status expected) {
        Node<Integer, Integer> node2 = node;
        synchronized (node2) {
            MatcherAssert.assertThat((Object)node.isAlive(), (Matcher)Matchers.is((Object)(expected == Status.ALIVE ? 1 : 0)));
            MatcherAssert.assertThat((Object)node.isRetired(), (Matcher)Matchers.is((Object)(expected == Status.RETIRED ? 1 : 0)));
            MatcherAssert.assertThat((Object)node.isDead(), (Matcher)Matchers.is((Object)(expected == Status.DEAD ? 1 : 0)));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.TEN}, weigher={CacheSpec.CacheWeigher.DEFAULT})
    public void evict_wtinylfu(Cache<Integer, Integer> cache, CacheContext context) throws Exception {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        localCache.frequencySketch().ensureCapacity(10L);
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)(-i));
        }
        this.checkContainsInOrder(cache, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8);
        this.checkReorder(cache, Arrays.asList(0, 1, 2), 9, 3, 4, 5, 6, 7, 8, 0, 1, 2);
        this.checkEvict(cache, Arrays.asList(10, 11, 12), 12, 3, 4, 5, 6, 7, 8, 0, 1, 2);
        this.checkReorder(cache, Arrays.asList(6, 7, 8), 12, 3, 4, 5, 0, 1, 2, 6, 7, 8);
        this.checkEvict(cache, Arrays.asList(13, 14, 15), 15, 3, 4, 5, 0, 1, 2, 6, 7, 8);
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasEvictionCount(6L));
    }

    private void checkReorder(Cache<Integer, Integer> cache, List<Integer> keys, Integer ... expect) {
        keys.forEach(arg_0 -> cache.getIfPresent(arg_0));
        this.checkContainsInOrder(cache, expect);
    }

    private void checkEvict(Cache<Integer, Integer> cache, List<Integer> keys, Integer ... expect) {
        keys.forEach(i -> cache.put(i, i));
        this.checkContainsInOrder(cache, expect);
    }

    private void checkContainsInOrder(Cache<Integer, Integer> cache, Integer ... expect) {
        cache.cleanUp();
        ImmutableList evictionList = ImmutableList.copyOf(((Policy.Eviction)cache.policy().eviction().get()).coldest(Integer.MAX_VALUE).keySet());
        MatcherAssert.assertThat((Object)cache.asMap().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expect.length)));
        MatcherAssert.assertThat(cache.asMap().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])expect));
        MatcherAssert.assertThat((Object)evictionList, (Matcher)Matchers.is((Matcher)Matchers.equalTo(Arrays.asList(expect))));
    }

    @Test(groups={"slow"})
    public void evict_update() {
        Integer key = 0;
        Integer oldValue = 1;
        Integer newValue = 2;
        final Thread evictor = Thread.currentThread();
        final AtomicBoolean started = new AtomicBoolean();
        final AtomicBoolean writing = new AtomicBoolean();
        final AtomicInteger evictedValue = new AtomicInteger();
        AtomicInteger removedValues = new AtomicInteger();
        AtomicInteger previousValue = new AtomicInteger();
        CacheWriter<Integer, Integer> writer = new CacheWriter<Integer, Integer>(){

            public void write(Integer key, Integer value) {
                if (started.get()) {
                    writing.set(true);
                    Awaits.await().until(evictor::getState, Matchers.is((Object)((Object)Thread.State.BLOCKED)));
                }
            }

            public void delete(Integer key, Integer value, RemovalCause cause) {
                evictedValue.set(value);
            }
        };
        RemovalListener listener = (k, v, cause) -> removedValues.addAndGet((int)v);
        Cache cache = Caffeine.newBuilder().removalListener(listener).executor(Runnable::run).maximumSize(100L).writer((CacheWriter)writer).build();
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache((Cache<Integer, Integer>)cache);
        cache.put((Object)key, (Object)oldValue);
        started.set(true);
        ConcurrentTestHarness.execute(() -> previousValue.set((Integer)localCache.put((Object)key, (Object)newValue)));
        Awaits.await().untilTrue(writing);
        Node node = (Node)localCache.data.values().iterator().next();
        localCache.evictEntry(node, RemovalCause.SIZE, 0L);
        Awaits.await().untilAtomic(evictedValue, Matchers.is((Object)newValue));
        Awaits.await().untilAtomic(previousValue, Matchers.is((Object)oldValue));
        Awaits.await().untilAtomic(removedValues, Matchers.is((Object)(oldValue + newValue)));
    }

    @Test(groups={"slow"})
    public void clear_update() {
        Integer key = 0;
        Integer oldValue = 1;
        Integer newValue = 2;
        final Thread invalidator = Thread.currentThread();
        final AtomicBoolean started = new AtomicBoolean();
        final AtomicBoolean writing = new AtomicBoolean();
        final AtomicInteger clearedValue = new AtomicInteger();
        AtomicInteger removedValues = new AtomicInteger();
        AtomicInteger previousValue = new AtomicInteger();
        CacheWriter<Integer, Integer> writer = new CacheWriter<Integer, Integer>(){

            public void write(Integer key, Integer value) {
                if (started.get()) {
                    writing.set(true);
                    Awaits.await().until(invalidator::getState, Matchers.is((Object)((Object)Thread.State.BLOCKED)));
                }
            }

            public void delete(Integer key, Integer value, RemovalCause cause) {
                clearedValue.set(value);
            }
        };
        RemovalListener listener = (k, v, cause) -> removedValues.addAndGet((int)v);
        Cache cache = Caffeine.newBuilder().removalListener(listener).executor(Runnable::run).maximumSize(100L).writer((CacheWriter)writer).build();
        cache.put((Object)key, (Object)oldValue);
        started.set(true);
        ConcurrentTestHarness.execute(() -> previousValue.set(cache.asMap().put(key, newValue)));
        Awaits.await().untilTrue(writing);
        cache.asMap().clear();
        Awaits.await().untilAtomic(clearedValue, Matchers.is((Object)newValue));
        Awaits.await().untilAtomic(previousValue, Matchers.is((Object)oldValue));
        Awaits.await().untilAtomic(removedValues, Matchers.is((Object)(oldValue + newValue)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL})
    public void updateRecency_onGet(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Node<Integer, Integer> first = BoundedLocalCacheTest.firstBeforeAccess(localCache, context);
        BoundedLocalCacheTest.updateRecency(localCache, context, () -> {
            Integer cfr_ignored_0 = (Integer)localCache.get(first.getKey());
        });
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL})
    public void updateRecency_onPutIfAbsent(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Node<Integer, Integer> first = BoundedLocalCacheTest.firstBeforeAccess(localCache, context);
        BoundedLocalCacheTest.updateRecency(localCache, context, () -> {
            Integer cfr_ignored_0 = (Integer)localCache.putIfAbsent((Object)((Integer)first.getKey()), (Object)((Integer)first.getKey()));
        });
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL})
    public void updateRecency_onPut(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Node<Integer, Integer> first = BoundedLocalCacheTest.firstBeforeAccess(localCache, context);
        BoundedLocalCacheTest.updateRecency(localCache, context, () -> {
            Integer cfr_ignored_0 = (Integer)localCache.put((Object)((Integer)first.getKey()), (Object)((Integer)first.getKey()));
        });
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL})
    public void updateRecency_onReplace(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Node<Integer, Integer> first = BoundedLocalCacheTest.firstBeforeAccess(localCache, context);
        BoundedLocalCacheTest.updateRecency(localCache, context, () -> {
            Integer cfr_ignored_0 = (Integer)localCache.replace((Object)((Integer)first.getKey()), (Object)((Integer)first.getKey()));
        });
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL})
    public void updateRecency_onReplaceConditionally(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Node<Integer, Integer> first = BoundedLocalCacheTest.firstBeforeAccess(localCache, context);
        Integer value = (Integer)first.getValue();
        BoundedLocalCacheTest.updateRecency(localCache, context, () -> localCache.replace((Object)((Integer)first.getKey()), (Object)value, (Object)value));
    }

    private static Node<Integer, Integer> firstBeforeAccess(BoundedLocalCache<Integer, Integer> localCache, CacheContext context) {
        return context.isZeroWeighted() ? (Node)localCache.accessOrderWindowDeque().peek() : (Node)localCache.accessOrderProbationDeque().peek();
    }

    private static void updateRecency(BoundedLocalCache<Integer, Integer> cache, CacheContext context, Runnable operation) {
        Node<Integer, Integer> first = BoundedLocalCacheTest.firstBeforeAccess(cache, context);
        operation.run();
        cache.maintenance(null);
        if (context.isZeroWeighted()) {
            MatcherAssert.assertThat((Object)((Node)cache.accessOrderWindowDeque().peekFirst()), (Matcher)Matchers.is((Matcher)Matchers.not(first)));
            MatcherAssert.assertThat((Object)((Node)cache.accessOrderWindowDeque().peekLast()), (Matcher)Matchers.is(first));
        } else {
            MatcherAssert.assertThat((Object)((Node)cache.accessOrderProbationDeque().peekFirst()), (Matcher)Matchers.is((Matcher)Matchers.not(first)));
            MatcherAssert.assertThat((Object)((Node)cache.accessOrderProtectedDeque().peekLast()), (Matcher)Matchers.is(first));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL})
    public void exceedsMaximumBufferSize_onRead(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Node dummy = localCache.nodeFactory.newNode((Object)new References.WeakKeyReference(null, null), null, null, 1, 0L);
        localCache.frequencySketch().ensureCapacity(1L);
        Buffer buffer = localCache.readBuffer;
        for (int i = 0; i < 16; ++i) {
            buffer.offer((Object)dummy);
        }
        MatcherAssert.assertThat((Object)buffer.offer((Object)dummy), (Matcher)Matchers.is((Object)1));
        localCache.afterRead(dummy, 0L, true);
        MatcherAssert.assertThat((Object)buffer.offer((Object)dummy), (Matcher)Matchers.is((Matcher)Matchers.not((Object)1)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL})
    public void exceedsMaximumBufferSize_onWrite(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        boolean[] ran = new boolean[1];
        localCache.afterWrite(() -> {
            ran[0] = true;
        });
        MatcherAssert.assertThat((Object)ran[0], (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)localCache.writeBuffer().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, expiry={CacheSpec.CacheExpiry.DISABLED}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void fastpath(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        MatcherAssert.assertThat((Object)localCache.skipReadBuffer(), (Matcher)Matchers.is((Object)true));
        int i = 0;
        while ((long)i < context.maximumSize() / 2L) {
            cache.put((Object)i, (Object)(-i));
            ++i;
        }
        MatcherAssert.assertThat((Object)localCache.skipReadBuffer(), (Matcher)Matchers.is((Object)true));
        cache.put((Object)-1, (Object)-1);
        MatcherAssert.assertThat((Object)localCache.skipReadBuffer(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)0)), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)localCache.readBuffer.writes(), (Matcher)Matchers.is((Object)1));
        cache.cleanUp();
        MatcherAssert.assertThat((Object)localCache.readBuffer.reads(), (Matcher)Matchers.is((Object)1));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL})
    public void afterWrite_drainFullWriteBuffer(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        localCache.drainStatus = 2;
        int[] processed = new int[]{0};
        Runnable pendingTask = () -> {
            processed[0] = processed[0] + 1;
        };
        int[] expectedCount = new int[]{0};
        while (localCache.writeBuffer().offer((Object)pendingTask)) {
            expectedCount[0] = expectedCount[0] + 1;
        }
        int[] triggered = new int[]{0};
        Runnable triggerTask = () -> {
            triggered[0] = 1 + expectedCount[0];
        };
        localCache.afterWrite(triggerTask);
        MatcherAssert.assertThat((Object)processed[0], (Matcher)Matchers.is((Object)expectedCount[0]));
        MatcherAssert.assertThat((Object)triggered[0], (Matcher)Matchers.is((Object)(expectedCount[0] + 1)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL})
    public void drain_onRead(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        Buffer buffer = localCache.readBuffer;
        for (int i = 0; i < 16; ++i) {
            localCache.get((Object)context.firstKey());
        }
        int pending = buffer.size();
        MatcherAssert.assertThat((Object)buffer.writes(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)pending)));
        MatcherAssert.assertThat((Object)pending, (Matcher)Matchers.is((Object)16));
        localCache.get((Object)context.firstKey());
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL})
    public void drain_onWrite(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        cache.put((Object)1, (Object)1);
        int size = localCache.accessOrderWindowDeque().size() + localCache.accessOrderProbationDeque().size();
        MatcherAssert.assertThat((Object)localCache.writeBuffer().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)size, (Matcher)Matchers.is((Object)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL})
    public void drain_nonblocking(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        AtomicBoolean done = new AtomicBoolean();
        Runnable task = () -> {
            localCache.lazySetDrainStatus(1);
            localCache.scheduleDrainBuffers();
            done.set(true);
        };
        localCache.evictionLock.lock();
        try {
            ConcurrentTestHarness.execute(task);
            Awaits.await().untilTrue(done);
        }
        finally {
            localCache.evictionLock.unlock();
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL})
    public void drain_blocksClear(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        this.checkDrainBlocks(localCache, () -> localCache.clear());
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL})
    public void drain_blocksOrderedMap(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        this.checkDrainBlocks(localCache, () -> eviction.coldest((int)context.maximumSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL})
    public void drain_blocksCapacity(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        this.checkDrainBlocks(localCache, () -> cache.policy().eviction().ifPresent(policy -> policy.setMaximum(0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkDrainBlocks(BoundedLocalCache<Integer, Integer> localCache, Runnable task) {
        AtomicBoolean done = new AtomicBoolean();
        ReentrantLock lock = localCache.evictionLock;
        lock.lock();
        try {
            ConcurrentTestHarness.execute(() -> {
                localCache.lazySetDrainStatus(1);
                task.run();
                done.set(true);
            });
            Awaits.await().until(lock::hasQueuedThreads);
        }
        finally {
            lock.unlock();
        }
        Awaits.await().untilTrue(done);
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.TEN})
    public void adapt_increaseWindow(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = this.prepareForAdaption(cache, context, false);
        int sampleSize = localCache.frequencySketch().sampleSize;
        long protectedSize = localCache.mainProtectedWeightedSize();
        long protectedMaximum = localCache.mainProtectedMaximum();
        long windowSize = localCache.windowWeightedSize();
        long windowMaximum = localCache.windowMaximum();
        this.adapt(cache, localCache, sampleSize);
        MatcherAssert.assertThat((Object)localCache.mainProtectedMaximum(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.lessThan((Comparable)Long.valueOf(protectedMaximum))).or(Matchers.is((Object)0L))));
        MatcherAssert.assertThat((Object)localCache.mainProtectedWeightedSize(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.lessThan((Comparable)Long.valueOf(protectedSize))).or(Matchers.is((Object)0L))));
        MatcherAssert.assertThat((Object)localCache.windowMaximum(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(windowMaximum))));
        MatcherAssert.assertThat((Object)localCache.windowWeightedSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(windowSize))));
    }

    @Test(dataProvider="caches")
    @CacheSpec(compute={CacheSpec.Compute.SYNC}, implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.TEN})
    public void adapt_decreaseWindow(Cache<Integer, Integer> cache, CacheContext context) {
        BoundedLocalCache<Integer, Integer> localCache = this.prepareForAdaption(cache, context, true);
        int sampleSize = localCache.frequencySketch().sampleSize;
        long protectedSize = localCache.mainProtectedWeightedSize();
        long protectedMaximum = localCache.mainProtectedMaximum();
        long windowSize = localCache.windowWeightedSize();
        long windowMaximum = localCache.windowMaximum();
        this.adapt(cache, localCache, sampleSize);
        MatcherAssert.assertThat((Object)localCache.mainProtectedMaximum(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(protectedMaximum))));
        MatcherAssert.assertThat((Object)localCache.mainProtectedWeightedSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(protectedSize))));
        MatcherAssert.assertThat((Object)localCache.windowMaximum(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.lessThan((Comparable)Long.valueOf(windowMaximum))).or(Matchers.is((Object)0L))));
        MatcherAssert.assertThat((Object)localCache.windowWeightedSize(), (Matcher)Matchers.is((Matcher)Matchers.either((Matcher)Matchers.lessThan((Comparable)Long.valueOf(windowSize))).or(Matchers.is((Object)0L))));
    }

    private BoundedLocalCache<Integer, Integer> prepareForAdaption(Cache<Integer, Integer> cache, CacheContext context, boolean recencyBias) {
        BoundedLocalCache<Integer, Integer> localCache = BoundedLocalCacheTest.asBoundedLocalCache(cache);
        localCache.setStepSize((double)(recencyBias ? 1 : -1) * Math.abs(localCache.stepSize()));
        localCache.setWindowMaximum((long)(0.5 * (double)context.maximumWeightOrSize()));
        localCache.setMainProtectedMaximum((long)(0.8 * (double)(context.maximumWeightOrSize() - localCache.windowMaximum())));
        cache.invalidateAll();
        cache.asMap().putAll(context.original());
        cache.asMap().keySet().stream().forEach(arg_0 -> cache.getIfPresent(arg_0));
        cache.asMap().keySet().stream().forEach(arg_0 -> cache.getIfPresent(arg_0));
        return localCache;
    }

    private void adapt(Cache<Integer, Integer> cache, BoundedLocalCache<Integer, Integer> localCache, int sampleSize) {
        localCache.setPreviousSampleHitRate(0.8);
        localCache.setMissesInSample(sampleSize / 2);
        localCache.setHitsInSample(sampleSize - localCache.missesInSample());
        localCache.climb();
        cache.asMap().keySet().stream().forEach(arg_0 -> cache.getIfPresent(arg_0));
    }

    private static /* synthetic */ void lambda$scheduleDrainBuffers$1(BoundedLocalCache cache, Executor executor, Integer start, Integer end) {
        cache.drainStatus = start;
        cache.scheduleDrainBuffers();
        MatcherAssert.assertThat((Object)cache.drainStatus, (Matcher)Matchers.is((Object)end));
        if (!start.equals(end)) {
            ((Executor)Mockito.verify((Object)executor)).execute((Runnable)ArgumentMatchers.any());
            Mockito.reset((Object[])new Executor[]{executor});
        }
    }

    private static /* synthetic */ void lambda$scheduleAfterWrite$0(BoundedLocalCache cache, Integer start, Integer end) {
        cache.drainStatus = start;
        cache.scheduleAfterWrite();
        MatcherAssert.assertThat((Object)cache.drainStatus, (Matcher)Matchers.is((Object)end));
    }

    static enum Status {
        ALIVE,
        RETIRED,
        DEAD;

    }
}

