/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.IsCacheReserializable;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.cache.testing.RejectingCacheWriter;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class CacheTest {
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void estimatedSize(Cache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getIfPresent_nullKey(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getIfPresent(null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getIfPresent_absent(Cache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getIfPresent_present(Cache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.middleKey())), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.lastKey())), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(3L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void get_nullKey(Cache<Integer, Integer> cache, CacheContext context) {
        cache.get(null, Function.identity());
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void get_nullLoader(Cache<Integer, Integer> cache, CacheContext context) {
        cache.get((Object)context.absentKey(), null);
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void get_nullKeyAndLoader(Cache<Integer, Integer> cache, CacheContext context) {
        cache.get(null, null);
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void get_throwsException(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.get((Object)context.absentKey(), key -> {
                throw new IllegalStateException();
            });
        }
        finally {
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        }
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void get_absent_null(Cache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.absentKey(), k -> null)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void get_absent(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        Integer value = (Integer)cache.get((Object)key, k -> context.absentValue());
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void get_present(Cache<Integer, Integer> cache, CacheContext context) {
        Function<Integer, Integer> loader = key -> {
            throw new RuntimeException();
        };
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.firstKey(), loader)), (Matcher)Matchers.is((Object)context.original().get(context.firstKey())));
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.middleKey(), loader)), (Matcher)Matchers.is((Object)context.original().get(context.middleKey())));
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.lastKey(), loader)), (Matcher)Matchers.is((Object)context.original().get(context.lastKey())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(3L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAllPresent_iterable_null(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getAllPresent(null);
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAllPresent_iterable_nullKey(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getAllPresent(Collections.singletonList(null));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_iterable_empty(Cache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAllPresent((Iterable)ImmutableList.of());
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)0));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_absent(Cache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAllPresent(context.absentKeys());
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)0));
        int count = context.absentKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(count)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void getAllPresent_immutable(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getAllPresent(context.absentKeys()).clear();
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_present_partial(Cache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> expect = new HashMap<Integer, Integer>();
        expect.put(context.firstKey(), context.original().get(context.firstKey()));
        expect.put(context.middleKey(), context.original().get(context.middleKey()));
        expect.put(context.lastKey(), context.original().get(context.lastKey()));
        Map result = cache.getAllPresent(expect.keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expect)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(expect.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_present_full(Cache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAllPresent(context.original().keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(result.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_duplicates(Cache<Integer, Integer> cache, CacheContext context) {
        Iterable keys = Iterables.concat(context.absentKeys(), context.absentKeys(), context.original().keySet(), context.original().keySet());
        Map result = cache.getAllPresent(keys);
        int misses = context.absentKeys().size();
        int hits = context.original().keySet().size();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(hits)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAllPresent_ordered(Cache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAllPresent(keys).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, writer={CacheSpec.Writer.DISABLED})
    public void getAllPresent_jdk8186171(Cache<Object, Integer> cache, CacheContext context) {
        class Key {
            Key() {
            }

            public int hashCode() {
                return 0;
            }
        }
        ArrayList<Key> keys = new ArrayList<Key>();
        int i = 0;
        while ((long)i < CacheSpec.Population.FULL.size()) {
            keys.add(new Key());
            ++i;
        }
        Key key = (Key)Iterables.getLast(keys);
        Integer value = context.absentValue();
        cache.put((Object)key, (Object)value);
        Map result = cache.getAllPresent(keys);
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableMap.of((Object)key, (Object)value))));
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAll_iterable_null(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(null, keys -> {
            throw new AssertionError();
        });
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAll_iterable_nullKey(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(Collections.singletonList(null), keys -> {
            throw new AssertionError();
        });
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_iterable_empty(Cache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAll((Iterable)ImmutableList.of(), keys -> {
            throw new AssertionError();
        });
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAll_function_null(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(context.absentKeys(), null);
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAll_function_nullValue(Cache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(context.absentKeys(), keys -> null);
    }

    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void getAll_immutable(Cache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAll(context.absentKeys(), CacheTest.bulkMappingFunction());
        result.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void getAll_absent_failure(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.getAll(context.absentKeys(), keys -> {
                throw new IllegalStateException();
            });
        }
        finally {
            int misses = context.absentKeys().size();
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        }
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_absent(Cache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAll(context.absentKeys(), CacheTest.bulkMappingFunction());
        int count = context.absentKeys().size();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)count));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(count)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_partial(Cache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> expect = new HashMap<Integer, Integer>();
        expect.put(context.firstKey(), -context.firstKey().intValue());
        expect.put(context.middleKey(), -context.middleKey().intValue());
        expect.put(context.lastKey(), -context.lastKey().intValue());
        Map result = cache.getAll(expect.keySet(), CacheTest.bulkMappingFunction());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expect)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(expect.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_full(Cache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAll(context.original().keySet(), CacheTest.bulkMappingFunction());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(result.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING}, implementation={CacheSpec.Implementation.Guava})
    public void getAll_duplicates(Cache<Integer, Integer> cache, CacheContext context) {
        ImmutableSet absentKeys = ImmutableSet.copyOf((Iterable)Iterables.limit(context.absentKeys(), (int)Ints.saturatedCast((long)(context.maximum().max() - context.initialSize()))));
        Iterable keys = Iterables.concat((Iterable)absentKeys, (Iterable)absentKeys, context.original().keySet(), context.original().keySet());
        Map result = cache.getAll(keys, CacheTest.bulkMappingFunction());
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasMissCount(absentKeys.size()));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasHitCount(context.initialSize()));
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Iterable)keys))));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_absent(Cache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys, CacheTest.bulkMappingFunction()).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_partial(Cache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys, CacheTest.bulkMappingFunction()).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_present(Cache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys, CacheTest.bulkMappingFunction()).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_exceeds(Cache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys, CacheTest.bulkMappingFunction()).keySet());
        MatcherAssert.assertThat(result.subList(0, keys.size()), (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, writer={CacheSpec.Writer.DISABLED})
    public void getAll_jdk8186171(CacheContext context) {
        LoadingCache cache = context.build(key -> null);
        class Key {
            Key() {
            }

            public int hashCode() {
                return 0;
            }
        }
        ArrayList<Key> keys = new ArrayList<Key>();
        int i = 0;
        while ((long)i < CacheSpec.Population.FULL.size()) {
            keys.add(new Key());
            ++i;
        }
        Key key2 = (Key)Iterables.getLast(keys);
        Integer value = context.absentValue();
        cache.put((Object)key2, (Object)value);
        Map result = cache.getAll(keys, keysToLoad -> ImmutableMap.of());
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableMap.of((Object)key2, (Object)value))));
    }

    static Function<Iterable<? extends Integer>, Map<Integer, Integer>> bulkMappingFunction() {
        return keys -> {
            Map result = Streams.stream((Iterable)keys).collect(Collectors.toMap(Function.identity(), key -> -key.intValue()));
            CacheSpec.interner.get().putAll(result);
            return result;
        };
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void put_insert(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() + 1L)));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Object)context.absentValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void put_replace_sameValue(Cache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            Integer value = context.original().get(key);
            cache.put((Object)key, (Object)value);
            MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)value));
        }
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        int count = context.firstMiddleLastKeys().size();
        if (context.isGuava() || context.isAsync()) {
            MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void put_replace_differentValue(Cache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.put((Object)key, (Object)context.absentValue());
            MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)context.absentValue()));
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote(key, context.absentValue()));
        }
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void put_nullKey(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put(null, (Object)context.absentValue());
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void put_nullValue(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.absentKey(), null);
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void put_nullKeyAndValue(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put(null, null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void put_insert_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.put((Object)context.absentKey(), (Object)context.absentValue());
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void put_replace_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.put((Object)context.middleKey(), (Object)context.absentValue());
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_insert(Cache<Integer, Integer> cache, CacheContext context) {
        int startKey = context.original().size() + 1;
        Map entries = IntStream.range(startKey, 100 + startKey).boxed().collect(Collectors.toMap(Function.identity(), key -> -key.intValue()));
        cache.putAll(entries);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)(100L + context.initialSize())));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wroteAll(entries));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void putAll_replace(Cache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> entries = new HashMap<Integer, Integer>(context.original());
        entries.replaceAll((key, value) -> value + 1);
        cache.putAll(entries);
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(entries)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, entries.size(), RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wroteAll(entries));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void putAll_mixed(Cache<Integer, Integer> cache, CacheContext context) {
        HashMap entries = new HashMap();
        HashMap replaced = new HashMap();
        context.original().forEach((key, value) -> {
            if (key % 2 == 0) {
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                replaced.put(key, value);
            }
            entries.put(key, value);
        });
        cache.putAll(entries);
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(entries)));
        HashMap expect = context.isGuava() || context.isAsync() ? entries : replaced;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, expect.size(), RemovalCause.REPLACED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wroteAll(replaced));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void putAll_empty(Cache<Integer, Integer> cache, CacheContext context) {
        cache.putAll(new HashMap());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void putAll_null(Cache<Integer, Integer> cache, CacheContext context) {
        cache.putAll(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void putAll_insert_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.putAll(context.absent());
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.WriteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void putAll_replace_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.putAll((Map)ImmutableMap.of((Object)context.middleKey(), (Object)context.absentValue()));
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void invalidate_absent(Cache<Integer, Integer> cache, CacheContext context) {
        cache.invalidate((Object)context.absentKey());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void invalidate_present(Cache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.invalidate((Object)key);
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deleted(key, context.original().get(key), RemovalCause.EXPLICIT));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() - (long)count)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @CheckNoStats
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void invalidate_nullKey(Cache<Integer, Integer> cache, CacheContext context) {
        cache.invalidate(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void invalidate_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.invalidate((Object)context.middleKey());
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @Test(dataProvider="caches")
    public void invalidateAll(Cache<Integer, Integer> cache, CacheContext context) {
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, context.original().size(), RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void invalidateAll_empty(Cache<Integer, Integer> cache, CacheContext context) {
        cache.invalidateAll(new HashSet());
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void invalidateAll_partial(Cache<Integer, Integer> cache, CacheContext context) {
        List keys = cache.asMap().keySet().stream().filter(i -> i % 2 == 0).collect(Collectors.toList());
        cache.invalidateAll(keys);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() - (long)keys.size())));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, keys.size(), RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(Maps.filterKeys(context.original(), (Predicate)Predicates.in((Collection)keys)), RemovalCause.EXPLICIT));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void invalidateAll_full(Cache<Integer, Integer> cache, CacheContext context) {
        cache.invalidateAll(context.original().keySet());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, context.original().size(), RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletedAll(context.original(), RemovalCause.EXPLICIT));
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void invalidateAll_null(Cache<Integer, Integer> cache, CacheContext context) {
        cache.invalidateAll(null);
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void invalidateAll_partial_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.invalidateAll(context.firstMiddleLastKeys());
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void invalidateAll_full_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.invalidateAll();
        }
        finally {
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void cleanup(Cache<Integer, Integer> cache, CacheContext context) {
        cache.cleanUp();
    }

    @CacheSpec
    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches")
    public void stats(Cache<Integer, Integer> cache, CacheContext context) {
        CacheStats stats = cache.stats().plus(new CacheStats(1L, 2L, 3L, 4L, 5L, 6L, 7L).minus(new CacheStats(6L, 5L, 4L, 3L, 2L, 1L, 0L)));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Object)new CacheStats(0L, 0L, 0L, 1L, 3L, 5L, 7L)));
        MatcherAssert.assertThat((Object)cache.policy().isRecordingStats(), (Matcher)Matchers.is((Object)context.isRecordingStats()));
    }

    @CheckNoStats
    @Test(dataProvider="caches")
    @CacheSpec(writer={CacheSpec.Writer.EXCEPTIONAL})
    public void serialize(Cache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat(cache, (Matcher)Matchers.is(IsCacheReserializable.reserializable()));
    }
}

