/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class CaffeineSpecTest {
    static final long UNSET_LONG = -1L;

    @Test(dataProvider="caches")
    @CacheSpec(initialCapacity={CacheSpec.InitialCapacity.DEFAULT, CacheSpec.InitialCapacity.FULL}, population={CacheSpec.Population.EMPTY}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.DISABLED}, removalListener={CacheSpec.Listener.DEFAULT}, implementation={CacheSpec.Implementation.Caffeine})
    public void specifications(CacheContext context) {
        CaffeineSpec spec = CaffeineSpecTest.toSpec(context);
        Caffeine builder = Caffeine.from((CaffeineSpec)spec);
        CaffeineSpecTest.checkInitialCapacity(spec, context, builder);
        CaffeineSpecTest.checkMaximumWeight(spec, context, builder);
        CaffeineSpecTest.checkMaximumSize(spec, context, builder);
        CaffeineSpecTest.checkWeakKeys(spec, context, builder);
        CaffeineSpecTest.checkValueStrength(spec, context, builder);
        CaffeineSpecTest.checkExpireAfterAccess(spec, context, builder);
        CaffeineSpecTest.checkExpireAfterWrite(spec, context, builder);
        CaffeineSpecTest.checkRefreshAfterWrite(spec, context, builder);
        MatcherAssert.assertThat((Object)spec, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)CaffeineSpec.parse((String)spec.toParsableString()))));
    }

    static CaffeineSpec toSpec(CacheContext context) {
        ArrayList<String> options = new ArrayList<String>();
        if (context.initialCapacity() != CacheSpec.InitialCapacity.DEFAULT) {
            options.add("initialCapacity=" + context.initialCapacity().size());
        }
        if (context.maximum() != CacheSpec.Maximum.DISABLED) {
            String key = context.isWeighted() ? "maximumWeight" : "maximumSize";
            options.add(key + "=" + context.maximum().max());
        }
        if (context.isWeakKeys()) {
            options.add("weakKeys");
        }
        if (context.isWeakValues()) {
            options.add("weakValues");
        }
        if (context.isSoftValues()) {
            options.add("softValues");
        }
        if (context.expireAfterAccess() != CacheSpec.Expire.DISABLED) {
            long durationMin = TimeUnit.NANOSECONDS.toMinutes(context.expireAfterAccess().timeNanos());
            options.add("expireAfterAccess=" + durationMin + "m");
        }
        if (context.expireAfterWrite() != CacheSpec.Expire.DISABLED) {
            long durationMin = TimeUnit.NANOSECONDS.toMinutes(context.expireAfterWrite().timeNanos());
            options.add("expireAfterWrite=" + durationMin + "m");
        }
        if (context.refreshAfterWrite() != CacheSpec.Expire.DISABLED) {
            long durationMin = TimeUnit.NANOSECONDS.toMinutes(context.refreshAfterWrite().timeNanos());
            options.add("refreshAfterWrite=" + durationMin + "m");
        }
        if (context.isRecordingStats()) {
            options.add("recordStats");
        }
        Collections.shuffle(options);
        String specString = Joiner.on((char)',').join(options);
        return CaffeineSpec.parse((String)specString);
    }

    static void checkInitialCapacity(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (context.initialCapacity() == CacheSpec.InitialCapacity.DEFAULT) {
            MatcherAssert.assertThat((Object)spec.initialCapacity, (Matcher)Matchers.is((Object)-1));
            MatcherAssert.assertThat((Object)builder.initialCapacity, (Matcher)Matchers.is((Object)-1));
        } else {
            MatcherAssert.assertThat((Object)spec.initialCapacity, (Matcher)Matchers.is((Object)context.initialCapacity().size()));
            MatcherAssert.assertThat((Object)builder.initialCapacity, (Matcher)Matchers.is((Object)context.initialCapacity().size()));
        }
    }

    static void checkMaximumSize(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (context.isWeighted()) {
            MatcherAssert.assertThat((Object)spec.maximumSize, (Matcher)Matchers.is((Object)-1L));
            MatcherAssert.assertThat((Object)builder.maximumSize, (Matcher)Matchers.is((Object)-1L));
            return;
        }
        if (context.maximum() == CacheSpec.Maximum.DISABLED) {
            MatcherAssert.assertThat((Object)spec.maximumSize, (Matcher)Matchers.is((Object)-1L));
            MatcherAssert.assertThat((Object)builder.maximumSize, (Matcher)Matchers.is((Object)-1L));
        } else {
            MatcherAssert.assertThat((Object)spec.maximumSize, (Matcher)Matchers.is((Object)context.maximum().max()));
            MatcherAssert.assertThat((Object)builder.maximumSize, (Matcher)Matchers.is((Object)context.maximum().max()));
        }
    }

    static void checkMaximumWeight(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (!context.isWeighted()) {
            MatcherAssert.assertThat((Object)spec.maximumWeight, (Matcher)Matchers.is((Object)-1L));
            MatcherAssert.assertThat((Object)builder.maximumWeight, (Matcher)Matchers.is((Object)-1L));
            return;
        }
        if (context.maximum() == CacheSpec.Maximum.DISABLED) {
            MatcherAssert.assertThat((Object)spec.maximumWeight, (Matcher)Matchers.is((Object)-1L));
            MatcherAssert.assertThat((Object)builder.maximumWeight, (Matcher)Matchers.is((Object)-1L));
        } else {
            MatcherAssert.assertThat((Object)spec.maximumWeight, (Matcher)Matchers.is((Object)context.maximum().max()));
            MatcherAssert.assertThat((Object)builder.maximumWeight, (Matcher)Matchers.is((Object)context.maximum().max()));
        }
    }

    static void checkWeakKeys(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (context.isWeakKeys()) {
            MatcherAssert.assertThat((Object)spec.keyStrength, (Matcher)Matchers.is((Object)Caffeine.Strength.WEAK));
            MatcherAssert.assertThat((Object)builder.keyStrength, (Matcher)Matchers.is((Object)Caffeine.Strength.WEAK));
        } else {
            MatcherAssert.assertThat((Object)spec.keyStrength, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)builder.keyStrength, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    static void checkValueStrength(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (context.isWeakValues()) {
            MatcherAssert.assertThat((Object)spec.valueStrength, (Matcher)Matchers.is((Object)Caffeine.Strength.WEAK));
            MatcherAssert.assertThat((Object)builder.valueStrength, (Matcher)Matchers.is((Object)Caffeine.Strength.WEAK));
        } else if (context.isSoftValues()) {
            MatcherAssert.assertThat((Object)spec.valueStrength, (Matcher)Matchers.is((Object)Caffeine.Strength.SOFT));
            MatcherAssert.assertThat((Object)builder.valueStrength, (Matcher)Matchers.is((Object)Caffeine.Strength.SOFT));
        } else {
            MatcherAssert.assertThat((Object)spec.valueStrength, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)builder.valueStrength, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    static void checkExpireAfterAccess(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (context.expireAfterAccess() == CacheSpec.Expire.DISABLED) {
            MatcherAssert.assertThat((Object)spec.expireAfterAccessDuration, (Matcher)Matchers.is((Object)-1L));
            MatcherAssert.assertThat((Object)((Object)spec.expireAfterAccessTimeUnit), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)builder.expireAfterAccessNanos, (Matcher)Matchers.is((Object)-1L));
        } else {
            long durationMin = TimeUnit.NANOSECONDS.toMinutes(context.expireAfterAccess().timeNanos());
            MatcherAssert.assertThat((Object)spec.expireAfterAccessDuration, (Matcher)Matchers.is((Object)durationMin));
            MatcherAssert.assertThat((Object)((Object)spec.expireAfterAccessTimeUnit), (Matcher)Matchers.is((Object)((Object)TimeUnit.MINUTES)));
            MatcherAssert.assertThat((Object)builder.expireAfterAccessNanos, (Matcher)Matchers.is((Object)TimeUnit.MINUTES.toNanos(durationMin)));
        }
    }

    static void checkExpireAfterWrite(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (context.expireAfterWrite() == CacheSpec.Expire.DISABLED) {
            MatcherAssert.assertThat((Object)spec.expireAfterWriteDuration, (Matcher)Matchers.is((Object)-1L));
            MatcherAssert.assertThat((Object)((Object)spec.expireAfterWriteTimeUnit), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)builder.expireAfterWriteNanos, (Matcher)Matchers.is((Object)-1L));
        } else {
            long durationMin = TimeUnit.NANOSECONDS.toMinutes(context.expireAfterWrite().timeNanos());
            MatcherAssert.assertThat((Object)spec.expireAfterWriteDuration, (Matcher)Matchers.is((Object)durationMin));
            MatcherAssert.assertThat((Object)((Object)spec.expireAfterWriteTimeUnit), (Matcher)Matchers.is((Object)((Object)TimeUnit.MINUTES)));
            MatcherAssert.assertThat((Object)builder.expireAfterWriteNanos, (Matcher)Matchers.is((Object)TimeUnit.MINUTES.toNanos(durationMin)));
        }
    }

    static void checkRefreshAfterWrite(CaffeineSpec spec, CacheContext context, Caffeine<?, ?> builder) {
        if (context.refreshAfterWrite() == CacheSpec.Expire.DISABLED) {
            MatcherAssert.assertThat((Object)spec.refreshAfterWriteDuration, (Matcher)Matchers.is((Object)-1L));
            MatcherAssert.assertThat((Object)((Object)spec.refreshAfterWriteTimeUnit), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)builder.refreshNanos, (Matcher)Matchers.is((Object)-1L));
        } else {
            long durationMin = TimeUnit.NANOSECONDS.toMinutes(context.refreshAfterWrite().timeNanos());
            MatcherAssert.assertThat((Object)spec.refreshAfterWriteDuration, (Matcher)Matchers.is((Object)durationMin));
            MatcherAssert.assertThat((Object)((Object)spec.refreshAfterWriteTimeUnit), (Matcher)Matchers.is((Object)((Object)TimeUnit.MINUTES)));
            MatcherAssert.assertThat((Object)builder.refreshNanos, (Matcher)Matchers.is((Object)TimeUnit.MINUTES.toNanos(durationMin)));
        }
    }
}

