/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.DisabledFuture;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.GuardedScheduler;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.google.common.testing.FakeTicker;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class CaffeineTest {
    @Mock
    StatsCounter statsCounter;
    @Mock
    Expiry<Object, Object> expiry;
    @Mock
    CacheLoader<Object, Object> loader;
    @Mock
    CacheWriter<Object, Object> writer;

    @BeforeClass
    public void beforeClass() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void unconfigured() {
        MatcherAssert.assertThat((Object)Caffeine.newBuilder().build(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)Caffeine.newBuilder().build(this.loader), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)Caffeine.newBuilder().buildAsync(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)Caffeine.newBuilder().buildAsync(this.loader), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)Caffeine.newBuilder().toString(), (Matcher)Matchers.is((Object)Caffeine.newBuilder().toString()));
    }

    @Test
    public void configured() {
        Caffeine configured = Caffeine.newBuilder().initialCapacity(1).weakKeys().expireAfterAccess(1L, TimeUnit.SECONDS).expireAfterWrite(1L, TimeUnit.SECONDS).removalListener((k, v, c) -> {}).recordStats();
        MatcherAssert.assertThat((Object)configured.build(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)configured.buildAsync(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)configured.build(this.loader), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)configured.buildAsync(this.loader), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)configured.refreshAfterWrite(1L, TimeUnit.SECONDS).toString(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Caffeine.newBuilder().toString())));
        MatcherAssert.assertThat((Object)Caffeine.newBuilder().maximumSize(1L).toString(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Caffeine.newBuilder().maximumWeight(1L).toString())));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromSpec_null() {
        Caffeine.from((CaffeineSpec)null);
    }

    @Test
    public void fromSpec_lenientParsing() {
        Caffeine.from((CaffeineSpec)CaffeineSpec.parse((String)"maximumSize=100")).weigher((k, v) -> 0).build();
    }

    @Test
    public void fromSpec() {
        MatcherAssert.assertThat((Object)Caffeine.from((CaffeineSpec)CaffeineSpec.parse((String)"")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromString_null() {
        Caffeine.from((String)null);
    }

    @Test
    public void fromString_lenientParsing() {
        Caffeine.from((String)"maximumSize=100").weigher((k, v) -> 0).build();
    }

    @Test
    public void fromString() {
        MatcherAssert.assertThat((Object)Caffeine.from((String)""), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void loading_nullLoader() {
        Caffeine.newBuilder().build(null);
    }

    @Test
    public void async_nullLoader() {
        try {
            Caffeine.newBuilder().buildAsync((CacheLoader)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            Caffeine.newBuilder().buildAsync((AsyncCacheLoader)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void async_asyncLoader() {
        Caffeine.newBuilder().buildAsync((arg_0, arg_1) -> this.loader.asyncLoad(arg_0, arg_1));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void async_weakValues() {
        Caffeine.newBuilder().weakValues().buildAsync(this.loader);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void async_softValues() {
        Caffeine.newBuilder().softValues().buildAsync(this.loader);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void async_writer() {
        Caffeine.newBuilder().writer(this.writer).buildAsync(this.loader);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void initialCapacity_negative() {
        Caffeine.newBuilder().initialCapacity(-1);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void initialCapacity_twice() {
        Caffeine.newBuilder().initialCapacity(1).initialCapacity(1);
    }

    @Test
    public void initialCapacity_small() {
        Caffeine builder = Caffeine.newBuilder().initialCapacity(0);
        MatcherAssert.assertThat((Object)builder.initialCapacity, (Matcher)Matchers.is((Object)0));
        builder.build();
    }

    @Test
    public void initialCapacity_large() {
        Caffeine builder = Caffeine.newBuilder().initialCapacity(Integer.MAX_VALUE);
        MatcherAssert.assertThat((Object)builder.initialCapacity, (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void maximumSize_negative() {
        Caffeine.newBuilder().maximumSize(-1L);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void maximumSize_twice() {
        Caffeine.newBuilder().maximumSize(1L).maximumSize(1L);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void maximumSize_maximumWeight() {
        Caffeine.newBuilder().maximumWeight(1L).maximumSize(1L);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void maximumSize_weigher() {
        Caffeine.newBuilder().weigher(Weigher.singletonWeigher()).maximumSize(1L);
    }

    @Test
    public void maximumSize_small() {
        Caffeine builder = Caffeine.newBuilder().maximumSize(0L);
        MatcherAssert.assertThat((Object)builder.maximumSize, (Matcher)Matchers.is((Object)0L));
        Cache cache = builder.build();
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).getMaximum(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void maximumSize_large() {
        Caffeine builder = Caffeine.newBuilder().maximumSize(Integer.MAX_VALUE);
        MatcherAssert.assertThat((Object)builder.maximumSize, (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
        Cache cache = builder.build();
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).getMaximum(), (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void maximumWeight_negative() {
        Caffeine.newBuilder().maximumWeight(-1L);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void maximumWeight_twice() {
        Caffeine.newBuilder().maximumWeight(1L).maximumWeight(1L);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void maximumWeight_noWeigher() {
        Caffeine.newBuilder().maximumWeight(1L).build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void maximumWeight_maximumSize() {
        Caffeine.newBuilder().maximumSize(1L).maximumWeight(1L);
    }

    @Test
    public void maximumWeight_small() {
        Caffeine builder = Caffeine.newBuilder().maximumWeight(0L).weigher(Weigher.singletonWeigher());
        MatcherAssert.assertThat((Object)builder.weigher, (Matcher)Matchers.is((Object)Weigher.singletonWeigher()));
        MatcherAssert.assertThat((Object)builder.maximumWeight, (Matcher)Matchers.is((Object)0L));
        Policy.Eviction eviction = (Policy.Eviction)builder.build().policy().eviction().get();
        MatcherAssert.assertThat((Object)eviction.getMaximum(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)eviction.isWeighted(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void maximumWeight_large() {
        Caffeine builder = Caffeine.newBuilder().maximumWeight(Integer.MAX_VALUE).weigher(Weigher.singletonWeigher());
        MatcherAssert.assertThat((Object)builder.maximumWeight, (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
        MatcherAssert.assertThat((Object)builder.weigher, (Matcher)Matchers.is((Object)Weigher.singletonWeigher()));
        Policy.Eviction eviction = (Policy.Eviction)builder.build().policy().eviction().get();
        MatcherAssert.assertThat((Object)eviction.getMaximum(), (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
        MatcherAssert.assertThat((Object)eviction.isWeighted(), (Matcher)Matchers.is((Object)true));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void weigher_null() {
        Caffeine.newBuilder().weigher(null);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void weigher_twice() {
        Caffeine.newBuilder().weigher(Weigher.singletonWeigher()).weigher(Weigher.singletonWeigher());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void weigher_maximumSize() {
        Caffeine.newBuilder().maximumSize(1L).weigher(Weigher.singletonWeigher());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void weigher_noMaximumWeight() {
        Caffeine.newBuilder().weigher(Weigher.singletonWeigher()).build();
    }

    @Test
    public void weigher() {
        Weigher weigher = (k, v) -> 0;
        Caffeine builder = Caffeine.newBuilder().maximumWeight(0L).weigher(weigher);
        MatcherAssert.assertThat((Object)builder.weigher, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)weigher)));
        builder.build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void expireAfterAccess_negative() {
        Caffeine.newBuilder().expireAfterAccess(-1L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterAccess_expiry() {
        Caffeine.newBuilder().expireAfter(this.expiry).expireAfterAccess(1L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterAccess_twice() {
        Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MILLISECONDS).expireAfterAccess(1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void expireAfterAccess_small() {
        Caffeine builder = Caffeine.newBuilder().expireAfterAccess(0L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)builder.expireAfterAccessNanos, (Matcher)Matchers.is((Object)0L));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterAccess().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void expireAfterAccess_large() {
        Caffeine builder = Caffeine.newBuilder().expireAfterAccess(Integer.MAX_VALUE, TimeUnit.NANOSECONDS);
        MatcherAssert.assertThat((Object)builder.expireAfterAccessNanos, (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterAccess().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.NANOSECONDS), (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void expireAfterAccess_duration_negative() {
        Caffeine.newBuilder().expireAfterAccess(Duration.ofMillis(-1L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterAccess_duration_expiry() {
        Caffeine.newBuilder().expireAfter(this.expiry).expireAfterAccess(Duration.ofMillis(1L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterAccess_duration_twice() {
        Caffeine.newBuilder().expireAfterAccess(Duration.ofMillis(1L)).expireAfterAccess(Duration.ofMillis(1L));
    }

    @Test
    public void expireAfterAccess_duration_small() {
        Caffeine builder = Caffeine.newBuilder().expireAfterAccess(Duration.ofMillis(0L));
        MatcherAssert.assertThat((Object)builder.expireAfterAccessNanos, (Matcher)Matchers.is((Object)0L));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterAccess().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void expireAfterAccess_duration_large() {
        Caffeine builder = Caffeine.newBuilder().expireAfterAccess(Duration.ofNanos(Integer.MAX_VALUE));
        MatcherAssert.assertThat((Object)builder.expireAfterAccessNanos, (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterAccess().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.NANOSECONDS), (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void expireAfterWrite_negative() {
        Caffeine.newBuilder().expireAfterWrite(-1L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterWrite_expiry() {
        Caffeine.newBuilder().expireAfter(this.expiry).expireAfterWrite(1L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterWrite_twice() {
        Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MILLISECONDS).expireAfterWrite(1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void expireAfterWrite_small() {
        Caffeine builder = Caffeine.newBuilder().expireAfterWrite(0L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)builder.expireAfterWriteNanos, (Matcher)Matchers.is((Object)0L));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterWrite().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void expireAfterWrite_large() {
        Caffeine builder = Caffeine.newBuilder().expireAfterWrite(Integer.MAX_VALUE, TimeUnit.NANOSECONDS);
        MatcherAssert.assertThat((Object)builder.expireAfterWriteNanos, (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterWrite().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.NANOSECONDS), (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void expireAfterWrite_duration_negative() {
        Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(-1L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterWrite_duration_expiry() {
        Caffeine.newBuilder().expireAfter(this.expiry).expireAfterWrite(Duration.ofMillis(1L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfterWrite_duration_twice() {
        Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(1L)).expireAfterWrite(Duration.ofMillis(1L));
    }

    @Test
    public void expireAfterWrite_duration_small() {
        Caffeine builder = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(0L));
        MatcherAssert.assertThat((Object)builder.expireAfterWriteNanos, (Matcher)Matchers.is((Object)0L));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterWrite().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void expireAfterWrite_duration_large() {
        Caffeine builder = Caffeine.newBuilder().expireAfterWrite(Duration.ofNanos(Integer.MAX_VALUE));
        MatcherAssert.assertThat((Object)builder.expireAfterWriteNanos, (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
        Policy.Expiration expiration = (Policy.Expiration)builder.build().policy().expireAfterWrite().get();
        MatcherAssert.assertThat((Object)expiration.getExpiresAfter(TimeUnit.NANOSECONDS), (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void expireAfter_null() {
        Caffeine.newBuilder().expireAfter(null);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfter_twice() {
        Caffeine.newBuilder().expireAfter(this.expiry).expireAfter(this.expiry);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfter_access() {
        Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MILLISECONDS).expireAfter(this.expiry);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void expireAfter_write() {
        Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MILLISECONDS).expireAfter(this.expiry);
    }

    @Test
    public void expireAfter() {
        Caffeine builder = Caffeine.newBuilder().expireAfter(this.expiry);
        MatcherAssert.assertThat((Object)builder.expiry, (Matcher)Matchers.is(this.expiry));
        builder.build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void refreshAfterWrite_negative() {
        Caffeine.newBuilder().refreshAfterWrite(-1L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void refreshAfterWrite_twice() {
        Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MILLISECONDS).refreshAfterWrite(1L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void refreshAfterWrite_noCacheLoader() {
        Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MILLISECONDS).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void refreshAfterWrite_zero() {
        Caffeine.newBuilder().refreshAfterWrite(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void refreshAfterWrite() {
        Caffeine builder = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)builder.getRefreshAfterWriteNanos(), (Matcher)Matchers.is((Object)TimeUnit.MILLISECONDS.toNanos(1L)));
        builder.build(k -> k);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void refreshAfterWrite_duration_negative() {
        Caffeine.newBuilder().refreshAfterWrite(Duration.ofMillis(-1L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void refreshAfterWrite_duration_twice() {
        Caffeine.newBuilder().refreshAfterWrite(Duration.ofMillis(1L)).refreshAfterWrite(Duration.ofMillis(1L));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void refreshAfterWrite_duration_noCacheLoader() {
        Caffeine.newBuilder().refreshAfterWrite(Duration.ofMillis(1L)).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void refreshAfterWrite_duration_zero() {
        Caffeine.newBuilder().refreshAfterWrite(Duration.ofMillis(0L));
    }

    @Test
    public void refreshAfterWrite_duration() {
        Caffeine builder = Caffeine.newBuilder().refreshAfterWrite(Duration.ofMillis(1L));
        MatcherAssert.assertThat((Object)builder.getRefreshAfterWriteNanos(), (Matcher)Matchers.is((Object)TimeUnit.MILLISECONDS.toNanos(1L)));
        builder.build(k -> k);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void weakKeys_twice() {
        Caffeine.newBuilder().weakKeys().weakKeys();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void weakKeys_writer() {
        Caffeine.newBuilder().writer(this.writer).weakKeys();
    }

    @Test
    public void weakKeys() {
        Caffeine.newBuilder().weakKeys().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void weakValues_twice() {
        Caffeine.newBuilder().weakValues().weakValues();
    }

    @Test
    public void weakValues() {
        Caffeine.newBuilder().weakValues().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void softValues_twice() {
        Caffeine.newBuilder().softValues().softValues();
    }

    @Test
    public void softValues() {
        Caffeine.newBuilder().softValues().build();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void scheduler_null() {
        Caffeine.newBuilder().scheduler(null);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void scheduler_twice() {
        Caffeine.newBuilder().scheduler(Scheduler.disabledScheduler()).scheduler(Scheduler.disabledScheduler());
    }

    @Test
    public void scheduler() {
        Scheduler scheduler = (executor, task, delay, unit) -> DisabledFuture.INSTANCE;
        Caffeine builder = Caffeine.newBuilder().scheduler(scheduler);
        MatcherAssert.assertThat((Object)((GuardedScheduler)builder.getScheduler()).delegate, (Matcher)Matchers.is((Object)scheduler));
        builder.build();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void executor_null() {
        Caffeine.newBuilder().executor(null);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void executor_twice() {
        Caffeine.newBuilder().executor(MoreExecutors.directExecutor()).executor(MoreExecutors.directExecutor());
    }

    @Test
    public void executor() {
        Caffeine builder = Caffeine.newBuilder().executor(MoreExecutors.directExecutor());
        MatcherAssert.assertThat((Object)builder.getExecutor(), (Matcher)Matchers.is((Object)MoreExecutors.directExecutor()));
        builder.build();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void ticker_null() {
        Caffeine.newBuilder().ticker(null);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void ticker_twice() {
        Caffeine.newBuilder().ticker(Ticker.systemTicker()).ticker(Ticker.systemTicker());
    }

    @Test
    public void ticker() {
        Ticker ticker = () -> ((FakeTicker)new FakeTicker()).read();
        Caffeine builder = Caffeine.newBuilder().ticker(ticker);
        MatcherAssert.assertThat((Object)builder.ticker, (Matcher)Matchers.is((Object)ticker));
        builder.build();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void recordStats_null() {
        Caffeine.newBuilder().recordStats(null);
    }

    @Test
    public void recordStats_twice() {
        Runnable[] tasks;
        Supplier<StatsCounter> supplier = () -> this.statsCounter;
        for (Runnable task : tasks = new Runnable[]{() -> Caffeine.newBuilder().recordStats().recordStats(), () -> Caffeine.newBuilder().recordStats(supplier).recordStats(), () -> Caffeine.newBuilder().recordStats().recordStats(supplier), () -> Caffeine.newBuilder().recordStats(supplier).recordStats(supplier)}) {
            try {
                task.run();
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void recordStats() {
        Caffeine builder = Caffeine.newBuilder().recordStats();
        MatcherAssert.assertThat((Object)builder.statsCounterSupplier, (Matcher)Matchers.is((Object)Caffeine.ENABLED_STATS_COUNTER_SUPPLIER));
        builder.build();
    }

    @Test
    public void recordStats_custom() {
        Supplier<StatsCounter> supplier = () -> this.statsCounter;
        Caffeine builder = Caffeine.newBuilder().recordStats(supplier);
        ((StatsCounter)builder.statsCounterSupplier.get()).recordEviction(1, RemovalCause.SIZE);
        ((StatsCounter)Mockito.verify((Object)this.statsCounter)).recordEviction(1, RemovalCause.SIZE);
        builder.build();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void removalListener_null() {
        Caffeine.newBuilder().removalListener(null);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void removalListener_twice() {
        Caffeine.newBuilder().removalListener((k, v, c) -> {}).removalListener((k, v, c) -> {});
    }

    @Test
    public void removalListener() {
        RemovalListener removalListener = (k, v, c) -> {};
        Caffeine builder = Caffeine.newBuilder().removalListener(removalListener);
        MatcherAssert.assertThat((Object)builder.getRemovalListener(false), (Matcher)Matchers.is((Object)removalListener));
        builder.build();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void writer_null() {
        Caffeine.newBuilder().writer(null);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void writer_twice() {
        Caffeine.newBuilder().writer(this.writer).writer(this.writer);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void writer_weakKeys() {
        Caffeine.newBuilder().writer(this.writer).weakKeys();
    }

    @Test
    public void writer() {
        Caffeine builder = Caffeine.newBuilder().writer(this.writer);
        MatcherAssert.assertThat((Object)builder.getCacheWriter(), (Matcher)Matchers.is(this.writer));
        builder.build();
    }
}

