/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.cache.testing.RejectingCacheWriter;
import com.github.benmanes.caffeine.cache.testing.RemovalListeners;
import com.github.benmanes.caffeine.cache.testing.RemovalNotification;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class EvictionTest {
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.TEN}, removalListener={CacheSpec.Listener.REJECTING})
    public void removalListener_fails(Cache<Integer, Integer> cache, CacheContext context) {
        RemovalListeners.RejectingRemovalListener removalListener = (RemovalListeners.RejectingRemovalListener)context.removalListener();
        removalListener.rejected = 0;
        long size = cache.estimatedSize();
        for (Integer key : context.absentKeys()) {
            cache.put((Object)key, (Object)(-key.intValue()));
            if (cache.estimatedSize() == ++size) continue;
            break;
        }
        MatcherAssert.assertThat((Object)removalListener.rejected, (Matcher)Matchers.is((Object)1));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.ZERO, CacheSpec.Maximum.ONE, CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.TEN})
    public void evict(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        cache.putAll(context.absent());
        if (eviction.isWeighted()) {
            MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)context.maximumWeight()));
        } else {
            MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.maximumSize()));
        }
        int count = context.absentKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasEvictionCount(count));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.SIZE));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> {
            HashMap<Integer, Integer> all = new HashMap<Integer, Integer>(context.original());
            all.putAll(context.absent());
            MapDifference diff = Maps.difference(all, (Map)cache.asMap());
            verifier.deletedAll(diff.entriesOnlyOnLeft(), RemovalCause.SIZE);
        });
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.TEN}, weigher={CacheSpec.CacheWeigher.COLLECTION}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void evict_weighted(Cache<Integer, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        CacheWriter<Integer, Integer> writer = context.cacheWriter();
        int i = 0;
        while ((long)i < context.maximumSize()) {
            cache.put((Object)i, Collections.emptyList());
            ++i;
        }
        cache.invalidateAll();
        Mockito.reset((Object[])new Object[]{writer});
        List<Integer> value1 = Arrays.asList(8, 9, 10);
        List<Integer> value2 = Arrays.asList(3, 4, 5, 6, 7);
        List<Integer> value3 = Arrays.asList(1, 2);
        List<Integer> value4 = Arrays.asList(11);
        List<Integer> value5 = Arrays.asList(12, 13, 14, 15, 16, 17, 18, 19, 20);
        cache.put((Object)0, Arrays.asList(new Integer[0]));
        cache.put((Object)1, value1);
        cache.put((Object)2, value2);
        cache.put((Object)3, value3);
        Awaits.await().until(() -> cache.estimatedSize(), Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)10L));
        cache.put((Object)4, value4);
        Awaits.await().until(() -> cache.estimatedSize(), Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)cache.asMap().containsKey(1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)8L));
        CacheWriterVerifier.verifyWriter(context, (verifier, ignored) -> {
            ((CacheWriter)Mockito.verify((Object)writer)).delete((Object)1, (Object)value1, RemovalCause.SIZE);
            verifier.deletions(1L, RemovalCause.SIZE);
        });
        cache.put((Object)5, value5);
        Awaits.await().until(() -> cache.estimatedSize(), Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)8L));
        CacheWriterVerifier.verifyWriter(context, (verifier, ignored) -> {
            ((CacheWriter)Mockito.verify((Object)writer)).delete((Object)5, (Object)value5, RemovalCause.SIZE);
            verifier.deletions(2L);
        });
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasEvictionCount(2L));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasEvictionWeight(12L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.CONSUMING}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG}, maximumSize={CacheSpec.Maximum.TEN}, weigher={CacheSpec.CacheWeigher.VALUE})
    public void evict_weighted_entryTooBig(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)1, (Object)1);
        cache.put((Object)9, (Object)9);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        cache.policy().eviction().ifPresent(eviction -> MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)10L)));
        cache.put((Object)20, (Object)20);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        cache.policy().eviction().ifPresent(eviction -> MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)10L)));
        MatcherAssert.assertThat(context.consumedNotifications(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableList.of(new RemovalNotification<Integer, Integer>(20, 20, RemovalCause.SIZE)))));
        if (context.isCaffeine()) {
            MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasEvictionWeight(20L));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.TEN}, weigher={CacheSpec.CacheWeigher.VALUE}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG}, removalListener={CacheSpec.Listener.CONSUMING})
    public void evict_weighted_async(AsyncLoadingCache<Integer, Integer> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        AtomicBoolean ready = new AtomicBoolean();
        AtomicBoolean done = new AtomicBoolean();
        CompletableFuture<Integer> valueFuture = CompletableFuture.supplyAsync(() -> {
            Awaits.await().untilTrue(ready);
            return 6;
        });
        valueFuture.whenComplete((r, e) -> done.set(true));
        cache.put((Object)5, CompletableFuture.completedFuture(5));
        cache.put((Object)4, CompletableFuture.completedFuture(4));
        cache.put((Object)6, valueFuture);
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)9L));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)3L));
        ready.set(true);
        Awaits.await().untilTrue(done);
        Awaits.await().until(context::consumedNotifications, Matchers.hasSize((int)1));
        Awaits.await().until(() -> cache.synchronous().estimatedSize(), Matchers.is((Object)2L));
        Awaits.await().until(() -> eviction.weightedSize().getAsLong(), Matchers.is((Object)10L));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasEvictionWeight(5L));
        MatcherAssert.assertThat((Object)context, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.SIZE));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(1L, RemovalCause.SIZE));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.ZERO}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void evict_zero_async(AsyncLoadingCache<Integer, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        AtomicBoolean ready = new AtomicBoolean();
        AtomicBoolean done = new AtomicBoolean();
        CompletableFuture<List> valueFuture = CompletableFuture.supplyAsync(() -> {
            Awaits.await().untilTrue(ready);
            return ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5);
        });
        valueFuture.whenComplete((r, e) -> done.set(true));
        cache.put((Object)context.absentKey(), valueFuture);
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)1L));
        ready.set(true);
        Awaits.await().untilTrue(done);
        Awaits.await().until(() -> eviction.weightedSize().getAsLong(), Matchers.is((Object)0L));
        Awaits.await().until(() -> cache.synchronous().estimatedSize(), Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)context, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.SIZE));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(1L, RemovalCause.SIZE));
    }

    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.TEN}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void evict_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.policy().eviction().ifPresent(policy -> policy.setMaximum(0L));
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CheckNoWriter
    @CacheSpec(maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.NEGATIVE}, population={CacheSpec.Population.EMPTY})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class, IllegalStateException.class})
    public void put_negativeWeight(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
    }

    @CacheSpec(maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.ZERO}, population={CacheSpec.Population.EMPTY})
    @Test(dataProvider="caches")
    public void put_zeroWeight(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.wrote(context.absentKey(), context.absentValue()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void put(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.put((Object)"a", Arrays.asList(1, 2, 3));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void put_sameWeight(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        cache.put((Object)"a", Arrays.asList(-1, -2, -3));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)4L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void put_changeWeight(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        CacheWriter<Integer, Integer> writer = context.cacheWriter();
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        cache.put((Object)"a", Arrays.asList(-1, -2, -3, -4));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)5L));
        CacheWriterVerifier.verifyWriter(context, (verifier, ignored) -> {
            ((CacheWriter)Mockito.verify((Object)writer)).write((Object)"a", Arrays.asList(1, 2, 3));
            ((CacheWriter)Mockito.verify((Object)writer)).write((Object)"b", Arrays.asList(1));
            ((CacheWriter)Mockito.verify((Object)writer)).write((Object)"a", Arrays.asList(-1, -2, -3, -4));
        });
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void put_asyncWeight(AsyncLoadingCache<Integer, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        AtomicBoolean ready = new AtomicBoolean();
        AtomicBoolean done = new AtomicBoolean();
        CompletableFuture<List> valueFuture = CompletableFuture.supplyAsync(() -> {
            Awaits.await().untilTrue(ready);
            return ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5);
        });
        valueFuture.whenComplete((r, e) -> done.set(true));
        cache.put((Object)context.absentKey(), valueFuture);
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)1L));
        ready.set(true);
        Awaits.await().untilTrue(done);
        Awaits.await().until(() -> eviction.weightedSize().getAsLong(), Matchers.is((Object)5L));
        Awaits.await().until(() -> cache.synchronous().estimatedSize(), Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void replace_sameWeight(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        cache.asMap().replace("a", Arrays.asList(-1, -2, -3));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)4L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void replace_changeWeight(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        cache.asMap().replace("a", Arrays.asList(-1, -2, -3, -4));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)5L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void replaceConditionally_sameWeight(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        MatcherAssert.assertThat((Object)cache.asMap().replace("a", Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)4L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void replaceConditionally_changeWeight(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        cache.asMap().replace("a", Arrays.asList(1, 2, 3), Arrays.asList(-1, -2, -3, -4));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)5L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void replaceConditionally_fails(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        MatcherAssert.assertThat((Object)cache.asMap().replace("a", Arrays.asList(1), Arrays.asList(4, 5)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)4L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void remove(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        MatcherAssert.assertThat((Object)((List)cache.asMap().remove("a")), (Matcher)Matchers.is(Arrays.asList(1, 2, 3)));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void removeConditionally(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        MatcherAssert.assertThat((Object)cache.asMap().remove("a", Arrays.asList(1, 2, 3)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void removeConditionally_fails(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        MatcherAssert.assertThat((Object)cache.asMap().remove("a", Arrays.asList(-1, -2, -3)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)4L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    public void invalidateAll(Cache<String, List<Integer>> cache, CacheContext context, Policy.Eviction<?, ?> eviction) {
        cache.putAll((Map)ImmutableMap.of((Object)"a", Arrays.asList(1, 2, 3), (Object)"b", Arrays.asList(1)));
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)0L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, population={CacheSpec.Population.EMPTY})
    public void isWeighted(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        MatcherAssert.assertThat((Object)eviction.isWeighted(), (Matcher)Matchers.is((Object)context.isWeighted()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.UNREACHABLE}, weigher={CacheSpec.CacheWeigher.VALUE})
    public void weightOf(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        Integer key = 1;
        cache.put((Object)key, (Object)1);
        MatcherAssert.assertThat((Object)eviction.weightOf((Object)key).getAsInt(), (Matcher)Matchers.is((Object)1));
        cache.put((Object)key, (Object)2);
        MatcherAssert.assertThat((Object)eviction.weightOf((Object)key).getAsInt(), (Matcher)Matchers.is((Object)2));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL})
    public void weightOf_absent(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        MatcherAssert.assertThat((Object)eviction.weightOf((Object)context.absentKey()), (Matcher)Matchers.is((Object)OptionalInt.empty()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.TEN})
    public void weightedSize(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        long weightedSize = 0L;
        for (Integer key : cache.asMap().keySet()) {
            weightedSize += (long)eviction.weightOf((Object)key).getAsInt();
        }
        MatcherAssert.assertThat((Object)weightedSize, (Matcher)Matchers.is((Object)eviction.weightedSize().getAsLong()));
        MatcherAssert.assertThat((Object)eviction.weightedSize().getAsLong(), (Matcher)Matchers.is((Object)(10L * cache.estimatedSize())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void maximumSize_decrease(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        long newSize = context.maximumWeightOrSize() / 2L;
        eviction.setMaximum(newSize);
        MatcherAssert.assertThat((Object)eviction.getMaximum(), (Matcher)Matchers.is((Object)newSize));
        if (context.initialSize() > newSize) {
            if (context.isZeroWeighted()) {
                MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
                MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 0, RemovalCause.SIZE));
            } else {
                MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)newSize));
                MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, newSize, RemovalCause.SIZE));
            }
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.TEN}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    public void maximumSize_decrease_min(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        eviction.setMaximum(0L);
        MatcherAssert.assertThat((Object)eviction.getMaximum(), (Matcher)Matchers.is((Object)0L));
        if (context.initialSize() > 0L) {
            long expect = context.isZeroWeighted() ? context.initialSize() : 0L;
            MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)expect));
        }
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, context.initialSize(), RemovalCause.SIZE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.CONSUMING})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void maximumSize_decrease_negative(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        try {
            eviction.setMaximum(-1L);
        }
        finally {
            MatcherAssert.assertThat((Object)eviction.getMaximum(), (Matcher)Matchers.is((Object)context.maximumWeightOrSize()));
            MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 0, RemovalCause.SIZE));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void maximumSize_increase(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        eviction.setMaximum(2L * context.maximumWeightOrSize());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat((Object)eviction.getMaximum(), (Matcher)Matchers.is((Object)(2L * context.maximumWeightOrSize())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL}, removalListener={CacheSpec.Listener.REJECTING})
    public void maximumSize_increase_max(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        eviction.setMaximum(Long.MAX_VALUE);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat((Object)eviction.getMaximum(), (Matcher)Matchers.is((Object)9223372034707292160L));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void coldest_unmodifiable(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        eviction.coldest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void coldest_negative(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        eviction.coldest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL})
    public void coldest_zero(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        MatcherAssert.assertThat((Object)eviction.coldest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.FULL})
    public void coldest_partial(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)eviction.coldest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.TEN}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void coldest_order(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        LinkedHashSet<Integer> keys = new LinkedHashSet<Integer>(context.original().keySet());
        LinkedHashSet coldest = new LinkedHashSet(eviction.coldest(Integer.MAX_VALUE).keySet());
        keys.remove(context.lastKey());
        coldest.remove(context.lastKey());
        MatcherAssert.assertThat(coldest, (Matcher)Matchers.contains((Object[])keys.toArray()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.FULL})
    public void coldest_snapshot(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        Map coldest = eviction.coldest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)coldest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void hottest_unmodifiable(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        eviction.hottest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void hottest_negative(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        eviction.hottest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, maximumSize={CacheSpec.Maximum.FULL})
    public void hottest_zero(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        MatcherAssert.assertThat((Object)eviction.hottest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.FULL})
    public void hottest_partial(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)eviction.hottest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void hottest_order(CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        LinkedHashSet<Integer> keys = new LinkedHashSet<Integer>(context.original().keySet());
        Set hottest = eviction.hottest(Integer.MAX_VALUE).keySet();
        LinkedHashSet coldest = new LinkedHashSet(ImmutableList.copyOf(hottest).reverse());
        keys.remove(context.lastKey());
        coldest.remove(context.lastKey());
        MatcherAssert.assertThat(coldest, (Matcher)Matchers.contains((Object[])keys.toArray()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, initialCapacity={CacheSpec.InitialCapacity.EXCESSIVE}, maximumSize={CacheSpec.Maximum.FULL})
    public void hottest_snapshot(Cache<Integer, Integer> cache, CacheContext context, Policy.Eviction<Integer, Integer> eviction) {
        Map hottest = eviction.hottest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)hottest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }
}

