/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.DisabledFuture;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Pacer;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.RejectingCacheWriter;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class ExpirationTest {
    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.IMMEDIATELY}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.IMMEDIATELY}, expiryTime=CacheSpec.Expire.IMMEDIATELY, population={CacheSpec.Population.EMPTY})
    public void expire_zero(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        if (context.isZeroWeighted() && context.isGuava()) {
            MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
            MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 0, RemovalCause.EXPIRED));
        } else {
            ExpirationTest.runVariableExpiration(context);
            MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
            MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.EXPIRED));
            CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deleted(context.absentKey(), context.absentValue(), RemovalCause.EXPIRED));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, scheduler={CacheSpec.CacheScheduler.MOCK})
    public void schedule(Cache<Integer, Integer> cache, CacheContext context) {
        ArgumentCaptor delay = ArgumentCaptor.forClass(Long.TYPE);
        ArgumentCaptor task = ArgumentCaptor.forClass(Runnable.class);
        ((Scheduler)Mockito.doReturn((Object)DisabledFuture.INSTANCE).when((Object)context.scheduler())).schedule((Executor)ArgumentMatchers.eq((Object)context.executor()), (Runnable)task.capture(), ((Long)delay.capture()).longValue(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        long minError = TimeUnit.MINUTES.toNanos(1L) - Pacer.TOLERANCE;
        long maxError = TimeUnit.MINUTES.toNanos(1L) + Pacer.TOLERANCE;
        MatcherAssert.assertThat((Object)((Long)delay.getValue()), (Matcher)Matchers.is((Matcher)Matchers.both((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(minError))).and(Matchers.lessThan((Comparable)Long.valueOf(maxError)))));
        context.ticker().advance(((Long)delay.getValue()).longValue());
        ((Runnable)task.getValue()).run();
        if (context.expiresVariably()) {
            MatcherAssert.assertThat((Object)delay.getAllValues(), (Matcher)Matchers.hasSize((int)2));
            context.ticker().advance(((Long)delay.getValue()).longValue());
            ((Runnable)task.getValue()).run();
        }
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, scheduler={CacheSpec.CacheScheduler.MOCK})
    public void schedule_immediate(Cache<Integer, Integer> cache, CacheContext context) {
        ((Scheduler)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgument(1)).run();
            return DisabledFuture.INSTANCE;
        }).when((Object)context.scheduler())).schedule((Executor)ArgumentMatchers.any(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        ((Scheduler)Mockito.verify((Object)context.scheduler(), (VerificationMode)Mockito.atMostOnce())).schedule((Executor)ArgumentMatchers.any(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, writer={CacheSpec.Writer.EXCEPTIONAL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, executorFailure=CacheSpec.ExecutorFailure.EXPECTED, removalListener={CacheSpec.Listener.REJECTING})
    public void getIfPresent_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.getIfPresent((Object)context.firstKey());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void get_writeTime(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        Integer value = context.absentValue();
        cache.get((Object)key, k -> {
            context.ticker().advance(5L, TimeUnit.MINUTES);
            return value;
        });
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)value));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void get_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.get((Object)context.firstKey(), java.util.function.Function.identity());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_insert(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.put((Object)context.firstKey(), (Object)context.absentValue());
        ExpirationTest.runVariableExpiration(context);
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_replace(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.put((Object)context.firstKey(), (Object)context.absentValue());
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.middleKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        if (context.isGuava()) {
            cache.cleanUp();
        }
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void put_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.put((Object)context.firstKey(), (Object)context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void putAll_insert(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.putAll((Map)ImmutableMap.of((Object)context.firstKey(), (Object)context.absentValue(), (Object)context.middleKey(), (Object)context.absentValue(), (Object)context.lastKey(), (Object)context.absentValue()));
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void putAll_replace(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.putAll((Map)ImmutableMap.of((Object)context.firstKey(), (Object)context.absentValue(), (Object)context.absentKey(), (Object)context.absentValue()));
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.middleKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        if (context.isGuava()) {
            cache.cleanUp();
        }
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void putAll_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.putAll((Map)ImmutableMap.of((Object)context.firstKey(), (Object)context.absentValue()));
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void invalidate(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.invalidate((Object)context.firstKey());
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void invalidate_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.invalidate((Object)context.firstKey());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void invalidateAll(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.invalidateAll(context.firstMiddleLastKeys());
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void invalidateAll_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.invalidateAll(context.firstMiddleLastKeys());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void invalidateAll_full(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.invalidateAll();
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void invalidateAll_full_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.invalidateAll();
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void estimatedSize(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void cleanUp(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.cleanUp();
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void cleanUp_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.HOURS);
        cache.cleanUp();
        context.disableRejectingCacheWriter();
        context.ticker().advance(-1L, TimeUnit.HOURS);
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void get_writerFails(LoadingCache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.get((Object)context.firstKey());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void getAll_writerFails(LoadingCache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            cache.getAll(context.firstMiddleLastKeys());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, loader={CacheSpec.Loader.IDENTITY}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void refresh(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        Integer key = context.firstKey();
        cache.refresh((Object)key);
        long count = cache.estimatedSize() == 1L ? context.initialSize() : 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deleted(key, context.original().get(key), RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void refresh_writerFails(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.HOURS);
        cache.refresh((Object)context.firstKey());
        context.disableRejectingCacheWriter();
        context.ticker().advance(-1L, TimeUnit.HOURS);
        MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, loader={CacheSpec.Loader.IDENTITY}, removalListener={CacheSpec.Listener.CONSUMING}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void get(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(2L, TimeUnit.MINUTES);
        cache.get((Object)context.firstKey());
        cache.get((Object)context.middleKey(), k -> context.absentValue());
        cache.get((Object)context.lastKey(), (k, executor) -> CompletableFuture.completedFuture(context.absentValue()));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void get_writeTime(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        Integer value = context.absentValue();
        cache.get((Object)key, k -> {
            context.ticker().advance(5L, TimeUnit.MINUTES);
            return value;
        });
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)key), IsFutureValue.futureOf(value));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.CONSUMING}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void get_async(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        cache.get((Object)context.absentKey(), (k, e) -> future);
        context.ticker().advance(2L, TimeUnit.MINUTES);
        cache.synchronous().cleanUp();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 0, RemovalCause.EXPIRED));
        future.complete(context.absentValue());
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is(future));
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        cache.synchronous().cleanUp();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(1L, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON}, removalListener={CacheSpec.Listener.CONSUMING}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, loader={CacheSpec.Loader.BULK_IDENTITY})
    public void getAll(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Set<Integer> keys = context.firstMiddleLastKeys();
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.getAll(context.firstMiddleLastKeys());
        MatcherAssert.assertThat((Object)((Map)cache.getAll(keys).join()), (Matcher)Matchers.is((Object)Maps.uniqueIndex(keys, (Function)Functions.identity())));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_insert(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.put((Object)context.firstKey(), CompletableFuture.completedFuture(context.absentValue()));
        ExpirationTest.runVariableExpiration(context);
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, removalListener={CacheSpec.Listener.CONSUMING}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_insert_async(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        cache.put((Object)context.absentKey(), future);
        context.ticker().advance(2L, TimeUnit.MINUTES);
        cache.synchronous().cleanUp();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 0, RemovalCause.EXPIRED));
        future.complete(context.absentValue());
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is(future));
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        cache.synchronous().cleanUp();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(1L, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_replace(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(context.absentValue());
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.put((Object)context.firstKey(), future);
        cache.put((Object)context.absentKey(), future);
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.firstKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentValue())));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentValue())));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.middleKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)2L));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void isEmpty(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void size(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)((int)context.initialSize())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void containsKey(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.containsKey(context.firstKey()), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void containsValue(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.containsValue(context.original().get(context.firstKey())), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void clear(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        map.clear();
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void clear_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.clear();
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void putIfAbsent_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.putIfAbsent(context.firstKey(), context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_insert(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.put(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_replace(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.put(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)map.put(context.absentKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.get(context.firstKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.get(context.middleKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)2));
        if (context.isGuava()) {
            context.cleanUp();
        }
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void put_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.put(context.firstKey(), context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void replace(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(60L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.replace(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (!map.isEmpty()) {
            context.cleanUp();
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void replace_updated(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.replace(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        context.cleanUp();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize() - 1L;
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void replaceConditionally(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.ticker().advance(60L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.replace(key, context.original().get(key), context.absentValue()), (Matcher)Matchers.is((Object)false));
        if (!map.isEmpty()) {
            context.cleanUp();
        }
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void replaceConditionally_updated(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.replace(key, context.original().get(key), context.absentValue()), (Matcher)Matchers.is((Object)true));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        context.cleanUp();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize() - 1L;
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void remove(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.remove(context.firstKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, compute={CacheSpec.Compute.SYNC}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void remove_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.remove(context.firstKey());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void removeConditionally(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.remove(key, context.original().get(key)), (Matcher)Matchers.is((Object)false));
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void removeConditionally_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Integer key = context.firstKey();
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.remove(key, context.original().get(key));
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void computeIfAbsent(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.computeIfAbsent(key, (? super K k) -> context.absentValue()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void computeIfAbsent_writeTime(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.absentKey();
        Integer value = context.absentValue();
        map.computeIfAbsent(key, (? super K k) -> {
            context.ticker().advance(5L, TimeUnit.MINUTES);
            return value;
        });
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)map.containsKey(key), (Matcher)Matchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void computeIfAbsent_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Integer key = context.firstKey();
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.computeIfAbsent(key, (? super K k) -> context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void computeIfPresent(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.computeIfPresent(key, (? super K k, ? super V v) -> value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        if (context.isGuava()) {
            context.cleanUp();
        }
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void computeIfPresent_writeTime(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        map.computeIfPresent(key, (? super K k, ? super V v) -> {
            context.ticker().advance(5L, TimeUnit.MINUTES);
            return value;
        });
        context.cleanUp();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)map.containsKey(key), (Matcher)Matchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, executorFailure=CacheSpec.ExecutorFailure.EXPECTED, removalListener={CacheSpec.Listener.REJECTING})
    public void computeIfPresent_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Integer key = context.firstKey();
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.computeIfPresent(key, (? super K k, ? super V v) -> context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void compute(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.compute(key, (? super K k, ? super V v) -> {
            MatcherAssert.assertThat((Object)v, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            return value;
        }), (Matcher)Matchers.is((Object)value));
        long count = context.initialSize() - (long)map.size() + 1L;
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void compute_writeTime(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        map.compute(key, (? super K k, ? super V v) -> {
            context.ticker().advance(5L, TimeUnit.MINUTES);
            return value;
        });
        context.cleanUp();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)map.containsKey(key), (Matcher)Matchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void compute_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Integer key = context.firstKey();
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.compute(key, (? super K k, ? super V v) -> context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void merge(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)map.merge(key, value, (oldValue, v) -> {
            throw new AssertionError((Object)"Should never be called");
        }), (Matcher)Matchers.is((Object)value));
        long count = context.initialSize() - (long)map.size() + 1L;
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void merge_writeTime(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        map.merge(key, value, (oldValue, v) -> {
            context.ticker().advance(5L, TimeUnit.MINUTES);
            return value;
        });
        context.cleanUp();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)map.containsKey(key), (Matcher)Matchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, keys={CacheSpec.ReferenceType.STRONG}, population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, compute={CacheSpec.Compute.SYNC}, writer={CacheSpec.Writer.EXCEPTIONAL}, removalListener={CacheSpec.Listener.REJECTING})
    public void merge_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            Integer key = context.firstKey();
            Integer value = context.absentValue();
            context.ticker().advance(1L, TimeUnit.HOURS);
            map.merge(key, value, (oldValue, v) -> context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat(map, (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void iterators(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)Iterators.size(map.keySet().iterator()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)Iterators.size(map.values().iterator()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)Iterators.size(map.entrySet().iterator()), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void putIfAbsent_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        cache.put((Object)1, (Object)ImmutableList.of((Object)1));
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.asMap().putIfAbsent(1, ImmutableList.of((Object)1, (Object)2, (Object)3));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void put_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        cache.put((Object)1, (Object)ImmutableList.of((Object)1));
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.put((Object)1, (Object)ImmutableList.of((Object)1, (Object)2, (Object)3));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void computeIfAbsent_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        cache.put((Object)1, (Object)ImmutableList.of((Object)1));
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.asMap().computeIfAbsent(1, (? super K k) -> ImmutableList.of((Object)1, (Object)2, (Object)3));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void compute_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        cache.put((Object)1, (Object)ImmutableList.of((Object)1));
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.asMap().compute(1, (? super K k, ? super V v) -> ImmutableList.of((Object)1, (Object)2, (Object)3));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.COLLECTION}, expiryTime=CacheSpec.Expire.ONE_MINUTE, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE})
    public void merge_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        cache.put((Object)1, (Object)ImmutableList.of((Object)1));
        context.ticker().advance(1L, TimeUnit.MINUTES);
        cache.asMap().merge(1, ImmutableList.of((Object)1, (Object)2, (Object)3), (oldValue, v) -> {
            throw new AssertionError((Object)"Should never be called");
        });
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    private static void runVariableExpiration(CacheContext context) {
        if (context.expiresVariably()) {
            context.ticker().advance(2L, TimeUnit.SECONDS);
            context.cleanUp();
        }
    }
}

