/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.ExpireAfterAccess;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class ExpireAfterAccessTest {
    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.ACCESS}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getIfPresent(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.getIfPresent((Object)context.firstKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Object)(-context.firstKey().intValue())));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.lastKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.ACCESS}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void get(Cache<Integer, Integer> cache, CacheContext context) {
        Function<Integer, Integer> mappingFunction = context.original()::get;
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey(), mappingFunction);
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey(), mappingFunction);
        cache.get((Object)context.lastKey(), mappingFunction);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.ACCESS}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getAllPresent(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.getAllPresent(context.firstMiddleLastKeys());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getAllPresent(context.firstMiddleLastKeys()).size(), (Matcher)Matchers.is((Object)3));
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)3L));
        long count = context.initialSize() - 3L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.VARIABLE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.ACCESS}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, loader={CacheSpec.Loader.IDENTITY}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void get(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.lastKey())), (Matcher)Matchers.is((Object)context.lastKey()));
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.ACCESS}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, loader={CacheSpec.Loader.IDENTITY, CacheSpec.Loader.BULK_IDENTITY}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getAll(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)ImmutableList.of((Object)context.firstKey(), (Object)context.middleKey())), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)context.firstKey(), (Object)(-context.firstKey().intValue()), (Object)context.middleKey(), (Object)(-context.middleKey().intValue()))));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)ImmutableList.of((Object)context.firstKey(), (Object)context.absentKey())), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)context.firstKey(), (Object)(-context.firstKey().intValue()), (Object)context.absentKey(), (Object)context.absentKey())));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)ImmutableList.of((Object)context.middleKey(), (Object)context.absentKey())), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)context.middleKey(), (Object)context.middleKey(), (Object)context.absentKey(), (Object)context.absentKey())));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)3L));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.ACCESS}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getIfPresent(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.getIfPresent((Object)context.firstKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.firstKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(-context.firstKey().intValue())));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.lastKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)1L));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_ACCESS, CacheSpec.Expiration.VARIABLE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.ACCESS}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.FULL})
    public void putIfAbsent(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.putIfAbsent(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.putIfAbsent(context.lastKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void getExpiresAfter(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        MatcherAssert.assertThat((Object)expireAfterAccess.getExpiresAfter(TimeUnit.MINUTES), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void getExpiresAfter_duration(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        MatcherAssert.assertThat((Object)expireAfterAccess.getExpiresAfter(), (Matcher)Matchers.is((Object)Duration.ofMinutes(1L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void setExpiresAfter(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        expireAfterAccess.setExpiresAfter(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)expireAfterAccess.getExpiresAfter(TimeUnit.MINUTES), (Matcher)Matchers.is((Object)2L));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void setExpiresAfter_duration(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        expireAfterAccess.setExpiresAfter(Duration.ofMinutes(2L));
        MatcherAssert.assertThat((Object)expireAfterAccess.getExpiresAfter(), (Matcher)Matchers.is((Object)Duration.ofMinutes(2L)));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void ageOf(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        MatcherAssert.assertThat((Object)expireAfterAccess.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).getAsLong(), (Matcher)Matchers.is((Object)0L));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)expireAfterAccess.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).getAsLong(), (Matcher)Matchers.is((Object)30L));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)expireAfterAccess.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).isPresent());
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void ageOf_duration(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        MatcherAssert.assertThat((Object)expireAfterAccess.ageOf((Object)context.firstKey()), (Matcher)Matchers.is(Optional.of(Duration.ZERO)));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)expireAfterAccess.ageOf((Object)context.firstKey()), (Matcher)Matchers.is(Optional.of(Duration.ofSeconds(30L))));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)expireAfterAccess.ageOf((Object)context.firstKey()).isPresent());
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void oldest_unmodifiable(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        expireAfterAccess.oldest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void oldest_negative(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        expireAfterAccess.oldest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_zero(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        MatcherAssert.assertThat((Object)expireAfterAccess.oldest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_partial(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)expireAfterAccess.oldest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void oldest_order(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        Map oldest = expireAfterAccess.oldest(Integer.MAX_VALUE);
        MatcherAssert.assertThat(oldest.keySet(), (Matcher)Matchers.contains((Object[])context.original().keySet().toArray(new Integer[0])));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_snapshot(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        Map oldest = expireAfterAccess.oldest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)oldest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void youngest_unmodifiable(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        expireAfterAccess.youngest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void youngest_negative(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        expireAfterAccess.youngest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_zero(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        MatcherAssert.assertThat((Object)expireAfterAccess.youngest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_partial(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)expireAfterAccess.youngest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void youngest_order(CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        Map youngest = expireAfterAccess.youngest(Integer.MAX_VALUE);
        LinkedHashSet keys = new LinkedHashSet(ImmutableList.copyOf(youngest.keySet()).reverse());
        MatcherAssert.assertThat(keys, (Matcher)Matchers.contains((Object[])context.original().keySet().toArray(new Integer[0])));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_snapshot(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterAccess Policy.Expiration<Integer, Integer> expireAfterAccess) {
        Map youngest = expireAfterAccess.youngest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)youngest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }
}

