/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class ExpireAfterVarTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches")
    @CacheSpec(expiryTime=CacheSpec.Expire.FOREVER, expiry={CacheSpec.CacheExpiry.CREATE, CacheSpec.CacheExpiry.WRITE, CacheSpec.CacheExpiry.ACCESS})
    public void expiry_bounds(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(System.nanoTime());
        AtomicBoolean running = new AtomicBoolean();
        AtomicBoolean done = new AtomicBoolean();
        Integer key = context.absentKey();
        cache.put((Object)key, (Object)key);
        try {
            ConcurrentTestHarness.execute(() -> {
                while (!done.get()) {
                    context.ticker().advance(1L, TimeUnit.MINUTES);
                    cache.get((Object)key, Integer::new);
                    running.set(true);
                }
            });
            Awaits.await().untilTrue(running);
            cache.cleanUp();
            MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key, Integer::new)), (Matcher)Matchers.sameInstance((Object)key));
        }
        finally {
            done.set(true);
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expiry={CacheSpec.CacheExpiry.CREATE})
    public void put_replace(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.put((Object)context.firstKey(), (Object)context.absentValue());
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.middleKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expiry={CacheSpec.CacheExpiry.CREATE})
    public void put_replace(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(context.absentValue());
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.put((Object)context.firstKey(), future);
        cache.put((Object)context.absentKey(), future);
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.firstKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.middleKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.absentKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentValue())));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)1L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expiry={CacheSpec.CacheExpiry.CREATE})
    public void put_replace(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.put(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)map.put(context.absentKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.get(context.firstKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.get(context.middleKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)map.get(context.absentKey()), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize();
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expiry={CacheSpec.CacheExpiry.CREATE})
    public void putAll_replace(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.putAll((Map)ImmutableMap.of((Object)context.firstKey(), (Object)context.absentValue(), (Object)context.absentKey(), (Object)context.absentValue()));
        context.consumedNotifications().clear();
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.middleKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Object)context.absentValue()));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expiry={CacheSpec.CacheExpiry.CREATE})
    public void replace_updated(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.replace(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        context.cleanUp();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        long count = context.initialSize();
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, expiryTime=CacheSpec.Expire.ONE_MINUTE, expiry={CacheSpec.CacheExpiry.CREATE})
    public void replaceConditionally_updated(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.replace(key, context.original().get(key), context.absentValue()), (Matcher)Matchers.is((Object)true));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        context.cleanUp();
        MatcherAssert.assertThat(map, (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
        long count = context.initialSize();
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO})
    @Test(dataProvider="caches", expectedExceptions={ExpirationException.class})
    public void getIfPresent_expiryFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            Mockito.when((Object)context.expiry().expireAfterRead((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenThrow(ExpirationException.class);
            cache.getIfPresent((Object)context.firstKey());
        }
        finally {
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO}, writer={CacheSpec.Writer.MOCKITO}, removalListener={CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={ExpirationException.class})
    public void get_expiryFails_create(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            Mockito.when((Object)context.expiry().expireAfterCreate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong())).thenThrow(ExpirationException.class);
            cache.get((Object)context.absentKey(), Function.identity());
        }
        finally {
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
            ((CacheWriter)Mockito.verify(context.cacheWriter(), (VerificationMode)Mockito.never())).write((Object)ArgumentMatchers.anyInt(), (Object)ArgumentMatchers.anyInt());
        }
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO})
    @Test(dataProvider="caches", expectedExceptions={ExpirationException.class})
    public void get_expiryFails_read(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            Mockito.when((Object)context.expiry().expireAfterRead((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenThrow(ExpirationException.class);
            cache.get((Object)context.firstKey(), Function.identity());
        }
        finally {
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO})
    @Test(dataProvider="caches", expectedExceptions={ExpirationException.class})
    public void getAllPresent_expiryFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            Mockito.when((Object)context.expiry().expireAfterRead((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenThrow(ExpirationException.class);
            cache.getAllPresent(context.firstMiddleLastKeys());
        }
        finally {
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO})
    @Test(dataProvider="caches", expectedExceptions={ExpirationException.class})
    public void put_insert_expiryFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            Mockito.when((Object)context.expiry().expireAfterCreate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong())).thenThrow(ExpirationException.class);
            cache.put((Object)context.absentKey(), (Object)context.absentValue());
        }
        finally {
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiryTime=CacheSpec.Expire.ONE_MINUTE, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO})
    @Test(dataProvider="caches", expectedExceptions={ExpirationException.class})
    public void put_insert_replaceExpired_expiryFails(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireVariably) {
        OptionalLong duration = expireVariably.getExpiresAfter((Object)context.firstKey(), TimeUnit.NANOSECONDS);
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            Mockito.when((Object)context.expiry().expireAfterCreate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong())).thenThrow(ExpirationException.class);
            cache.put((Object)context.firstKey(), (Object)context.absentValue());
        }
        finally {
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
            MatcherAssert.assertThat((Object)expireVariably.getExpiresAfter((Object)context.firstKey(), TimeUnit.NANOSECONDS), (Matcher)Matchers.is((Object)duration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO})
    @Test(dataProvider="caches", expectedExceptions={ExpirationException.class})
    public void put_update_expiryFails(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireVariably) {
        OptionalLong duration = expireVariably.getExpiresAfter((Object)context.firstKey(), TimeUnit.NANOSECONDS);
        try {
            context.ticker().advance(1L, TimeUnit.HOURS);
            Mockito.when((Object)context.expiry().expireAfterUpdate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenThrow(ExpirationException.class);
            cache.put((Object)context.firstKey(), (Object)context.absentValue());
        }
        finally {
            context.ticker().advance(-1L, TimeUnit.HOURS);
            MatcherAssert.assertThat((Object)cache.asMap(), (Matcher)Matchers.equalTo(context.original()));
            MatcherAssert.assertThat((Object)expireVariably.getExpiresAfter((Object)context.firstKey(), TimeUnit.NANOSECONDS), (Matcher)Matchers.is((Object)duration));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, expiry={CacheSpec.CacheExpiry.DISABLED})
    public void expireVariably_notEnabled(Cache<Integer, Integer> cache) {
        MatcherAssert.assertThat((Object)cache.policy().expireVariably(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void getExpiresAfter(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.absentKey(), TimeUnit.MINUTES), (Matcher)Matchers.is((Object)OptionalLong.empty()));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.firstKey(), TimeUnit.MINUTES), (Matcher)Matchers.is((Object)OptionalLong.of(1L)));
        Mockito.when((Object)context.expiry().expireAfterUpdate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)TimeUnit.HOURS.toNanos(1L));
        cache.put((Object)context.firstKey(), (Object)context.absentValue());
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.firstKey(), TimeUnit.MINUTES), (Matcher)Matchers.is((Object)OptionalLong.of(60L)));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.lastKey(), TimeUnit.MINUTES), (Matcher)Matchers.is((Object)OptionalLong.of(1L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void getExpiresAfter_duration(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.absentKey()), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.firstKey()), (Matcher)Matchers.is(Optional.of(Duration.ofMinutes(1L))));
        Mockito.when((Object)context.expiry().expireAfterUpdate((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)TimeUnit.HOURS.toNanos(1L));
        cache.put((Object)context.firstKey(), (Object)context.absentValue());
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.firstKey()), (Matcher)Matchers.is(Optional.of(Duration.ofHours(1L))));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.lastKey()), (Matcher)Matchers.is(Optional.of(Duration.ofMinutes(1L))));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void setExpiresAfter(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.setExpiresAfter((Object)context.firstKey(), 2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.firstKey(), TimeUnit.MINUTES), (Matcher)Matchers.is((Object)OptionalLong.of(2L)));
        expireAfterVar.setExpiresAfter((Object)context.absentKey(), 4L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.absentKey(), TimeUnit.MINUTES), (Matcher)Matchers.is((Object)OptionalLong.empty()));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.MOCKITO}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void setExpiresAfter_duration(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.setExpiresAfter((Object)context.firstKey(), Duration.ofMinutes(2L));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.firstKey()), (Matcher)Matchers.is(Optional.of(Duration.ofMinutes(2L))));
        expireAfterVar.setExpiresAfter((Object)context.absentKey(), Duration.ofMinutes(4L));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)context.absentKey()), (Matcher)Matchers.is(Optional.empty()));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent_nullKey(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.putIfAbsent(null, (Object)2, 3L, TimeUnit.SECONDS);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent_nullValue(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.putIfAbsent((Object)1, null, 3L, TimeUnit.SECONDS);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent_nullTimeUnit(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.putIfAbsent((Object)1, (Object)2, 3L, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent_negativeDuration(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.putIfAbsent((Object)1, (Object)2, -10L, TimeUnit.SECONDS);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent_nullDuration(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.putIfAbsent((Object)1, (Object)2, null);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent_insert(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Integer key = context.absentKey();
        Integer value = context.absentValue();
        MatcherAssert.assertThat((Object)expireAfterVar.putIfAbsent((Object)key, (Object)value, Duration.ofMinutes(2L)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)key), (Matcher)Matchers.is(Optional.of(Duration.ofMinutes(2L))));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent_present(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        MatcherAssert.assertThat((Object)expireAfterVar.putIfAbsent((Object)key, (Object)value, Duration.ofMinutes(2L)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)context.original().get(key)));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)key), (Matcher)Matchers.is(Optional.of(Duration.ofMinutes(1L))));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void put_nullKey(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.put(null, (Object)2, 3L, TimeUnit.SECONDS);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void put_nullValue(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.put((Object)1, null, 3L, TimeUnit.SECONDS);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void put_nullTimeUnit(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.put((Object)1, (Object)2, 3L, null);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void put_negativeDuration(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.put((Object)1, (Object)2, -10L, TimeUnit.SECONDS);
    }

    @CheckNoWriter
    @CheckNoStats
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void put_nullDuration(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.put((Object)1, (Object)2, null);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void put_insert(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Integer key = context.absentKey();
        Integer value = context.absentValue();
        expireAfterVar.put((Object)key, (Object)value, Duration.ofMinutes(2L));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)key), (Matcher)Matchers.is(Optional.of(Duration.ofMinutes(2L))));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void put_replace(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Integer key = context.firstKey();
        Integer value = context.absentValue();
        expireAfterVar.put((Object)key, (Object)value, Duration.ofMinutes(2L));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)expireAfterVar.getExpiresAfter((Object)key), (Matcher)Matchers.is(Optional.of(Duration.ofMinutes(2L))));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void oldest_unmodifiable(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.oldest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void oldest_negative(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.oldest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    public void oldest_zero(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        MatcherAssert.assertThat((Object)expireAfterVar.oldest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.ACCESS})
    public void oldest_partial(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)expireAfterVar.oldest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.ACCESS}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void oldest_order(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Map oldest = expireAfterVar.oldest(Integer.MAX_VALUE);
        MatcherAssert.assertThat(oldest.keySet(), (Matcher)Matchers.contains((Object[])context.original().keySet().toArray(new Integer[0])));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    public void oldest_snapshot(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Map oldest = expireAfterVar.oldest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)oldest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void youngest_unmodifiable(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.youngest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void youngest_negative(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        expireAfterVar.youngest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    public void youngest_zero(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        MatcherAssert.assertThat((Object)expireAfterVar.youngest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.ACCESS})
    public void youngest_partial(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)expireAfterVar.youngest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, expiry={CacheSpec.CacheExpiry.ACCESS}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void youngest_order(CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Map youngest = expireAfterVar.youngest(Integer.MAX_VALUE);
        LinkedHashSet keys = new LinkedHashSet(ImmutableList.copyOf(youngest.keySet()).reverse());
        MatcherAssert.assertThat(keys, (Matcher)Matchers.contains((Object[])((Integer[])Iterables.toArray(keys, Integer.class))));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expiry={CacheSpec.CacheExpiry.ACCESS})
    public void youngest_snapshot(Cache<Integer, Integer> cache, CacheContext context, Policy.VarExpiration<Integer, Integer> expireAfterVar) {
        Map youngest = expireAfterVar.youngest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)youngest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }

    static final class ExpirationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        ExpirationException() {
        }
    }
}

