/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.ExpireAfterWrite;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class ExpireAfterWriteTest {
    @Test(dataProvider="caches")
    @CacheSpec(mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expireAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MINUTE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getIfPresent(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.getIfPresent((Object)context.firstKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void get(Cache<Integer, Integer> cache, CacheContext context) {
        Function<Integer, Integer> mappingFunction = context.original()::get;
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey(), mappingFunction);
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.get((Object)context.lastKey(), mappingFunction);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void getAllPresent(Cache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.getAllPresent(context.firstMiddleLastKeys());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getAllPresent(context.firstMiddleLastKeys()).size(), (Matcher)Matchers.is((Object)0));
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void get(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey());
        cache.get((Object)context.absentKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.absentKey())), (Matcher)Matchers.is((Object)(-context.absentKey().intValue())));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE, loader={CacheSpec.Loader.IDENTITY, CacheSpec.Loader.BULK_IDENTITY})
    public void getAll(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)ImmutableList.of((Object)context.firstKey(), (Object)context.absentKey())), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)context.firstKey(), (Object)(-context.firstKey().intValue()), (Object)context.absentKey(), (Object)context.absentKey())));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)ImmutableList.of((Object)context.firstKey(), (Object)context.absentKey())), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)context.firstKey(), (Object)context.firstKey(), (Object)context.absentKey(), (Object)context.absentKey())));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)2L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void getIfPresent(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.getIfPresent((Object)context.firstKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.firstKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.lastKey()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)0L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.FULL}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE, CacheSpec.Expiration.VARIABLE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, expiry={CacheSpec.CacheExpiry.DISABLED, CacheSpec.CacheExpiry.WRITE}, expiryTime=CacheSpec.Expire.ONE_MINUTE)
    public void putIfAbsent(Map<Integer, Integer> map, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.putIfAbsent(context.firstKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)map.putIfAbsent(context.lastKey(), context.absentValue()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPIRED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.EXPIRED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void getExpiresAfter(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        MatcherAssert.assertThat((Object)expireAfterWrite.getExpiresAfter(TimeUnit.MINUTES), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void getExpiresAfter_duration(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        MatcherAssert.assertThat((Object)expireAfterWrite.getExpiresAfter(), (Matcher)Matchers.is((Object)Duration.ofMinutes(1L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void setExpiresAfter(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        expireAfterWrite.setExpiresAfter(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)expireAfterWrite.getExpiresAfter(TimeUnit.MINUTES), (Matcher)Matchers.is((Object)2L));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, mustExpireWithAnyOf={CacheSpec.Expiration.AFTER_WRITE}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void setExpiresAfter_duration(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        expireAfterWrite.setExpiresAfter(Duration.ofMinutes(2L));
        MatcherAssert.assertThat((Object)expireAfterWrite.getExpiresAfter(), (Matcher)Matchers.is((Object)Duration.ofMinutes(2L)));
        context.ticker().advance(90L, TimeUnit.SECONDS);
        cache.cleanUp();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void ageOf(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        MatcherAssert.assertThat((Object)expireAfterWrite.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).getAsLong(), (Matcher)Matchers.is((Object)0L));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)expireAfterWrite.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).getAsLong(), (Matcher)Matchers.is((Object)30L));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)expireAfterWrite.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void ageOf_duration(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        MatcherAssert.assertThat((Object)expireAfterWrite.ageOf((Object)context.firstKey()), (Matcher)Matchers.is(Optional.of(Duration.ZERO)));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)expireAfterWrite.ageOf((Object)context.firstKey()), (Matcher)Matchers.is(Optional.of(Duration.ofSeconds(30L))));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)expireAfterWrite.ageOf((Object)context.firstKey()).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void oldest_unmodifiable(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        expireAfterWrite.oldest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void oldest_negative(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        expireAfterWrite.oldest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_zero(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        MatcherAssert.assertThat((Object)expireAfterWrite.oldest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_partial(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)expireAfterWrite.oldest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void oldest_order(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        Map oldest = expireAfterWrite.oldest(Integer.MAX_VALUE);
        MatcherAssert.assertThat(oldest.keySet(), (Matcher)Matchers.contains((Object[])context.original().keySet().toArray(new Integer[0])));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_snapshot(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        Map oldest = expireAfterWrite.oldest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)oldest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void youngest_unmodifiable(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        expireAfterWrite.youngest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void youngest_negative(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        expireAfterWrite.youngest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_zero(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        MatcherAssert.assertThat((Object)expireAfterWrite.youngest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_partial(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)expireAfterWrite.youngest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void youngest_order(CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        Map youngest = expireAfterWrite.youngest(Integer.MAX_VALUE);
        LinkedHashSet keys = new LinkedHashSet(ImmutableList.copyOf(youngest.keySet()).reverse());
        MatcherAssert.assertThat(keys, (Matcher)Matchers.contains((Object[])((Integer[])Iterables.toArray(keys, Integer.class))));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, expireAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_snapshot(Cache<Integer, Integer> cache, CacheContext context, @ExpireAfterWrite Policy.Expiration<Integer, Integer> expireAfterWrite) {
        Map youngest = expireAfterWrite.youngest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)youngest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }
}

