/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.FrequencySketch;
import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class FrequencySketchTest {
    final Integer item = ThreadLocalRandom.current().nextInt();

    @Test
    public void construct() {
        FrequencySketch sketch = new FrequencySketch();
        MatcherAssert.assertThat((Object)sketch.table, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="sketch", expectedExceptions={IllegalArgumentException.class})
    public void ensureCapacity_negative(FrequencySketch<Integer> sketch) {
        sketch.ensureCapacity(-1L);
    }

    @Test(dataProvider="sketch")
    public void ensureCapacity_smaller(FrequencySketch<Integer> sketch) {
        int size = sketch.table.length;
        sketch.ensureCapacity((long)(size / 2));
        MatcherAssert.assertThat((Object)sketch.table.length, (Matcher)Matchers.is((Object)size));
        MatcherAssert.assertThat((Object)sketch.tableMask, (Matcher)Matchers.is((Object)(size - 1)));
        MatcherAssert.assertThat((Object)sketch.sampleSize, (Matcher)Matchers.is((Object)(10 * size)));
    }

    @Test(dataProvider="sketch")
    public void ensureCapacity_larger(FrequencySketch<Integer> sketch) {
        int size = sketch.table.length;
        sketch.ensureCapacity((long)(size * 2));
        MatcherAssert.assertThat((Object)sketch.table.length, (Matcher)Matchers.is((Object)(size * 2)));
        MatcherAssert.assertThat((Object)sketch.tableMask, (Matcher)Matchers.is((Object)(2 * size - 1)));
        MatcherAssert.assertThat((Object)sketch.sampleSize, (Matcher)Matchers.is((Object)(20 * size)));
    }

    @Test(dataProvider="sketch")
    public void increment_once(FrequencySketch<Integer> sketch) {
        sketch.increment((Object)this.item);
        MatcherAssert.assertThat((Object)sketch.frequency((Object)this.item), (Matcher)Matchers.is((Object)1));
    }

    @Test(dataProvider="sketch")
    public void increment_max(FrequencySketch<Integer> sketch) {
        for (int i = 0; i < 20; ++i) {
            sketch.increment((Object)this.item);
        }
        MatcherAssert.assertThat((Object)sketch.frequency((Object)this.item), (Matcher)Matchers.is((Object)15));
    }

    @Test(dataProvider="sketch")
    public void increment_distinct(FrequencySketch<Integer> sketch) {
        sketch.increment((Object)this.item);
        sketch.increment((Object)(this.item + 1));
        MatcherAssert.assertThat((Object)sketch.frequency((Object)this.item), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)sketch.frequency((Object)(this.item + 1)), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)sketch.frequency((Object)(this.item + 2)), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void reset() {
        boolean reset = false;
        FrequencySketch sketch = new FrequencySketch();
        sketch.ensureCapacity(64L);
        for (int i = 1; i < 20 * sketch.table.length; ++i) {
            sketch.increment((Object)i);
            if (sketch.size == i) continue;
            reset = true;
            break;
        }
        MatcherAssert.assertThat((Object)reset, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)sketch.size, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(sketch.sampleSize / 2)));
    }

    @Test
    public void heavyHitters() {
        int i;
        int i2;
        FrequencySketch sketch = FrequencySketchTest.makeSketch(512L);
        for (i2 = 100; i2 < 100000; ++i2) {
            sketch.increment((Object)i2);
        }
        for (i2 = 0; i2 < 10; i2 += 2) {
            for (int j = 0; j < i2; ++j) {
                sketch.increment((Object)i2);
            }
        }
        int[] popularity = new int[10];
        for (i = 0; i < 10; ++i) {
            popularity[i] = sketch.frequency((Object)i);
        }
        for (i = 0; i < popularity.length; ++i) {
            if (i == 0 || i == 1 || i == 3 || i == 5 || i == 7 || i == 9) {
                MatcherAssert.assertThat((Object)popularity[i], (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(popularity[2])));
                continue;
            }
            if (i == 2) {
                MatcherAssert.assertThat((Object)popularity[2], (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(popularity[4])));
                continue;
            }
            if (i == 4) {
                MatcherAssert.assertThat((Object)popularity[4], (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(popularity[6])));
                continue;
            }
            if (i != 6) continue;
            MatcherAssert.assertThat((Object)popularity[6], (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(popularity[8])));
        }
    }

    @DataProvider(name="sketch")
    public Object[][] providesSketch() {
        return new Object[][]{{FrequencySketchTest.makeSketch(512L)}};
    }

    private static <E> FrequencySketch<E> makeSketch(long maximumSize) {
        FrequencySketch sketch = new FrequencySketch();
        sketch.ensureCapacity(maximumSize);
        return sketch;
    }
}

