/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.BoundedWeigher;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.IsValidAsyncCache;
import com.github.benmanes.caffeine.cache.IsValidCache;
import com.github.benmanes.caffeine.cache.LocalAsyncLoadingCache;
import com.github.benmanes.caffeine.cache.UnboundedLocalCache;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import com.google.common.testing.SerializableTester;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsCacheReserializable<T>
extends TypeSafeDiagnosingMatcher<T> {
    DescriptionBuilder desc;

    private IsCacheReserializable() {
    }

    public void describeTo(Description description) {
        description.appendValue((Object)"serialized copy");
        if (this.desc.getDescription() != description) {
            description.appendText(this.desc.getDescription().toString());
        }
    }

    public boolean matchesSafely(T original, Description description) {
        this.desc = new DescriptionBuilder(description);
        Object copy = SerializableTester.reserialize(original);
        if (original instanceof AsyncLoadingCache) {
            AsyncLoadingCache asyncCache = (AsyncLoadingCache)original;
            AsyncLoadingCache asyncCopy = (AsyncLoadingCache)copy;
            IsCacheReserializable.checkAsynchronousCache(asyncCache, asyncCopy, this.desc);
        } else if (original instanceof Cache) {
            Cache syncCache = (Cache)original;
            Cache syncCopy = (Cache)copy;
            IsCacheReserializable.checkSynchronousCache(syncCache, syncCopy, this.desc);
        } else {
            throw new UnsupportedOperationException();
        }
        return this.desc.matches();
    }

    private static <K, V> void checkAsynchronousCache(AsyncLoadingCache<K, V> original, AsyncLoadingCache<K, V> copy, DescriptionBuilder desc) {
        if (!IsValidAsyncCache.validAsyncCache().matchesSafely(copy, desc.getDescription())) {
            desc.expected("valid async cache");
        } else if (original instanceof UnboundedLocalCache.UnboundedLocalAsyncLoadingCache) {
            IsCacheReserializable.checkUnboundedAsyncLocalLoadingCache((UnboundedLocalCache.UnboundedLocalAsyncLoadingCache)original, (UnboundedLocalCache.UnboundedLocalAsyncLoadingCache)copy, desc);
        } else if (original instanceof BoundedLocalCache.BoundedLocalAsyncLoadingCache) {
            IsCacheReserializable.checkBoundedAsyncLocalLoadingCache((BoundedLocalCache.BoundedLocalAsyncLoadingCache)original, (BoundedLocalCache.BoundedLocalAsyncLoadingCache)copy, desc);
        }
    }

    private static <K, V> void checkSynchronousCache(Cache<K, V> original, Cache<K, V> copy, DescriptionBuilder desc) {
        if (!IsValidCache.validCache().matchesSafely(copy, desc.getDescription())) {
            desc.expected("valid cache");
            return;
        }
        IsCacheReserializable.checkIfUnbounded(original, copy, desc);
        IsCacheReserializable.checkIfBounded(original, copy, desc);
    }

    private static <K, V> void checkIfUnbounded(Cache<K, V> original, Cache<K, V> copy, DescriptionBuilder desc) {
        if (original instanceof UnboundedLocalCache.UnboundedLocalManualCache) {
            IsCacheReserializable.checkUnboundedLocalManualCache((UnboundedLocalCache.UnboundedLocalManualCache)original, (UnboundedLocalCache.UnboundedLocalManualCache)copy, desc);
        }
        if (original instanceof UnboundedLocalCache.UnboundedLocalLoadingCache) {
            IsCacheReserializable.checkUnboundedLocalLoadingCache((UnboundedLocalCache.UnboundedLocalLoadingCache)original, (UnboundedLocalCache.UnboundedLocalLoadingCache)copy, desc);
        }
        if (original instanceof LocalAsyncLoadingCache.LoadingCacheView) {
            LocalAsyncLoadingCache originalAsync = ((LocalAsyncLoadingCache.LoadingCacheView)original).asyncCache();
            LocalAsyncLoadingCache copyAsync = ((LocalAsyncLoadingCache.LoadingCacheView)copy).asyncCache();
            if (originalAsync instanceof UnboundedLocalCache.UnboundedLocalAsyncLoadingCache) {
                IsCacheReserializable.checkUnboundedAsyncLocalLoadingCache((UnboundedLocalCache.UnboundedLocalAsyncLoadingCache)originalAsync, (UnboundedLocalCache.UnboundedLocalAsyncLoadingCache)copyAsync, desc);
            }
        }
    }

    private static <K, V> void checkUnboundedLocalManualCache(UnboundedLocalCache.UnboundedLocalManualCache<K, V> original, UnboundedLocalCache.UnboundedLocalManualCache<K, V> copy, DescriptionBuilder desc) {
        IsCacheReserializable.checkUnboundedLocalCache(original.cache, copy.cache, desc);
    }

    private static <K, V> void checkUnboundedLocalLoadingCache(UnboundedLocalCache.UnboundedLocalLoadingCache<K, V> original, UnboundedLocalCache.UnboundedLocalLoadingCache<K, V> copy, DescriptionBuilder desc) {
        desc.expectThat("same cacheLoader", copy.loader, Matchers.is((Object)original.loader));
    }

    private static <K, V> void checkUnboundedAsyncLocalLoadingCache(UnboundedLocalCache.UnboundedLocalAsyncLoadingCache<K, V> original, UnboundedLocalCache.UnboundedLocalAsyncLoadingCache<K, V> copy, DescriptionBuilder desc) {
        IsCacheReserializable.checkUnboundedLocalCache(original.cache, copy.cache, desc);
        desc.expectThat("same cacheLoader", copy.loader, Matchers.is((Object)original.loader));
    }

    private static <K, V> void checkUnboundedLocalCache(UnboundedLocalCache<K, V> original, UnboundedLocalCache<K, V> copy, DescriptionBuilder desc) {
        desc.expectThat("estimated empty", Long.valueOf(copy.estimatedSize()), Matchers.is((Object)0L));
        desc.expectThat("same ticker", copy.ticker, Matchers.is((Object)original.ticker));
        desc.expectThat("same writer", copy.writer, Matchers.is((Object)original.writer));
        desc.expectThat("same isRecordingStats", Boolean.valueOf(copy.isRecordingStats), Matchers.is((Object)original.isRecordingStats));
        if (original.removalListener == null) {
            desc.expectThat("same removalListener", copy.removalListener, Matchers.is((Matcher)Matchers.nullValue()));
        } else if (copy.removalListener == null) {
            desc.expected("non-null removalListener");
        } else if (copy.removalListener.getClass() != original.removalListener.getClass()) {
            desc.expected("same removalListener but was " + copy.removalListener.getClass());
        }
    }

    private static <K, V> void checkIfBounded(Cache<K, V> original, Cache<K, V> copy, DescriptionBuilder desc) {
        if (original instanceof BoundedLocalCache.BoundedLocalManualCache) {
            IsCacheReserializable.checkBoundedLocalManualCache((BoundedLocalCache.BoundedLocalManualCache)original, (BoundedLocalCache.BoundedLocalManualCache)copy, desc);
        }
        if (original instanceof BoundedLocalCache.BoundedLocalLoadingCache) {
            IsCacheReserializable.checkBoundedLocalLoadingCache((BoundedLocalCache.BoundedLocalLoadingCache)original, (BoundedLocalCache.BoundedLocalLoadingCache)copy, desc);
        }
        if (original instanceof LocalAsyncLoadingCache.LoadingCacheView) {
            LocalAsyncLoadingCache originalAsync = ((LocalAsyncLoadingCache.LoadingCacheView)original).asyncCache();
            LocalAsyncLoadingCache copyAsync = ((LocalAsyncLoadingCache.LoadingCacheView)copy).asyncCache();
            if (originalAsync instanceof BoundedLocalCache.BoundedLocalAsyncLoadingCache) {
                IsCacheReserializable.checkBoundedAsyncLocalLoadingCache((BoundedLocalCache.BoundedLocalAsyncLoadingCache)originalAsync, (BoundedLocalCache.BoundedLocalAsyncLoadingCache)copyAsync, desc);
            }
        }
    }

    private static <K, V> void checkBoundedLocalManualCache(BoundedLocalCache.BoundedLocalManualCache<K, V> original, BoundedLocalCache.BoundedLocalManualCache<K, V> copy, DescriptionBuilder desc) {
        IsCacheReserializable.checkBoundedLocalCache(original.cache, copy.cache, desc);
    }

    private static <K, V> void checkBoundedLocalLoadingCache(BoundedLocalCache.BoundedLocalLoadingCache<K, V> original, BoundedLocalCache.BoundedLocalLoadingCache<K, V> copy, DescriptionBuilder desc) {
        desc.expectThat("same cacheLoader", copy.cache.cacheLoader, Matchers.is((Object)original.cache.cacheLoader));
    }

    private static <K, V> void checkBoundedAsyncLocalLoadingCache(BoundedLocalCache.BoundedLocalAsyncLoadingCache<K, V> original, BoundedLocalCache.BoundedLocalAsyncLoadingCache<K, V> copy, DescriptionBuilder desc) {
        IsCacheReserializable.checkBoundedLocalCache(original.cache, copy.cache, desc);
        desc.expectThat("same cacheLoader", copy.loader, Matchers.is((Object)original.loader));
    }

    private static <K, V> void checkBoundedLocalCache(BoundedLocalCache<K, V> original, BoundedLocalCache<K, V> copy, DescriptionBuilder desc) {
        desc.expectThat("empty", Long.valueOf(copy.estimatedSize()), Matchers.is((Object)0L));
        desc.expectThat("same weigher", IsCacheReserializable.unwrapWeigher(copy.weigher).getClass(), Matchers.is((Matcher)Matchers.equalTo(IsCacheReserializable.unwrapWeigher(original.weigher).getClass())));
        desc.expectThat("same nodeFactory", copy.nodeFactory, Matchers.instanceOf(original.nodeFactory.getClass()));
        if (original.evicts()) {
            desc.expectThat("same maximumWeight", Long.valueOf(copy.maximum()), Matchers.is((Object)original.maximum()));
            desc.expectThat("same maximumwindowWeight", Long.valueOf(copy.windowMaximum()), Matchers.is((Object)original.windowMaximum()));
        }
        if (original.expiresVariable()) {
            desc.expectThat("same expiry", IsCacheReserializable.unwrapExpiry(copy.expiry()).getClass(), Matchers.is((Matcher)Matchers.equalTo(IsCacheReserializable.unwrapExpiry(original.expiry()).getClass())));
        } else {
            desc.expectThat("", Boolean.valueOf(copy.expiresVariable()), Matchers.is((Object)false));
        }
        if (original.expiresAfterAccess()) {
            desc.expectThat("same expiresAfterAccessNanos", Long.valueOf(copy.expiresAfterAccessNanos()), Matchers.is((Object)original.expiresAfterAccessNanos()));
        } else {
            desc.expectThat("", Boolean.valueOf(copy.expiresAfterAccess()), Matchers.is((Object)false));
        }
        if (original.expiresAfterWrite()) {
            desc.expectThat("same expireAfterWriteNanos", Long.valueOf(copy.expiresAfterWriteNanos()), Matchers.is((Object)original.expiresAfterWriteNanos()));
        } else {
            desc.expectThat("", Boolean.valueOf(copy.expiresAfterWrite()), Matchers.is((Object)false));
        }
        if (original.refreshAfterWrite()) {
            desc.expectThat("same refreshAfterWriteNanos", Long.valueOf(copy.refreshAfterWriteNanos()), Matchers.is((Object)original.refreshAfterWriteNanos()));
        } else {
            desc.expectThat("", Boolean.valueOf(copy.refreshAfterWrite()), Matchers.is((Object)false));
        }
        if (original.removalListener() == null) {
            desc.expectThat("same removalListener", copy.removalListener(), Matchers.is((Matcher)Matchers.nullValue()));
        } else if (copy.removalListener() == null) {
            desc.expected("non-null removalListener");
        } else if (copy.removalListener().getClass() != original.removalListener().getClass()) {
            desc.expected("same removalListener but was " + copy.removalListener().getClass());
        }
    }

    private static <K, V> Weigher<K, V> unwrapWeigher(Weigher<K, V> weigher) {
        while (true) {
            if (weigher instanceof BoundedWeigher) {
                weigher = ((BoundedWeigher)weigher).delegate;
                continue;
            }
            if (!(weigher instanceof Async.AsyncWeigher)) break;
            weigher = ((Async.AsyncWeigher)weigher).delegate;
        }
        return weigher;
    }

    private static <K, V> Expiry<K, V> unwrapExpiry(Expiry<K, V> expiry) {
        while (expiry instanceof Async.AsyncExpiry) {
            expiry = ((Async.AsyncExpiry)expiry).delegate;
        }
        return expiry;
    }

    public static <T> Matcher<T> reserializable() {
        return new IsCacheReserializable<T>();
    }
}

