/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.IsValidBoundedLocalCache;
import com.github.benmanes.caffeine.cache.IsValidUnboundedLocalCache;
import com.github.benmanes.caffeine.cache.UnboundedLocalCache;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsValidAsyncCache<K, V>
extends TypeSafeDiagnosingMatcher<AsyncLoadingCache<K, V>> {
    Description description;

    public void describeTo(Description description) {
        description.appendText("async cache");
        if (this.description != description) {
            description.appendText(this.description.toString());
        }
    }

    protected boolean matchesSafely(AsyncLoadingCache<K, V> cache, Description description) {
        this.description = description;
        if (cache instanceof BoundedLocalCache.BoundedLocalAsyncLoadingCache) {
            BoundedLocalCache.BoundedLocalAsyncLoadingCache local = (BoundedLocalCache.BoundedLocalAsyncLoadingCache)cache;
            return IsValidBoundedLocalCache.valid().matchesSafely(local.cache, description);
        }
        if (cache instanceof UnboundedLocalCache.UnboundedLocalAsyncLoadingCache) {
            UnboundedLocalCache.UnboundedLocalAsyncLoadingCache local = (UnboundedLocalCache.UnboundedLocalAsyncLoadingCache)cache;
            return IsValidUnboundedLocalCache.valid().matchesSafely(local.cache, description);
        }
        return true;
    }

    public static <K, V> IsValidAsyncCache<K, V> validAsyncCache() {
        return new IsValidAsyncCache<K, V>();
    }
}

