/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.IsValidLinkedDeque;
import com.github.benmanes.caffeine.cache.LinkedDeque;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.References;
import com.github.benmanes.caffeine.cache.TimerWheel;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsValidBoundedLocalCache<K, V>
extends TypeSafeDiagnosingMatcher<BoundedLocalCache<K, V>> {
    DescriptionBuilder desc;

    public void describeTo(Description description) {
        description.appendText("valid bounded cache");
        if (this.desc.getDescription() != description) {
            description.appendText(this.desc.getDescription().toString());
        }
    }

    protected boolean matchesSafely(BoundedLocalCache<K, V> cache, Description description) {
        this.desc = new DescriptionBuilder(description);
        this.drain(cache);
        this.checkReadBuffer(cache);
        this.checkCache(cache);
        this.checkTimerWheel(cache);
        this.checkEvictionDeque(cache);
        if (!this.desc.matches()) {
            throw new AssertionError((Object)this.desc.getDescription().toString());
        }
        return true;
    }

    private void drain(BoundedLocalCache<K, V> cache) {
        do {
            cache.cleanUp();
        } while (cache.buffersWrites() && cache.writeBuffer().size() > 0);
    }

    private void checkReadBuffer(BoundedLocalCache<K, V> cache) {
        Buffer buffer = cache.readBuffer;
        Awaits.await().until(() -> {
            cache.cleanUp();
            return buffer.size() == 0 && buffer.reads() == buffer.writes();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCache(BoundedLocalCache<K, V> cache) {
        while (true) {
            long remainingNanos = TimeUnit.SECONDS.toNanos(5L);
            long end = System.nanoTime() + remainingNanos;
            try {
                if (cache.evictionLock.tryLock(remainingNanos, TimeUnit.NANOSECONDS)) {
                    cache.evictionLock.unlock();
                    break;
                }
                this.desc.expected("Maintenance lock cannot be acquired");
            }
            catch (InterruptedException ignored) {
                remainingNanos = end - System.nanoTime();
                continue;
            }
            break;
        }
        this.desc.expectThat("Inconsistent size", Integer.valueOf(cache.data.size()), Matchers.is((Object)cache.size()));
        if (cache.evicts()) {
            cache.evictionLock.lock();
            try {
                long weightedSize = cache.weightedSize();
                this.desc.expectThat("overflow", Long.valueOf(cache.maximum()), Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(weightedSize))));
            }
            finally {
                cache.evictionLock.unlock();
            }
        }
        if (cache.isEmpty()) {
            this.desc.expectThat("empty map", cache, IsEmptyMap.emptyMap());
        }
        for (Node node : cache.data.values()) {
            this.checkNode(cache, node, this.desc);
        }
    }

    private void checkTimerWheel(BoundedLocalCache<K, V> cache) {
        if (!cache.expiresVariable()) {
            return;
        }
        Set seen = Sets.newIdentityHashSet();
        for (int i = 0; i < cache.timerWheel().wheel.length; ++i) {
            for (int j = 0; j < cache.timerWheel().wheel[i].length; ++j) {
                Node sentinel = cache.timerWheel().wheel[i][j];
                this.desc.expectThat("Wrong sentinel prev", sentinel.getPreviousInVariableOrder().getNextInVariableOrder(), Matchers.sameInstance((Object)sentinel));
                this.desc.expectThat("Wrong sentinel next", sentinel.getNextInVariableOrder().getPreviousInVariableOrder(), Matchers.sameInstance((Object)sentinel));
                this.desc.expectThat("Sentinel must be first element", sentinel, Matchers.instanceOf(TimerWheel.Sentinel.class));
                for (Node node = sentinel.getNextInVariableOrder(); node != sentinel; node = node.getNextInVariableOrder()) {
                    Node next = node.getNextInVariableOrder();
                    Node prev = node.getPreviousInVariableOrder();
                    long duration = node.getVariableTime() - cache.timerWheel().nanos;
                    this.desc.expectThat("Expired", Long.valueOf(duration), Matchers.greaterThan((Comparable)Long.valueOf(0L)));
                    this.desc.expectThat("Loop detected", Boolean.valueOf(seen.add(node)), Matchers.is((Object)true));
                    this.desc.expectThat("Wrong prev", prev.getNextInVariableOrder(), Matchers.is((Matcher)Matchers.sameInstance((Object)node)));
                    this.desc.expectThat("Wrong next", next.getPreviousInVariableOrder(), Matchers.is((Matcher)Matchers.sameInstance((Object)node)));
                }
            }
        }
        this.desc.expectThat("Timers != Entries", seen, Matchers.hasSize((int)cache.size()));
    }

    private void checkEvictionDeque(BoundedLocalCache<K, V> cache) {
        if (cache.evicts()) {
            ImmutableList deques = ImmutableList.of((Object)cache.accessOrderWindowDeque(), (Object)cache.accessOrderProbationDeque(), (Object)cache.accessOrderProtectedDeque());
            this.checkLinks(cache, deques, this.desc);
            this.checkDeque((LinkedDeque<Node<K, V>>)cache.accessOrderWindowDeque(), this.desc);
            this.checkDeque((LinkedDeque<Node<K, V>>)cache.accessOrderProbationDeque(), this.desc);
        } else if (cache.expiresAfterAccess()) {
            this.checkLinks(cache, ImmutableList.of((Object)cache.accessOrderWindowDeque()), this.desc);
            this.checkDeque((LinkedDeque<Node<K, V>>)cache.accessOrderWindowDeque(), this.desc);
        }
        if (cache.expiresAfterWrite()) {
            this.checkLinks(cache, ImmutableList.of((Object)cache.writeOrderDeque()), this.desc);
            this.checkDeque((LinkedDeque<Node<K, V>>)cache.writeOrderDeque(), this.desc);
        }
    }

    private void checkDeque(LinkedDeque<Node<K, V>> deque, DescriptionBuilder desc) {
        IsValidLinkedDeque.validLinkedDeque().matchesSafely(deque, desc.getDescription());
    }

    private void checkLinks(BoundedLocalCache<K, V> cache, ImmutableList<LinkedDeque<Node<K, V>>> deques, DescriptionBuilder desc) {
        int size = 0;
        long weightedSize = 0L;
        Set seen = Sets.newIdentityHashSet();
        for (LinkedDeque deque : deques) {
            size += deque.size();
            weightedSize += this.scanLinks(cache, seen, deque, desc);
        }
        if (cache.size() != size) {
            desc.expectThat(() -> "deque size " + deques, Integer.valueOf(size), Matchers.is((Object)cache.size()));
        }
        Supplier<String> errorMsg = () -> String.format("Size != list length; pending=%s, additional: %s", cache.writeBuffer().size(), Sets.difference((Set)seen, (Set)ImmutableSet.copyOf(cache.data.values())));
        desc.expectThat(errorMsg, Integer.valueOf(cache.size()), Matchers.is((Object)seen.size()));
        if (cache.evicts()) {
            long weighted = weightedSize;
            long expectedWeightedSize = Math.max(0L, cache.weightedSize());
            Supplier<String> error = () -> String.format("WeightedSize != link weights [%d vs %d] {%d vs %d}", expectedWeightedSize, weighted, seen.size(), cache.size());
            desc.expectThat("non-negative weight", Long.valueOf(weightedSize), Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L))));
            desc.expectThat(error, Long.valueOf(expectedWeightedSize), Matchers.is((Object)weightedSize));
        }
    }

    private long scanLinks(BoundedLocalCache<K, V> cache, Set<Node<K, V>> seen, LinkedDeque<Node<K, V>> deque, DescriptionBuilder desc) {
        long weightedSize = 0L;
        Node prev = null;
        for (Node node : deque) {
            Supplier<String> errorMsg = () -> String.format("Loop detected: %s, saw %s in %s", node, seen, cache);
            desc.expectThat(errorMsg, Boolean.valueOf(seen.add(node)), Matchers.is((Object)true));
            desc.expectThat("wrong previous", (Node)deque.getPrevious((Object)node), Matchers.is(prev));
            desc.expectThat("policyWeight != weight", Integer.valueOf(node.getPolicyWeight()), Matchers.is((Object)node.getWeight()));
            weightedSize += (long)node.getWeight();
            prev = node;
        }
        return weightedSize;
    }

    private void checkNode(BoundedLocalCache<K, V> cache, Node<K, V> node, DescriptionBuilder desc) {
        boolean canCheckWeight;
        Weigher weigher = cache.weigher;
        Object value = node.getValue();
        Object key = node.getKey();
        desc.expectThat("weight", Integer.valueOf(node.getWeight()), Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        boolean bl = canCheckWeight = weigher == CacheSpec.CacheWeigher.RANDOM;
        if (weigher instanceof Async.AsyncWeigher) {
            boolean bl2 = canCheckWeight = ((Async.AsyncWeigher)weigher).delegate == CacheSpec.CacheWeigher.RANDOM;
        }
        if (canCheckWeight) {
            desc.expectThat("weight", Integer.valueOf(node.getWeight()), Matchers.is((Object)weigher.weigh(key, value)));
        }
        if (cache.collectKeys()) {
            if (key != null && value != null) {
                desc.expectThat("inconsistent", Boolean.valueOf(cache.containsKey(key)), Matchers.is((Object)true));
            }
            desc.expectThat("Invalid reference type", node.getKeyReference(), Matchers.instanceOf(References.WeakKeyReference.class));
        } else {
            desc.expectThat("not null key", key, Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        }
        desc.expectThat("found wrong node", (Node)cache.data.get(node.getKeyReference()), Matchers.is(node));
        if (!cache.collectValues()) {
            desc.expectThat("not null value", value, Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            if (key != null && !cache.hasExpired(node, cache.expirationTicker().read())) {
                desc.expectThat(() -> "Could not find key: " + key + ", value: " + value, Boolean.valueOf(cache.containsValue(value)), Matchers.is((Object)true));
            }
        }
        if (cache.refreshAfterWrite()) {
            desc.expectThat("infinite timestamp", Long.valueOf(node.getWriteTime()), Matchers.is((Matcher)Matchers.not((Object)Long.MAX_VALUE)));
        }
        if (value instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)value;
            boolean success = future.isDone() && !future.isCompletedExceptionally();
            desc.expectThat("future is done", Boolean.valueOf(success), Matchers.is((Object)true));
            desc.expectThat("not null value", future.getNow(null), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        }
    }

    public static <K, V> IsValidBoundedLocalCache<K, V> valid() {
        return new IsValidBoundedLocalCache<K, V>();
    }
}

