/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.IsValidBoundedLocalCache;
import com.github.benmanes.caffeine.cache.IsValidUnboundedLocalCache;
import com.github.benmanes.caffeine.cache.LocalAsyncLoadingCache;
import com.github.benmanes.caffeine.cache.UnboundedLocalCache;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsValidCache<K, V>
extends TypeSafeDiagnosingMatcher<Cache<K, V>> {
    Description description;

    public void describeTo(Description description) {
        description.appendText("cache");
        if (this.description != description) {
            description.appendText(description.toString());
        }
    }

    protected boolean matchesSafely(Cache<K, V> cache, Description description) {
        LocalAsyncLoadingCache async;
        this.description = description;
        if (cache instanceof BoundedLocalCache.BoundedLocalManualCache) {
            BoundedLocalCache.BoundedLocalManualCache local = (BoundedLocalCache.BoundedLocalManualCache)cache;
            return IsValidBoundedLocalCache.valid().matchesSafely(local.cache, description);
        }
        if (cache instanceof LocalAsyncLoadingCache.LoadingCacheView && (async = ((LocalAsyncLoadingCache.LoadingCacheView)cache).asyncCache()) instanceof BoundedLocalCache.BoundedLocalAsyncLoadingCache) {
            return IsValidBoundedLocalCache.valid().matchesSafely(((BoundedLocalCache.BoundedLocalAsyncLoadingCache)async).cache, description);
        }
        if (cache instanceof UnboundedLocalCache.UnboundedLocalManualCache) {
            UnboundedLocalCache.UnboundedLocalManualCache local = (UnboundedLocalCache.UnboundedLocalManualCache)cache;
            return IsValidUnboundedLocalCache.valid().matchesSafely(local.cache, description);
        }
        if (cache instanceof LocalAsyncLoadingCache.LoadingCacheView) {
            async = ((LocalAsyncLoadingCache.LoadingCacheView)cache).asyncCache();
            if (async instanceof UnboundedLocalCache.UnboundedLocalAsyncLoadingCache) {
                return IsValidUnboundedLocalCache.valid().matchesSafely(((UnboundedLocalCache.UnboundedLocalAsyncLoadingCache)async).cache, description);
            }
            LocalAsyncLoadingCache.LoadingCacheView view = (LocalAsyncLoadingCache.LoadingCacheView)cache;
            UnboundedLocalCache asyncCache = (UnboundedLocalCache)view.asyncCache().cache();
            return IsValidUnboundedLocalCache.valid().matchesSafely(asyncCache, description);
        }
        return true;
    }

    public static <K, V> IsValidCache<K, V> validCache() {
        return new IsValidCache<K, V>();
    }
}

