/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.LinkedDeque;
import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import com.github.benmanes.caffeine.testing.IsEmptyIterable;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsValidLinkedDeque<E>
extends TypeSafeDiagnosingMatcher<LinkedDeque<E>> {
    public void describeTo(Description description) {
        description.appendText("valid");
    }

    protected boolean matchesSafely(LinkedDeque<E> deque, Description description) {
        DescriptionBuilder desc = new DescriptionBuilder(description);
        if (deque.isEmpty()) {
            this.checkEmpty(deque, desc);
        }
        this.checkIterator(deque, (Iterator<E>)deque.iterator(), desc);
        this.checkIterator(deque, (Iterator<E>)deque.descendingIterator(), desc);
        return desc.matches();
    }

    void checkEmpty(LinkedDeque<? extends E> deque, DescriptionBuilder desc) {
        desc.expectThat("empty deque", deque, IsEmptyIterable.deeplyEmpty());
        desc.expectThat("empty deque", deque.pollFirst(), Matchers.is((Matcher)Matchers.nullValue()));
        desc.expectThat("empty deque", deque.pollLast(), Matchers.is((Matcher)Matchers.nullValue()));
        desc.expectThat("empty deque", deque.poll(), Matchers.is((Matcher)Matchers.nullValue()));
    }

    void checkIterator(LinkedDeque<E> deque, Iterator<E> iterator, DescriptionBuilder desc) {
        Set seen = Sets.newIdentityHashSet();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.checkElement(deque, element, desc);
            Supplier<String> errorMsg = () -> String.format("Loop detected: %s in %s", element, seen);
            desc.expectThat(errorMsg, Boolean.valueOf(seen.add(element)), Matchers.is((Object)true));
        }
        desc.expectThat("deque size", deque, Matchers.hasSize((int)seen.size()));
    }

    void checkElement(LinkedDeque<E> deque, E element, DescriptionBuilder desc) {
        Object first = deque.peekFirst();
        Object last = deque.peekLast();
        if (element == first) {
            desc.expectThat("not null prev", deque.getPrevious(element), Matchers.is((Matcher)Matchers.nullValue()));
        }
        if (element == last) {
            desc.expectThat("not null next", deque.getNext(element), Matchers.is((Matcher)Matchers.nullValue()));
        }
        if (element != first && element != last) {
            desc.expectThat("empty deque", deque.getPrevious(element), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            desc.expectThat("empty deque", deque.getNext(element), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        }
    }

    public static <E> IsValidLinkedDeque<E> validLinkedDeque() {
        return new IsValidLinkedDeque<E>();
    }
}

