/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.IsValidBoundedLocalCache;
import com.github.benmanes.caffeine.cache.IsValidUnboundedLocalCache;
import com.github.benmanes.caffeine.cache.LocalAsyncCache;
import com.github.benmanes.caffeine.cache.UnboundedLocalCache;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsValidMapView<K, V>
extends TypeSafeDiagnosingMatcher<Map<K, V>> {
    Description description;

    public void describeTo(Description description) {
        description.appendText("cache");
        if (this.description != description) {
            description.appendText(this.description.toString());
        }
    }

    protected boolean matchesSafely(Map<K, V> map, Description description) {
        this.description = description;
        if (map instanceof BoundedLocalCache) {
            BoundedLocalCache cache = (BoundedLocalCache)map;
            return IsValidBoundedLocalCache.valid().matchesSafely(cache, description);
        }
        if (map instanceof UnboundedLocalCache) {
            UnboundedLocalCache cache = (UnboundedLocalCache)map;
            return IsValidUnboundedLocalCache.valid().matchesSafely(cache, description);
        }
        if (map instanceof LocalAsyncCache.AsMapView) {
            LocalAsyncCache.AsMapView asMap = (LocalAsyncCache.AsMapView)map;
            if (asMap.delegate instanceof BoundedLocalCache) {
                return IsValidBoundedLocalCache.valid().matchesSafely((BoundedLocalCache)asMap.delegate, description);
            }
            if (asMap.delegate instanceof UnboundedLocalCache) {
                return IsValidUnboundedLocalCache.valid().matchesSafely((UnboundedLocalCache)asMap.delegate, description);
            }
        }
        return true;
    }

    public static <K, V> IsValidMapView<K, V> validAsMap() {
        return new IsValidMapView<K, V>();
    }
}

