/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.UnboundedLocalCache;
import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsValidUnboundedLocalCache<K, V>
extends TypeSafeDiagnosingMatcher<UnboundedLocalCache<K, V>> {
    DescriptionBuilder desc;

    public void describeTo(Description description) {
        description.appendText("valid unbounded cache");
        if (this.desc.getDescription() != description) {
            description.appendText(this.desc.getDescription().toString());
        }
    }

    protected boolean matchesSafely(UnboundedLocalCache<K, V> map, Description description) {
        this.desc = new DescriptionBuilder(description);
        this.checkMap(map, this.desc);
        return this.desc.matches();
    }

    private void checkMap(UnboundedLocalCache<K, V> map, DescriptionBuilder desc) {
        if (map.isEmpty()) {
            desc.expectThat("empty map", map, IsEmptyMap.emptyMap());
        }
        map.data.forEach((key, value) -> {
            desc.expectThat("non null key", key, Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            desc.expectThat("non null value", value, Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            if (value instanceof CompletableFuture) {
                CompletableFuture future = (CompletableFuture)value;
                boolean success = future.isDone() && !future.isCompletedExceptionally();
                desc.expectThat("future is done", Boolean.valueOf(success), Matchers.is((Object)true));
                desc.expectThat("not null value", future.getNow(null), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            }
        });
    }

    public static <K, V> IsValidUnboundedLocalCache<K, V> valid() {
        return new IsValidUnboundedLocalCache<K, V>();
    }
}

