/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AbstractLinkedDeque;
import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.LinkedDeque;
import com.github.benmanes.caffeine.cache.WriteOrderDeque;
import com.github.benmanes.caffeine.testing.IsEmptyIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class LinkedDequeTest {
    static final int SIZE = 100;

    @Test(dataProvider="empty")
    public void clear_whenEmpty(Deque<?> deque) {
        deque.clear();
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="full")
    public void clear_whenPopulated(Deque<?> deque) {
        deque.clear();
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void isEmpty_whenEmpty(Deque<?> deque) {
        MatcherAssert.assertThat((Object)deque.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="full")
    public void isEmpty_whenPopulated(Deque<?> deque) {
        MatcherAssert.assertThat((Object)deque.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="empty")
    public void size_whenEmpty(Deque<?> deque) {
        MatcherAssert.assertThat((Object)deque.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="full")
    public void size_whenPopulated(Deque<?> deque) {
        MatcherAssert.assertThat((Object)deque.size(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((Object)Iterables.size(deque), (Matcher)Matchers.is((Object)100));
    }

    @Test(dataProvider="empty")
    public void contains_withNull(Deque<?> deque) {
        MatcherAssert.assertThat((Object)deque.contains(null), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void contains_whenFound(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.contains(Iterables.get(deque, (int)50)), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="full")
    public void contains_whenNotFound(LinkedDeque<LinkedValue> deque) {
        LinkedValue unlinked = new LinkedValue(1);
        MatcherAssert.assertThat((Object)deque.contains((Object)unlinked), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void moveToFront_first(LinkedDeque<LinkedValue> deque) {
        this.checkMoveToFront(deque, (LinkedValue)deque.getFirst());
    }

    @Test(dataProvider="full")
    public void moveToFront_middle(LinkedDeque<LinkedValue> deque) {
        this.checkMoveToFront(deque, (LinkedValue)Iterables.get(deque, (int)50));
    }

    @Test(dataProvider="full")
    public void moveToFront_last(LinkedDeque<LinkedValue> deque) {
        this.checkMoveToFront(deque, (LinkedValue)deque.getLast());
    }

    private void checkMoveToFront(LinkedDeque<LinkedValue> deque, LinkedValue element) {
        deque.moveToFront((Object)element);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)element));
        MatcherAssert.assertThat((Object)deque.size(), (Matcher)Matchers.is((Object)100));
    }

    @Test(dataProvider="full")
    public void moveToBack_first(LinkedDeque<LinkedValue> deque) {
        this.checkMoveToBack(deque, (LinkedValue)deque.getFirst());
    }

    @Test(dataProvider="full")
    public void moveToBack_middle(LinkedDeque<LinkedValue> deque) {
        this.checkMoveToBack(deque, (LinkedValue)Iterables.get(deque, (int)50));
    }

    @Test(dataProvider="full")
    public void moveToBack_last(LinkedDeque<LinkedValue> deque) {
        this.checkMoveToBack(deque, (LinkedValue)deque.getLast());
    }

    private void checkMoveToBack(LinkedDeque<LinkedValue> deque, LinkedValue element) {
        deque.moveToBack((Object)element);
        MatcherAssert.assertThat((Object)deque.size(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.getLast()), (Matcher)Matchers.is((Object)element));
    }

    @Test(dataProvider="empty")
    public void isFirst_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.isFirst((Object)new LinkedValue(0)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)deque.isFirst(null), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void isFirst_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.first;
        MatcherAssert.assertThat((Object)deque.isFirst((Object)first), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.first), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty")
    public void isLast_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.isLast((Object)new LinkedValue(0)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)deque.isLast(null), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void isLast_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue last = (LinkedValue)deque.last;
        MatcherAssert.assertThat((Object)deque.isLast((Object)last), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.last), (Matcher)Matchers.is((Object)last));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)last), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty")
    public void peek_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peek()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="full")
    public void peek_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.first;
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peek()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.first), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty")
    public void peekFirst_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="full")
    public void peekFirst_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.first;
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.first), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty")
    public void peekLast_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="full")
    public void peekLast_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue last = (LinkedValue)deque.last;
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)last));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.last), (Matcher)Matchers.is((Object)last));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)last), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void getFirst_whenEmpty(LinkedDeque<LinkedValue> deque) {
        deque.getFirst();
    }

    @Test(dataProvider="full")
    public void getFirst_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.first;
        MatcherAssert.assertThat((Object)((LinkedValue)deque.getFirst()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.first), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void getLast_whenEmpty(LinkedDeque<LinkedValue> deque) {
        deque.getLast();
    }

    @Test(dataProvider="full")
    public void getLast_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue last = (LinkedValue)deque.last;
        MatcherAssert.assertThat((Object)((LinkedValue)deque.getLast()), (Matcher)Matchers.is((Object)last));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.last), (Matcher)Matchers.is((Object)last));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)last), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void element_whenEmpty(LinkedDeque<LinkedValue> deque) {
        deque.element();
    }

    @Test(dataProvider="full")
    public void element_whenPopulated(AbstractLinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.first;
        MatcherAssert.assertThat((Object)((LinkedValue)deque.element()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.first), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="empty")
    public void offer_whenEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(1);
        MatcherAssert.assertThat((Object)deque.offer((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="full")
    public void offer_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(100);
        MatcherAssert.assertThat((Object)deque.offer((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)101));
    }

    @Test(dataProvider="full")
    public void offer_whenLinked(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.offer((Object)((LinkedValue)deque.peek())), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
    }

    @Test(dataProvider="empty")
    public void offerFirst_whenEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(1);
        MatcherAssert.assertThat((Object)deque.offerFirst((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="full")
    public void offerFirst_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(100);
        MatcherAssert.assertThat((Object)deque.offerFirst((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)101));
    }

    @Test(dataProvider="full")
    public void offerFirst_whenLinked(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.offerFirst((Object)((LinkedValue)deque.peek())), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
    }

    @Test(dataProvider="empty")
    public void offerLast_whenEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(1);
        MatcherAssert.assertThat((Object)deque.offerLast((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="full")
    public void offerLast_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(100);
        MatcherAssert.assertThat((Object)deque.offerLast((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)101));
    }

    @Test(dataProvider="full")
    public void offerLast_whenLinked(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.offerLast((Object)((LinkedValue)deque.peek())), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)100));
    }

    @Test(dataProvider="empty")
    public void add_whenEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(1);
        MatcherAssert.assertThat((Object)deque.add((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="full")
    public void add_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(100);
        MatcherAssert.assertThat((Object)deque.add((Object)value), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)101));
    }

    @Test(dataProvider="full")
    public void add_whenLinked(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.add((Object)((LinkedValue)deque.peek())), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="empty")
    public void addFirst_whenEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(1);
        deque.addFirst((Object)value);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="full")
    public void addFirst_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(100);
        deque.addFirst((Object)value);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)101));
    }

    @Test(dataProvider="full", expectedExceptions={IllegalArgumentException.class})
    public void addFirst_whenLinked(LinkedDeque<LinkedValue> deque) {
        deque.addFirst((Object)((LinkedValue)deque.peek()));
    }

    @Test(dataProvider="empty")
    public void addLast_whenEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(1);
        deque.addLast((Object)value);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="full")
    public void addLast_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(100);
        deque.addLast((Object)value);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)101));
    }

    @Test(dataProvider="full", expectedExceptions={IllegalArgumentException.class})
    public void addLast_whenLinked(LinkedDeque<LinkedValue> deque) {
        deque.addLast((Object)((LinkedValue)deque.peek()));
    }

    @Test(dataProvider="empty")
    public void addAll_withEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.addAll((Collection)ImmutableList.of()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void addAll_withPopulated(LinkedDeque<LinkedValue> deque) {
        ArrayList<LinkedValue> expected = new ArrayList<LinkedValue>();
        this.populate(expected);
        MatcherAssert.assertThat((Object)deque.addAll(expected), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.contains((Object[])expected.toArray(new LinkedValue[0])));
    }

    @Test(dataProvider="full")
    public void addAll_withSelf(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.addAll(deque), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="empty")
    public void poll_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.poll()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="full")
    public void poll_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peek();
        MatcherAssert.assertThat((Object)((LinkedValue)deque.poll()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void poll_toEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value;
        while ((value = (LinkedValue)deque.poll()) != null) {
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void pollFirst_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.pollFirst()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="full")
    public void pollFirst_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)((LinkedValue)deque.pollFirst()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void pollFirst_toEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value;
        while ((value = (LinkedValue)deque.pollFirst()) != null) {
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void pollLast_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.pollLast()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="full")
    public void pollLast_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue last = (LinkedValue)deque.peekLast();
        MatcherAssert.assertThat((Object)((LinkedValue)deque.pollLast()), (Matcher)Matchers.is((Object)last));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)last), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void pollLast_toEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value;
        while ((value = (LinkedValue)deque.pollLast()) != null) {
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void remove_whenEmpty(LinkedDeque<LinkedValue> deque) {
        deque.remove();
    }

    @Test(dataProvider="full")
    public void remove_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)((LinkedValue)deque.remove()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void remove_toEmpty(LinkedDeque<LinkedValue> deque) {
        while (!deque.isEmpty()) {
            LinkedValue value = (LinkedValue)deque.remove();
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void removeElement_notFound(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.remove((Object)new LinkedValue(0)), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeElement_whenFound(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)deque.remove((Object)first), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeElement_toEmpty(LinkedDeque<LinkedValue> deque) {
        while (!deque.isEmpty()) {
            LinkedValue value = (LinkedValue)deque.peek();
            MatcherAssert.assertThat((Object)deque.remove((Object)value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void removeFirst_whenEmpty(LinkedDeque<LinkedValue> deque) {
        deque.removeFirst();
    }

    @Test(dataProvider="full")
    public void removeFirst_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)((LinkedValue)deque.removeFirst()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeFirst_toEmpty(LinkedDeque<LinkedValue> deque) {
        while (!deque.isEmpty()) {
            LinkedValue value = (LinkedValue)deque.removeFirst();
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void removeLast_whenEmpty(LinkedDeque<LinkedValue> deque) {
        deque.removeLast();
    }

    @Test(dataProvider="full")
    public void removeLast_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue last = (LinkedValue)deque.peekLast();
        MatcherAssert.assertThat((Object)((LinkedValue)deque.removeLast()), (Matcher)Matchers.is((Object)last));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)last), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeLast_toEmpty(LinkedDeque<LinkedValue> deque) {
        while (!deque.isEmpty()) {
            LinkedValue value = (LinkedValue)deque.removeLast();
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void removeFirstOccurrence_notFound(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.removeFirstOccurrence((Object)new LinkedValue(0)), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeFirstOccurrence_whenFound(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)deque.removeFirstOccurrence((Object)first), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeFirstOccurrence_toEmpty(LinkedDeque<LinkedValue> deque) {
        while (!deque.isEmpty()) {
            LinkedValue value = (LinkedValue)deque.peek();
            MatcherAssert.assertThat((Object)deque.removeFirstOccurrence((Object)value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void removeLastOccurrence_notFound(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.removeLastOccurrence((Object)new LinkedValue(0)), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeLastOccurrence_whenFound(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)deque.removeLastOccurrence((Object)first), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeLastOccurrence_toEmpty(LinkedDeque<LinkedValue> deque) {
        while (!deque.isEmpty()) {
            LinkedValue value = (LinkedValue)deque.peek();
            MatcherAssert.assertThat((Object)deque.removeLastOccurrence((Object)value), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void removeAll_withEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.removeAll((Collection)ImmutableList.of()), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="full")
    public void remove_withPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)deque.removeAll((Collection)ImmutableList.of((Object)first)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void removeAll_toEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)deque.removeAll((Collection)ImmutableList.copyOf(deque)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty")
    public void push_whenEmpty(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(1);
        deque.push((Object)value);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)1));
    }

    @Test(dataProvider="full")
    public void push_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue value = new LinkedValue(100);
        deque.push((Object)value);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekFirst()), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peekLast()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)101));
    }

    @Test(dataProvider="full", expectedExceptions={IllegalArgumentException.class})
    public void push_whenLinked(LinkedDeque<LinkedValue> deque) {
        deque.push((Object)((LinkedValue)deque.peek()));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void pop_whenEmpty(LinkedDeque<LinkedValue> deque) {
        deque.pop();
    }

    @Test(dataProvider="full")
    public void pop_whenPopulated(LinkedDeque<LinkedValue> deque) {
        LinkedValue first = (LinkedValue)deque.peekFirst();
        MatcherAssert.assertThat((Object)((LinkedValue)deque.pop()), (Matcher)Matchers.is((Object)first));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
        MatcherAssert.assertThat((Object)deque.contains((Object)first), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void pop_toEmpty(LinkedDeque<LinkedValue> deque) {
        while (!deque.isEmpty()) {
            LinkedValue value = (LinkedValue)deque.pop();
            MatcherAssert.assertThat((Object)deque.contains((Object)value), (Matcher)Matchers.is((Object)false));
        }
        MatcherAssert.assertThat(deque, (Matcher)Matchers.is(IsEmptyIterable.deeplyEmpty()));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void iterator_noMoreElements(LinkedDeque<LinkedValue> deque) {
        deque.iterator().next();
    }

    @Test(dataProvider="empty")
    public void iterator_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.iterator().peek()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)deque.iterator().hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void iterator_whenWarmed(LinkedDeque<LinkedValue> deque) {
        ArrayList<LinkedValue> expected = new ArrayList<LinkedValue>();
        this.populate(expected);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.peek()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)Iterators.elementsEqual((Iterator)deque.iterator(), expected.iterator()), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="full")
    public void iterator_removal(LinkedDeque<LinkedValue> deque) {
        LinkedDeque.PeekingIterator iterator = deque.iterator();
        LinkedValue value = (LinkedValue)iterator.next();
        iterator.remove();
        int remaining = 0;
        while (iterator.hasNext()) {
            MatcherAssert.assertThat((Object)((LinkedValue)iterator.next()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
            ++remaining;
        }
        MatcherAssert.assertThat((Object)remaining, (Matcher)Matchers.is((Object)99));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void descendingIterator_noMoreElements(LinkedDeque<LinkedValue> deque) {
        deque.descendingIterator().next();
    }

    @Test(dataProvider="empty")
    public void descendingIterator_whenEmpty(LinkedDeque<LinkedValue> deque) {
        MatcherAssert.assertThat((Object)((LinkedValue)deque.descendingIterator().peek()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)deque.descendingIterator().hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="full")
    public void descendingIterator_whenWarmed(LinkedDeque<LinkedValue> deque) {
        ArrayList<LinkedValue> expected = new ArrayList<LinkedValue>();
        this.populate(expected);
        Collections.reverse(expected);
        MatcherAssert.assertThat((Object)((LinkedValue)deque.descendingIterator().peek()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)Iterators.elementsEqual((Iterator)deque.descendingIterator(), expected.iterator()), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="full")
    public void descendingIterator_removal(LinkedDeque<LinkedValue> deque) {
        LinkedDeque.PeekingIterator iterator = deque.descendingIterator();
        LinkedValue value = (LinkedValue)iterator.next();
        iterator.remove();
        int remaining = 0;
        while (iterator.hasNext()) {
            MatcherAssert.assertThat((Object)((LinkedValue)iterator.next()), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
            ++remaining;
        }
        MatcherAssert.assertThat((Object)remaining, (Matcher)Matchers.is((Object)99));
        MatcherAssert.assertThat(deque, (Matcher)Matchers.hasSize((int)99));
    }

    @Test(dataProvider="full")
    public void concat(LinkedDeque<LinkedValue> deque) {
        ImmutableList expect = ImmutableList.copyOf((Iterator)Iterators.concat((Iterator)deque.iterator(), (Iterator)deque.descendingIterator()));
        Iterable actual = () -> LinkedDeque.PeekingIterator.concat((LinkedDeque.PeekingIterator)deque.iterator(), (LinkedDeque.PeekingIterator)deque.descendingIterator());
        MatcherAssert.assertThat(actual, (Matcher)Matchers.contains((Object[])expect.toArray(new LinkedValue[0])));
    }

    @Test(dataProvider="empty", expectedExceptions={NoSuchElementException.class})
    public void concat_noMoreElements(LinkedDeque<LinkedValue> deque) {
        LinkedDeque.PeekingIterator.concat((LinkedDeque.PeekingIterator)deque.iterator(), (LinkedDeque.PeekingIterator)deque.iterator()).next();
    }

    @Test(dataProvider="full")
    public void comparing(LinkedDeque<LinkedValue> deque) {
        ImmutableList expect = ImmutableList.copyOf((Iterator)Iterators.concat((Iterator)deque.iterator(), (Iterator)deque.descendingIterator()));
        LinkedDeque.PeekingIterator actual = LinkedDeque.PeekingIterator.comparing((LinkedDeque.PeekingIterator)deque.iterator(), (LinkedDeque.PeekingIterator)deque.descendingIterator(), (a, b) -> 1);
        MatcherAssert.assertThat((Object)((LinkedValue)actual.peek()), (Matcher)Matchers.is((Object)((LinkedValue)expect.get(0))));
        MatcherAssert.assertThat(() -> actual, (Matcher)Matchers.contains((Object[])expect.toArray(new LinkedValue[0])));
    }

    @Test(dataProvider="full")
    public void comparing_uneven(LinkedDeque<LinkedValue> deque) {
        LinkedDeque.PeekingIterator empty = new AccessOrderDeque().iterator();
        LinkedDeque.PeekingIterator left = LinkedDeque.PeekingIterator.comparing((LinkedDeque.PeekingIterator)deque.iterator(), (LinkedDeque.PeekingIterator)empty, (a, b) -> 1);
        LinkedDeque.PeekingIterator right = LinkedDeque.PeekingIterator.comparing((LinkedDeque.PeekingIterator)deque.iterator(), (LinkedDeque.PeekingIterator)empty, (a, b) -> 1);
        MatcherAssert.assertThat((Object)left.peek(), (Matcher)Matchers.is((Object)deque.getFirst()));
        MatcherAssert.assertThat((Object)right.peek(), (Matcher)Matchers.is((Object)deque.getFirst()));
    }

    @DataProvider(name="empty")
    public Object[][] providesEmptyDeque() {
        return new Object[][]{{new AccessOrderDeque()}, {new WriteOrderDeque()}};
    }

    @DataProvider(name="full")
    public Object[][] providesWarmedDeque() {
        AccessOrderDeque accessOrder = new AccessOrderDeque();
        WriteOrderDeque writeOrder = new WriteOrderDeque();
        this.populate((Collection<LinkedValue>)accessOrder);
        this.populate((Collection<LinkedValue>)writeOrder);
        return new Object[][]{{accessOrder}, {writeOrder}};
    }

    void populate(Collection<LinkedValue> collection) {
        for (int i = 0; i < 100; ++i) {
            collection.add(new LinkedValue(i));
        }
    }

    static final class LinkedValue
    implements AccessOrderDeque.AccessOrder<LinkedValue>,
    WriteOrderDeque.WriteOrder<LinkedValue> {
        LinkedValue prev;
        LinkedValue next;
        final int value;

        LinkedValue(int value) {
            this.value = value;
        }

        public LinkedValue getPreviousInAccessOrder() {
            return this.prev;
        }

        public void setPreviousInAccessOrder(LinkedValue prev) {
            this.prev = prev;
        }

        public LinkedValue getNextInAccessOrder() {
            return this.next;
        }

        public void setNextInAccessOrder(LinkedValue next) {
            this.next = next;
        }

        public LinkedValue getPreviousInWriteOrder() {
            return this.prev;
        }

        public void setPreviousInWriteOrder(LinkedValue prev) {
            this.prev = prev;
        }

        public LinkedValue getNextInWriteOrder() {
            return this.next;
        }

        public void setNextInWriteOrder(LinkedValue next) {
            this.next = next;
        }

        public boolean equals(Object o) {
            return o instanceof LinkedValue && this.value == ((LinkedValue)o).value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return String.format("value=%s prev=%s, next=%s]", this.value, this.prev == null ? null : Integer.valueOf(this.prev.value), this.next == null ? null : Integer.valueOf(this.next.value));
        }
    }
}

