/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.cache.testing.RemovalNotification;
import com.github.benmanes.caffeine.testing.Awaits;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class LoadingCacheTest {
    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void get_null(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.get(null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NULL})
    public void get_absent_null(LoadingCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.absentKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
    }

    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.EXCEPTIONAL})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void get_absent_failure(LoadingCache<Integer, Integer> cache, CacheContext context) {
        try {
            cache.get((Object)context.absentKey());
        }
        finally {
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(1L)));
        }
    }

    @CacheSpec
    @CheckNoWriter
    @Test(dataProvider="caches")
    public void get_absent(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        Integer value = (Integer)cache.get((Object)key);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)(-key.intValue())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(1L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void get_present(LoadingCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.firstKey())), (Matcher)Matchers.is((Object)(-context.firstKey().intValue())));
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.middleKey())), (Matcher)Matchers.is((Object)(-context.middleKey().intValue())));
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.lastKey())), (Matcher)Matchers.is((Object)(-context.lastKey().intValue())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(3L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAll_iterable_null(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(null);
    }

    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void getAll_iterable_nullKey(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(Collections.singletonList(null));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_iterable_empty(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAll((Iterable)ImmutableList.of());
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
    }

    @CacheSpec
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void getAll_immutable(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(context.absentKeys()).clear();
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NULL})
    public void getAll_absent_null(LoadingCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.getAll(context.absentKeys()), (Matcher)Matchers.is((Object)ImmutableMap.of()));
    }

    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.BULK_NULL})
    @Test(dataProvider="caches", expectedExceptions={Exception.class})
    public void getAll_absent_bulkNull(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.getAll(context.absentKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.EXCEPTIONAL, CacheSpec.Loader.BULK_EXCEPTIONAL})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void getAll_absent_failure(LoadingCache<Integer, Integer> cache, CacheContext context) {
        int loadFailures;
        int misses;
        try {
            cache.getAll(context.absentKeys());
            misses = context.absentKeys().size();
            loadFailures = context.loader().isBulk() ? 1 : (context.isAsync() ? misses : 1);
        }
        catch (Throwable throwable) {
            int misses2 = context.absentKeys().size();
            int loadFailures2 = context.loader().isBulk() ? 1 : (context.isAsync() ? misses2 : 1);
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses2)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures2)));
            throw throwable;
        }
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.EXCEPTIONAL, CacheSpec.Loader.BULK_EXCEPTIONAL})
    @Test(dataProvider="caches", expectedExceptions={IllegalStateException.class})
    public void getAll_absent_failure_iterable(LoadingCache<Integer, Integer> cache, CacheContext context) {
        int loadFailures;
        int misses;
        try {
            cache.getAll(() -> context.absentKeys().iterator());
            misses = context.absentKeys().size();
            loadFailures = context.loader().isBulk() ? 1 : (context.isAsync() ? misses : 1);
        }
        catch (Throwable throwable) {
            int misses2 = context.absentKeys().size();
            int loadFailures2 = context.loader().isBulk() ? 1 : (context.isAsync() ? misses2 : 1);
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses2)).and((Matcher)HasStats.hasHitCount(0L)));
            MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures2)));
            throw throwable;
        }
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(misses)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(loadFailures)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_absent(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAll(context.absentKeys());
        int count = context.absentKeys().size();
        int loads = context.loader().isBulk() ? 1 : count;
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)count));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(count)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(loads)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_partial(LoadingCache<Integer, Integer> cache, CacheContext context) {
        HashMap<Integer, Integer> expect = new HashMap<Integer, Integer>();
        expect.put(context.firstKey(), -context.firstKey().intValue());
        expect.put(context.middleKey(), -context.middleKey().intValue());
        expect.put(context.lastKey(), -context.lastKey().intValue());
        Map result = cache.getAll(expect.keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expect)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(expect.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_full(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Map result = cache.getAll(context.original().keySet());
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(result.size())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_duplicates(LoadingCache<Integer, Integer> cache, CacheContext context) {
        ImmutableSet absentKeys = ImmutableSet.copyOf((Iterable)Iterables.limit(context.absentKeys(), (int)Ints.saturatedCast((long)(context.maximum().max() - context.initialSize()))));
        Iterable keys = Iterables.concat((Iterable)absentKeys, (Iterable)absentKeys, context.original().keySet(), context.original().keySet());
        Map result = cache.getAll(keys);
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasMissCount(absentKeys.size()));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasHitCount(context.initialSize()));
        MatcherAssert.assertThat(result.keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableSet.copyOf((Iterable)keys))));
        int loads = context.loader().isBulk() ? 1 : absentKeys.size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(loads)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_absent(LoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_partial(LoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_present(LoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys).keySet());
        MatcherAssert.assertThat(result, (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.BULK_NEGATIVE_EXCEEDS}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void getAll_present_ordered_exceeds(LoadingCache<Integer, Integer> cache, CacheContext context) {
        ArrayList<Integer> keys = new ArrayList<Integer>(context.original().keySet());
        keys.addAll(context.absentKeys());
        Collections.shuffle(keys);
        ArrayList result = new ArrayList(cache.getAll(keys).keySet());
        MatcherAssert.assertThat(result.subList(0, keys.size()), (Matcher)Matchers.is((Matcher)Matchers.equalTo(keys)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, keys={CacheSpec.ReferenceType.STRONG}, writer={CacheSpec.Writer.DISABLED})
    public void getAll_jdk8186171(CacheContext context) {
        LoadingCache cache = context.build(key -> null);
        class Key {
            Key() {
            }

            public int hashCode() {
                return 0;
            }
        }
        ArrayList<Key> keys = new ArrayList<Key>();
        int i = 0;
        while ((long)i < CacheSpec.Population.FULL.size()) {
            keys.add(new Key());
            ++i;
        }
        Key key2 = (Key)Iterables.getLast(keys);
        Integer value = context.absentValue();
        cache.put((Object)key2, (Object)value);
        Map result = cache.getAll(keys);
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableMap.of((Object)key2, (Object)value))));
    }

    @CheckNoWriter
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    @Test(dataProvider="caches", expectedExceptions={NullPointerException.class})
    public void refresh_null(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.refresh(null);
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, compute={CacheSpec.Compute.SYNC}, executor={CacheSpec.CacheExecutor.DIRECT}, loader={CacheSpec.Loader.NULL}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void refresh_remove(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.refresh((Object)context.firstKey());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() - 1L)));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(executor={CacheSpec.CacheExecutor.DIRECT}, loader={CacheSpec.Loader.EXCEPTIONAL}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void refresh_failure(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.refresh((Object)context.absentKey());
        cache.refresh((Object)context.firstKey());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(2L)));
    }

    @CheckNoWriter
    @CacheSpec(loader={CacheSpec.Loader.NULL})
    @Test(dataProvider="caches")
    public void refresh_absent_null(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.refresh((Object)context.absentKey());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void refresh_absent(LoadingCache<Integer, Integer> cache, CacheContext context) {
        cache.refresh((Object)context.absentKey());
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)(1L + context.initialSize())));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)context.absentKey())), (Matcher)Matchers.is((Object)(-context.absentKey().intValue())));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, loader={CacheSpec.Loader.NULL}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void refresh_present_null(LoadingCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.refresh((Object)key);
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(0L)).and((Matcher)HasStats.hasLoadFailureCount(count)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)(context.initialSize() - (long)count)));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.EXPLICIT));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void refresh_present_sameValue(LoadingCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.refresh((Object)key);
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(0L)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
        for (Integer key : context.firstMiddleLastKeys()) {
            MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key)), (Matcher)Matchers.is((Object)context.original().get(key)));
        }
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(loader={CacheSpec.Loader.IDENTITY}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void refresh_present_differentValue(LoadingCache<Integer, Integer> cache, CacheContext context) {
        for (Integer key : context.firstMiddleLastKeys()) {
            cache.refresh((Object)key);
            MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key)), (Matcher)Matchers.is((Object)key));
        }
        int count = context.firstMiddleLastKeys().size();
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasMissCount(0L)).and((Matcher)HasStats.hasHitCount(count)));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(count)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, executor={CacheSpec.CacheExecutor.THREADED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void refresh_conflict(CacheContext context) {
        AtomicBoolean refresh = new AtomicBoolean();
        Integer key = context.absentKey();
        Integer original = 1;
        Integer updated = 2;
        Integer refreshed = 3;
        LoadingCache cache = context.build(k -> {
            Awaits.await().untilTrue(refresh);
            return refreshed;
        });
        cache.put((Object)key, (Object)original);
        cache.refresh((Object)key);
        MatcherAssert.assertThat((Object)cache.asMap().put(key, updated), (Matcher)Matchers.is((Object)original));
        refresh.set(true);
        Awaits.await().until(() -> context.consumedNotifications().size(), Matchers.is((Object)2));
        List removed = context.consumedNotifications().stream().map(RemovalNotification::getValue).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)updated));
        MatcherAssert.assertThat(removed, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{original, refreshed}));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 2, RemovalCause.REPLACED));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, executor={CacheSpec.CacheExecutor.THREADED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void refresh_invalidate(CacheContext context) {
        AtomicBoolean refresh = new AtomicBoolean();
        Integer key = context.absentKey();
        Integer original = 1;
        Integer refreshed = 2;
        LoadingCache cache = context.build(k -> {
            Awaits.await().untilTrue(refresh);
            return refreshed;
        });
        cache.put((Object)key, (Object)original);
        cache.refresh((Object)key);
        cache.invalidate((Object)key);
        refresh.set(true);
        Awaits.await().until(() -> (Integer)cache.getIfPresent((Object)key), Matchers.is((Object)refreshed));
        Awaits.await().until(() -> cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.EXPLICIT));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void loadAll() throws Exception {
        CacheLoader loader = key -> key;
        loader.loadAll(Collections.emptyList());
    }

    @Test
    public void reload() throws Exception {
        CacheLoader loader = key -> key;
        MatcherAssert.assertThat((Object)((Integer)loader.reload((Object)1, (Object)1)), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void asyncLoad_exception() throws Exception {
        Exception e = new Exception();
        CacheLoader loader = key -> {
            throw e;
        };
        try {
            loader.asyncLoad((Object)1, Runnable::run).join();
        }
        catch (CompletionException ex) {
            MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)e)));
        }
    }

    @Test
    public void asyncLoad() throws Exception {
        CacheLoader loader = key -> key;
        CompletableFuture future = loader.asyncLoad((Object)1, Runnable::run);
        MatcherAssert.assertThat(future.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void asyncLoadAll_exception() throws Exception {
        final Exception e = new Exception();
        CacheLoader<Integer, Integer> loader = new CacheLoader<Integer, Integer>(){

            public Integer load(Integer key) throws Exception {
                throw new AssertionError();
            }

            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) throws Exception {
                throw e;
            }
        };
        try {
            loader.asyncLoadAll(Arrays.asList(1), Runnable::run).join();
        }
        catch (CompletionException ex) {
            MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)e)));
        }
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void asyncLoadAll() throws Throwable {
        CacheLoader loader = key -> key;
        try {
            loader.asyncLoadAll(Collections.emptyList(), Runnable::run).get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test
    public void asyncReload_exception() throws Exception {
        for (Exception e : Arrays.asList(new Exception(), new RuntimeException())) {
            CacheLoader loader = key -> {
                throw e;
            };
            try {
                loader.asyncReload((Object)1, (Object)1, Runnable::run).join();
                Assert.fail();
            }
            catch (CompletionException ex) {
                MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)e)));
            }
        }
    }

    @Test
    public void asyncReload() throws Exception {
        CacheLoader loader = key -> -key.intValue();
        CompletableFuture future = loader.asyncReload((Object)1, (Object)2, Runnable::run);
        MatcherAssert.assertThat(future.get(), (Matcher)Matchers.is((Object)-1));
    }
}

