/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.MpscGrowableArrayQueue;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class MpscGrowableArrayQueueTest {
    private static final int NUM_PRODUCERS = 10;
    private static final int PRODUCE = 100;
    private static final int POPULATED_SIZE = 10;
    private static final int FULL_SIZE = 32;

    @Test(dataProvider="empty")
    public void size_whenEmpty(MpscGrowableArrayQueue<Integer> buffer) {
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="populated")
    public void size_whenPopulated(MpscGrowableArrayQueue<Integer> buffer) {
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)10));
    }

    @Test(dataProvider="empty")
    public void offer_whenEmpty(MpscGrowableArrayQueue<Integer> buffer) {
        MatcherAssert.assertThat((Object)buffer.offer((Object)1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test(dataProvider="populated")
    public void offer_whenPopulated(MpscGrowableArrayQueue<Integer> buffer) {
        MatcherAssert.assertThat((Object)buffer.offer((Object)1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)11));
    }

    @Test(dataProvider="full")
    public void offer_whenFull(MpscGrowableArrayQueue<Integer> buffer) {
        MatcherAssert.assertThat((Object)buffer.offer((Object)1), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)32));
    }

    @Test(dataProvider="empty")
    public void poll_whenEmpty(MpscGrowableArrayQueue<Integer> buffer) {
        MatcherAssert.assertThat((Object)((Integer)buffer.poll()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="populated")
    public void poll_whenPopulated(MpscGrowableArrayQueue<Integer> buffer) {
        MatcherAssert.assertThat((Object)((Integer)buffer.poll()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)9));
    }

    @Test(dataProvider="full")
    public void poll_toEmpty(MpscGrowableArrayQueue<Integer> buffer) {
        while (buffer.poll() != null) {
        }
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="empty")
    public void oneProducer_oneConsumer(MpscGrowableArrayQueue<Integer> buffer) {
        AtomicInteger started = new AtomicInteger();
        AtomicInteger finished = new AtomicInteger();
        ConcurrentTestHarness.execute(() -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)2));
            for (int i = 0; i < 100; ++i) {
                while (!buffer.offer((Object)i)) {
                }
            }
            finished.incrementAndGet();
        });
        ConcurrentTestHarness.execute(() -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)2));
            for (int i = 0; i < 100; ++i) {
                while (buffer.poll() == null) {
                }
            }
            finished.incrementAndGet();
        });
        Awaits.await().untilAtomic(finished, Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="empty")
    public void manyProducers_noConsumer(MpscGrowableArrayQueue<Integer> buffer) {
        AtomicInteger count = new AtomicInteger();
        ConcurrentTestHarness.timeTasks(10, () -> {
            for (int i = 0; i < 100; ++i) {
                if (!buffer.offer((Object)i)) continue;
                count.incrementAndGet();
            }
        });
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)count.get()));
    }

    @Test(dataProvider="empty")
    public void manyProducers_oneConsumer(MpscGrowableArrayQueue<Integer> buffer) {
        AtomicInteger started = new AtomicInteger();
        AtomicInteger finished = new AtomicInteger();
        ConcurrentTestHarness.execute(() -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)11));
            for (int i = 0; i < 1000; ++i) {
                while (buffer.poll() == null) {
                }
            }
            finished.incrementAndGet();
        });
        ConcurrentTestHarness.timeTasks(10, () -> {
            started.incrementAndGet();
            Awaits.await().untilAtomic(started, Matchers.is((Object)11));
            for (int i = 0; i < 100; ++i) {
                while (!buffer.offer((Object)i)) {
                }
            }
            finished.incrementAndGet();
        });
        Awaits.await().untilAtomic(finished, Matchers.is((Object)11));
        MatcherAssert.assertThat((Object)buffer.size(), (Matcher)Matchers.is((Object)0));
    }

    @DataProvider(name="empty")
    public Object[][] providesEmpty() {
        return new Object[][]{{MpscGrowableArrayQueueTest.makePopulated(0)}};
    }

    @DataProvider(name="populated")
    public Object[][] providesPopulated() {
        return new Object[][]{{MpscGrowableArrayQueueTest.makePopulated(10)}};
    }

    @DataProvider(name="full")
    public Object[][] providesFull() {
        return new Object[][]{{MpscGrowableArrayQueueTest.makePopulated(32)}};
    }

    static MpscGrowableArrayQueue<Integer> makePopulated(int items) {
        MpscGrowableArrayQueue buffer = new MpscGrowableArrayQueue(4, 32);
        for (int i = 0; i < items; ++i) {
            buffer.offer((Object)i);
        }
        return buffer;
    }
}

