/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.testing.Threads;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.SerializableTester;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(groups={"slow"}, dataProviderClass=CacheProvider.class)
public final class MultiThreadedTest {
    List<BiConsumer<LoadingCache<Integer, Integer>, Integer>> operations = ImmutableList.of((cache, key) -> cache.get(key), (cache, key) -> cache.getAll((Iterable)ImmutableList.of((Object)key)), (cache, key) -> cache.refresh(key), (cache, key) -> cache.getIfPresent(key), (cache, key) -> cache.get(key, Function.identity()), (cache, key) -> cache.getAllPresent((Iterable)ImmutableList.of((Object)key)), (cache, key) -> cache.put(key, key), (cache, key) -> cache.putAll((Map)ImmutableMap.of((Object)key, (Object)key)), (cache, key) -> cache.invalidate(key), (cache, key) -> cache.invalidateAll((Iterable)ImmutableList.of((Object)key)), (cache, key) -> {
        int random = ThreadLocalRandom.current().nextInt();
        if ((random & 0xFF) == 0) {
            cache.invalidateAll();
        }
    }, (cache, key) -> Preconditions.checkState((cache.estimatedSize() >= 0L ? 1 : 0) != 0), (Object[])new BiConsumer[]{(cache, key) -> cache.stats(), (cache, key) -> cache.cleanUp(), (cache, key) -> cache.asMap().containsKey(key), (cache, key) -> cache.asMap().containsValue(key), (cache, key) -> cache.asMap().isEmpty(), (cache, key) -> Preconditions.checkState((cache.asMap().size() >= 0 ? 1 : 0) != 0), (cache, key) -> cache.asMap().get(key), (cache, key) -> cache.asMap().put(key, key), (cache, key) -> cache.asMap().putAll(ImmutableMap.of((Object)key, (Object)key)), (cache, key) -> cache.asMap().putIfAbsent(key, key), (cache, key) -> cache.asMap().remove(key), (cache, key) -> cache.asMap().remove(key, key), (cache, key) -> cache.asMap().replace(key, key), (cache, key) -> cache.asMap().computeIfAbsent(key, k -> k), (cache, key) -> cache.asMap().computeIfPresent(key, (k, v) -> v), (cache, key) -> cache.asMap().compute(key, (k, v) -> v), (cache, key) -> cache.asMap().merge(key, key, (k, v) -> v), (cache, key) -> {
        int random = ThreadLocalRandom.current().nextInt();
        if ((random & 0xFF) == 0) {
            cache.asMap().clear();
        }
    }, (cache, key) -> cache.asMap().keySet().toArray(new Object[cache.asMap().size()]), (cache, key) -> cache.asMap().values().toArray(new Object[cache.asMap().size()]), (cache, key) -> cache.asMap().entrySet().toArray(new Map.Entry[cache.asMap().size()]), (cache, key) -> cache.hashCode(), (cache, key) -> cache.equals(cache), (cache, key) -> cache.toString(), (cache, key) -> {
        int random = ThreadLocalRandom.current().nextInt();
        if ((random & 0xFF) == 0) {
            SerializableTester.reserialize((Object)cache);
        }
    }});
    List<BiConsumer<AsyncLoadingCache<Integer, Integer>, Integer>> asyncOperations = ImmutableList.of((cache, key) -> cache.getIfPresent(key), (cache, key) -> cache.get(key, k -> key), (cache, key) -> cache.get(key, (k, e) -> CompletableFuture.completedFuture(key)), (cache, key) -> cache.get(key), (cache, key) -> cache.getAll((Iterable)ImmutableList.of((Object)key)), (cache, key) -> cache.put(key, CompletableFuture.completedFuture(key)));

    @Test(dataProvider="caches")
    @CacheSpec(maximumSize={CacheSpec.Maximum.DISABLED}, stats={CacheSpec.Stats.DISABLED}, population={CacheSpec.Population.EMPTY}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, removalListener={CacheSpec.Listener.DEFAULT}, refreshAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MILLISECOND}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG}, writer={CacheSpec.Writer.DISABLED})
    public void concurrent_unbounded(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Threads.runTest(cache, this.operations);
    }

    @Test(dataProvider="caches")
    @CacheSpec(maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.RANDOM}, stats={CacheSpec.Stats.DISABLED}, population={CacheSpec.Population.EMPTY}, expireAfterAccess={CacheSpec.Expire.FOREVER}, removalListener={CacheSpec.Listener.DEFAULT}, expireAfterWrite={CacheSpec.Expire.FOREVER}, refreshAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MILLISECOND}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG}, writer={CacheSpec.Writer.DISABLED})
    public void concurrent_bounded(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Threads.runTest(cache, this.operations);
    }

    @Test(dataProvider="caches")
    @CacheSpec(maximumSize={CacheSpec.Maximum.DISABLED}, stats={CacheSpec.Stats.DISABLED}, population={CacheSpec.Population.EMPTY}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, removalListener={CacheSpec.Listener.DEFAULT}, refreshAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MILLISECOND}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG}, writer={CacheSpec.Writer.DISABLED})
    public void async_concurrent_unbounded(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Threads.runTest(cache, this.asyncOperations);
    }

    @Test(dataProvider="caches")
    @CacheSpec(maximumSize={CacheSpec.Maximum.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT, CacheSpec.CacheWeigher.RANDOM}, stats={CacheSpec.Stats.DISABLED}, population={CacheSpec.Population.EMPTY}, expireAfterAccess={CacheSpec.Expire.FOREVER}, expireAfterWrite={CacheSpec.Expire.FOREVER}, removalListener={CacheSpec.Listener.DEFAULT}, refreshAfterWrite={CacheSpec.Expire.DISABLED, CacheSpec.Expire.ONE_MILLISECOND}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG}, writer={CacheSpec.Writer.DISABLED})
    public void async_concurrent_bounded(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Threads.runTest(cache, this.asyncOperations);
    }
}

