/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.DisabledFuture;
import com.github.benmanes.caffeine.cache.Pacer;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.primitives.Ints;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public final class PacerTest {
    private static final long ONE_MINUTE_IN_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private static final Random random = new Random();
    private static final long NOW = random.nextLong();
    @Mock
    Scheduler scheduler;
    @Mock
    Executor executor;
    @Mock
    Runnable command;
    @Mock
    Future<?> future;
    Pacer pacer;

    @BeforeMethod
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)this);
        this.pacer = new Pacer(this.scheduler);
    }

    @Test
    public void scheduledAfterNextFireTime_skip() {
        this.pacer.nextFireTime = NOW + ONE_MINUTE_IN_NANOS;
        this.pacer.future = this.future;
        long expectedNextFireTime = this.pacer.nextFireTime;
        this.pacer.schedule(this.executor, this.command, NOW, ONE_MINUTE_IN_NANOS);
        MatcherAssert.assertThat((Object)this.pacer.future, (Matcher)Matchers.is(this.future));
        MatcherAssert.assertThat((Object)this.pacer.nextFireTime, (Matcher)Matchers.is((Object)expectedNextFireTime));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.scheduler, this.executor, this.command, this.future});
    }

    @Test
    public void scheduledBeforeNextFireTime_skip() {
        this.pacer.nextFireTime = NOW + ONE_MINUTE_IN_NANOS;
        this.pacer.future = this.future;
        long expectedNextFireTime = this.pacer.nextFireTime;
        long delay = ONE_MINUTE_IN_NANOS - (long)Math.max(1, random.nextInt(Ints.saturatedCast((long)Pacer.TOLERANCE)));
        this.pacer.schedule(this.executor, this.command, NOW, delay);
        MatcherAssert.assertThat((Object)this.pacer.future, (Matcher)Matchers.is(this.future));
        MatcherAssert.assertThat((Object)this.pacer.nextFireTime, (Matcher)Matchers.is((Object)expectedNextFireTime));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.scheduler, this.executor, this.command, this.future});
    }

    @Test
    public void scheduledBeforeNextFireTime_minimumDelay() {
        this.pacer.nextFireTime = NOW + ONE_MINUTE_IN_NANOS;
        this.pacer.future = this.future;
        long delay = random.nextInt(Ints.saturatedCast((long)Pacer.TOLERANCE));
        ((Scheduler)Mockito.doReturn((Object)DisabledFuture.INSTANCE).when((Object)this.scheduler)).schedule(this.executor, this.command, Pacer.TOLERANCE, TimeUnit.NANOSECONDS);
        this.pacer.schedule(this.executor, this.command, NOW, delay);
        MatcherAssert.assertThat((Object)this.pacer.future, (Matcher)Matchers.is((Object)DisabledFuture.INSTANCE));
        MatcherAssert.assertThat((Object)this.pacer.nextFireTime, (Matcher)Matchers.is((Object)(NOW + Pacer.TOLERANCE)));
        ((Future)Mockito.verify(this.future)).cancel(ArgumentMatchers.anyBoolean());
        ((Scheduler)Mockito.verify((Object)this.scheduler)).schedule(this.executor, this.command, Pacer.TOLERANCE, TimeUnit.NANOSECONDS);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executor, this.command});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.scheduler, this.future});
    }

    @Test
    public void scheduledBeforeNextFireTime_customDelay() {
        this.pacer.nextFireTime = NOW + ONE_MINUTE_IN_NANOS;
        this.pacer.future = this.future;
        long delay = Pacer.TOLERANCE + (long)Math.max(1, random.nextInt());
        ((Scheduler)Mockito.doReturn((Object)DisabledFuture.INSTANCE).when((Object)this.scheduler)).schedule(this.executor, this.command, delay, TimeUnit.NANOSECONDS);
        this.pacer.schedule(this.executor, this.command, NOW, delay);
        MatcherAssert.assertThat((Object)this.pacer.future, (Matcher)Matchers.is((Object)DisabledFuture.INSTANCE));
        MatcherAssert.assertThat((Object)this.pacer.nextFireTime, (Matcher)Matchers.is((Object)(NOW + delay)));
        ((Future)Mockito.verify(this.future)).cancel(ArgumentMatchers.anyBoolean());
        ((Scheduler)Mockito.verify((Object)this.scheduler)).schedule(this.executor, this.command, delay, TimeUnit.NANOSECONDS);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executor, this.command});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.scheduler, this.future});
    }
}

