/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.base.UnsafeAccess;

public final class RandomSeedEnforcer {
    static final long PROBE = UnsafeAccess.objectFieldOffset(Thread.class, (String)"threadLocalRandomProbe");
    static final long SEED = UnsafeAccess.objectFieldOffset(Thread.class, (String)"threadLocalRandomSeed");
    static final int RANDOM_PROBE = -1640531527;
    static final int RANDOM_SEED = 1033096058;

    private RandomSeedEnforcer() {
    }

    public static void resetThreadLocalRandom() {
        RandomSeedEnforcer.setThreadLocalRandom(-1640531527, 1033096058);
    }

    public static void setThreadLocalRandom(int probe, int seed) {
        UnsafeAccess.UNSAFE.putInt(Thread.currentThread(), PROBE, probe);
        UnsafeAccess.UNSAFE.putLong(Thread.currentThread(), SEED, seed);
    }
}

