/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Buffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public abstract class ReadBuffer<E>
implements Buffer<E> {
    public static final int BUFFER_SIZE = 32;
    public static final int BUFFER_MASK = 31;
    final Consumer<E> consumer = any -> {};
    final Lock evictionLock = new ReentrantLock();

    public boolean record(E e) {
        return this.offer(e) == 1;
    }

    public void drain() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainTo(this.consumer);
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    public int recorded() {
        return this.writes();
    }

    public int drained() {
        this.drain();
        return this.reads();
    }
}

