/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.RejectingCacheWriter;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.testing.GcFinalization;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(groups={"slow"}, dataProviderClass=CacheProvider.class)
public final class ReferenceTest {
    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.WEAK}, population={CacheSpec.Population.FULL})
    public void identity_keys(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = new Integer(context.firstKey());
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, population={CacheSpec.Population.FULL})
    public void identity_values(Cache<Integer, Integer> cache, CacheContext context) {
        Integer value = new Integer(context.original().get(context.firstKey()));
        MatcherAssert.assertThat((Object)cache.asMap().containsValue(value), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void getIfPresent(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void get(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key, k -> context.absentValue())), (Matcher)Matchers.is((Object)context.absentValue()));
        long count = context.initialSize() - cache.estimatedSize() + 1L;
        if (context.population() != CacheSpec.Population.SINGLETON) {
            MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(1L))));
        }
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void get_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.get((Object)key, Function.identity());
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void getAllPresent(Cache<Integer, Integer> cache, CacheContext context) {
        Set<Integer> keys = context.firstMiddleLastKeys();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)cache.getAllPresent(keys), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void put(Cache<Integer, Integer> cache, CacheContext context) {
        cache.put((Object)context.firstKey(), (Object)context.absentValue());
        cache.put((Object)context.absentKey(), (Object)context.absentValue());
        Mockito.reset((Object[])new Object[]{context.cacheWriter()});
        context.consumedNotifications().clear();
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        long count = context.initialSize() + 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void put_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.put((Object)key, (Object)context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void putAll(Cache<Integer, Integer> cache, CacheContext context) {
        ImmutableMap entries = ImmutableMap.of((Object)context.firstKey(), (Object)context.absentValue(), (Object)context.middleKey(), (Object)context.absentValue(), (Object)context.absentKey(), (Object)context.absentValue());
        cache.putAll((Map)entries);
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)3L));
        long count = context.initialSize() - 2L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void putAll_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.putAll((Map)ImmutableMap.of((Object)key, (Object)context.absentValue()));
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void invalidate(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = (Integer)cache.getIfPresent((Object)key);
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        cache.invalidate((Object)key);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void invalidate_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.invalidate((Object)key);
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void invalidateAll(Cache<Integer, Integer> cache, CacheContext context) {
        Set<Integer> keys = context.firstMiddleLastKeys();
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        cache.invalidateAll(keys);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        long count = context.initialSize() - (long)(context.isWeakKeys() ? keys.size() : 0);
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void invalidateAll_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        Set<Integer> keys = context.firstMiddleLastKeys();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.invalidateAll(keys);
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void invalidateAll_full(Cache<Integer, Integer> cache, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        cache.invalidateAll();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 0L, RemovalCause.EXPLICIT));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(0L, RemovalCause.EXPLICIT));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void invalidateAll_full_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.invalidateAll();
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void cleanUp(Cache<Integer, Integer> cache, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)0L));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void cleanUp_writerFails(Cache<Integer, Integer> cache, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        cache.cleanUp();
        context.disableRejectingCacheWriter();
        MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, population={CacheSpec.Population.FULL}, weigher={CacheSpec.CacheWeigher.DEFAULT}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void get(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.original().get(key);
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key)), (Matcher)Matchers.is((Object)value));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void get_writerFails(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.get((Object)key);
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.CONSUMING})
    public void getAll(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Set<Integer> keys = context.firstMiddleLastKeys();
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        MatcherAssert.assertThat((Object)cache.getAll(keys), (Matcher)Matchers.is((Object)Maps.toMap(keys, key -> -key.intValue())));
        long count = context.initialSize() - (long)(context.isStrongValues() ? keys.size() : 0);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)keys.size()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL}, compute={CacheSpec.Compute.SYNC}, loader={CacheSpec.Loader.IDENTITY, CacheSpec.Loader.BULK_IDENTITY})
    public void getAll_writerFails(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Set<Integer> keys = context.firstMiddleLastKeys();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            cache.getAll(keys);
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, loader={CacheSpec.Loader.IDENTITY}, removalListener={CacheSpec.Listener.CONSUMING})
    public void refresh(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.original().get(key);
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache);
        cache.refresh((Object)key);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Matcher)Matchers.not((Object)value)));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void refresh_writerFails(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        cache.refresh((Object)key);
        context.disableRejectingCacheWriter();
        MatcherAssert.assertThat((Object)cache.asMap().isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void getIfPresent(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.original().get(key);
        context.clear();
        GcFinalization.awaitFullGc();
        ReferenceTest.awaitFullCleanup(cache.synchronous());
        MatcherAssert.assertThat((Object)((Integer)cache.synchronous().getIfPresent((Object)key)), (Matcher)Matchers.is((Object)value));
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.WEAK}, values={CacheSpec.ReferenceType.STRONG}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, loader={CacheSpec.Loader.IDENTITY}, removalListener={CacheSpec.Listener.CONSUMING})
    public void get(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)cache.get((Object)context.absentKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(context.absentKey())));
        long count = context.initialSize();
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.WEAK}, values={CacheSpec.ReferenceType.STRONG}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, loader={CacheSpec.Loader.NEGATIVE, CacheSpec.Loader.BULK_NEGATIVE}, removalListener={CacheSpec.Listener.CONSUMING})
    public void getAll(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ImmutableSet keys = ImmutableSet.of((Object)context.firstKey(), (Object)context.lastKey(), (Object)context.absentKey());
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)((Map)cache.getAll((Iterable)keys).join()), (Matcher)Matchers.is(keys.stream().collect(Collectors.toMap(Function.identity(), key -> -key.intValue()))));
        long count = context.initialSize() - cache.synchronous().estimatedSize() + 1L;
        MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(keys.size()))));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(keys={CacheSpec.ReferenceType.WEAK}, values={CacheSpec.ReferenceType.STRONG}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void put(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = context.absentKey();
        context.clear();
        GcFinalization.awaitFullGc();
        cache.put((Object)key, CompletableFuture.completedFuture(context.absentValue()));
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void isEmpty(Map<Integer, Integer> map, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void size(Map<Integer, Integer> map, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)((int)context.initialSize())));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void containsKey(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.containsKey(key), (Matcher)Matchers.is((Object)context.isStrongValues()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void containsValue(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.original().get(key);
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.containsValue(value), (Matcher)Matchers.is((Object)true));
        key = null;
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.containsValue(value), (Matcher)Matchers.is((Matcher)Matchers.not((Object)context.isWeakKeys())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void clear(Map<Integer, Integer> map, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        map.clear();
        long count = context.initialSize();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void clear_writerFails(Map<Integer, Integer> map, CacheContext context) {
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            map.clear();
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)map.keySet().isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void putIfAbsent(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.putIfAbsent(key, context.absentValue()), (Matcher)Matchers.is((Matcher)(context.isStrongValues() ? Matchers.notNullValue() : Matchers.nullValue())));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize() - (long)(context.isStrongValues() ? 1 : 0);
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void putIfAbsent_writerFails(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            map.putIfAbsent(key, context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void put(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.put(key, context.absentValue()), (Matcher)Matchers.is((Matcher)(context.isStrongValues() ? Matchers.notNullValue() : Matchers.nullValue())));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.get(key), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize() - (long)(context.isStrongValues() ? 1 : 0);
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void put_writerFails(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            map.put(key, context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void replace(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.replace(key, context.absentValue()), (Matcher)Matchers.is((Matcher)(context.isStrongValues() ? Matchers.notNullValue() : Matchers.nullValue())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void replaceConditionally(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.original().get(key);
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.replace(key, value, context.absentValue()), (Matcher)Matchers.is((Object)true));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void remove(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.remove(key), (Matcher)Matchers.is((Matcher)(context.isStrongValues() ? Matchers.notNullValue() : Matchers.nullValue())));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        long count = context.initialSize() - (long)(context.isStrongValues() ? 1 : 0);
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void remove_writerFails(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            map.remove(key);
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void removeConditionally(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        Integer value = context.original().get(key);
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.remove(key, value), (Matcher)Matchers.is((Object)true));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        long count = context.initialSize() - 1L;
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void computeIfAbsent(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.computeIfAbsent(key, (? super K k) -> context.absentValue()), (Matcher)(context.isStrongValues() ? Matchers.not((Object)context.absentValue()) : Matchers.is((Object)context.absentValue())));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize() - (long)(context.isStrongValues() ? 1 : 0);
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void computeIfAbsent_writerFails(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            map.computeIfAbsent(key, (? super K k) -> context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void computeIfPresent(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.computeIfPresent(key, (? super K k, ? super V v) -> context.absentValue()), (Matcher)(context.isStrongValues() ? Matchers.is((Object)context.absentValue()) : Matchers.is((Matcher)Matchers.nullValue())));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)(context.isStrongValues() ? 1 : 0)));
        long count = context.initialSize() - (long)(context.isStrongValues() ? 1 : 0);
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void compute(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.compute(key, (? super K k, ? super V v) -> {
            MatcherAssert.assertThat((Object)v, (Matcher)Matchers.is((Matcher)(context.isStrongValues() ? Matchers.notNullValue() : Matchers.nullValue())));
            return context.absentValue();
        }), (Matcher)Matchers.is((Object)context.absentValue()));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize() - (long)(context.isStrongValues() ? 1 : 0);
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void compute_writerFails(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            map.compute(key, (? super K k, ? super V v) -> context.absentValue());
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void merge(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)map.merge(key, context.absentValue(), (oldValue, v) -> {
            if (context.isWeakKeys() && !context.isStrongValues()) {
                throw new AssertionError((Object)"Should never be called");
            }
            return context.absentValue();
        }), (Matcher)Matchers.is((Object)context.absentValue()));
        ReferenceTest.awaitFullCleanup(context.cache());
        MatcherAssert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
        long count = context.initialSize() - (long)(context.isStrongValues() ? 1 : 0);
        MatcherAssert.assertThat(map, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.COLLECTED));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.deletions(count, RemovalCause.COLLECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="caches", expectedExceptions={RejectingCacheWriter.DeleteException.class})
    @CacheSpec(keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.WEAK, CacheSpec.ReferenceType.SOFT}, implementation={CacheSpec.Implementation.Caffeine}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, population={CacheSpec.Population.FULL}, stats={CacheSpec.Stats.ENABLED}, compute={CacheSpec.Compute.SYNC}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.EXCEPTIONAL})
    public void merge_writerFails(Map<Integer, Integer> map, CacheContext context) {
        Integer key = context.firstKey();
        try {
            context.clear();
            GcFinalization.awaitFullGc();
            map.merge(key, context.absentValue(), (k, v) -> v);
        }
        finally {
            context.disableRejectingCacheWriter();
            MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(dataProvider="caches")
    @CacheSpec(requiresWeakOrSoft=true)
    public void iterators(Map<Integer, Integer> map, CacheContext context) {
        context.clear();
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)Iterators.size(map.keySet().iterator()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)Iterators.size(map.values().iterator()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)Iterators.size(map.entrySet().iterator()), (Matcher)Matchers.is((Object)0));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.UNREACHABLE}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.CONSUMING}, writer={CacheSpec.Writer.DISABLED})
    public void putIfAbsent_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        Integer key = context.absentKey();
        cache.put((Object)key, (Object)ImmutableList.of((Object)1));
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)((List)cache.asMap().putIfAbsent(key, ImmutableList.of((Object)1, (Object)2, (Object)3))), (Matcher)(context.isStrongValues() ? Matchers.is((Object)ImmutableList.of((Object)1)) : Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)(context.isStrongValues() ? 1L : 3L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.UNREACHABLE}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.DEFAULT}, writer={CacheSpec.Writer.DISABLED})
    public void put_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        Integer key = context.absentKey();
        cache.put((Object)key, (Object)ImmutableList.of((Object)1));
        GcFinalization.awaitFullGc();
        MatcherAssert.assertThat((Object)((List)cache.asMap().put(key, ImmutableList.of((Object)1, (Object)2, (Object)3))), (Matcher)(context.isStrongValues() ? Matchers.is((Object)ImmutableList.of((Object)1)) : Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.UNREACHABLE}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.DEFAULT}, writer={CacheSpec.Writer.DISABLED})
    public void computeIfAbsent_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        Integer key = context.absentKey();
        cache.put((Object)key, (Object)ImmutableList.of((Object)1));
        GcFinalization.awaitFullGc();
        cache.asMap().computeIfAbsent(key, (? super K k) -> ImmutableList.of((Object)1, (Object)2, (Object)3));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)(context.isStrongValues() ? 1L : 3L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.UNREACHABLE}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.DEFAULT}, writer={CacheSpec.Writer.DISABLED})
    public void compute_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        Integer key = context.absentKey();
        cache.put((Object)key, (Object)ImmutableList.of((Object)1));
        GcFinalization.awaitFullGc();
        cache.asMap().compute(key, (? super K k, ? super V v) -> ImmutableList.of((Object)1, (Object)2, (Object)3));
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, requiresWeakOrSoft=true, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, maximumSize={CacheSpec.Maximum.UNREACHABLE}, weigher={CacheSpec.CacheWeigher.COLLECTION}, population={CacheSpec.Population.EMPTY}, stats={CacheSpec.Stats.ENABLED}, removalListener={CacheSpec.Listener.DEFAULT}, writer={CacheSpec.Writer.DISABLED})
    public void merge_weighted(Cache<Integer, List<Integer>> cache, CacheContext context) {
        Integer key = context.absentKey();
        cache.put((Object)key, (Object)ImmutableList.of((Object)1));
        GcFinalization.awaitFullGc();
        cache.asMap().merge(key, ImmutableList.of((Object)1, (Object)2, (Object)3), (oldValue, v) -> {
            if (context.isWeakKeys() && !context.isStrongValues()) {
                throw new AssertionError((Object)"Should never be called");
            }
            return v;
        });
        MatcherAssert.assertThat((Object)((Policy.Eviction)cache.policy().eviction().get()).weightedSize().getAsLong(), (Matcher)Matchers.is((Object)3L));
    }

    private static void awaitFullCleanup(Cache<?, ?> cache) {
        long size;
        do {
            size = cache.estimatedSize();
            cache.cleanUp();
        } while (size != cache.estimatedSize());
    }
}

