/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasRemovalNotifications;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.cache.testing.RefreshAfterWrite;
import com.github.benmanes.caffeine.cache.testing.RemovalNotification;
import com.github.benmanes.caffeine.cache.testing.TrackingExecutor;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.IsEmptyMap;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class RefreshAfterWriteTest {
    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, loader={CacheSpec.Loader.NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getIfPresent(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.middleKey())), (Matcher)Matchers.is((Object)(-context.middleKey().intValue())));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.middleKey())), (Matcher)Matchers.is((Object)(-context.middleKey().intValue())));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, loader={CacheSpec.Loader.NEGATIVE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getIfPresent(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.middleKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(-context.middleKey().intValue())));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.middleKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(-context.middleKey().intValue())));
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getAllPresent(LoadingCache<Integer, Integer> cache, CacheContext context) {
        int count = context.firstMiddleLastKeys().size();
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.getAllPresent(context.firstMiddleLastKeys());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getAllPresent(context.firstMiddleLastKeys()).size(), (Matcher)Matchers.is((Object)count));
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, count, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getFunc(LoadingCache<Integer, Integer> cache, CacheContext context) {
        Function<Integer, Integer> mappingFunction = context.original()::get;
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey(), mappingFunction);
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.get((Object)context.lastKey(), mappingFunction);
        MatcherAssert.assertThat((Object)cache.estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getFunc(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Function<Integer, Integer> mappingFunction = context.original()::get;
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey(), mappingFunction);
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.get((Object)context.lastKey(), mappingFunction);
        MatcherAssert.assertThat((Object)cache.synchronous().estimatedSize(), (Matcher)Matchers.is((Object)context.initialSize()));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void get(LoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey());
        cache.get((Object)context.absentKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)context.firstKey())), (Matcher)Matchers.is((Object)(-context.firstKey().intValue())));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void get(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        context.ticker().advance(30L, TimeUnit.SECONDS);
        cache.get((Object)context.firstKey());
        cache.get((Object)context.absentKey());
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getIfPresent((Object)context.firstKey()), (Matcher)Matchers.is(IsFutureValue.futureOf(-context.firstKey().intValue())));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, executor={CacheSpec.CacheExecutor.THREADED}, compute={CacheSpec.Compute.ASYNC}, values={CacheSpec.ReferenceType.STRONG})
    public void get_sameFuture(CacheContext context) {
        AtomicBoolean done = new AtomicBoolean();
        AsyncLoadingCache cache = context.buildAsync(key -> {
            Awaits.await().untilTrue(done);
            return -key.intValue();
        });
        Integer key2 = 1;
        cache.synchronous().put((Object)key2, (Object)key2);
        CompletableFuture original = cache.get((Object)key2);
        for (int i = 0; i < 10; ++i) {
            context.ticker().advance(1L, TimeUnit.MINUTES);
            CompletableFuture next = cache.get((Object)key2);
            MatcherAssert.assertThat((Object)next, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)original)));
        }
        done.set(true);
        Awaits.await().until(() -> (Integer)cache.synchronous().getIfPresent((Object)key2), Matchers.is((Object)(-key2.intValue())));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, executor={CacheSpec.CacheExecutor.THREADED})
    public void get_slowRefresh(CacheContext context) {
        Integer key = context.absentKey();
        Integer originalValue = context.absentValue();
        final AtomicBoolean reloaded = new AtomicBoolean();
        final AtomicInteger reloading = new AtomicInteger();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)((TrackingExecutor)((Object)context.executor())).delegate();
        LoadingCache<Integer, Integer> cache = context.build(new CacheLoader<Integer, Integer>(){

            public Integer load(Integer key) {
                throw new AssertionError();
            }

            public Integer reload(Integer key, Integer oldValue) {
                int count = reloading.incrementAndGet();
                Awaits.await().untilTrue(reloaded);
                return count;
            }
        });
        cache.put((Object)key, (Object)originalValue);
        context.ticker().advance(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key)), (Matcher)Matchers.is((Object)originalValue));
        Awaits.await().untilAtomic(reloading, Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)originalValue));
        context.ticker().advance(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key)), (Matcher)Matchers.is((Object)originalValue));
        reloaded.set(true);
        Awaits.await().until(() -> (Integer)cache.get((Object)key), Matchers.is((Matcher)Matchers.not((Object)originalValue)));
        Awaits.await().until(executor::getQueue, Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)reloading.get(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Integer)cache.get((Object)key)), (Matcher)Matchers.is((Object)1));
    }

    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, loader={CacheSpec.Loader.NULL})
    public void get_null(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        Integer key = 1;
        cache.synchronous().put((Object)key, (Object)key);
        context.ticker().advance(2L, TimeUnit.MINUTES);
        Awaits.await().until(() -> (Integer)cache.synchronous().getIfPresent((Object)key), Matchers.is((Matcher)Matchers.nullValue()));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, loader={CacheSpec.Loader.IDENTITY}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getAll(LoadingCache<Integer, Integer> cache, CacheContext context) {
        ImmutableList keys = ImmutableList.of((Object)context.firstKey(), (Object)context.absentKey());
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)keys), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)context.firstKey(), (Object)(-context.firstKey().intValue()), (Object)context.absentKey(), (Object)context.absentKey())));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.getAll((Iterable)keys);
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)keys), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)context.firstKey(), (Object)context.firstKey(), (Object)context.absentKey(), (Object)context.absentKey())));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @CheckNoWriter
    @Test(dataProvider="caches")
    @CacheSpec(refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, loader={CacheSpec.Loader.IDENTITY}, population={CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void getAll(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        ImmutableList keys = ImmutableList.of((Object)context.firstKey(), (Object)context.absentKey());
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)keys), (Matcher)Matchers.is(IsFutureValue.futureOf(ImmutableMap.of((Object)context.firstKey(), (Object)(-context.firstKey().intValue()), (Object)context.absentKey(), (Object)context.absentKey()))));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        cache.getAll((Iterable)keys);
        MatcherAssert.assertThat((Object)cache.getAll((Iterable)keys), (Matcher)Matchers.is(IsFutureValue.futureOf(ImmutableMap.of((Object)context.firstKey(), (Object)context.firstKey(), (Object)context.absentKey(), (Object)context.absentKey()))));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.REPLACED));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, executor={CacheSpec.CacheExecutor.THREADED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void put(CacheContext context) {
        AtomicBoolean refresh = new AtomicBoolean();
        Integer key = context.absentKey();
        Integer original = 1;
        Integer updated = 2;
        Integer refreshed = 3;
        LoadingCache cache = context.build(k -> {
            Awaits.await().untilTrue(refresh);
            return refreshed;
        });
        cache.put((Object)key, (Object)original);
        context.ticker().advance(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)original));
        MatcherAssert.assertThat((Object)cache.asMap().put(key, updated), (Matcher)Matchers.is((Object)original));
        refresh.set(true);
        Awaits.await().until(() -> context.consumedNotifications().size(), Matchers.is((Object)2));
        List removed = context.consumedNotifications().stream().map(RemovalNotification::getValue).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)updated));
        MatcherAssert.assertThat(removed, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{original, refreshed}));
        MatcherAssert.assertThat(cache, HasRemovalNotifications.hasRemovalNotifications(context, 2, RemovalCause.REPLACED));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, executor={CacheSpec.CacheExecutor.THREADED}, removalListener={CacheSpec.Listener.CONSUMING})
    public void invalidate(CacheContext context) {
        AtomicBoolean refresh = new AtomicBoolean();
        Integer key = context.absentKey();
        Integer original = 1;
        Integer refreshed = 2;
        LoadingCache cache = context.build(k -> {
            Awaits.await().untilTrue(refresh);
            return refreshed;
        });
        cache.put((Object)key, (Object)original);
        context.ticker().advance(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)((Integer)cache.getIfPresent((Object)key)), (Matcher)Matchers.is((Object)original));
        cache.invalidate((Object)key);
        refresh.set(true);
        Awaits.await().until(() -> (Integer)cache.getIfPresent((Object)key), Matchers.is((Object)refreshed));
        Awaits.await().until(() -> cache, HasRemovalNotifications.hasRemovalNotifications(context, 1, RemovalCause.EXPLICIT));
        Awaits.await().until(() -> context, (Matcher)Matchers.both((Matcher)HasStats.hasLoadSuccessCount(1L)).and((Matcher)HasStats.hasLoadFailureCount(0L)));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void getExpiresAfter(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        MatcherAssert.assertThat((Object)refreshAfterWrite.getExpiresAfter(TimeUnit.MINUTES), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void setExpiresAfter(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        refreshAfterWrite.setExpiresAfter(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)refreshAfterWrite.getExpiresAfter(TimeUnit.MINUTES), (Matcher)Matchers.is((Object)2L));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, population={CacheSpec.Population.SINGLETON, CacheSpec.Population.PARTIAL, CacheSpec.Population.FULL})
    public void ageOf(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        MatcherAssert.assertThat((Object)refreshAfterWrite.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).getAsLong(), (Matcher)Matchers.is((Object)0L));
        context.ticker().advance(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)refreshAfterWrite.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).getAsLong(), (Matcher)Matchers.is((Object)30L));
        context.ticker().advance(45L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)refreshAfterWrite.ageOf((Object)context.firstKey(), TimeUnit.SECONDS).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void oldest_unmodifiable(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        refreshAfterWrite.oldest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void oldest_negative(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        refreshAfterWrite.oldest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_zero(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        MatcherAssert.assertThat((Object)refreshAfterWrite.oldest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_partial(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)refreshAfterWrite.oldest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, advanceOnPopulation={CacheSpec.Advance.ONE_MINUTE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void oldest_order(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        Map oldest = refreshAfterWrite.oldest(Integer.MAX_VALUE);
        MatcherAssert.assertThat(oldest.keySet(), (Matcher)Matchers.contains((Object[])context.original().keySet().toArray(new Integer[0])));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void oldest_snapshot(Cache<Integer, Integer> cache, CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        Map oldest = refreshAfterWrite.oldest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)oldest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={UnsupportedOperationException.class})
    public void youngest_unmodifiable(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        refreshAfterWrite.youngest(Integer.MAX_VALUE).clear();
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    @Test(dataProvider="caches", expectedExceptions={IllegalArgumentException.class})
    public void youngest_negative(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        refreshAfterWrite.youngest(-1);
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_zero(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        MatcherAssert.assertThat((Object)refreshAfterWrite.youngest(0), (Matcher)Matchers.is(IsEmptyMap.emptyMap()));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_partial(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        int count = (int)context.initialSize() / 2;
        MatcherAssert.assertThat((Object)refreshAfterWrite.youngest(count).size(), (Matcher)Matchers.is((Object)count));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.FULL}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE}, advanceOnPopulation={CacheSpec.Advance.ONE_MINUTE}, removalListener={CacheSpec.Listener.DEFAULT, CacheSpec.Listener.REJECTING})
    public void youngest_order(CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        Map youngest = refreshAfterWrite.youngest(Integer.MAX_VALUE);
        LinkedHashSet keys = new LinkedHashSet(ImmutableList.copyOf(youngest.keySet()).reverse());
        MatcherAssert.assertThat(keys, (Matcher)Matchers.contains((Object[])context.original().keySet().toArray(new Integer[0])));
    }

    @Test(dataProvider="caches")
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, refreshAfterWrite={CacheSpec.Expire.ONE_MINUTE})
    public void youngest_snapshot(Cache<Integer, Integer> cache, CacheContext context, @RefreshAfterWrite Policy.Expiration<Integer, Integer> refreshAfterWrite) {
        Map youngest = refreshAfterWrite.youngest(Integer.MAX_VALUE);
        cache.invalidateAll();
        MatcherAssert.assertThat((Object)youngest, (Matcher)Matchers.is((Matcher)Matchers.equalTo(context.original())));
    }
}

