/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.DisabledFuture;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.SystemScheduler;
import com.github.benmanes.caffeine.testing.Awaits;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.testing.TestingExecutors;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogManager;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class SchedulerTest {
    private final NullPointerTester npeTester = new NullPointerTester();

    @Test
    public void hasSystemScheduler() {
        Scheduler scheduler = SystemUtils.IS_JAVA_1_8 ? Scheduler.disabledScheduler() : SystemScheduler.INSTANCE;
        MatcherAssert.assertThat((Object)Scheduler.systemScheduler(), (Matcher)Matchers.is((Object)scheduler));
    }

    @Test(dataProvider="schedulers")
    public void scheduler_null(Scheduler scheduler) {
        this.npeTester.testAllPublicInstanceMethods((Object)scheduler);
    }

    @Test(dataProvider="runnableSchedulers")
    public void scheduler_exception(Scheduler scheduler) {
        AtomicBoolean executed = new AtomicBoolean();
        Executor executor = task -> {
            executed.set(true);
            throw new IllegalStateException();
        };
        scheduler.schedule(executor, () -> {}, 1L, TimeUnit.NANOSECONDS);
        Awaits.await().untilTrue(executed);
    }

    @Test(dataProvider="runnableSchedulers")
    public void scheduler(Scheduler scheduler) {
        AtomicBoolean executed = new AtomicBoolean();
        Runnable task = () -> executed.set(true);
        scheduler.schedule(ConcurrentTestHarness.executor, task, 1L, TimeUnit.NANOSECONDS);
        Awaits.await().untilTrue(executed);
    }

    @Test
    public void disabledScheduler() {
        Future future = Scheduler.disabledScheduler().schedule(Runnable::run, () -> {}, 1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)future, (Matcher)Matchers.is((Object)DisabledFuture.INSTANCE));
    }

    @Test
    public void disabledFuture_null() {
        this.npeTester.testAllPublicInstanceMethods((Object)DisabledFuture.INSTANCE);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void guardedScheduler_null() {
        Scheduler.guardedScheduler(null);
    }

    @Test
    public void guardedScheduler_nullFuture() {
        ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Scheduler scheduler = Scheduler.forScheduledExecutorService((ScheduledExecutorService)scheduledExecutor);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        Runnable command = () -> {};
        Future future = Scheduler.guardedScheduler((Scheduler)scheduler).schedule(executor, command, 1L, TimeUnit.MINUTES);
        ((ScheduledExecutorService)Mockito.verify((Object)scheduledExecutor)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)1L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MINUTES))));
        MatcherAssert.assertThat((Object)future, (Matcher)Matchers.is((Object)DisabledFuture.INSTANCE));
    }

    @Test
    public void guardedScheduler() {
        Future future = Scheduler.guardedScheduler((Scheduler)Scheduler.disabledScheduler()).schedule(Runnable::run, () -> {}, 1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)future, (Matcher)Matchers.is((Object)DisabledFuture.INSTANCE));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void scheduledExecutorService_null() {
        Scheduler.forScheduledExecutorService(null);
    }

    @Test
    public void scheduledExecutorService_schedule() {
        ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ArgumentCaptor task = ArgumentCaptor.forClass(Runnable.class);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        Runnable command = () -> {};
        Scheduler scheduler = Scheduler.forScheduledExecutorService((ScheduledExecutorService)scheduledExecutor);
        Future future = scheduler.schedule(executor, command, 1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)future, (Matcher)Matchers.is((Matcher)Matchers.not((Object)DisabledFuture.INSTANCE)));
        ((ScheduledExecutorService)Mockito.verify((Object)scheduledExecutor)).isShutdown();
        ((ScheduledExecutorService)Mockito.verify((Object)scheduledExecutor)).schedule((Runnable)task.capture(), ArgumentMatchers.eq((long)1L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MINUTES))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{scheduledExecutor});
        ((Runnable)task.getValue()).run();
        ((Executor)Mockito.verify((Object)executor)).execute(command);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{executor});
    }

    @Test
    public void scheduledExecutorService_shutdown() {
        ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        Mockito.when((Object)scheduledExecutor.isShutdown()).thenReturn((Object)true);
        Scheduler scheduler = Scheduler.forScheduledExecutorService((ScheduledExecutorService)scheduledExecutor);
        Future future = scheduler.schedule(executor, () -> {}, 1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)future, (Matcher)Matchers.is((Object)DisabledFuture.INSTANCE));
        ((ScheduledExecutorService)Mockito.verify((Object)scheduledExecutor)).isShutdown();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{scheduledExecutor});
        Mockito.verifyZeroInteractions((Object[])new Object[]{executor});
    }

    @DataProvider(name="schedulers")
    public Iterator<Scheduler> providesSchedulers() {
        ImmutableSet schedulers = ImmutableSet.of((Object)Scheduler.forScheduledExecutorService((ScheduledExecutorService)TestingExecutors.sameThreadScheduledExecutor()), (Object)Scheduler.forScheduledExecutorService((ScheduledExecutorService)ConcurrentTestHarness.scheduledExecutor), (Object)Scheduler.disabledScheduler(), (Object)Scheduler.systemScheduler());
        return schedulers.iterator();
    }

    @DataProvider(name="runnableSchedulers")
    public Iterator<Scheduler> providesRunnableSchedulers() {
        ImmutableSet schedulers = ImmutableSet.of((Object)Scheduler.forScheduledExecutorService((ScheduledExecutorService)TestingExecutors.sameThreadScheduledExecutor()), (Object)Scheduler.forScheduledExecutorService((ScheduledExecutorService)ConcurrentTestHarness.scheduledExecutor), (Object)Scheduler.systemScheduler());
        return schedulers.stream().filter(scheduler -> scheduler != Scheduler.disabledScheduler()).iterator();
    }

    static {
        LogManager.getLogManager().reset();
    }
}

