/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public final class Stresser {
    private static final String[] STATUS = new String[]{"Idle", "Required", "Processing -> Idle", "Processing -> Required"};
    private static final int MAX_THREADS = 2 * Runtime.getRuntime().availableProcessors();
    private static final int WRITE_MAX_SIZE = 4096;
    private static final int TOTAL_KEYS = 0x100000;
    private static final int MASK = 1048575;
    private static final int STATUS_INTERVAL = 5;
    private final BoundedLocalCache<Integer, Integer> local;
    private final LoadingCache<Integer, Integer> cache;
    private final Stopwatch stopwatch;
    private final Integer[] ints;
    private static final Operation operation = Operation.REFRESH;

    public Stresser() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setPriority(10).setDaemon(true).build();
        Executors.newSingleThreadScheduledExecutor(threadFactory).scheduleAtFixedRate(this::status, 5L, 5L, TimeUnit.SECONDS);
        this.cache = Caffeine.newBuilder().maximumSize((long)operation.maxEntries).recordStats().build(key -> key);
        this.local = (BoundedLocalCache)this.cache.asMap();
        this.ints = new Integer[0x100000];
        Arrays.setAll(this.ints, key -> {
            this.cache.put((Object)key, (Object)key);
            return key;
        });
        this.cache.cleanUp();
        this.stopwatch = Stopwatch.createStarted();
        this.status();
    }

    public void run() throws InterruptedException {
        ConcurrentTestHarness.timeTasks(operation.maxThreads, () -> {
            int index = ThreadLocalRandom.current().nextInt();
            while (true) {
                Integer key = this.ints[index++ & 0xFFFFF];
                switch (operation) {
                    case READ: {
                        this.cache.getIfPresent((Object)key);
                        break;
                    }
                    case WRITE: {
                        this.cache.put((Object)key, (Object)key);
                        break;
                    }
                    case REFRESH: {
                        this.cache.refresh((Object)key);
                    }
                }
            }
        });
    }

    private void status() {
        int drainStatus;
        int pendingWrites;
        this.local.evictionLock.lock();
        try {
            pendingWrites = this.local.writeBuffer().size();
            drainStatus = this.local.drainStatus();
        }
        finally {
            this.local.evictionLock.unlock();
        }
        LocalTime elapsedTime = LocalTime.ofSecondOfDay(this.stopwatch.elapsed(TimeUnit.SECONDS));
        System.out.printf("---------- %s ----------%n", elapsedTime);
        System.out.printf("Pending reads: %,d; writes: %,d%n", this.local.readBuffer.size(), pendingWrites);
        System.out.printf("Drain status = %s (%s)%n", STATUS[drainStatus], drainStatus);
        System.out.printf("Evictions = %,d%n", this.cache.stats().evictionCount());
        System.out.printf("Size = %,d (max: %,d)%n", this.local.data.mappingCount(), operation.maxEntries);
        System.out.printf("Lock = [%s%n", StringUtils.substringAfter((String)this.local.evictionLock.toString(), (String)"["));
        System.out.printf("Pending tasks = %,d%n", ForkJoinPool.commonPool().getQueuedSubmissionCount());
        long maxMemory = Runtime.getRuntime().maxMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long allocatedMemory = Runtime.getRuntime().totalMemory();
        System.out.printf("Max Memory = %,d bytes%n", maxMemory);
        System.out.printf("Free Memory = %,d bytes%n", freeMemory);
        System.out.printf("Allocated Memory = %,d bytes%n", allocatedMemory);
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        new Stresser().run();
    }

    static /* synthetic */ int access$000() {
        return MAX_THREADS;
    }

    private static enum Operation {
        READ(Stresser.access$000(), 0x100000),
        WRITE(Stresser.access$000(), 4096),
        REFRESH(1, 4096);

        private final int maxThreads;
        private final int maxEntries;

        private Operation(int maxThreads, int maxEntries) {
            this.maxThreads = maxThreads;
            this.maxEntries = maxEntries;
        }
    }
}

