/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.StripedBuffer;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class StripedBufferTest {
    static final Integer ELEMENT = 1;

    @Test(dataProvider="buffers")
    public void init(FakeBuffer<Integer> buffer) {
        MatcherAssert.assertThat((Object)buffer.table, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        buffer.offer(ELEMENT);
        MatcherAssert.assertThat((Object)buffer.table.length, (Matcher)Matchers.is((Object)1));
    }

    @Test(dataProvider="buffers")
    public void produce(FakeBuffer<Integer> buffer) {
        ConcurrentTestHarness.timeTasks(10, () -> {
            for (int i = 0; i < 10; ++i) {
                buffer.offer(ELEMENT);
                Thread.yield();
            }
        });
        MatcherAssert.assertThat((Object)buffer.table.length, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(StripedBuffer.MAXIMUM_TABLE_SIZE)));
    }

    @Test(dataProvider="buffers")
    public void drain(FakeBuffer<Integer> buffer) {
        buffer.drainTo(e -> {});
        MatcherAssert.assertThat((Object)buffer.drains, (Matcher)Matchers.is((Object)0));
        buffer.offer(ELEMENT);
        buffer.drainTo(e -> {});
        MatcherAssert.assertThat((Object)buffer.drains, (Matcher)Matchers.is((Object)1));
    }

    @DataProvider
    public Object[][] buffers() {
        return new Object[][]{{new FakeBuffer(1)}, {new FakeBuffer(-1)}, {new FakeBuffer(0)}};
    }

    static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    static final class FakeBuffer<E>
    extends StripedBuffer<E> {
        final int result;
        int drains = 0;

        FakeBuffer(int result) {
            this.result = Objects.requireNonNull(result);
        }

        protected Buffer<E> create(E e) {
            return new Buffer<E>(){

                public int offer(E e) {
                    return result;
                }

                public void drainTo(Consumer<E> consumer) {
                    ++drains;
                }

                public int size() {
                    return 0;
                }

                public int reads() {
                    return 0;
                }

                public int writes() {
                    return 0;
                }
            };
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).addValue(this.result).toString();
        }
    }
}

