/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.RandomSeedEnforcer;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.TimerWheel;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public final class TimerWheelTest {
    private static final Random random = new Random();
    private static final long NOW = random.nextLong();
    @Captor
    ArgumentCaptor<Node<Long, Long>> captor;
    @Mock
    BoundedLocalCache<Long, Long> cache;
    TimerWheel<Long, Long> timerWheel;

    @BeforeMethod
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)this);
        this.timerWheel = new TimerWheel(this.cache);
        RandomSeedEnforcer.setThreadLocalRandom(random.nextInt(), random.nextInt());
    }

    @Test(dataProvider="schedule")
    public void schedule(long nanos, int expired) {
        Mockito.when((Object)this.cache.evictEntry((Node)this.captor.capture(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.timerWheel.nanos = NOW;
        for (int timeout : new int[]{25, 90, 240}) {
            this.timerWheel.schedule((Node)new Timer(NOW + TimeUnit.SECONDS.toNanos(timeout)));
        }
        this.timerWheel.advance(NOW + nanos);
        ((BoundedLocalCache)Mockito.verify(this.cache, (VerificationMode)Mockito.times((int)expired))).evictEntry((Node)ArgumentMatchers.any(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        Object object = this.captor.getAllValues().iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            MatcherAssert.assertThat((Object)node.getVariableTime(), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(NOW + nanos))));
        }
    }

    @DataProvider(name="schedule")
    public Object[][] providesSchedule() {
        return new Object[][]{{TimeUnit.SECONDS.toNanos(10L), 0}, {TimeUnit.MINUTES.toNanos(3L), 2}, {TimeUnit.MINUTES.toNanos(10L), 3}};
    }

    @Test(dataProvider="fuzzySchedule")
    public void schedule_fuzzy(long clock, long nanos, long[] times) {
        Mockito.when((Object)this.cache.evictEntry((Node)this.captor.capture(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.timerWheel.nanos = clock;
        int expired = 0;
        for (long timeout : times) {
            if (timeout <= nanos) {
                ++expired;
            }
            this.timerWheel.schedule((Node)new Timer(timeout));
        }
        this.timerWheel.advance(nanos);
        ((BoundedLocalCache)Mockito.verify(this.cache, (VerificationMode)Mockito.times((int)expired))).evictEntry((Node)ArgumentMatchers.any(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        Object object = this.captor.getAllValues().iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            MatcherAssert.assertThat((Object)node.getVariableTime(), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(nanos))));
        }
        this.checkTimerWheel(nanos);
    }

    @Test(dataProvider="fuzzySchedule", invocationCount=25)
    public void getExpirationDelay(long clock, long nanos, long[] times) {
        Mockito.when((Object)this.cache.evictEntry((Node)ArgumentMatchers.any(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.timerWheel.nanos = clock;
        for (long timeout : times) {
            this.timerWheel.schedule((Node)new Timer(timeout));
        }
        this.timerWheel.advance(nanos);
        long minDelay = Long.MAX_VALUE;
        int minSpan = Integer.MAX_VALUE;
        int minBucket = Integer.MAX_VALUE;
        for (int i = 0; i < this.timerWheel.wheel.length; ++i) {
            for (int j = 0; j < this.timerWheel.wheel[i].length; ++j) {
                LongArrayList timers = this.getTimers(this.timerWheel.wheel[i][j]);
                for (int k = 0; k < timers.size(); ++k) {
                    long delay = timers.getLong(k);
                    if (delay >= minDelay) continue;
                    minDelay = delay;
                    minBucket = j;
                    minSpan = i;
                }
            }
        }
        long delay = this.timerWheel.getExpirationDelay();
        String msg = String.format("delay=%d but minDelay=%d, minSpan=%d, minBucket=%d", delay, minDelay, minSpan, minBucket);
        if (minDelay == Long.MAX_VALUE) {
            MatcherAssert.assertThat((String)msg, (Object)delay, (Matcher)Matchers.is((Object)Long.MAX_VALUE));
            return;
        }
        long maxError = minDelay + TimerWheel.SPANS[minSpan];
        if (maxError > delay) {
            MatcherAssert.assertThat((String)msg, (Object)delay, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(maxError))));
        }
    }

    @DataProvider(name="fuzzySchedule")
    public Object[][] providesFuzzySchedule() {
        long[] times = new long[5000];
        long clock = ThreadLocalRandom.current().nextLong();
        long bound = clock + TimeUnit.DAYS.toNanos(1L) + TimerWheel.SPANS[TimerWheel.SPANS.length - 1];
        for (int i = 0; i < times.length; ++i) {
            times[i] = ThreadLocalRandom.current().nextLong(clock + 1L, bound);
        }
        long nanos = ThreadLocalRandom.current().nextLong(clock + 1L, bound);
        return new Object[][]{{clock, nanos, times}};
    }

    private void checkTimerWheel(long nanos) {
        for (int i = 0; i < this.timerWheel.wheel.length; ++i) {
            for (int j = 0; j < this.timerWheel.wheel[i].length; ++j) {
                LongListIterator longListIterator = this.getTimers(this.timerWheel.wheel[i][j]).iterator();
                while (longListIterator.hasNext()) {
                    long timer = (Long)longListIterator.next();
                    if (timer <= nanos) {
                        throw new AssertionError((Object)String.format("wheel[%s][%d] by %ss", i, j, TimeUnit.NANOSECONDS.toSeconds(nanos - timer)));
                    }
                }
            }
        }
    }

    private LongArrayList getTimers(Node<?, ?> sentinel) {
        LongArrayList timers = new LongArrayList();
        for (Node node = sentinel.getNextInVariableOrder(); node != sentinel; node = node.getNextInVariableOrder()) {
            timers.add(node.getVariableTime());
        }
        return timers;
    }

    @Test
    public void reschedule() {
        Mockito.when((Object)this.cache.evictEntry((Node)this.captor.capture(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.timerWheel.nanos = NOW;
        Timer timer = new Timer(NOW + TimeUnit.MINUTES.toNanos(15L));
        this.timerWheel.schedule((Node)timer);
        Node<Long, Long> startBucket = timer.getNextInVariableOrder();
        timer.setVariableTime(NOW + TimeUnit.HOURS.toNanos(2L));
        this.timerWheel.reschedule((Node)timer);
        MatcherAssert.assertThat(timer.getNextInVariableOrder(), (Matcher)Matchers.is((Matcher)Matchers.not(startBucket)));
        this.timerWheel.advance(NOW + TimeUnit.DAYS.toNanos(1L));
        this.checkEmpty();
    }

    private void checkEmpty() {
        for (int i = 0; i < this.timerWheel.wheel.length; ++i) {
            for (int j = 0; j < this.timerWheel.wheel[i].length; ++j) {
                Node sentinel = this.timerWheel.wheel[i][j];
                MatcherAssert.assertThat((Object)sentinel.getNextInVariableOrder(), (Matcher)Matchers.is((Object)sentinel));
                MatcherAssert.assertThat((Object)sentinel.getPreviousInVariableOrder(), (Matcher)Matchers.is((Object)sentinel));
            }
        }
    }

    @Test
    public void deschedule() {
        Timer timer = new Timer(NOW + 100L);
        this.timerWheel.nanos = NOW;
        this.timerWheel.schedule((Node)timer);
        this.timerWheel.deschedule((Node)timer);
        MatcherAssert.assertThat(timer.getNextInVariableOrder(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(timer.getPreviousInVariableOrder(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void deschedule_notScheduled() {
        this.timerWheel.nanos = NOW;
        this.timerWheel.deschedule((Node)new Timer(NOW + 100L));
    }

    @Test(dataProvider="fuzzySchedule")
    public void deschedule_fuzzy(long clock, long nanos, long[] times) {
        ArrayList<Timer> timers = new ArrayList<Timer>();
        this.timerWheel.nanos = clock;
        for (long timeout : times) {
            Timer timer = new Timer(timeout);
            this.timerWheel.schedule((Node)timer);
            timers.add(timer);
        }
        Object object = timers.iterator();
        while (object.hasNext()) {
            Timer timer = (Timer)((Object)object.next());
            this.timerWheel.deschedule((Node)timer);
        }
        this.checkTimerWheel(nanos);
    }

    @Test
    public void expire_reschedule() {
        Mockito.when((Object)this.cache.evictEntry((Node)this.captor.capture(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenAnswer(invocation -> {
            Timer timer = (Timer)((Object)((Object)invocation.getArgument(0)));
            timer.setVariableTime(this.timerWheel.nanos + 100L);
            return false;
        });
        this.timerWheel.nanos = NOW;
        this.timerWheel.schedule((Node)new Timer(NOW + 100L));
        this.timerWheel.advance(NOW + TimerWheel.SPANS[0]);
        ((BoundedLocalCache)Mockito.verify(this.cache)).evictEntry((Node)ArgumentMatchers.any(), (RemovalCause)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        MatcherAssert.assertThat((Object)((Node)this.captor.getValue()).getNextInVariableOrder(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((Node)this.captor.getValue()).getPreviousInVariableOrder(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test(dataProvider="cascade")
    public void cascade(long nanos, long timeout, int span) {
        this.timerWheel.nanos = NOW;
        this.timerWheel.schedule((Node)new Timer(NOW + timeout));
        this.timerWheel.advance(NOW + nanos);
        int count = 0;
        for (int i = 0; i <= span; ++i) {
            for (int j = 0; j < this.timerWheel.wheel[i].length; ++j) {
                count += this.getTimers(this.timerWheel.wheel[i][j]).size();
            }
        }
        MatcherAssert.assertThat((String)("\n" + this.timerWheel.toString()), (Object)count, (Matcher)Matchers.is((Object)1));
    }

    @DataProvider(name="cascade")
    public Iterator<Object[]> providesCascade() {
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (int i = 1; i < TimerWheel.SPANS.length - 1; ++i) {
            long duration = TimerWheel.SPANS[i];
            long timeout = ThreadLocalRandom.current().nextLong(duration + 1L, 2L * duration);
            long nanos = ThreadLocalRandom.current().nextLong(duration + 1L, timeout - 1L);
            args.add(new Object[]{nanos, timeout, i});
        }
        return args.iterator();
    }

    @Test(dataProvider="snapshot")
    public void snapshot(boolean ascending, int limit, long clock, Function<Long, Long> transformer) {
        int count = 21;
        this.timerWheel.nanos = clock;
        int expected = Math.min(limit, count);
        Comparator order = ascending ? Comparator.naturalOrder() : Comparator.reverseOrder();
        List times = IntStream.range(0, count).mapToLong(i -> {
            long time = clock + TimeUnit.SECONDS.toNanos(2 << i);
            this.timerWheel.schedule((Node)new Timer(time));
            return time;
        }).boxed().sorted(order).collect(Collectors.toList()).subList(0, expected);
        Mockito.when((Object)transformer.apply(ArgumentMatchers.anyLong())).thenAnswer(invocation -> invocation.getArgument(0));
        MatcherAssert.assertThat(this.snapshot(ascending, limit, transformer), (Matcher)Matchers.is(times));
        ((Function)Mockito.verify(transformer, (VerificationMode)Mockito.times((int)expected))).apply(ArgumentMatchers.anyLong());
    }

    private List<Long> snapshot(boolean ascending, int limit, Function<Long, Long> transformer) {
        return ImmutableList.copyOf(this.timerWheel.snapshot(ascending, limit, transformer).keySet());
    }

    @DataProvider(name="snapshot")
    public Iterator<Object[]> providesSnaphot() {
        ArrayList scenarios = new ArrayList();
        for (long clock : new long[]{0L, NOW}) {
            for (int limit : new int[]{10, 100}) {
                scenarios.addAll(Arrays.asList({true, limit, clock, Mockito.mock(Function.class)}, {false, limit, clock, Mockito.mock(Function.class)}));
            }
        }
        return scenarios.iterator();
    }

    private static final class Timer
    extends Node<Long, Long> {
        Node<Long, Long> prev;
        Node<Long, Long> next;
        long variableTime;

        Timer(long accessTime) {
            this.setVariableTime(accessTime);
        }

        public long getVariableTime() {
            return this.variableTime;
        }

        public void setVariableTime(long variableTime) {
            this.variableTime = variableTime;
        }

        public Node<Long, Long> getPreviousInVariableOrder() {
            return this.prev;
        }

        public void setPreviousInVariableOrder(@Nullable Node<Long, Long> prev) {
            this.prev = prev;
        }

        public Node<Long, Long> getNextInVariableOrder() {
            return this.next;
        }

        public void setNextInVariableOrder(@Nullable Node<Long, Long> next) {
            this.next = next;
        }

        public Long getKey() {
            return this.variableTime;
        }

        public Object getKeyReference() {
            return null;
        }

        public Long getValue() {
            return this.variableTime;
        }

        public Object getValueReference() {
            return null;
        }

        public void setValue(Long value, ReferenceQueue<Long> referenceQueue) {
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public boolean isAlive() {
            return true;
        }

        public boolean isRetired() {
            return false;
        }

        public boolean isDead() {
            return false;
        }

        public void retire() {
        }

        public void die() {
        }
    }
}

